#!/usr/bin/env python3
#
# GlobalChem - Cimetidine & Acyclovir
#
# -----------------------------------

class CimetidineAndAcyclovir(object):

    def __init__(self):

        self.name = 'cimetidine_and_acyclovir'

    @staticmethod
    def get_smiles():

        smiles = {
            'microcrystalline_cellulose': 'COC1OC(CO)C(OC2OC(CO)C(OC)C(O)C2O)C(O)C1O',
            'corn_starch': 'COC4C(CO)OC(OCC2OC(OC1C(CO)OC(C)C(O)C1O)C(O)C(O)C2OC3OC(CO)C(OC)C(O)C3O)C(O)C4O',
            'dibasic_calcium_phosphate': 'O.O.OP(=O)([O-])[O-].[Ca+2]',
            'lactose': 'C(C1C(C(C(C(O1)OC2C(OC(C(C2O)O)O)CO)O)O)O)O',
            'pregelatinized_starch': 'COC1C(O)C(O)C(OCC2OC(OC3C(O)C(O)C(C)OC3CO)C(O)C(O)C2OC2OC(CO)C(OC)C(O)C2O)OC1CO',
            'hydroxypropyl_methylcellulose': 'CC(COCC1C(C(C(C(O1)OC2C(OC(C(C2OCC(C)O)OCC(C)O)OCC(C)O)COCC(C)O)OCC(C)O)OCC(C)O)OCC(C)O)O.COCC1C(C(C(C(O1)OC2C(OC(C(C2OC)OC)OC)COC)OC)OC)OC',
            'sodium_starch_glycolate': 'NN1CC2N(C(C)=O)C(C1)CC2',
            'sodium_lauryl_sulfate': 'CCCCCCCCCCCCOS(=O)(=O)[O-].[Na+]',
            'povidone': 'C1CC(=O)N(C1)C(CP)P',
            'croscarmellose_sodium': 'CC(=O)O.C(C(C(C(C(C=O)O)O)O)O)O.[Na]',
            'colloidal_silicon_dioxide': 'O=[Si]=O',
            'crospovidone': 'C1CC(=O)NC1',
            'stearic_acid': 'CCCCCCCCCCCCCCCCCC(=O)O',
            'magnesium_stearate': 'CCCCCCCCCCCCCCCCCC(=O)[O-].CCCCCCCCCCCCCCCCCC(=O)[O-].[Mg+2]'
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'microcrystalline_cellulose': '[#6]-[#8]-[#6]1-[#8]-[#6](-[#6]-[#8])-[#6](-[#8]-[#6]2-[#8]-[#6](-[#6]-[#8])-[#6](-[#8]-[#6])-[#6](-[#8])-[#6]-2-[#8])-[#6](-[#8])-[#6]-1-[#8]',
            'corn_starch': '[#6]-[#8]-[#6]1-[#6](-[#6]-[#8])-[#8]-[#6](-[#8]-[#6]-[#6]2-[#8]-[#6](-[#8]-[#6]3-[#6](-[#6]-[#8])-[#8]-[#6](-[#6])-[#6](-[#8])-[#6]-3-[#8])-[#6](-[#8])-[#6](-[#8])-[#6]-2-[#8]-[#6]2-[#8]-[#6](-[#6]-[#8])-[#6](-[#8]-[#6])-[#6](-[#8])-[#6]-2-[#8])-[#6](-[#8])-[#6]-1-[#8]',
            'dibasic_calcium_phosphate': '[#8].[#8].[#8]-[#15](=[#8])(-[#8-])-[#8-].[Ca+2]',
            'lactose': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1-[#6](-[#8]-[#6](-[#6](-[#6]-1-[#8])-[#8])-[#8])-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'pregelatinized_starch': '[#6]-[#8]-[#6]1-[#6](-[#8])-[#6](-[#8])-[#6](-[#8]-[#6]-[#6]2-[#8]-[#6](-[#8]-[#6]3-[#6](-[#8])-[#6](-[#8])-[#6](-[#6])-[#8]-[#6]-3-[#6]-[#8])-[#6](-[#8])-[#6](-[#8])-[#6]-2-[#8]-[#6]2-[#8]-[#6](-[#6]-[#8])-[#6](-[#8]-[#6])-[#6](-[#8])-[#6]-2-[#8])-[#8]-[#6]-1-[#6]-[#8]',
            'hydroxypropyl_methylcellulose': '[#6]-[#6](-[#6]-[#8]-[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1-[#6](-[#8]-[#6](-[#6](-[#6]-1-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#6]-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8].[#6]-[#8]-[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1-[#6](-[#8]-[#6](-[#6](-[#6]-1-[#8]-[#6])-[#8]-[#6])-[#8]-[#6])-[#6]-[#8]-[#6])-[#8]-[#6])-[#8]-[#6])-[#8]-[#6]',
            'sodium_starch_glycolate': '[#7]-[#7]1-[#6]-[#6]2-[#7](-[#6](-[#6])=[#8])-[#6](-[#6]-1)-[#6]-[#6]-2',
            'sodium_lauryl_sulfate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#8]-[#16](=[#8])(=[#8])-[#8-].[Na+]',
            'povidone': '[#6]1-[#6]-[#6](=[#8])-[#7](-[#6]-1)-[#6](-[#6]-[#15])-[#15]',
            'croscarmellose_sodium': '[#6]-[#6](=[#8])-[#8].[#6](-[#6](-[#6](-[#6](-[#6](-[#6]=[#8])-[#8])-[#8])-[#8])-[#8])-[#8].[Na]',
            'colloidal_silicon_dioxide': '[#8]=[Si]=[#8]',
            'crospovidone': '[#6]1-[#6]-[#6](=[#8])-[#7]-[#6]-1',
            'stearic_acid': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'magnesium_stearate': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8-].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8-].[Mg+2]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'microcrystalline_cellulose': '00000000000000000000000000000000010000000000000000000100000000001000000000000000100000000000000000100000000000000000000000000000000000000000000010000000000000000000000000000000000000010000000000000000000000000000000000000010000010000100000000000000000000000000000000000000000000010000000000000001000100000000000000000000000000000100000000000000000000000000010000000000000000000000000001100000000000001000000000000010000000000100000000000000010000000000000000000001001000000000000000000000010010010000000000010000',
            'corn_starch': '00000000010000000000000000000000010000100000000000000100000000001000000000000000100000000000000000100000000000001000000000001000000000000000000010000000000000000001000000100000000000010000000000000000000000000010000000000010000010000100000000000000000000000000100000000000000000000000010000000001000100000000000100000000000000000100000000000000000000000000010000000000000000000000000001000000000000001100000000000010000000000100000000000000010000000000000000000001001000000000000000000000010010010000000000010000',
            'dibasic_calcium_phosphate': '00000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000010000000000100000000000000000000000000000000000000000000000000000000000000000000000000100000100000000001000000100000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000',
            'lactose': '00000000000001000000000000000000000000000000000000000100000000001000000000000000100000000000000000100000000000000000000000000000000000000000000010000000000000100000000000000000000000010000000000000000000000000010000000000010000010000100000000000000000000000000000000000000000000000000000000000001000100000000100000000000000000000000000000000000000000000000010000000000000000000000000001000000000000000000000000000010000000000000000010000000010000000000000000000001001000000000000000000000010010000000000000010000',
            'pregelatinized_starch': '00000000010000000000000000000000010000100000000000000100000000001000000000000000100000000000000000100000000000001000000000001000000000000000000010000000000000000001000000100000000000010000000000000000000000000010000000000010000010000100000000000000000000000000100000000000000000000000010000000001000100000000000100000000000000000100000000000000000000000000010000000000000000000000000001000000000000001100000000000010000000000100000000000000010000000000000000000001001000000000000000000000010010010000000000010000',
            'hydroxypropyl_methylcellulose': '01000000000000000000010000000000010000000000000000000100000010000000000000000000100000000100000000100000100000001000001000000000000000000000000010000100000001010001000000000000000001010000000000000000100000000000000000000000000110000100001000000000000000000000000000000000000000010001000000000001000100000000010100000000000000000100000000010000000000000000010000001000000000000000000001000000000000001100000000010010000000000100000000010000010000000000000110000000000000000000000000000000000001000000000000010000',
            'sodium_starch_glycolate': '00000000000010000000000000000000010000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000010000000000000000000000000000000001000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000010000000000000000001000011000000000000100000000000000000000000100000010000000000000000000000000000100000010000000000000000000000100000000010000000010000000000001000000000000000000000000000000000000000000000000000000000000000000001010000',
            'sodium_lauryl_sulfate': '00000000000001100000000000000000010000000000000000000000000000000000000000000001100000000001000000000000000000000000000100000000000000000010000000000000000000000000000000000000100000010001010000000000000100000000000000000000010000000000000000000000000000000000000000000000000000000010010000000010000000000000000000000000000000000000000000000000000000100000000000000000000000010000000000000000000000000000000000000000000010000000000000000000000000000000100000000000000000000000000000000000000000000000000000010000',
            'povidone': '01001000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000010000000000000000000000011000000000000000000100000000100000000000000000000000000000010001000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000100000000000000001101000000000010000000000000000010000000000100010000000000000000000000000000000000000000000000000000010000000010000000000000000001000000000000010000000000010000000000000000000000000000000000000000000',
            'croscarmellose_sodium': '01000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000010000001000000000000000000000000000000000000100010000000000000000000000000000000000010000100010000000000000000000000000000000000000000000000100000000000000001000000000000000000000101000000000000000000000000000000000000000000000000000000001100010000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000001001000',
            'colloidal_silicon_dioxide': '10000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000010000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'crospovidone': '00001000000000000000000000000000000000010000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000010000000000000000000000000000000000100000000000001000000000000001000000000000000000000000000000000000000000000000000100000000000000000000000100000000000000000000000000100000000100000000000000010000000000000000000000000100000000000000000000000000000000000000000000000000000000010000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'stearic_acid': '00000000000000000000000000001000010000000000000000000000000000000000000000000001100000100000000000000000000000000000000100000000000000000010000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000010000000000000000000100000000000000000010000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000010000010000000100000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'magnesium_stearate': '00000000000000000000000000001000010000000000000000000000000000000000000000000001100000000000000000000000000000000000000100000000000000000010000000000000000000000000000000000000000000000000000000000000001100000000000000000001000000000000000000010000000000000000000000000000110000000010000000000011000000100000000000000000000000000000000000000000000000000000000000000000000000010000010000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
        }

        return bit_vector