#!/usr/bin/env python3
#
# GlobalChem - I Want to Live Longer
#
# -----------------------------------

class HowToLiveLonger(object):

    def __init__(self):

        self.name = 'how_to_live_longer'


    @staticmethod
    def get_smiles():

        smiles = {
            'metformin': 'CN(C)C(=N)N=C(N)N',
            'glucosamine': 'NC1C(OC(C(O)C1O)CO)O',
            'chondroitin_sulfate': 'CC(=O)NC1C(C(C(OC1O)OS(=O)(=O)O)O)OC2C(C(C(C(O2)C(=O)O)O)O)O',
            'spermidine': 'C(CCNCCCN)CN',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'metformin': '[#6]-[#7](-[#6])-[#6](=[#7])-[#7]=[#6](-[#7])-[#7]',
            'glucosamine': '[#7]-[#6]1-[#6](-[#8]-[#6](-[#6](-[#8])-[#6]-1-[#8])-[#6]-[#8])-[#8]',
            'chondroitin_sulfate': '[#6]-[#6](=[#8])-[#7]-[#6]1-[#6](-[#6](-[#6](-[#8]-[#6]-1-[#8])-[#8]-[#16](=[#8])(=[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6](=[#8])-[#8])-[#8])-[#8])-[#8]',
            'spermidine': '[#6](-[#6]-[#6]-[#7]-[#6]-[#6]-[#6]-[#7])-[#6]-[#7]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'metformin': '10000000000000000000000000000000010000000000000000000000000000000000000000000000100000000001000000000000000000010100010000000000000000000001100000010000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000100000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000010000000010000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000',
            'glucosamine': '00000000000000000000010000000000000000000000000000000000000000001000000000000000100000000000000000100000000000000100000000000000000000000000000010010000000000000000000000000000000000000000000000000000000000000010000000000010000010000100000000000000000000000000000000000000000000000000000000000001100000000000100000000000000000010000000000000000000000000000000000000000000000100000000001000000000000000000000000000000000000000000000010000000000000000000000000000001000000000000000000000000000010000000000000010000',
            'chondroitin_sulfate': '00000000000001000100000000000010010000000000000000000100000000011000000000000010100000000000000000000000000000100000001000000000100010001010000010000000100100000000000000000000000000110000000000010000000000000000000000000000000000000101000000000100000000000000000000000010000000000000000000000001000100000000000000000000000000000000000000000000000000100000010000000000000000000000010001010100000000000000000100000010000000000000000000000000000000001000100000000001000000000000000010000000010000000000000001010000',
            'spermidine': '00000000000000000000000000000000000000000000000000000000001000000000000000000000100000000000000000000000000000000000000000000000100000000000000000010000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000001000000000000000000000000000000001000001000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000011000000000000000000',
        }

        return bit_vector