#!/usr/bin/env python3
#
# GlobalChem - Plan B
#
# -------------------

class OralContraceptives(object):

    def __init__(self):

        self.name = 'oral_contraceptives'

    @staticmethod
    def get_smiles():

        smiles = {
            'desogestrel': 'CCC12CC(=C)C3C(C1CCC2(C#C)O)CCC4=CCCCC34',
            'dienogest': 'CC12CCC3=C4CCC(=O)C=C4CCC3C1CCC2(CC#N)O',
            'drospirenone': 'CC12CCC(=O)C=C1C3CC3C4C2CCC5(C4C6CC6C57CCC(=O)O7)C',
            'estradiol': 'CC12CCC3C(C1CCC2O)CCC4=C3C=CC(=C4)O',
            'estradiol valerate': 'CCCCC(=O)OC1CCC2C1(CCC3C2CCC4=C3C=CC(=C4)O)C',
            'estriol': 'CC12CCC3C(C1CC(C2O)O)CCC4=C3C=CC(=C4)O',
            'estrone': 'CC12CCC3C(C1CCC2=O)CCC4=C3C=CC(=C4)O',
            'ethinyl estradiol': 'CC12CCC3C(C1CCC2(C#C)O)CCC4=C3C=CC(=C4)O',
            'etonogestrel': 'CCC12CC(=C)C3C(C1CCC2(C#C)O)CCC4=CC(=O)CCC34',
            'levonorgestrel': 'CCC12CCC3C(C1CCC2(C#C)O)CCC4=CC(=O)CCC34',
            'mestranol': 'CC12CCC3C(C1CCC2(C#C)O)CCC4=C3C=CC(=C4)OC',
            'norelgestromin': 'CCC12CCC3C(C1CCC2(C#C)O)CCC4=CC(=NO)CCC34',
            'norethisterone': 'CC12CCC3C(C1CCC2(C#C)O)CCC4=CC(=O)CCC34',
            'norethisterone acetate': 'CC(=O)OC1(CCC2C1(CCC3C2CCC4=CC(=O)CCC34)C)C#C',
            'norethynodre': 'CC12CCC3C(C1CCC2(C#C)O)CCC4=C3CCC(=O)C4',
            'norgestimate': 'CCC12CCC3C(C1CCC2(C#C)OC(=O)C)CCC4=CC(=NO)CCC34',
            'progesterone': 'CC(=O)C1CCC2C1(CCC3C2CCC4=CC(=O)CCC34C)C',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'desogestrel': '[#6]-[#6]-[#6]12-[#6]-[#6](=[#6])-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2(-[#6]#[#6])-[#8])-[#6]-[#6]-[#6]1=[#6]-[#6]-[#6]-[#6]-[#6]-3-1',
            'dienogest': '[#6]-[#6]12-[#6]-[#6]-[#6]3=[#6]4-[#6]-[#6]-[#6](=[#8])-[#6]=[#6]-4-[#6]-[#6]-[#6]-3-[#6]-1-[#6]-[#6]-[#6]-2(-[#6]-[#6]#[#7])-[#8]',
            'drospirenone': '[#6]-[#6]12-[#6]-[#6]-[#6](=[#8])-[#6]=[#6]-1-[#6]1-[#6]-[#6]-1-[#6]1-[#6]-2-[#6]-[#6]-[#6]2(-[#6]-1-[#6]1-[#6]-[#6]-1-[#6]-21-[#6]-[#6]-[#6](=[#8])-[#8]-1)-[#6]',
            'estradiol': '[#6]-[#6]12-[#6]-[#6]-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2-[#8])-[#6]-[#6]-[#6]1:[#6]-3:[#6]:[#6]:[#6](:[#6]:1)-[#8]',
            'estradiol valerate': '[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]1-[#6]-[#6]-[#6]2-[#6]-1(-[#6]-[#6]-[#6]1-[#6]-2-[#6]-[#6]-[#6]2:[#6]-1:[#6]:[#6]:[#6](:[#6]:2)-[#8])-[#6]',
            'estriol': '[#6]-[#6]12-[#6]-[#6]-[#6]3-[#6](-[#6]-1-[#6]-[#6](-[#6]-2-[#8])-[#8])-[#6]-[#6]-[#6]1:[#6]-3:[#6]:[#6]:[#6](:[#6]:1)-[#8]',
            'estrone': '[#6]-[#6]12-[#6]-[#6]-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2=[#8])-[#6]-[#6]-[#6]1:[#6]-3:[#6]:[#6]:[#6](:[#6]:1)-[#8]',
            'ethinyl estradiol': '[#6]-[#6]12-[#6]-[#6]-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2(-[#6]#[#6])-[#8])-[#6]-[#6]-[#6]1:[#6]-3:[#6]:[#6]:[#6](:[#6]:1)-[#8]',
            'etonogestrel': '[#6]-[#6]-[#6]12-[#6]-[#6](=[#6])-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2(-[#6]#[#6])-[#8])-[#6]-[#6]-[#6]1=[#6]-[#6](=[#8])-[#6]-[#6]-[#6]-3-1',
            'levonorgestrel': '[#6]-[#6]-[#6]12-[#6]-[#6]-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2(-[#6]#[#6])-[#8])-[#6]-[#6]-[#6]1=[#6]-[#6](=[#8])-[#6]-[#6]-[#6]-3-1',
            'mestranol': '[#6]-[#6]12-[#6]-[#6]-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2(-[#6]#[#6])-[#8])-[#6]-[#6]-[#6]1:[#6]-3:[#6]:[#6]:[#6](:[#6]:1)-[#8]-[#6]',
            'norelgestromin': '[#6]-[#6]-[#6]12-[#6]-[#6]-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2(-[#6]#[#6])-[#8])-[#6]-[#6]-[#6]1=[#6]-[#6](=[#7]-[#8])-[#6]-[#6]-[#6]-3-1',
            'norethisterone': '[#6]-[#6]12-[#6]-[#6]-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2(-[#6]#[#6])-[#8])-[#6]-[#6]-[#6]1=[#6]-[#6](=[#8])-[#6]-[#6]-[#6]-3-1',
            'norethisterone acetate': '[#6]-[#6](=[#8])-[#8]-[#6]1(-[#6]-[#6]-[#6]2-[#6]-1(-[#6]-[#6]-[#6]1-[#6]-2-[#6]-[#6]-[#6]2=[#6]-[#6](=[#8])-[#6]-[#6]-[#6]-1-2)-[#6])-[#6]#[#6]',
            'norethynodre': '[#6]-[#6]12-[#6]-[#6]-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2(-[#6]#[#6])-[#8])-[#6]-[#6]-[#6]1=[#6]-3-[#6]-[#6]-[#6](=[#8])-[#6]-1',
            'norgestimate': '[#6]-[#6]-[#6]12-[#6]-[#6]-[#6]3-[#6](-[#6]-1-[#6]-[#6]-[#6]-2(-[#6]#[#6])-[#8]-[#6](=[#8])-[#6])-[#6]-[#6]-[#6]1=[#6]-[#6](=[#7]-[#8])-[#6]-[#6]-[#6]-3-1',
            'progesterone': '[#6]-[#6](=[#8])-[#6]1-[#6]-[#6]-[#6]2-[#6]-1(-[#6]-[#6]-[#6]1-[#6]-2-[#6]-[#6]-[#6]2=[#6]-[#6](=[#8])-[#6]-[#6]-[#6]-1-2-[#6])-[#6]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'desogestrel': '00001001000000000100001000000000010110000000000000000000010000100000000000010000100000000000000000000000000000100000000000011000001000000110000000000000000000010010000000000000100000000000000000000000001001010000000000000010000000000000100000000100000000100000000000000000000000000000000000000011000001000000000000000000000000010000010001000010000000000000100000001000000110000000000000000000000001000001000010000010100000010000100001000000000000000000000100000010000000000010000000000000000000000000010000010000',
            'dienogest': '00000001000100000100000000000000010010000000000000000000000000000100000000000000100010000000000000000000000000000000001000000000001000001110000000000000000000010010100000000000001000000000000000000000001000000000000000000000000000000000000000100000001001000000000000000000000000101000100000000001100001010000000000100000001000000100000001000010000000010000100010100000010000000000000000000000000000000010100000101010000000000000000000000100000000000000000100000000000000000000000000000000000000000000000000010000',
            'drospirenone': '00000001000000000100000000000000011010000001000000010000000000000000010000000000000010001000000000000000000000100000000000000000100000000010000010000000010000000001000000000000000000000000000000000000001000000000000000000010000010000000000000100000001000000110000000001100000000000000000010000000000101000000000000100000000000000100000001000010000010000000100000100000000000000000000010000000000000000000000000001010000000000000001000000000000000000000000110100000000000000100000100000000000000000100010100010000',
            'estradiol': '00010001000000010000000000000000010010000000000001100000000000000010000000000000000000000000000000000000010000100000001000001000000000000010000000000000000000000000000000000000000000000000000000000000011000000000101010000000000000000100000000000000101000000000000000000000000000000000000001000001000001000000000100000000000000000000000001000000000000000000100000010000000000010000010000000000000000000000010010000011000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000010000',
            'estradiol valerate': '00010001000000010000000000001000010011000000000001100000000000000010000000000001110000000000000000000010010000100000001000001000000000000010000000000000000000000000000000100000000000010010000000000000011000000000101000000000000000000100000000000000011000100000000000000000000000000010000001000011000001000000000100000000000000000000000001000000000000000000100000110000000000010000010000000000000000000000000010001011000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000010000',
            'estriol': '00010001000000010000000000000000010010000000000001000000000000000010000000000000000000000000000000000000000000100000001000001000000000000010000000000000000000000000000000000000000000000000000000000000011000000000101000000000000000000100000000000000001000000000000000001000001000001000000001000001000001000000000100000000000000000000000001000000000000000000100000010000000000000000010000010000000000000000000010000011000000000000000000000000000000000000010100000000000000000000000000000001000000000010000000010000',
            'estrone': '00010001000000010000000000000000010010000000000001000000000001000010000000000000000000000000000000000000000000100000001001001000000000000010000000000000000000000000000000000000000000000000000000000000011000000000101000000000000000000100000100000010001000000000000000000000000000000000000001000001000001000000000100100001000000000000000001000000000010000000100000010000000000000000010000000000000000000000000010000010000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000010000',
            'ethinyl estradiol': '00010001000000010100000000000000010010000001000001000000000000000010000000010000000000000000000000000000000000100000001000001000001000000110000000000000000000000010000000000000000000000000000000000000011000000000101000000000000000000100000000000000001000000000000000000000000000000000000001000001000001000000000100000000000000000000000001000000000000000000100000011000000000000000010000000000000001000001000010001010000000000000000000000000010000000000000100000010000000000000000000000000000000000000000000010000',
            'etonogestrel': '00000001000000000100001000000000010110000000000000000000010000100000000000010000100010000000000000000000000000100000000000001001001000000110000000000000000000000010000000000000100000000000000000000000001001000000000000000000000000000000100000100000000001100000000000000000000000000000000000001011000001000000000000100000000000010100010001000010000000000000100000001000000110000000000000000000000001000001000010000010100000000000100001001000000000000000000100000010000000000010000000000000000000000000000000010000',
            'levonorgestrel': '00000001000000000100001000000000010010000000000100000000010000000000000000010000100010000000000000100000000000100000000000000001001000000110000000000000000000000010000000000000000000101000000000000000001001000000000000000000000000000000100000100000000001000000000000000000000000000000001000001011000001000000000000100000000000010100000001000000010000000000100000001000000010000000000000000000000001000001000010000010100000000000000000001000000000000000000100000010000000000000000000000000000000000000000000010000',
            'mestranol': '10010001000000010100000000000000010010000001000001000000000000000000000000010000000000000000000000000000000000100000001000001000001000000110000000000000000000000010000000000000000000010000000000000000011000100000101000000000000000000000000000000000001000000000000000000100000000000000000001000001000001000000000100000000001000000100000001000000000000000000100000011000000000000000000000000000000001000001000010001010000000000000000000001000010000000000100100000010000000000000000000000000000000000000000000010000',
            'norelgestromin': '00000001000000000100001000000010010010000000000100000000010000000000000000010000100010000000000000100000000000100000000000000000001000000110000000000100000000000010000000000000000000101000000000000000001001000000010000000000000000000000100000000000000001000000000000000000000000000000001000001011000001000000000000000000000000010000001001000001010000000000100000001000000011000000000000000000000001000101000010000010100000000000000001000000000000000000000100000010000000000000000000000000000000000000000000010000',
            'norethisterone': '00000001000000000100000000000000010010000001000100000000010000000000000000010000000010000000000000000000000000100000000000000001001000000110000000000000000000000010000000000000000000101000000000000000001001000000000000000000000000000000000000100000001001000000000000000000000000000000000001001001000001000000000000100000000000000100000001000000010000000000100000001000000000000000000000000000000001000001000010001010000000000000000000001000010000000000000100000010000000000000000000000000000000000000000000010000',
            'norethisterone acetate': '00000001000100000100000000010000010010000001000100000000010000000000000000000000000010000000000000000000000000100000000000000001010000000010000000000000000000000010000000000000000000111000000000000001001001000000000000000100000000000000000000100100001001000000000000000000000000000000000000001001000001000000000000100000000000000100000001000000010000000000100000000000000000000000010000000000000001000001000010001010000000000000000000011000000000100000000100000010000000000000000000001000000000000000000001010000',
            'norethynodre': '00000001000000000100000000001000010010000001000000000000000000000000000000010000000000000000000000000000000000100000000001000000001000000110000000000000000000001010000000000000000000000000000000000000001000000000000000000000010000010000000000000000001000000000000000010000000000000000001001000001000001000000000100100000000000000000010000000000000000000000100100001000000000000000000000000000000001000001100010001010000000000000000000000000010000000100000100000010000000000000000000000000000000000000000000010000',
            'norgestimate': '00000001000100000100001000000010010010000000000100000000010000000000000000000000100010000000000000100000000000100000000000000000010010000010000000000100000000000010000000000000000000111000000000000001001001000000010000000100000000000000100000000100000001000000000000000000000000000000000000001011000001000000000000000000000000010000001001001001010000000000100000000000000001000000010000000000000001000101000010000010100000000000000001010000000000000000000100000010000000000000000000001000000000000000000001010000',
            'progesterone': '00000001000000001100000000000000010010000000000000100000000000000000000100000000000010001000000000000000011000100000000010000000000000000010000000000000000001000000000000000000000000100000000000010000001000100000000000000000000000000000000000100000001000000000001000000000000000010000000000000001000001000000000000100000000000000101000001000000000010000000100000000000000000000000010000000000000000000000000010000011000000000000000000000000000000000000010000000000000000000000000100000000000000000000000011010000',
        }

        return bit_vector