"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Analytics = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const es = require("@aws-cdk/aws-elasticsearch");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class Analytics extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const region = cdk.Stack.of(this).region;
        const account = cdk.Stack.of(this).account;
        const esDomainName = (_b = props.domainName) !== null && _b !== void 0 ? _b : props.clusterId;
        this.vpc = props.vpc;
        // PolicyName: ElasticsearchPermissions
        const trustedSourceIpCidr = [
            `${props.sechedulerPublicIp}/32`,
        ];
        if (props.clientIpCidr)
            trustedSourceIpCidr.push(props.clientIpCidr);
        const elasticsearchPermissionsPolicy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: [
                'es:ESHttp*',
            ],
            principals: [new iam.AccountRootPrincipal()],
            conditions: {
                IpAddress: { 'aws:SourceIp': trustedSourceIpCidr },
            },
            resources: [`arn:aws:es:${region}:${account}:domain/${esDomainName}/*`],
        });
        //Create Elasticsearch service
        const esDomain = new es.Domain(this, 'ElasticsearchDomain', {
            version: es.ElasticsearchVersion.V7_4,
            domainName: esDomainName,
            nodeToNodeEncryption: true,
            encryptionAtRest: {
                enabled: true,
            },
            ebs: {
                volumeSize: 100,
                volumeType: ec2.EbsDeviceVolumeType.GP2,
                enabled: true,
            },
            capacity: {
                masterNodeInstanceType: 'm5.large.elasticsearch',
                dataNodes: 2,
                dataNodeInstanceType: 'm5.large.elasticsearch',
            },
            zoneAwareness: {
                enabled: true,
            },
            automatedSnapshotStartHour: 0,
            accessPolicies: [
                elasticsearchPermissionsPolicy,
            ],
            enforceHttps: true,
            logging: {
                slowSearchLogEnabled: true,
                appLogEnabled: true,
                slowIndexLogEnabled: true,
            },
            removalPolicy: (_c = props.removalPolicy) !== null && _c !== void 0 ? _c : cdk.RemovalPolicy.DESTROY,
        });
        new cdk.CfnOutput(this, 'ESDomainArn:', { value: esDomain.domainArn });
        new cdk.CfnOutput(this, 'ESDomainEndpoint:', { value: esDomain.domainEndpoint });
    }
}
exports.Analytics = Analytics;
_a = JSII_RTTI_SYMBOL_1;
Analytics[_a] = { fqn: "cdk-soca.Analytics", version: "0.2.85" };
//# sourceMappingURL=data:application/json;base64,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