# coding: utf-8

"""
    Data Repository API

    This document defines the REST API for Data Repository. **Status: design in progress** There are four top-level endpoints (besides some used by swagger):  * /swagger-ui.html - generated by swagger: swagger API page that provides this documentation and a live UI for      submitting REST requests  * /status - provides the operational status of the service  * /api    - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The overall API (/api) currently supports two interfaces:  * Repository - a general and default interface for initial setup, managing ingest and repository metadata  * Resource - an interface for managing billing accounts and resources  The API endpoints are organized by interface. Each interface is separately versioned. ## Notes on Naming All of the reference items are suffixed with \"Model\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. ## Editing and debugging I have found it best to edit this file directly to make changes and then use the swagger-editor to validate. The errors out of swagger-codegen are not that helpful. In the swagger-editor, it gives you nice errors and links to the place in the YAML where the errors are. But... the swagger-editor has been a bit of a pain for me to run. I tried the online website and was not able to load my YAML. Instead, I run it locally in a docker container, like this: ``` docker pull swaggerapi/swagger-editor docker run -p 9090:8080 swaggerapi/swagger-editor ``` Then navigate to localhost:9090 in your browser. I have not been able to get the file upload to work. It is a bit of a PITA, but I copy-paste the source code, replacing what is in the editor. Then make any fixes. Then copy-paste the resulting, valid file back into our source code. Not elegant, but easier than playing detective with the swagger-codegen errors. This might be something about my browser or environment, so give it a try yourself and see how it goes. ## Merging the DRS standard swagger into this swagger ## The merging is done in three sections:  1. Merging the security definitions into our security definitions  2. This section of paths. We make all paths explicit (prefixed with /ga4gh/drs/v1)     All standard DRS definitions and parameters are prefixed with 'DRS' to separate them     from our native definitions and parameters. We remove the x-swagger-router-controller lines.  3. A separate part of the definitions section for the DRS definitions  NOTE: the code here does not relect the DRS spec anymore. See DR-409.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotRequestAssetModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'asset_name': 'str',
        'root_values': 'list[str]'
    }

    attribute_map = {
        'asset_name': 'assetName',
        'root_values': 'rootValues'
    }

    def __init__(self, asset_name=None, root_values=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotRequestAssetModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._asset_name = None
        self._root_values = None
        self.discriminator = None

        self.asset_name = asset_name
        self.root_values = root_values

    @property
    def asset_name(self):
        """Gets the asset_name of this SnapshotRequestAssetModel.  # noqa: E501

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :return: The asset_name of this SnapshotRequestAssetModel.  # noqa: E501
        :rtype: str
        """
        return self._asset_name

    @asset_name.setter
    def asset_name(self, asset_name):
        """Sets the asset_name of this SnapshotRequestAssetModel.

        Table and column names follow this pattern. This should be used for the name of any object in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. For table and column names, this is shorter than what BigQuery allows.   # noqa: E501

        :param asset_name: The asset_name of this SnapshotRequestAssetModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and asset_name is None:  # noqa: E501
            raise ValueError("Invalid value for `asset_name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                asset_name is not None and len(asset_name) > 63):
            raise ValueError("Invalid value for `asset_name`, length must be less than or equal to `63`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                asset_name is not None and len(asset_name) < 1):
            raise ValueError("Invalid value for `asset_name`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                asset_name is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', asset_name)):  # noqa: E501
            raise ValueError(r"Invalid value for `asset_name`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._asset_name = asset_name

    @property
    def root_values(self):
        """Gets the root_values of this SnapshotRequestAssetModel.  # noqa: E501


        :return: The root_values of this SnapshotRequestAssetModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._root_values

    @root_values.setter
    def root_values(self, root_values):
        """Sets the root_values of this SnapshotRequestAssetModel.


        :param root_values: The root_values of this SnapshotRequestAssetModel.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and root_values is None:  # noqa: E501
            raise ValueError("Invalid value for `root_values`, must not be `None`")  # noqa: E501

        self._root_values = root_values

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotRequestAssetModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotRequestAssetModel):
            return True

        return self.to_dict() != other.to_dict()
