# coding: utf-8

"""
    Data Repository API

    This document defines the REST API for Data Repository. **Status: design in progress** There are four top-level endpoints (besides some used by swagger):  * /swagger-ui.html - generated by swagger: swagger API page that provides this documentation and a live UI for      submitting REST requests  * /status - provides the operational status of the service  * /api    - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The overall API (/api) currently supports two interfaces:  * Repository - a general and default interface for initial setup, managing ingest and repository metadata  * Resource - an interface for managing billing accounts and resources  The API endpoints are organized by interface. Each interface is separately versioned. ## Notes on Naming All of the reference items are suffixed with \"Model\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. ## Editing and debugging I have found it best to edit this file directly to make changes and then use the swagger-editor to validate. The errors out of swagger-codegen are not that helpful. In the swagger-editor, it gives you nice errors and links to the place in the YAML where the errors are. But... the swagger-editor has been a bit of a pain for me to run. I tried the online website and was not able to load my YAML. Instead, I run it locally in a docker container, like this: ``` docker pull swaggerapi/swagger-editor docker run -p 9090:8080 swaggerapi/swagger-editor ``` Then navigate to localhost:9090 in your browser. I have not been able to get the file upload to work. It is a bit of a PITA, but I copy-paste the source code, replacing what is in the editor. Then make any fixes. Then copy-paste the resulting, valid file back into our source code. Not elegant, but easier than playing detective with the swagger-codegen errors. This might be something about my browser or environment, so give it a try yourself and see how it goes. ## Merging the DRS standard swagger into this swagger ## The merging is done in three sections:  1. Merging the security definitions into our security definitions  2. This section of paths. We make all paths explicit (prefixed with /ga4gh/drs/v1)     All standard DRS definitions and parameters are prefixed with 'DRS' to separate them     from our native definitions and parameters. We remove the x-swagger-router-controller lines.  3. A separate part of the definitions section for the DRS definitions  NOTE: the code here does not relect the DRS spec anymore. See DR-409.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class UpgradeModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'upgrade_name': 'str',
        'upgrade_type': 'str',
        'custom_name': 'str',
        'custom_args': 'list[str]'
    }

    attribute_map = {
        'upgrade_name': 'upgradeName',
        'upgrade_type': 'upgradeType',
        'custom_name': 'customName',
        'custom_args': 'customArgs'
    }

    def __init__(self, upgrade_name=None, upgrade_type=None, custom_name=None, custom_args=None, local_vars_configuration=None):  # noqa: E501
        """UpgradeModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._upgrade_name = None
        self._upgrade_type = None
        self._custom_name = None
        self._custom_args = None
        self.discriminator = None

        self.upgrade_name = upgrade_name
        self.upgrade_type = upgrade_type
        if custom_name is not None:
            self.custom_name = custom_name
        if custom_args is not None:
            self.custom_args = custom_args

    @property
    def upgrade_name(self):
        """Gets the upgrade_name of this UpgradeModel.  # noqa: E501

        Unique name for the upgrade  # noqa: E501

        :return: The upgrade_name of this UpgradeModel.  # noqa: E501
        :rtype: str
        """
        return self._upgrade_name

    @upgrade_name.setter
    def upgrade_name(self, upgrade_name):
        """Sets the upgrade_name of this UpgradeModel.

        Unique name for the upgrade  # noqa: E501

        :param upgrade_name: The upgrade_name of this UpgradeModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and upgrade_name is None:  # noqa: E501
            raise ValueError("Invalid value for `upgrade_name`, must not be `None`")  # noqa: E501

        self._upgrade_name = upgrade_name

    @property
    def upgrade_type(self):
        """Gets the upgrade_type of this UpgradeModel.  # noqa: E501

        Enumeration to allow different kinds upgrades  # noqa: E501

        :return: The upgrade_type of this UpgradeModel.  # noqa: E501
        :rtype: str
        """
        return self._upgrade_type

    @upgrade_type.setter
    def upgrade_type(self, upgrade_type):
        """Sets the upgrade_type of this UpgradeModel.

        Enumeration to allow different kinds upgrades  # noqa: E501

        :param upgrade_type: The upgrade_type of this UpgradeModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and upgrade_type is None:  # noqa: E501
            raise ValueError("Invalid value for `upgrade_type`, must not be `None`")  # noqa: E501
        allowed_values = ["custom"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and upgrade_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `upgrade_type` ({0}), must be one of {1}"  # noqa: E501
                .format(upgrade_type, allowed_values)
            )

        self._upgrade_type = upgrade_type

    @property
    def custom_name(self):
        """Gets the custom_name of this UpgradeModel.  # noqa: E501

        Name of custom upgrade to launch. Only used when upgradeType is custom.  # noqa: E501

        :return: The custom_name of this UpgradeModel.  # noqa: E501
        :rtype: str
        """
        return self._custom_name

    @custom_name.setter
    def custom_name(self, custom_name):
        """Sets the custom_name of this UpgradeModel.

        Name of custom upgrade to launch. Only used when upgradeType is custom.  # noqa: E501

        :param custom_name: The custom_name of this UpgradeModel.  # noqa: E501
        :type: str
        """

        self._custom_name = custom_name

    @property
    def custom_args(self):
        """Gets the custom_args of this UpgradeModel.  # noqa: E501

        Array of string arguments to the custom upgrade. Only used when upgradeType is custom.  # noqa: E501

        :return: The custom_args of this UpgradeModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._custom_args

    @custom_args.setter
    def custom_args(self, custom_args):
        """Sets the custom_args of this UpgradeModel.

        Array of string arguments to the custom upgrade. Only used when upgradeType is custom.  # noqa: E501

        :param custom_args: The custom_args of this UpgradeModel.  # noqa: E501
        :type: list[str]
        """

        self._custom_args = custom_args

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpgradeModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpgradeModel):
            return True

        return self.to_dict() != other.to_dict()
