# sphinx-autoschematics

![Build Status](https://img.shields.io/travis/NerdWalletOSS/sphinx-autoschematics.svg)
![CodeCov](https://img.shields.io/codecov/c/github/NerdWalletOSS/sphinx-autoschematics.svg)
![PyPI - Version](https://img.shields.io/pypi/v/sphinx-autoschematics.svg)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/sphinx-autoschematics.svg)

This is a Sphinx extension to automatically document [Schematics](https://schematics.readthedocs.io/) models.

## How to use it

In your Sphinx configuration you will need to list `autoschematics` as an extension:

```python
extensions = ["autoschematics", "sphinx.ext.autodoc"]
```

This will provide a new `automodel` directive that you can provide the full path of a model to:

```
.. automodel:: myproject.models.MyModel
```

The extension will inspect your model and generate documentation from the docstring and the different fields on the model.


## Example

Given the following model:

```python
from schematics import types
from schematics.models import Model
from schematics.types import compound


class MyModel(Model):
    """MyModel defines the structure of data when interacting with SomeService

    Just like in Sphinx .rst files you can use restructured text directives in the
    docstring to provide rich content in the generated docs.

    .. code-block:: yaml

        foo: Foo
        bar:
          - bar1
          - bar2
    """

    foo = types.StringType(
        required=True,
        metadata=dict(
            custom_value=True
        )
    )

    bar = compound.ListType(types.StringType, default=list)
```

Would produce documentation like:

#### models.MyModel

MyModel defines the structure of data when interacting with SomeService 

Just like in Sphinx .rst files you can use restructured text directives in the
docstring to provide rich content in the generated docs.

```yaml
foo: Foo
bar:
  - bar1
  - bar2
```

<dl class="attribute">
<dt id="models.ExampleModel.foo">
<code class="sig-name descname">foo</code><em class="property"> StringType()</em></dt>
<dd><div class="line-block">
<div class="line"><strong>Required</strong>: True</div>
<div class="line"><strong>Default</strong>: Undefined</div>
<div class="line"><strong>Custom value</strong>: True</div>
</div>
</dd></dl>

<dl class="attribute">
<dt id="models.ExampleModel.bar">
<code class="sig-name descname">bar</code><em class="property"> ListType(StringType())</em></dt>
<dd><div class="line-block">
<div class="line"><strong>Required</strong>: False</div>
<div class="line"><strong>Default</strong>: Undefined</div>
</div>
</dd></dl>
