# Automated Model Reduction Tool for SBML models
## Python toolbox to automatically obtain reduced model expressions using time-scale separation, conservation laws, and other assumptions.

[![Build Status](https://travis-ci.com/ayush9pandey/AutoReduce.svg?branch=master)](https://travis-ci.com/ayush9pandey/AutoReduce)
[![codecov](https://codecov.io/gh/ayush9pandey/AutoReduce/branch/master/graph/badge.svg)](https://codecov.io/gh/ayush9pandey/AutoReduce)
[![PyPI version](https://badge.fury.io/py/autoreduce.svg)](https://badge.fury.io/py/autoreduce)

Refer to the [bioRxiv paper](https://www.biorxiv.org/content/10.1101/2020.02.15.950840v2.full.pdf) for more details.
To run - Go through tutorial files inside tutorials folder then check out some common examples in the examples folder. To check if different tools are working properly, run tests. 
Contact : Ayush Pandey (apandet at caltech dot edu) for any feedback or suggestions.


- **Website:** https://github.com/ayush9pandey/AutoReduce
- **Paper:** [Introduction](https://www.biorxiv.org/content/10.1101/640276v1.full), [Toolbox](https://www.biorxiv.org/content/10.1101/2020.02.15.950840v2.full.pdf)
- **Source:** https://github.com/ayush9pandey/autoreduce
- **Bug reports:** https://github.com/ayush9pandey/autoreduce/issues
- **Documentation:** Coming Soon on: [autoreduce.readthedocs.io](https://readthedocs.org/projects/autoreduce/)

# Simple example

# Installation

Install the latest version of AutoReduce::

    $ pip install autoreduce 

Install with all optional dependencies::

    $ pip install autoreduce[all]

# Bugs
Report any bugs that you find [here](https://github.com/ayush9pandey/autoreduce/issues).
You can also fork the repository on [GitHub](https://github.com/ayush9pandey/autoreduce),
and the create a pull request (PR) with any changes. We welcome all changes, big or small, and we
will help you make the PR if you are new to `git` (just create a new issue)

# Versions

AutoReduce versions:

* 0.1.0 (alpha release): To install run `pip install autoreduce==0.1.0`

# License
Released under the BSD 3-Clause License (see `LICENSE`)

Copyright (c) 2020, Ayush Pandey. All rights reserved.

