# -*- coding: utf-8 -*-
"""
Created on Mon Jun 10 14:30:05 2019.

@author: HugoFara
"""

import matplotlib.pyplot as plt
import numpy as np
import re

def f(x) :
    if 0 <= x < 1 :
        return 3
    if 6 < x < 7 :
        return 3 * np.cos((x - 6.5) * np.pi) + 1
    return np.sin(x * np.pi / 4) + 2


def show(s=False):
    X = np.linspace(0, 10, 1000)
    plt.grid(lw=.5)
    plt.plot(X, [f(x) for x in X])
    if s :
        plt.show()
    return X


def show_exhaustive():
    X = show()
    for x in np.linspace(0, 10, 11) :
        plt.plot([x, x], [0, f(x)])
    m = max((f(x) for x in np.linspace(0, 10, 11)))
    plt.plot([0, 10], [m, m])
    plt.show()


def show_swarm() :
    show()
    for x in (6.5, 6.5) :
        plt.plot([x, x], [0, f(x)])
    plt.show()


d = """Step : 0, 100 individuals, scores :
[2.2063329521405755, 8.841899545428147, 4.550037983821669, 2.6463168438712676, 17.21116421595514, 5.699099342741226, 2.2798455523144483, 5.70583880284387, 6.0781097443636485, 3.6805241228825802, 2.3251898116168084, 9.92372314760024, 2.8606885820675454, 6.562059954285253, 7.6884615322958565, 3.6725697179468364, 3.9155870188520914, 4.6729741955775355, 3.8892924402043874, 3.155089271296206, 3.8913393314874267, 3.3231628517469174, 3.144597462902141, 4.222196819549028, 3.004092612779584, 3.4883357643334323, 8.654399642908414, 3.0270252398817203, 6.042408296807515, 3.7108092656512577, 13.365864531738982, 5.703714716593122, 4.2328523361620665, 7.687388785987137, 51.129365697787904, 4.0141827669838035, 2.096830394121571, 2.78828366312317, 3.3904190986920617, 2.5832747526058535, 3.8611298948095145, 4.994226774980533, 3.9635223423034707, 4.175513379594649, 4.8986045295693454, 4.022799003952881, 4.876615120262224, 2.30738165717993, 4.659571087062149, 1.6029193899276917, -1.1051182026382196, 1.7678547161192475, -0.8980204529271197, -0.49391195569021956, 2.6274459263217835, -0.48218784206174437, 0.35668747028767084, 1.614350841949073, -inf, 0.7197760470553669, 1.4907944345319712, 0.7980450969584688, 1.2034471398588595, 0.9290091574282189, 2.2404451328853643, 564.7188970973491, 0.43563936764416417, 2.3956223490502726, 1.1354014978513705, -10.39560697711027, 1.2717803632606155, 4.371769476442763, 0.4534689305805025, 302.44603208921336, 0.37467453498686265, 1.448164340898532, 0.10759289197746753, 389.8079715994833, 1.3489173398260093, 5.503246200865349, -197.02684616875194, -1.800496632126658, 2.770726812432733, 1.0182242182269283, 1.631248338355698, 0.6317769322752861, 0.8616694563045393, -2.9564556292398496, 0.40161458434389, -6.922493718855202, 1.1025207290812027, 0.6866044548107054, -9.242566074727655, 3.0217559529155857, 445.1625461938478, 5.867083374724869, 1.46891888527068, 12.005731351791729, 1.5072109995273366, 1.4901512434042123]
Diversité génétique : 0.08533560916232864
Score médian : 4.666272641319843, 18 parents
----
!!!!!!!!!!!!
Step : 1, 59 individuals, scores :
[8.841899545428147, 4.090547365515588, 17.21116421595514, 4.77065699457728, 4.956377423085944, 6.0781097443636485, 3.321196492521761, 9.92372314760024, 3.7431970258115905, 5.817159621867905, 7.541493747355442, 2.55807248838471, -11.66690779283398, 3.8368919656408726, 4.032566789434911, 2.846412843107308, 4.226993777608016, 3.6720945779285934, 2.969822274491968, 3.220511610003236, 2.498561567954354, 2.9322213812078743, 8.654399642908414, 3.92572945740346, 6.206715599772491, 4.381543784894818, 13.365864531738982, 7.761826511169999, 4.3831920275192235, 7.687388785987137, 51.129365697787904, 4.384800093465703, 4.216185941979507, 3.636465927509346, 5.247292767005889, 34.37420568818464, 3.8499007607644278, 4.298085546067779, 5.574899121667814, 11.041330172563073, 3.7603874389327268, 3.2448178210979846, 1.6349629189832617, -7.487951438782664, 449.3489976596971, 0.6335166294369349, 0.201119501277288, 2.0042725987383085, 4.600339006593625, 11.486351189676647, -4.932696055734611, -0.9294091027388998, 3.148317573987244, 4.0965803896121775, -2.256323701345401, 3.413228520597003, 3.2418769072798863, -46.34219424066942, -0.4030422351139757]
Diversité génétique : 0.07676796307962375
Score médian : 4.262539661837898, 12 parents
----
Step : 2, 56 individuals, scores :
[8.841899545428147, 3.2572145203497267, 17.21116421595514, 4.4554417444679695, 4.953361718900099, 6.0781097443636485, 3.9906075580173197, 9.92372314760024, 4.654410328177825, 7.042140175164652, 7.0388926606657805, 2.6421754876676764, 3.4869934905342848, 4.141890114441723, 3.4182917238132977, 4.527678734315686, 3.4206176360330405, 4.451798189188799, 2.702640224598399, 2.825499466957538, 3.4603239831609285, 8.654399642908414, 4.596913193792828, 5.669510085678991, 3.5184109342420893, 13.365864531738982, 7.161309365938562, 3.650807048587177, 7.687388785987137, 51.129365697787904, 6.2589709182240965, 3.365831597368755, 3.830518291956872, 3.716152060423954, -4.8767908798520265, 4.639841005138927, 4.847043069268666, 4.157661099957556, 3.248588980732409, 3.7441855199711855, -85.00826766588759, 0.8042110288863814, 416.7117525331471, 52.13066304083936, 2.2113019324425345, 13.556357697219621, 0.824351985667095, 0.6294274450140208, 3.729187303258644, 4.2920604045479624, 2.4168108972932454, 0.2869373879916384, 1.7533236851653442, 1.43933582480146, 103.84917889001278, 2.171080953494179]
Diversité génétique : 0.07408925320866572
Score médian : 4.37192929686838, 18 parents
----
Step : 3, 59 individuals, scores :
[8.841899545428147, 4.72399021770851, 17.21116421595514, 5.783180960783187, 4.856197251968411, 6.0781097443636485, 3.970360553087149, 9.92372314760024, 3.7002782780689216, 7.329302716905958, 7.686085340619864, 3.0789019015811454, 3.593058739449575, 4.127196647863073, 2.5765578210102937, 3.2256227467916085, 1.6564665106389571, 3.6730759192289644, 1.63621336601242, 2.910166242156957, 3.4013058490924566, 8.654399642908414, 4.271348187871986, 4.4693464487495005, 3.3882120499804134, 13.365864531738982, 7.0167754824383, 2.1064213610166247, 7.687388785987137, 51.129365697787904, 4.201918525103095, 4.6923657567080905, 3.198926111382197, 4.665400785453549, 4.164530696655821, 5.043991408952583, 3.883785419713446, 1.6103203176600032, 4.225363602263644, -113.87503465384614, 95.532219471202, 2.151953375884707, 8.245018587825472, 0.43273193993013326, 3.9383920554908745, 2.021040446283539, 1.3855453692743642, 1.43933582480146, 3.5198303086081864, 0.2767699354246848, 1.2164710871119475, -6.648860209774963, 1.8023307975784255, -1.2139132948886031, 1.193224981091023, 0.5974979681327299, 3.8366466524471035, 2.270334748340685, 1.4862967392968804]
Diversité génétique : 0.07306898439953136
Score médian : 4.048778600475111, 12 parents
----
Step : 4, 56 individuals, scores :
[8.841899545428147, 4.0996188054340355, 17.21116421595514, 5.251977752272114, 6.126837176011734, 6.0781097443636485, 3.4789073442734875, 9.92372314760024, 2.929688356321234, 7.653279316806523, 35.415594700311296, 2.4359809659259293, 3.284582904494384, 6.108196022737736, 3.3703924364769353, 4.414558801602443, 3.383331145722078, 4.714983228106385, 3.388001540879869, 1.947798385708387, 3.240410534758639, 8.654399642908414, 3.310774385745417, 5.242161461437032, 5.531847184110579, 13.365864531738982, 4.2990326952473445, 3.5262091410692187, 7.687388785987137, 51.129365697787904, 4.308461902656263, 3.0815099823449774, 4.129050942163509, 5.969763057867421, 4.184046106048344, 6.014148949961007, 4.570129280805115, -4.697959633860602, 3.5177059881549146, 2429.721986002511, 1.9535397657712772, 14.405526343216566, 3.527370159658272, 0.9374354367183988, 1.43933582480146, 0.08627497062735706, 0.22685306939143418, 2.784724206783896, 2.2778373771141953, 0.9044087562141719, 1.3661069370244598, -0.6991659726917542, 5.518831762156035, -5769.4088550825145, 1.6006305748898908, 4.304529861503282]
Diversité génétique : 0.07473547142917829
Score médian : 4.301781278375313, 10 parents
----
Step : 5, 55 individuals, scores :
[8.841899545428147, 4.4945494023001, 17.21116421595514, 5.945728938934978, 6.160654549425823, 6.0781097443636485, 3.258185863572649, 9.92372314760024, 4.778757545011497, 6.638526395660164, 6.6872113823884165, 1.8559941842055292, 4.558178319322469, 4.432056871063544, 4.0872715767902505, 3.2543134338689903, 3.194550305197941, 2.2167125260924343, 3.7264569064437647, 3.0668300044030476, 3.9349826781593764, 8.654399642908414, 3.4713221751989503, 5.36625219647747, 2.4388922999713847, 13.365864531738982, 5.625223986069061, 4.060751158436305, 7.687388785987137, 51.129365697787904, 4.501177862007256, 2.735539518142374, 3.764778454276151, 6.162749153106948, 3.9012926279903373, 6.555283425994937, 4.403684701549664, 4.60204655109179, 3.2530019012365696, 2.7322901724696296, 11.209062273991423, 4.708468346992923, 1.2229488606730854, 1.43933582480146, 2.8836790984128555, 1.5386030085711855, 0.7485161050934142, 5.518831762156035, 1.883056352616586, 3.6050747657751474, 3.520949354035668, 5.789631332568068, 2.2151389465533446, -19.427746716016095, -0.1871248403644765]
Diversité génétique : 0.0725247874092673
Score médian : 4.463303136681822, 14 parents
----
Step : 6, 57 individuals, scores :
[8.841899545428147, 3.8284490995536156, 17.21116421595514, 5.271635578281081, 5.956774149471682, 6.0781097443636485, 4.533595262445991, 9.92372314760024, 3.857824806478167, 6.988505487495245, 7.0878284400694564, 3.0915342155325107, 4.400334242336775, 4.519193799677311, 2.438362009486327, 5.121359291722373, 3.604416210855215, 3.2003634242805434, 2.8504857352294883, 2.4589362550434557, 3.541894589141522, 8.654399642908414, 3.926772449011548, 5.774913339036373, 2.6587507176672, 13.365864531738982, 7.602718449063035, 3.7208579221104428, 7.687388785987137, 51.129365697787904, 4.099324609322511, 4.584065960682122, 3.007973042697571, 4.387044294318439, 3.727387180176818, 5.230378266169432, 3.733732277612413, 4.810222269787301, 4013.7694717771483, 2.251778703512486, 12.218501609833162, 2.4716022074363564, 3.059962412563443, 3.571427291811005, 5.518831762156035, 0.8204249080097281, -14.694510289889829, 265.6045582673522, -1.9585040624643937, 2.3996511181340963, 0.6585806611927221, 2.925717880776732, 9.173965484310507, 3.4924667808409855, 18.572333746965466, 0.5989819184194672, 0.2017907483513809]
Diversité génétique : 0.07051505960390331
Score médian : 4.526394531061651, 10 parents
----
Step : 7, 55 individuals, scores :
[8.841899545428147, 3.4236051533086096, 17.21116421595514, 6.4240553523911155, 5.7456232839952905, 6.0781097443636485, -0.08268947835231885, 9.92372314760024, 4.146533453031004, -0.8273259303380829, 6.745958800604264, 2.692346299536659, 3.83882627482708, 3.7052859472529605, 2.4155095467256964, 3.513271724729497, 3.7186428127939384, 3.2403335218582305, 4.02010495995814, 2.6873487366717366, 3.584496840694474, 8.654399642908414, 4.031476304795713, 5.700000832570256, 2.793219884563121, 13.365864531738982, -1.8696972062025474, 4.524758791848983, 7.687388785987137, 51.129365697787904, 3.7384220940312463, 4.20582469651591, 3.1286916285473323, 4.807039058381897, 3.74204518536672, 4.622934597097959, 4.406032898885252, 3.8093132959947456, -8.190370495349317, 0.7775058464669267, 3.018527719941115, 2.7704294108213796, 2.687706350550134, 5.518831762156035, -5.303034990566486, 1.1533634209279362, 2.4250422813530075, 9.173965484310507, 2.7901126610346036, 2.595762808335899, 0.04257211559681544, 2.192505363011438, -1.0506865629894708, 1.5717358539515671, 1.8403448103815712]
Diversité génétique : 0.07004108534401203
Score médian : 3.740233639698983, 12 parents
----
Step : 8, 56 individuals, scores :
[8.841899545428147, 4.288953530317912, 17.21116421595514, 4.6230213016539805, 4.2446585228295755, 6.0781097443636485, 3.5629255766106627, 9.92372314760024, 4.584532420143146, 7.9829662382941855, 2.9361240427648703, 4.320527511984344, 3.7124867723425647, 4.381955457143937, 4.564092271173407, 5.144074221639628, 2.5343167448126547, 3.718888289556491, 2.875457674908173, 2.639685156395343, 8.654399642908414, 3.2632613683805545, 7.898442573846836, 3.194996141372854, 13.365864531738982, 4.7951866017456775, 7.687388785987137, 51.129365697787904, 3.660603083756558, 3.2855525244365666, 3.510487040265866, 4.947714473800355, 4.105127010927677, 6.0369512356322526, -4.725749954038715, 3.971378513110759, -57.23838268311223, 3.653235999991005, 3.1470861117637745, 2.4325915011006876, 5.518831762156035, 1.66943540246482, 4.1701197021732925, 9.173965484310507, 2.809221625223469, 3.0798450466201417, 0.04257211559681544, 2.207157238787979, 1.3223020034067514, 2.160594713228853, -1.811640750183488, 0.024132805678362613, 0.14392592540384821, 3.5815248883025914, 1.6057129997089774, 0.5435850919851846]
Diversité génétique : 0.07068812035111668
Score médian : 4.0382527620192175, 14 parents
----
Step : 9, 57 individuals, scores :
[8.841899545428147, 4.776294458258114, 17.21116421595514, 5.245819755517367, 4.561419030702153, 6.0781097443636485, 2.9801459074191667, 9.92372314760024, 7.612953564028695, 7.493987789724954, 1.9474069219529633, 4.305061507944279, 3.8036622230634585, 1.7025169934678424, 4.1596539298109585, 3.3389047509611496, 3.7372036480180606, 2.2191542060376714, 2.3748614104524424, 3.5331856978541363, 8.654399642908414, 3.1485844301463244, 5.712709460066567, 4.286706921716886, 13.365864531738982, 3.5544981911440643, 7.687388785987137, 51.129365697787904, 3.693864215244287, 3.4664938839212605, 3.3060943935071667, 4.600729542291198, 5.0068263606655155, 3.371408549857117, 3.578254547006217, -5.887188445019891, 3.1082504151491133, 1.4376339948179837, 5.518831762156035, 1.9801059556874898, 1.8681089070264587, 9.173965484310507, 2.627782262227885, 0.6446759589325802, 3.5504189489447335, 1.739667841993457, 2.699500087886019, 4.8338346651808655, 2.752063967630443, 1.1609022550578882, 4.390760893124967, 2.170696630083238, -276.5173071038124, 4.427163481535815, 5.843739435721435, 2.701200473276262, -6.0560487758995665]
Diversité génétique : 0.07073078982601949
Score médian : 3.9816580764372085, 18 parents
----
Step : 10, 59 individuals, scores :
[8.841899545428147, 4.176231344175649, 17.21116421595514, 0.5851430786977421, 6.171670145474694, 6.0781097443636485, 3.679847068490205, 9.92372314760024, 4.394070053184972, 7.880141958536427, 2.669192840832951, 4.864102646783689, 4.516453557677326, 3.5736801779231504, 3.5296175384785826, 3.2863003437483296, 4.096187794855352, 2.9010363196253395, 3.3314753977763116, 8.654399642908414, 4.40542267677933, 5.206858515072614, 3.5716766599290652, 13.365864531738982, 4.232280907760433, 7.687388785987137, 51.129365697787904, 2.879094275689235, 4.883076143709326, 3.753250868011638, 4.897088973145474, 4.360131723250362, 4.5991450952773985, 3.959328757860447, 3.1637063618696977, 5.518831762156035, 3.668802379289749, 2.7653968186072713, 9.173965484310507, 2.995181572594933, 2.8079612368780817, 1.6846745491308808, 2.146882839553182, 4.489816952068731, 2.0847286862413186, 4.152771820473012, -2.4869214317241943, 4.476263436370584, -0.5579450871553409, 0.5772570980350125, -0.4518352183392701, 3.770439890006742, 1.316896089272935, 1.6497135145922095, 3.9096735532827727, -1.7220167435336384, 6.741291456280972, -4.130900207717504, 3.3507829629755386]
Diversité génétique : 0.0730353541913885
Score médian : 4.204256125968041, 12 parents
----
!!!!!!!!!!!!
Step : 11, 55 individuals, scores :
[8.841899545428147, 3.3498361199657616, 17.21116421595514, -20.142332773044533, 6.0781097443636485, 3.4191077484241177, 9.92372314760024, 3.949288577954382, 7.645461042046621, 2.3998590272729747, 4.930007692265578, 4.4927050211948485, 3.539494269957533, 3.785617618731633, 3.6851641376399416, 3.2330828972267316, 3.2776315056531633, 3.292046453424356, 8.654399642908414, 3.792040114142848, 7.3265645716213355, 3.39714969450531, 13.365864531738982, 4.879000467093781, 7.687388785987137, 51.129365697787904, 4.149760971565946, 3.429937430104358, 3.0672788499649624, 3.8459371017121438, 3.6306525616833487, 5.244297146174808, 5.378482756243174, 3.820219856446214, 5.518831762156035, 2.3066798692335615, 3.4694637783174938, 9.173965484310507, 2.926753288435572, 2.3764860038893967, 1.5608365986568296, 2.373960828011964, 3.688724566973826, 1.5005666287012607, 5.452459081865818, 4.414102649787279, 3.0878262958863494, 3.142264134441138, 5.518265314235016, 3.3507829629755386, 0.8964988268264505, 6.557637263725726, 3.6898735880941564, -3.970104098787619, 4.2424471105956085]
Diversité génétique : 0.0718793365367254
Score médian : 3.833078479079179, 16 parents
----
Step : 12, 58 individuals, scores :
[8.841899545428147, 4.429099540792832, 17.21116421595514, 6.0781097443636485, 3.3899735051303295, 9.92372314760024, 3.7331580870796746, 7.32077135529442, 3.189366371538251, 4.090685544330653, 4.279353038039948, 4.378004619568474, 3.0859038637766534, 3.60370693094057, 2.8283703437522405, 2.438558980063496, 1.6055610199875576, 8.654399642908414, 3.9257194119395047, 6.143606368665903, 5.047038509206771, 13.365864531738982, 5.675168096946714, 7.687388785987137, 51.129365697787904, 5.352828456604748, 4.385171843808715, 3.3256803274877216, 5.924509612098201, 3.9099253911315444, 4.605736635885626, 3.837514511086502, 4.073477852660092, 5.518831762156035, 2.492281614835902, 2.0737347925500695, 9.173965484310507, 2.599870319245263, 2.3614137672095947, 2.4815872322925703, 5.138499819375838, 22.764957731106715, 5.183617463174735, 2.7605769425509803, 3.565420433270862, -1.6080168056105921, 3.3507829629755386, 3.730340114694286, 4.362986634096963, -11.369060722659267, -2.2361937998972743, 1.5827785679735649, 3.376125685789652, 4.0609520130575625, 1.465953806863606, 0.9734768761606188, -0.08297397091198348, 3.4852975106849233]
Diversité génétique : 0.06908903820597924
Score médian : 4.1850192911853, 16 parents
----
Impossible d'actualiser la position de Left knee link (D) 1 : contraintes insolubles <class 'Exception'>
Step : 13, 58 individuals, scores :
[8.841899545428147, 3.954419766215355, 17.21116421595514, 6.0781097443636485, 3.9612690695527046, 9.92372314760024, 4.368437029816416, 8.051865282841954, 3.0848442331328654, 4.90577672901546, 3.441326709818946, 4.218744345918192, 3.1352083719520785, 3.6168566946522174, 3.289388242955703, 2.7101761204103125, 8.654399642908414, 2.967844853546593, 4.426009225421677, 3.041170449877984, 13.365864531738982, 4.78011706889701, 7.687388785987137, 51.129365697787904, 5.8780593452387455, 3.882928472059032, 3.819941006457109, 5.009308175372883, 5.126476280509736, 4.338067513484821, 4.059151184922028, 2.6005096813998314, 5.518831762156035, 1.832599811605626, 1.6571313331600266, 9.173965484310507, 1.762703069423981, 2.083734688128504, 2.4723440815384534, 3.417890161047694, 3.1888662453663863, 4.128451526243754, 3.8752175701096734, 4.402868559885167, 3.3507829629755386, 4.484825619264062, 0.23926425138342827, 3.081325730482396, 3.3922829915071735, 118.03585567670474, 3.2745340216824053, 0.6241108584911088, -47.647081560992525, 6.757782533984967, -76.76411949411009, -1.5813428875616424, 4.5192945332023315, -inf]
Diversité génétique : 0.06931117600536323
Score médian : 4.173597936080974, 18 parents
----
Impossible d'actualiser la position de Left knee link (D) 1 : contraintes insolubles <class 'Exception'>
Step : 14, 59 individuals, scores :
[8.841899545428147, 4.5197532773854645, 17.21116421595514, 6.0781097443636485, 3.3085255926695933, 9.92372314760024, 4.608803571942344, 7.053536482179141, 2.7162135452345826, 4.192646332908256, 4.503776832753152, 4.1813863371822855, 3.3329008475082564, 2.4823555093863923, 4.60800269158696, 3.2251797836403258, 8.654399642908414, 3.7003222372525193, 6.15171348381482, 4.705231801116031, 13.365864531738982, 5.167201963335438, 7.687388785987137, 51.129365697787904, 3.3462071748071796, 2.7167747798538544, 3.388830663531149, 6.44167765646695, 4.4612438381973405, 5.647865790053818, 4.82144515196159, 2.816065612578561, 5.518831762156035, 1.258887890236113, 9.173965484310507, 2.7629075011523083, 4.774158516202566, 4.225919174019941, 63.63429021504194, 1.5043890950928163, 4.133055635625547, 3.7213651881268834, 3.3507829629755386, 2.7611015667357166, 3.6251198442653227, 3.6819345598523903, 81.00492207296983, 2.0313509073435982, 6.757782533984967, 5.398965618743155, -inf, 1.0359471397466364, 5.202810252078823, 1.8312345901856155, 75.49438934537424, 4.353959799654517, 3.283265530032624, 2.609594686536023, -inf]
Diversité génétique : 0.0693016809212765
Score médian : 4.608403131764652, 8 parents
----
Step : 15, 54 individuals, scores :
[8.841899545428147, 4.327839208173666, 17.21116421595514, 6.0781097443636485, 3.333661603957278, 9.92372314760024, 3.963238273768662, 7.048964749432464, 2.677689393074038, 3.7511039010133542, 4.420493805050919, 4.219384902892884, 3.5237292063703536, 3.119715560552174, 2.857203081333875, 8.654399642908414, 3.7905948107284346, 4.90285365094573, 4.885608287429699, 13.365864531738982, 4.426532946419272, 7.687388785987137, 51.129365697787904, 3.7147049811363484, 5.0723182112180165, 3.9212359765786595, 4.344944229111449, 4.246033637608936, 4.57748056660808, 4.087590524935258, 3.384031303319965, 5.518831762156035, 9.173965484310507, 2.382923079955251, 2.6810911287572745, 4.691794963036175, 2.100806242583947, 3.730770194019172, 1.8871319056274551, 3.3507829629755386, 3.039214261636418, 3.7408708690019226, 3.710039258338287, -12.8501010516978, 6.757782533984967, 4.975187965779301, 5.202810252078823, 75.49438934537424, 4.353959799654517, 1.8986154250747076, 1.721012221141743, 3.96338715727508, 1.5963110105956444, -2.241578640761033]
Diversité génétique : 0.06622264468483123
Score médian : 4.286936422891301, 14 parents
----
Impossible d'actualiser la position de Left knee link (D) 1 : contraintes insolubles <class 'Exception'>
Step : 16, 57 individuals, scores :
[8.841899545428147, 2.817874573910863, 17.21116421595514, 6.0781097443636485, 3.367950288950239, 9.92372314760024, 4.2855950719114615, 8.137657713433422, 3.0538386623104508, 2.146280551919411, 4.413666399507742, 4.360134805332665, 3.4870223606959296, 3.9989001961925243, 2.8449943202947017, 8.654399642908414, 3.192707767938479, 6.428504901303111, 2.505297838772523, 13.365864531738982, 4.401836814775993, 7.687388785987137, 51.129365697787904, 4.153240568196287, 3.5280577526258985, 3.0623314716984478, 4.153657426329328, 4.625628226851239, 2.0196870149143415, 4.246522168926173, 3.4219159407814628, 5.518831762156035, 9.173965484310507, 2.6145803526448916, 2.165636531018593, 4.370780637217167, 3.6206427239632597, 2.8719253880253457, 2.13130550003251, 3.3507829629755386, 2.353013633134824, 3.780757983464652, -2.7174984795980883, 6.757782533984967, 4.696623980906332, 5.202810252078823, 75.49438934537424, 4.353959799654517, 1.2181420148804922, 2.1718120492879827, -1.3262753766891031, 26.970627981518124, 1.0848013531862604, -4.113727486493729, 7.630956278180568, -inf, -1.8770420524841005]
Diversité génétique : 0.07160262412083677
Score médian : 4.266058620418818, 16 parents
----
Step : 17, 58 individuals, scores :
[8.841899545428147, 4.087182636329621, 17.21116421595514, 6.0781097443636485, 2.66830007186288, 9.92372314760024, 4.203838686701404, 7.20152137039308, 1.9370579694949246, 3.543326216126268, 4.148725737420379, 3.5317650477047504, 3.543181991537434, 4.572243435815479, 2.846790546157774, 8.654399642908414, 3.5782529288275793, 5.499226957198303, 3.330370177122597, 13.365864531738982, 4.191578469675047, 7.687388785987137, 51.129365697787904, 4.434141165271981, 4.7240287511541785, 3.7259411426117555, 4.798222056814351, 4.698735135734716, 4.8142587539980495, 3.3571812816310573, 3.520610436488601, 5.518831762156035, 9.173965484310507, 3.048492105905841, 2.419397397040863, 3.0629655438394257, 4.363066456385301, 2.928941092752337, 0.22240199444785808, 3.3507829629755386, 3.583231211736961, 2.1199648839972873, 6.757782533984967, 5.41159534019196, 5.202810252078823, 75.49438934537424, 4.353959799654517, 4.680850649793585, 26.970627981518124, 8.721442972621544, 5.183813400063117, 28.873538321909905, 3.5474352654252868, 10.128590657837755, 5.766945406932142, 1.137376127857856, 13.125147830093264, 3.9972614989677244]
Diversité génétique : 0.06993483271080259
Score médian : 4.7611254039842645, 12 parents
----
Step : 18, 56 individuals, scores :
[8.841899545428147, 4.444048122442989, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 4.2771847603090425, 7.5705136075622415, 3.387558634891141, 3.1485414662933375, 3.9059746576449843, 2.2689174779121606, 1.9974129285403168, 8.654399642908414, 3.528965669267452, 2.1806105113595473, 3.6486672131889937, 13.365864531738982, 3.6711426742174007, 7.687388785987137, 51.129365697787904, 3.4288066522895093, 3.9271759395851036, 3.770028898614689, 4.791936364369985, 3.74670893770979, 4.832521091531101, 4.465311558540966, 2.638615631041626, 5.518831762156035, 9.173965484310507, 2.01474730566635, 4.277217017079924, 5.131490886278555, 3.3507829629755386, 1.9140362755521096, 6.757782533984967, 4.583976901599542, 5.202810252078823, 75.49438934537424, 4.353959799654517, 0.34615327236196775, 26.970627981518124, 7.759201739699419, 5.902579706994569, 28.873538321909905, 1.493020155164651, 10.128590657837755, 3.2117623693528063, 13.125147830093264, 3.9972614989677244, 20.875166556674188, -1.447879512844707, 0.6711813761787995, 3.467269633287887, 2.6296567011653154, 1.006276290569659]
Diversité génétique : 0.07232024087691465
Score médian : 4.524644230070255, 10 parents
----
Step : 19, 55 individuals, scores :
[8.841899545428147, 6.146174843167764, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 4.782020227234806, 7.517715216669219, 4.700066841972236, 4.794878345979245, 4.259459875063443, 3.6523036545551686, 3.222334396887038, 8.654399642908414, 3.4221016881149877, 7.869727849883916, 3.9794804213446198, 13.365864531738982, 4.496556278226031, 7.687388785987137, 51.129365697787904, 3.76040031958651, 2.928547565091228, 3.5814291526985205, 4.57090905826385, 3.1198738880021533, 4.294249162106213, 4.042379409875375, 3.2769912343781615, 5.518831762156035, 9.173965484310507, 1.8226563995368668, 3.6257129171218203, -76.9507211565541, 3.3507829629755386, 6.757782533984967, 6.310779170818733, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 2.6559098856189283, 5.760300473716279, 28.873538321909905, 10.128590657837755, 2.4091920724024636, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 3.467269633287887, 2.6296567011653154, 1.815323914788438, 0.09445938497188731, 0.7921723754368791, 3.12828387685964, -5.266225105518042]
Diversité génétique : 0.07500344952301964
Score médian : 4.741043534603521, 14 parents
----
Step : 20, 57 individuals, scores :
[8.841899545428147, 4.381594069872165, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 3.8913689559938285, 7.445590561940415, 4.086528990781933, 4.950853611487696, 4.293414065145293, 3.56477220037407, 3.5065166050534176, 8.654399642908414, 3.9883737699556354, 5.708685249980929, 6.364967215122838, 13.365864531738982, 4.6815178156765445, 7.687388785987137, 51.129365697787904, 3.00436205673296, 3.5411184362647763, 3.598593872495616, 5.212551451307112, 5.241085340039172, 4.7232967799691, 3.373034060152911, 2.861399254718713, 5.518831762156035, 9.173965484310507, 3.038430718506106, 3.392375973237367, 3.3507829629755386, 6.757782533984967, 4.2463471051787804, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 9.466075752756018, 4.380101664179133, 28.873538321909905, 10.128590657837755, -7.1285508100108945, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 3.467269633287887, 2.6296567011653154, 3.12828387685964, 1.7801147519676437, -10.206221555816674, 8.892469937696395, -6.346683680898104, 5.144691479830308, 1.0526236516564347, 3.492623360043373]
Diversité génétique : 0.07591401601453981
Score médian : 5.173750865954565, 12 parents
Step : 0, 100 individuals, scores :
[8.841899545428147, 4.131542649541881, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 5.236284412675458, 7.574272959529957, 3.151129804853276, 4.297579616151085, 3.792233402061624, 2.9602295897181885, 4.6970880997062965, 8.654399642908414, 3.697959273504637, 5.337403264108364, 5.172686723984746, 13.365864531738982, 4.213837796500167, 7.687388785987137, 51.129365697787904, 4.796362327488547, 3.310988843821689, 3.0968483213631997, 5.034760070179564, 4.385141664814266, 5.090556325481278, 4.776486754951458, 5.518831762156035, 9.173965484310507, 1.4809332799107537, 4.072170672243729, 3.3507829629755386, 6.757782533984967, 5.107141533214011, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 7.839627453684082, 6.0354386962557065, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 3.467269633287887, 3.12828387685964, 8.892469937696395, -2.248594052790765, 1.0119708458491465, 0.9085281741945429, 1.9824774118717157, -1621.657822391841, 3.500001238052095, 60.554777695584704, 2.379228110985191, 2.1149505493209153, 1.7315411182811216, 11.306943838859025, 1.616609967300769, -143.83683131952438, 2.966734697877495, -4.915576551198354, 34.25170097848791, 34.752119603681265, 3.3377783592095085, 0.9593921106668792, 2.6727985109216785, 4.6858313772388405, -0.9528712567464617, 1.5246733659444573, 0.7222709566027168, 1.830603244504291, -0.25797968505782304, -9.089393534151387, 4.014080718865725, -0.6676981732370183, 2.8492106842229714, 2.656743362120682, 0.09189335166004475, 1.8697590012847662, -inf, 16.531631324848444, 1.9366198559750372, 1.0462677469882466, 4.577593673943344, 0.8126095513745645, 0.9763010046721716, 1.7290262168484392, 2.3955089756303773, 0.0281254288511587, 3.1494838830913707, -1.7325946747937768, 1.2039222555055602, 2.583573823462106, -0.5315972644219575, 3.7005502189364137, -3.1755826024694334, 3.348331236151749, 0.6471776651049692]
Diversité génétique : 0.3151155547326411
Score médian : 5.777135229205871, 16 parents
----
!!!!!!!!!!!!
Step : 1, 58 individuals, scores :
[8.841899545428147, 4.738145375908796, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 3.3790762848388454, 8.063085101227463, 3.284453548816702, 4.2682678959420075, 3.1777688393364745, 8.654399642908414, 4.458479389048116, 5.65465088862344, 4.240860029505439, 13.365864531738982, 4.039708385206757, 7.687388785987137, 51.129365697787904, 3.9704232360175964, 4.768957058638601, 3.7607983340344946, 5.825410657306718, 3.738818679682341, 5.518831762156035, 9.173965484310507, 3.4743441542086138, 6.757782533984967, 4.810409430892072, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 8.878543503232692, 4.483792198726205, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 8.892469937696395, 2.899668130459948, 60.554777695584704, 11.306943838859025, -8.139680532856648, 34.752119603681265, 4.6858313772388405, 4.145033114919773, 2.8605074988533707, 3.9827150587979103, 2.9267304804604892, 8.818798490197423, 0.4695794927913869, 0.7037541135446082, 0.2552284856286633, 6.308353235265485, -0.6887592470795592, 2.2636086571514595, -10.643858827172775]
Diversité génétique : 0.23256157591297655
Score médian : 5.7400307729650795, 16 parents
----
Step : 2, 57 individuals, scores :
[8.841899545428147, 6.312880293074199, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 5.254421387898289, 7.878552878934767, 4.920633713760781, 4.056850091692327, 3.2725928605351564, 8.654399642908414, 4.050101926454473, 6.171784988557057, 3.5547402863119104, 13.365864531738982, 3.6489968199883123, 7.687388785987137, 51.129365697787904, 4.43373691970319, 2.7914951361254876, 6.008147845613082, 4.993136317936909, 3.3370173840986523, 5.518831762156035, 9.173965484310507, 7.170438474796568, 6.757782533984967, 5.425401556156194, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 9.220488391355559, 7.881169809423875, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 8.892469937696395, 1.6224505730731582, 60.554777695584704, 11.306943838859025, 34.752119603681265, 4.6858313772388405, 3.2885023595964467, 5.191789181458046, -7.6696803567188265, 7.465843619901319, 5.816527780482422, -1.8504043627066893, 65.28253641743342, 2.2516941504751826, 1.6543121354648194, -2.427417189819118, -13.243848002354852, -6.490962256716747]
Diversité génétique : 0.21788325078145326
Score médian : 6.535331413529583, 16 parents
----
Step : 3, 58 individuals, scores :
[8.841899545428147, 3.1986664557407902, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 5.2870048324669705, 7.446106608646666, 4.510600953142843, 4.543947804263732, 3.5171567642964394, 8.654399642908414, 3.2860959543341917, 4.027928634161321, 4.2820220327552745, 13.365864531738982, 5.802425768234001, 7.687388785987137, 51.129365697787904, 3.452331944360119, 5.36602402413479, 3.7875737527308253, 5.581264464435151, 4.438060589393323, 5.518831762156035, 9.173965484310507, 4.61020376906667, 6.757782533984967, 4.898461748921692, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 7.8386014980991305, 4.023001073603226, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 4.6858313772388405, 1.0133219216076998, 4.001492662095472, 10.57504230018921, 4.906831480427751, 65.28253641743342, 1.518548637524115, -0.5213351520657615, -2.84603199282384, 1.8802209105545205, 2.740870945788143, -9.4984160798808, 1.8236460452761134, 3.313298917684979, -10.426005893779742]
Diversité génétique : 0.2257037895024382
Score médian : 5.6918451163345765, 16 parents
----
Step : 4, 58 individuals, scores :
[8.841899545428147, 4.22543345874571, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 4.156417773981107, 6.754794583877671, 3.617378757073701, 4.765781103199844, 2.78047469093495, 8.654399642908414, 3.1439684176414477, 6.331601987829356, 4.256351388765453, 13.365864531738982, 4.156186474303172, 7.687388785987137, 51.129365697787904, 4.577661723500541, 4.732395056521815, 4.8277187756794415, 4.33917589049753, 3.90105897686362, 5.518831762156035, 9.173965484310507, 4.274938007507707, 6.757782533984967, 4.616591042844398, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 7.301627610387616, 5.903525955537965, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 4.6858313772388405, 3.9097134203667423, -40.34498441059025, -5.0277335195584465, 65.28253641743342, 1.7608346309596585, 3.313298917684979, 1.2053210589618124, -5.996324167934192, 0.32511408374062584, -21.28283876638175, 177.7432235157822, -2.1345714799579505, -0.29414430076078557, -156.59449176027576]
Diversité génétique : 0.21673184812697635
Score médian : 5.9908178499508065, 16 parents
----
Step : 5, 57 individuals, scores :
[8.841899545428147, 4.216738000585439, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 4.941141195607031, 23.546252738778172, 5.148881810707109, 4.701984368159967, 3.695716938017148, 8.654399642908414, 3.8993359485905033, 5.5719803285980944, 4.65093821474313, 13.365864531738982, 4.066936551982084, 7.687388785987137, 51.129365697787904, 3.798792361111623, 5.568564084935219, 4.499973292649153, 5.024107057008816, 7.606916018795556, 5.518831762156035, 9.173965484310507, 3.394152384692379, 6.757782533984967, 4.385804341914857, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 7.31511992861245, 7.778753244846138, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 4.6858313772388405, 4.377270210608352, 65.28253641743342, 1.6488738332747712, 3.313298917684979, 1.2053210589618124, 177.7432235157822, 3.5133120187100633, 2.9361240172473537, 6.310107929634969, -1.0326443684486077, 3.287608227122617, 2.617048497648956, 4.6214370038579675]
Diversité génétique : 0.23721349800956062
Score médian : 6.533945231809968, 16 parents
----
Step : 6, 57 individuals, scores :
[8.841899545428147, 3.8984049342206233, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 3.9902839975447777, 29.792140347017565, 4.63519804797055, 4.12743178436685, 3.8396590091794254, 8.654399642908414, 3.4739510434851884, 5.825539371481461, 3.9288583631426324, 13.365864531738982, 4.772993775128139, 7.687388785987137, 51.129365697787904, 4.331732867470492, 5.903277931658632, 3.782302932108902, 5.371532817944066, -3.469980543136707, 5.518831762156035, 9.173965484310507, 4.654001066301898, 6.757782533984967, 5.448617413648314, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 6.830355685781721, 4.977946200076434, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 4.6858313772388405, 4.171361873147039, 65.28253641743342, 177.7432235157822, 6.50795158062083, 5.597038876913323, 2.279428211003987, -24.02754758194125, 13.846735234016704, 7.483072404298703, 3.285132701829261, 0.8854967448168247, 3.8196933743986174, 2.3514691513690855]
Diversité génétique : 0.24484691804154862
Score médian : 6.6328670573028985, 12 parents
----
Step : 7, 56 individuals, scores :
[8.841899545428147, 4.431375102535241, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 4.280472389391493, 7.2778811964822685, 5.09060571961649, 4.167126832871108, 3.7326790076537377, 8.654399642908414, 6.1801659668724005, 3.972125461804223, 13.365864531738982, 5.128045276773369, 7.687388785987137, 51.129365697787904, 4.613169674414707, 6.18875815822867, 4.1371116772957715, 5.5730166025121175, 5.518831762156035, 9.173965484310507, 4.97762320570709, 6.757782533984967, 4.2348112464098415, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 3.755729440520416, 7.08103917766782, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 4.6858313772388405, 3.428927707814215, 65.28253641743342, 177.7432235157822, 3.3715046879357917, 5.632537591227213, 1.4221111487214706, 7.483072404298703, 3.8196933743986174, 7.730483461970432, 2.544235769258882, 2.9713737909693267, 3.102022557412282, 18.02647675008718, 6.1938875021076045]
Diversité génétique : 0.22629922645409478
Score médian : 6.919410855826394, 10 parents
----
Step : 8, 55 individuals, scores :
[8.841899545428147, 4.826028673224043, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 4.207871075106814, 8.49157062404793, 4.082599277866172, 3.096368801187454, 3.820056701985628, 8.654399642908414, 6.333877806039163, 6.845409759075614, 13.365864531738982, 4.39359270866663, 7.687388785987137, 51.129365697787904, 4.053397215501569, 5.613167071094824, 4.374421978067457, 5.5594842801220885, 5.518831762156035, 9.173965484310507, 3.873986909648825, 6.757782533984967, 5.0412017546802375, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 6.874384243318641, 8.072767201716028, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 4.6858313772388405, 65.28253641743342, 177.7432235157822, 4.995709808993613, 7.483072404298703, 3.8196933743986174, 5.56872669621079, -5.210688486228286, 17.350566537596904, 2.2499480214612113, 2.0351245318145215, -3.1630890593916017, 3.966665269431, -4.487682784649569]
Diversité génétique : 0.21395762919856467
Score médian : 6.859897001197128, 14 parents
----
Step : 9, 57 individuals, scores :
[8.841899545428147, 4.324648546812454, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 4.942386880415856, -2.5155427061951645, 4.888090158562673, 3.6346854669718796, -0.46847794989565017, 8.654399642908414, 5.716150880632244, 5.42779819886516, 13.365864531738982, 4.616269829312296, 7.687388785987137, 51.129365697787904, 4.483075581320569, 6.112859691847432, 4.470319191527706, 5.621673666707304, 5.518831762156035, 9.173965484310507, 4.1912213611281475, 6.757782533984967, 4.375010670808403, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 9.742504985415284, 5.961600105882268, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 4.6858313772388405, 65.28253641743342, 177.7432235157822, 5.890378882203658, 7.483072404298703, 3.8196933743986174, 7.521930444370476, 6.612592718910694, 3.966665269431, 1.0964733464920515, 7.048395645910115, 4.026379376086154, 3.4820133758675778, 3.860587067373851, -0.39609810796625405, 0.6997641548802589]
Diversité génétique : 0.24241218504522033
Score médian : 6.6851876264478305, 12 parents
----
Step : 10, 55 individuals, scores :
[8.841899545428147, 3.822986630220613, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 5.44799708271765, 4.881019797584385, 8.654399642908414, 6.1165557321171615, 4.397133524431042, 13.365864531738982, 4.215025243837608, 7.687388785987137, 51.129365697787904, 4.166750600113201, 4.773367152608318, 4.229802274197714, 5.043219272885314, 5.518831762156035, 9.173965484310507, 4.2857290885656, 6.757782533984967, 3.4690109281556483, 5.202810252078823, 75.49438934537424, 4.353959799654517, 26.970627981518124, 7.889629344187642, 6.710478217748576, 28.873538321909905, 10.128590657837755, 13.125147830093264, 3.9972614989677244, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 4.6858313772388405, 65.28253641743342, 177.7432235157822, 1.5670532528934413, 7.483072404298703, 3.8196933743986174, 4.629521640282769, 6.1899159457248745, 3.966665269431, 6.8868294197631466, -20.257258358342053, 5.926076051949304, -3.1583267881938797, 3.1770543680327368, 0.15367481888180126, 0.845733381868262, 5.6948081961099435]
Diversité génétique : 0.24322509693106079
Score médian : 6.450197081736725, 12 parents
Step : 0, 100 individuals, scores :
[8.841899545428147, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 8.654399642908414, 5.279501756462565, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 6.757782533984967, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 5.659968074730319, 38.867594075769304, 6.301515234744067, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.555146282048149, 6.09334974205582, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 5.511008672582694, 7.162114137560062, 12.924241198699994, 2.984209922145787, -inf, -0.46958157124325817, 0.8756577772055792, 1.6955360235218988, 0.9165136452107099, 1.5610136599457518, 0.3854105269258367, -1.520666047036173, -0.14141453533704787, 1.1188112646378237, -0.9679255468833075, -1.3107593608295336, -1.775423801675618, 1.9843834584062021, 4.550793819292331, 0.7887420103132061, -inf, 4.4242840882887995, 0.21778827118504038, 1.0917312435078992, 2.2828584749892396, -1.1294633096023914, 0.4685580712872627, 0.10403667113856783, 3.1552808999613373, 2.5616222388992673, -3.879759424292306, 1.7987957472269966, -8.563851516684489, 1.311797627407729, -inf, 1.2272724272041766, -28.232264360080595, 1.2638316225811022, -8.589650575486619, 12.211515231455888, 4.424763943060358, -0.2891092886744033, 4.1448481981380185, 1.4085704905563048, 0.1884606844310762, 2.399804119859837, 1.5554591403964735, -0.9662435897729257, 1.5698653654627188, 0.0423332832923914, -1.0941170725159572, 1.207832379417004, 3.007463164586988]
Diversité génétique : 2.909876643117706
Score médian : 12.718668637915027, 14 parents
----
!!!!!!!!!!!!
Step : 1, 55 individuals, scores :
[8.841899545428147, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 6.757782533984967, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 5.659968074730319, 38.867594075769304, 6.301515234744067, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.701932092000915, 6.09334974205582, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 5.550664719181826, 7.162114137560062, 12.924241198699994, 0.26877591231625386, 0.2558080701740115, 3.7486842444752924, 20.885013944286225, 31.34712308517308, -0.37553638157247693]
Diversité génétique : 3.2669297481733044
Score médian : 13.245506180916124, 14 parents
----
Step : 2, 54 individuals, scores :
[8.841899545428147, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 6.757782533984967, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 5.659968074730319, 38.867594075769304, 6.301515234744067, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.673661243839938, 6.09334974205582, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 7.162114137560062, 12.924241198699994, 20.885013944286225, 31.34712308517308, -6.200147568880835, 0.1562396552932652, 0.38650287516456033, -0.5508705818469164]
Diversité génétique : 3.286950542894045
Score médian : 13.245506180916124, 14 parents
----
Step : 3, 55 individuals, scores :
[8.841899545428147, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 6.757782533984967, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 5.659968074730319, 38.867594075769304, 6.301515234744067, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.655448548559834, 6.09334974205582, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 7.162114137560062, 12.924241198699994, 20.885013944286225, 31.34712308517308, -627.250458052225, 4.2524638429376305, 38.1525416098616, 3.2012430808560097, -0.5195936374713225]
Diversité génétique : 3.27273169242645
Score médian : 13.443771566088856, 14 parents
----
Impossible d'actualiser la position de Left foot (H) 0 : contraintes insolubles <class 'Exception'>
Step : 4, 55 individuals, scores :
[8.841899545428147, 17.21116421595514, 6.0781097443636485, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 6.757782533984967, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 6.301515234744067, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.66603352510494, 6.09334974205582, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 7.162114137560062, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 5.642041795363295, -6.501839437891045, 6.788768585399605, -inf, -2.8606340710605935]
Diversité génétique : 3.2292750212645807
Score médian : 13.443771566088856, 16 parents
----
Impossible d'actualiser la position de Left foot (H) : contraintes insolubles <class 'Exception'>
Step : 5, 56 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 6.757782533984967, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 6.301515234744067, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.598126430261622, 6.09334974205582, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 7.162114137560062, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 10.269787435797085, 2.540778006638025, 2.0213140074314397, 5.55637890707792, -0.549804176379151, 0.3001493522449647, -inf]
Diversité génétique : 3.279248232160649
Score médian : 13.443771566088856, 14 parents
Step : 0, 100 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 6.757782533984967, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 6.301515234744067, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.851685196358277, 6.09334974205582, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 7.162114137560062, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 6.078773888336908, 6.172227285512937, 1.8267587938514587, -inf, 0.30548149883424663, -7.439960452340025, 0.42652854191675166, 5.4793165462721625, 0.7149018508863713, -inf, -0.6048225092088279, 2.525333049612345, -0.49298181954742276, -4.936115999114501, 2.0664557668576533, 3.982953734429159, 6.308475661065732, 1.1332138115050976, 1.5861267003463178, 7.803454126595235, -0.6398678180656496, 15.291428185787357, 2.8357703727148356, -0.9362033850505125, -4.42211119530726, -1.5989147649589293, 0.8057231965068575, 1.9301715818260854, 8.537864995999795, 1.3055496630670878, 0.15755095141289013, 0.7806939188438705, 2.5135472803521584, 1.2849509408994246, -2.771363489029978, 1.853262101313073, 0.7828473635803327, -0.018305567223713234, -0.4271893840799856, 2.961766700516383, -1.1158246527242848, -70.48968679532415, -0.49628690210916326, -3.887949087729103, 1.0121561379531758, 2.5945095920278325, 2.030391131616635, -1.5995327656121803, 1.0154504648969251, 0.7476858607073485, -6.426929044358389]
Diversité génétique : 2.163146902156863
/usr/local/lib/python3.5/dist-packages/numpy/lib/function_base.py:3768: RuntimeWarning: invalid value encountered in multiply
  x2 = take(ap, indices_above, axis=axis) * weights_above
Score médian : 6.53312909752535, 30 parents
----
Sauvegarde effectuée
Impossible d'actualiser la position de Left foot (H) 0 : contraintes insolubles <class 'Exception'>
Impossible d'actualiser la position de Left knee link (D) 1 : contraintes insolubles <class 'Exception'>
Step : 1, 112 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 6.757782533984967, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 6.301515234744067, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.619459171459315, 6.09334974205582, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 7.162114137560062, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 5.751916353794054, 6.172227285512937, 0.5159375384197383, -inf, 0.30548149883424663, -7.439960452340025, 0.42652854191675166, -57.40575044951227, 0.7149018508863713, -inf, -0.6048225092088279, 3.2580955358354955, -0.49298181954742276, -4.936115999114501, 2.1595120613759295, 3.982953734429159, 3.379587781809483, 1.032123835057349, 1.5861267003463178, 7.803454126595235, -0.6398678180656496, 15.291428185787357, 2.8357703727148356, -0.9362033850505125, 0.717288282408975, -1.5989147649589293, 0.6285589872644798, 1.321460675422347, 8.537864995999795, 1.3055496630670878, 0.22513417279398762, 2.4166126348670227, 1.6969884328961244, 1.2849509408994246, 0.8481702822883997, 1.853262101313073, 0.7828473635803327, -0.018305567223713234, -0.4271893840799856, -1.87627004102425, -1.1158246527242848, 9.452388400314076, -0.49628690210916326, -3.887949087729103, 0.8163687339617149, 1.4440153816453463, 1.9137469318073974, -1.5995327656121803, 1.0154504648969251, 0.7476858607073485, -6.426929044358389, 4.255658693808111, -1.1080715610978784, 1.9348491482833805, 0.5108567522374454, -0.9603814811179621, -0.23259393541279894, 9.309362606809456, 28.36443855086948, 1.3997621569412944, -0.8110474128934483, 2.437888245045532, -1.3504606345821142]
Diversité génétique : 2.192884408163855
Score médian : 7.307946116025844, 24 parents
----
Impossible d'actualiser la position de Left foot (H) : contraintes insolubles <class 'Exception'>
Step : 2, 109 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 6.757782533984967, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 6.301515234744067, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.693520318164833, 6.09334974205582, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 7.162114137560062, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 5.653260951561951, 6.172227285512937, 0.8177183386443315, 0.30548149883424663, 0.42652854191675166, 0.7149018508863713, -0.6048225092088279, 2.6895741577834755, -0.49298181954742276, 1.8058897529832312, 3.982953734429159, 2.2022100358892622, 0.7297640368928231, 1.5861267003463178, 7.803454126595235, -0.6398678180656496, 15.291428185787357, 2.8357703727148356, -0.9362033850505125, 10.50891619867685, -7.870413776211698, 2.709467438941587, 8.537864995999795, 1.3055496630670878, 0.7255562980574851, 1.9890080364413123, 2.4330911802830917, 1.2849509408994246, 1.5800981988281753, 1.853262101313073, 0.7828473635803327, -0.018305567223713234, -0.4271893840799856, 47.99878645932518, -0.49628690210916326, 0.03552047183700741, 3.783962889909322, 2.2894640228883176, 1.0154504648969251, 0.7476858607073485, 0.975702831210892, -1.1080715610978784, 1.9348491482833805, 0.8319154881807026, -0.9603814811179621, -0.23259393541279894, -63.68787648598355, 28.36443855086948, -39.27221010454516, -1.7822599013344953, 67.19767852043876, 0.7130781965546957, -9.661432698893963, 12.163502735778726, -0.8063139807402308, -inf, 4.296219243361941, 0.2473784648296362, -10.913233849159052, 2.6452702166153528]
Diversité génétique : 2.2311594277921745
Score médian : 7.58523059514292, 28 parents
Step : 0, 100 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 6.757782533984967, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 6.301515234744067, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.680271378638126, 6.09334974205582, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 7.162114137560062, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 0.8904484747581062, 6.172227285512937, 0.9830309620258294, 0.30548149883424663, 0.42652854191675166, 0.7149018508863713, -0.6048225092088279, 0.3851937437300514, -0.49298181954742276, -1.2434210893771762, 3.982953734429159, 2.7238825097678356, 0.783831217702361, 1.5861267003463178, 7.803454126595235, -0.6398678180656496, 15.291428185787357, 2.8357703727148356, -0.9362033850505125, 1.1844193124199152, 3.0907177554772174, 8.537864995999795, 1.3055496630670878, 0.07127491641529438, 2.220866572349561, 1.9293705894374025, 1.2849509408994246, -4.049692469564507, 1.853262101313073, 0.7828473635803327, -0.018305567223713234, -0.4271893840799856, 5.138647539644443, -0.49628690210916326, 0.846340326900316, 2.140430132238114, 1.924699127409642, 1.0154504648969251, 0.7476858607073485, 4.522934374551801, 1.9348491482833805, 0.9963493335288275, -0.23259393541279894, 28.36443855086948, 6.682539283689375, 0.7130781965546957, 12.163502735778726, -0.8063139807402308, -4.132526818858961, 0.2473784648296362, 0.976761673981554]
Diversité génétique : 0.4456093789332289
Score médian : 14.677780145107889, 8 parents
----
Sauvegarde effectuée
Step : 1, 52 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 21.969533309737805, 7.293301195041833, 11.603175996565891, 15.85899613535947, 9.690142749414308, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 0.5407610013693944, 7.4219347309885535]
Diversité génétique : 0.4607190047815985
Score médian : 14.677780145107889, 14 parents
----
Step : 2, 54 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.813147897666443, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 7.4219347309885535, -1.5588953701752668, -1.1779938116083155, 0.7012630797856454, -0.14700800900508204]
Diversité génétique : 0.45466696513608307
Score médian : 14.677780145107889, 12 parents
----
Impossible d'actualiser la position de Left foot (H) 0 : contraintes insolubles <class 'Exception'>
Step : 3, 54 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.648270518597847, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 7.322591037009857, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 7.4219347309885535, 0.3870140000837468, 6.214980197767264, -inf, 12.43034270003633]
Diversité génétique : 0.45870101660122287
Score médian : 14.677780145107889, 14 parents
----
Step : 4, 56 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.656701200250279, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 7.4219347309885535, 2.139410996296043, 7.38168276770966, 114.3882870863164, -13.565376496564797, -0.4988031594542982, -0.16858551913852543, 2.5756428868449395]
Diversité génétique : 0.45134819957658334
Score médian : 15.575212160573415, 12 parents
----
Impossible d'actualiser la position de Left foot (H) 0 : contraintes insolubles <class 'Exception'>
Step : 5, 54 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.611905076075773, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 7.4219347309885535, 114.3882870863164, -16.37722822005637, 2.6770569801090773, 2.610006494759066, -inf]
Diversité génétique : 0.4677154886906008
Score médian : 15.575212160573415, 14 parents
----
Sauvegarde effectuée
Step : 6, 55 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.749273439509533, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 7.4219347309885535, 114.3882870863164, -0.01863227643591305, -31.083180195396853, 11.990938232398726, 1.3069330560409513, -1.6086545658414502]
Diversité génétique : 0.4363196386842156
Score médian : 15.575212160573415, 14 parents
----
Impossible d'actualiser la position de Left foot (H) 0 : contraintes insolubles <class 'Exception'>
Step : 7, 56 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.662036737661317, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 114.3882870863164, 7.01950607808722, 2.975371341268604, 3.7343776526466486, 0.7368021290685683, 8.067799903362388, 0.7598673588209974, -inf]
Diversité génétique : 0.46659950364453007
Score médian : 15.575212160573415, 16 parents
----
Step : 8, 57 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.624184099698674, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 114.3882870863164, 6.175204575330996, 0.16284194847743952, -5.362367673182958, -8.855539271634926, 3.222937974412785, 2.813980359849724, 9.704826221980358, 5.288256343275044]
Diversité génétique : 0.45528451828734395
Score médian : 15.575212160573415, 16 parents
----
Step : 9, 56 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 7.483072404298703, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.662203074589534, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 114.3882870863164, 10.039668200906185, 111.95919541191999, 0.2986111243018977, -31.964286294197635, 3.5726130729090353, 0.04355389531921704, -9.13196749815972]
Diversité génétique : 0.4514275572182114
Score médian : 16.535080175657306, 16 parents
----
Step : 10, 56 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.692749229574133, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 114.3882870863164, 6.789929846137457, 111.95919541191999, 6.363120278031074, 0.9345443974211213, 4.970133614450798, 0.7837101373024014, -1.2414671624011167, -0.5775482618508722]
Diversité génétique : 0.4281405884259381
Score médian : 16.535080175657306, 14 parents
----
Sauvegarde effectuée
Step : 11, 55 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.24759287332659, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 114.3882870863164, 5.865173287404446, 111.95919541191999, 4.145948388382058, 1.175140551465339, -1.8382339380178296, -0.8691709059565811, -125.41064916262381]
Diversité génétique : 0.42114773655366794
Score médian : 16.535080175657306, 14 parents
----
Step : 12, 55 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.634161591076511, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 114.3882870863164, 6.65160176464338, 111.95919541191999, 3.4445028207281414, 1.6330210561787348, 5.738982192521157, 3.6528015017618203, 1.2852786409588153]
Diversité génétique : 0.4362380218578812
Score médian : 16.535080175657306, 16 parents
----
Step : 13, 57 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.648894317562284, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 114.3882870863164, 6.0508756348070225, 111.95919541191999, -5.846198880726298, -26.038049967502374, -0.6340842432561373, 1.0327106697453818, -10.126452520299717, 4.661310683627648, 8.66569391868213]
Diversité génétique : 0.42134856110901703
Score médian : 16.535080175657306, 14 parents
----
Step : 14, 55 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.764357489355497, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 0.01526674021215159, -2.1852410238564617, 79.35278950113963, -1.1507068430897787, -0.7886075181910701, 2.1522069666347785]
Diversité génétique : 0.42377869955440445
Score médian : 17.489068204304782, 18 parents
----
Step : 15, 58 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 7.687388785987137, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.63698188149817, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 7.900665164024302, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 7.803454126595235, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 9.01142471753172, 1.1891832110804323, 6.482484033786918, -5.362503171925616, 19.418717128457907, 81.97677986181709, -11.776621378094507, -1.2623396530345168]
Diversité génétique : 0.42747394617370676
Score médian : 20.146941842566047, 18 parents
----
Sauvegarde effectuée
Step : 16, 58 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 8.654399642908414, 13.365864531738982, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.700488385885025, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 8.537864995999795, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 9.01142471753172, 19.418717128457907, 81.97677986181709, -1.0254206193325042, -256.62862999001305, 5.316908237319557, 2.36229581681263, -1.9368922266969284, 12.1943932769735, 34.38629301177432, 3.209447173601216]
Diversité génétique : 0.42729758285661035
Score médian : 20.880090250480208, 16 parents
----
Step : 17, 56 individuals, scores :
[8.841899545428147, 17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 8.892469937696395, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.684549252021139, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 9.01142471753172, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 0.5447434460276361, 15.998787181408607, 7.898281099977212, -3.7883557834878925, -30.97617137750693]
Diversité génétique : 0.4258938115101086
Score médian : 21.427273627012013, 16 parents
----
Step : 18, 56 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.551652413780102, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 9.01142471753172, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, -207.61800186195714, -6.737379587786872, 7.274746075539222, 5.382372401640132, 3.452333905083606, -4.571430181176355, -0.9554197276557066]
Diversité génétique : 0.42184819233864546
Score médian : 21.427273627012013, 16 parents
----
Step : 19, 56 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.76642804120005, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 9.01142471753172, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 7.274746075539222, -7.111688887026211, 4.9927720416172425, 35.33134901416509, 1.0616707492885207, -92.54421848225829, 0.5288837446411997]
Diversité génétique : 0.41697124605945846
Score médian : 24.470080645627966, 14 parents
----
Step : 20, 55 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.694964218370979, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 9.01142471753172, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 0.37051446012851197, -3.24797503018001, 2.0277867788530655, 1.8102439092524274, 1.6857890354022798]
Diversité génétique : 0.41310908731892154
Score médian : 24.470080645627966, 16 parents
----
Sauvegarde effectuée
Step : 21, 56 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.770120184544057, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 9.01142471753172, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, -0.6353244442566963, -0.8168227591267414, -176.20573214849745, -5.6030691173034635, 3.3754400409365446, 0.9387080009179273]
Diversité génétique : 0.43235371217736107
Score médian : 24.470080645627966, 14 parents
----
Step : 22, 56 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.656997302418791, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 9.01142471753172, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 2.7563752495146927, 0.6618849509454386, 1.7448354696125727, -0.14345611143212258, 3.4012015932662485, 5.570389014147812]
Diversité génétique : 0.4302328919878157
Score médian : 24.470080645627966, 16 parents
----
Step : 23, 56 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.633484910269884, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 9.01142471753172, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, -7.874675092445705, 6.478180736716902, 28.793496718570406, -8.817338506711193, 0.6797440159169141, -0.30616730816547677]
Diversité génétique : 0.4312307778151411
Score médian : 27.6675332661938, 16 parents
----
Step : 24, 56 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.593329076433106, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 0.9481539495276449, -0.7289808845145089, -0.20347111121977263, -0.12250352906640993, 1.6256930754193935, 0.04725758446720745]
Diversité génétique : 0.4278703612684764
Score médian : 27.6675332661938, 12 parents
----
Step : 25, 54 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 9.173965484310507, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.623093442068441, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, -18.590278501393655, -0.4691063385840707, 15.304090627231753, 5.347486685969965]
Diversité génétique : 0.4185311311283081
Score médian : 27.6675332661938, 12 parents
----
Sauvegarde effectuée
Step : 26, 54 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 9.64894298809941, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 0.5852300310768574, 0.1801934062863615, 0.44608649229014113, 21.306519989523327]
Diversité génétique : 0.4210768262743035
Score médian : 27.6675332661938, 16 parents
----
Step : 27, 58 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, -3.0194656665626654, 5.3801597262782535, 1.442758664287667, 1.457921492947855, 3.8235720250824534, 5.762931725067181, -0.6122267702123511, 9.605858806352481]
Diversité génétique : 0.40503364419265914
Score médian : 27.6675332661938, 14 parents
----
Step : 28, 55 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, -2.827938008393872, 1.2094231387896242, 5.308091835749168, -11.993011291039059, 4.225135549038279]
Diversité génétique : 0.39373245418315583
Score médian : 27.6675332661938, 18 parents
----
Step : 29, 56 individuals, scores :
[17.21116421595514, 9.92372314760024, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, -1.8330671858106506, 24.56476156467991, 4.943404161073655, 4.838161901278993, 2.465026203382477, -5.1125732410920985]
Diversité génétique : 0.41290280599985296
Score médian : 27.6675332661938, 14 parents
----
Step : 30, 55 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 10.128590657837755, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, -38.85141163795617, -23.43742516865572, -3.0818265111259175, 178.6672327013289, -166.42671339954802]
Diversité génétique : 0.39016351872828103
Score médian : 28.578967634719945, 12 parents
----
Sauvegarde effectuée
Step : 31, 55 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 11.306943838859025, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 47.981545516446715, 17.766972192654425, 10.606920786307949, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.6019791348861, 7.711947635365527, 20.03203195515549, 12.919881998828382, -3.208645101699483, 5.482410569828141]
Diversité génétique : 0.38315318966655004
Score médian : 28.578967634719945, 10 parents
----
Step : 32, 54 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.9050697064032, 20.03203195515549, 12.919881998828382, -0.2092746928979576, -0.9151453735848989, -0.020625982649567585, -0.06122162703187231]
Diversité génétique : 0.3778536184252876
Score médian : 28.578967634719945, 16 parents
----
Step : 33, 57 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 179.78629807570272, 20.03203195515549, 12.919881998828382, -0.35017356169105307, -0.7819707394691732, 9.518993924491994, 1.0538487088380057, 1.3249682830563658, -0.7248829953917962, 1.5013404927200311]
Diversité génétique : 0.38342262933110105
Score médian : 28.578967634719945, 16 parents
----
Step : 34, 57 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 11.603175996565891, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 184.3699164254407, 20.03203195515549, 12.919881998828382, 4.384629625301811, 1.9735686393582987, 7.160854777513832, 18.365789943499916, -0.83747778258754, -1.1306483030665033, 3.0968786981238967]
Diversité génétique : 0.3657950485023993
Score médian : 28.578967634719945, 10 parents
----
Step : 35, 54 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 11.785952109905107, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 12.163502735778726, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 183.03614059063818, 20.03203195515549, 12.919881998828382, 20.253447086816816, 42.519799109811814, 7.949143673796735, 1512.9650070507107, 0.5164029964742543]
Diversité génétique : 0.37373626980350066
Score médian : 30.110330703541493, 14 parents
----
Sauvegarde effectuée
Step : 36, 55 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 181.17221335096784, 20.03203195515549, 12.919881998828382, -2.8724066088504907, 2.8710565534407917, 377.9732820239227, -2.2529334392138667, 4.503088627104334, 1.5237495205285336, 1.488507053924802, 2.4596289193086016]
Diversité génétique : 0.36105560569575434
Score médian : 28.833517520240157, 12 parents
----
Step : 37, 55 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 181.44737808562286, 20.03203195515549, 12.919881998828382, 4.4259659382176535, 1.1817100669307088, 3.0916669304457938, 21.699060965184042, 5.0351338281140325, 0.004489304909367042, 2.498149578601754, -1.512301424237285]
Diversité génétique : 0.3601273034444902
Score médian : 28.578967634719945, 14 parents
----
Step : 38, 57 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.90745505813877, 20.03203195515549, 12.919881998828382, 8.264003973111507, 21.699060965184042, 5.0351338281140325, 0.03658749482888706, -0.8111385904539324, 0.4378968841266197, 2.6064779696971088, 1.8681591886791382, 88.43363638020031, 123.0225477151303]
Diversité génétique : 0.368168623415908
Score médian : 30.110330703541493, 16 parents
----
Step : 39, 56 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 12.1943932769735, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 119.06606181762655, 20.03203195515549, 12.919881998828382, 21.699060965184042, 88.43363638020031, 123.0225477151303, -0.9602404731178347, 0.5346035282377134, 0.2268025238229019, 8.142054247097777, 3.5687631288234125, 13.739349070805389]
Diversité génétique : 0.36274042614994634
Score médian : 30.110330703541493, 14 parents
----
Step : 40, 55 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.30653848165846, 20.03203195515549, 12.919881998828382, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 2.6623319113117905, -6.461067414737698, 1.6627381896967992, 0.624204323355756, -21.25476572069994]
Diversité génétique : 0.36297759258285034
Score médian : 30.110330703541493, 14 parents
Step : 0, 75 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 12.51309607713006, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.76266273480496, 20.03203195515549, 12.919881998828382, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 3.749642617512713, 11.335653800938944, 1.9418259191381035, -2.144643846115221, 3.701825715298892, 0.5747080386616082, 1.0568131001128394, -2.448251952835151, 488.7042019824926, 3.0383397557963905, 0.7841693236027744, 7.151721168033711, 4.632913820290314, -3.7404802262411314, 72.32270660478268, -1.135427984337528, 0.1298556636283616, 0.4808260242243525, 1.1724249597858762, -24801.92105274186, 0.4195281734980626, 0.7850557541669534, 1.663202227901749, 0.4470042615958623, 3.0096856821912983]
Diversité génétique : 0.33720760142616857
Score médian : 34.5692063077278, 18 parents
----
Sauvegarde effectuée
Step : 1, 56 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 12.924241198699994, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 156.92070448133288, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, -37.08769973218958, 6.127264875133526, 197.3582996884317, 1.0049798310831841, -6.715712523031376, -3.180300074625902]
Diversité génétique : 0.33259535315367955
Score médian : 35.04173430892318, 18 parents
----
Step : 2, 56 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 13.125147830093264, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 181.39221091367025, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 10.310626500038605, -6.6812740711874685, -1211.267069952595, 15.422499228662069, -83.69037058807082, -9.350204271284968]
Diversité génétique : 0.32861097670928463
Score médian : 35.04173430892318, 10 parents
----
Step : 3, 54 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.57704332396628, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 5.532208577852017, -2.8618486949573216, -0.01919887209338668, 0.2580194998490801, -0.27106397859117537]
Diversité génétique : 0.3435212367351989
Score médian : 35.04173430892318, 14 parents
----
Step : 4, 55 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 178.838423306189, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 11.194503140800268, 0.12755705811840634, 10.49004870278362, 2.7630526760872187, -4.269102716525574, 76.45792268320051]
Diversité génétique : 0.34627314629132866
Score médian : 36.74194531201334, 12 parents
----
Step : 5, 54 individuals, scores :
[17.21116421595514, 13.365864531738982, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 185.49454454327758, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 21.868628423653227, 3.888634707800152, 4.237136705238252, -226.68146861315316]
Diversité génétique : 0.34321030565744276
Score médian : 36.74194531201334, 16 parents
----
Sauvegarde effectuée
Step : 6, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.0122712986871, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 3.052523320456804, -11.812934467750154, 15.331178796848778, 2.4700555058350275, 4.953983164274149, 0.8997339837686384]
Diversité génétique : 0.3527117330698622
Score médian : 36.74194531201334, 12 parents
----
Step : 7, 54 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 182.38993136902468, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 5.812250921196113, 2.12404298810906, 7.111662792968139, -38.538291564354026]
Diversité génétique : 0.3415366956662122
Score médian : 36.74194531201334, 14 parents
----
Step : 8, 54 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 13.52167860043873, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 186.0665580918529, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 5.92417124458742, 2.7043573747682537, -8.20164557917767, 16.12933306404573]
Diversité génétique : 0.3423639637403753
Score médian : 36.74194531201334, 16 parents
----
Step : 9, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 181.19010236084873, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, -6.156956802955899, 3.1888700108347736, 5.145890723752291, 0.08696934964799048, 2.148225625075276]
Diversité génétique : 0.35394728623433025
Score médian : 36.74194531201334, 14 parents
----
Step : 10, 54 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 178.6233859516511, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, -229.64796812945312, 1.2298729733068023, 4.420743811434958, 11.093101319362326]
Diversité génétique : 0.35708417757114796
Score médian : 36.74194531201334, 16 parents
----
Sauvegarde effectuée
Step : 11, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 184.3075748884407, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 7.608808145756856, 7.918855243419388, 6.09999022686859, -1.130151127866602, 1.0647269868733806]
Diversité génétique : 0.35913956710168593
Score médian : 36.74194531201334, 14 parents
----
Step : 12, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 181.59003110186933, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 0.7717420011183702, 5.033440182839219, 1.4146929328781332, 0.2864132397024221, -0.21343566254755764]
Diversité génétique : 0.3590472093764217
Score médian : 36.74194531201334, 14 parents
----
Step : 13, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 182.26862547902005, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, -2.4678283241024817, 12.63112479677969, 8.72892320315721, 1.4704082690825646, 0.5310170870857167]
Diversité génétique : 0.348274917131217
Score médian : 36.74194531201334, 16 parents
----
Step : 14, 56 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 181.03164087516717, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 13.739349070805389, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 13.932255532052658, -4.170648836275983, 0.4935753757057626, 2.914884709959174, 2.55200779932311, 15.94975202522906]
Diversité génétique : 0.3577848435619911
Score médian : 36.74194531201334, 14 parents
----
Step : 15, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.76770114775664, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 4.769572669019498, -0.1206862450034994, 6.552435675039862, -0.3482829319903293, -22.560496725444878, 6.521067446448333]
Diversité génétique : 0.3496515546597592
Score médian : 36.74194531201334, 14 parents
----
Sauvegarde effectuée
Step : 16, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.6167786351387, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 6.552435675039862, 0.3417553456348835, -4.472094822591456, -0.20486649277391297, 1.751512146750469, 2.335987284108217]
Diversité génétique : 0.3493303568256157
Score médian : 36.74194531201334, 16 parents
----
Step : 17, 56 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 185.1145222439289, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 6.552435675039862, 5.267471446944096, -0.6632559607255251, -0.8675614553238746, -2.8979112885802287, -73.93596189333029, 0.5968207028190815]
Diversité génétique : 0.3564808566933819
Score médian : 36.74194531201334, 16 parents
----
Step : 18, 56 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 14.064132104428419, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.79125673360383, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 6.552435675039862, 0.25730682858543413, 44.9251800475221, 10.21147446369204, 22.064991187895387, 1.9674990922074147, 7.2717603670923285]
Diversité génétique : 0.35684883805754924
Score médian : 38.51006784281545, 14 parents
----
Step : 19, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 181.35041936381128, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 44.9251800475221, 22.064991187895387, 0.9500480245584186, 0.9921890718272152, -1.1824480282026264, 0.02877068130583853, 1.6966464154816296]
Diversité génétique : 0.3499812178170176
Score médian : 38.51006784281545, 14 parents
----
Step : 20, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 15.291428185787357, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 178.68853506691906, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 44.9251800475221, 22.064991187895387, -8.15906402050973, -1.3464434866347554, 2.551129146149718, 8.962478395754278, 47.21043783735726]
Diversité génétique : 0.3540775777400708
Score médian : 41.525433425204376, 14 parents
----
Sauvegarde effectuée
Step : 21, 54 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 178.63556238613563, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, 2.257450190626412, -3.7253894513943955, -0.9367702003771509, 4.027110067228879]
Diversité génétique : 0.3508921223548332
Score médian : 41.525433425204376, 14 parents
----
Step : 22, 53 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 181.72673799876577, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, -6.844125578364109, -0.04501198602754471, 2.3883058717384245]
Diversité génétique : 0.3569033882445375
Score médian : 41.525433425204376, 14 parents
----
Step : 23, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 180.8512981039864, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, 2.9902101220666863, 1.3253615360371078, 4.006133625025955, 3.6860113778137324, 4.537721618607855]
Diversité génétique : 0.35058207361512167
Score médian : 41.525433425204376, 16 parents
----
Step : 24, 54 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 15.304090627231753, 21.306519989523327, 24.56476156467991, 181.2306010929784, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, 0.3623817699551521, 2.122400161485442, 46.91537613781885, -22.665633146655445]
Diversité génétique : 0.35934072676006723
Score médian : 44.554226411080776, 18 parents
----
Step : 25, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 181.38829830888469, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 2.9812828204646253, 5.5175981828501675, 8.641715017965165, 2.9833062351282376, -0.44638160956235423]
Diversité génétique : 0.36973695178226124
Score médian : 44.554226411080776, 14 parents
----
Sauvegarde effectuée
Step : 26, 52 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.3161734748512, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 2.1302186352548214, 0.9400726625303537]
Diversité génétique : 0.3629919742796062
Score médian : 44.554226411080776, 16 parents
----
Step : 27, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.00654259985643, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 15.331178796848778, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, -2.4304478810151458, 0.516038927594988, 6.473068068820044, -52.48239671359663, 98.00885752543712]
Diversité génétique : 0.3697679473511008
Score médian : 45.92027809267047, 18 parents
----
Step : 28, 56 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 181.18428989454426, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, -250.78271179118087, -4.580247855027577, -17.0641825218621, 14.665589870756529, 4.7624581410713205, 2.660683574799405]
Diversité génétique : 0.36592336356951083
Score médian : 45.92027809267047, 10 parents
----
Step : 29, 53 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 15.85899613535947, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.4481353616354, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 1.0468827757926151, 1.141728884690475, 92.2034373887393]
Diversité génétique : 0.3607355264696538
Score médian : 47.06290698758806, 14 parents
----
Step : 30, 54 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 186.64219941342364, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, -2.4702284210761416, -1.353671102310616, 3.9914558120717474, 3.21154891199057]
Diversité génétique : 0.3572428995133268
Score médian : 47.06290698758806, 16 parents
----
Sauvegarde effectuée
Step : 31, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 182.07898622994887, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 16.12933306404573, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 2.052136656509698, 188.91248881863305, -2.7135434350136287, 2.7309376201873565, 0.22125487041220954]
Diversité génétique : 0.36098355617186645
Score médian : 47.59599167690199, 16 parents
----
Step : 32, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 183.41472734554162, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 0.8984033243965133, 8.265258613960514, 9.348397677388972, -4.3078552353485255, 5.195374170028419, 2.245393209430187]
Diversité génétique : 0.35123878734087605
Score médian : 47.06290698758806, 16 parents
----
Step : 33, 55 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 183.53263276100003, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 7.886186994938074, 6.72610584339801, -12.942985807209634, -0.5654871184548601, 16.959914850050314, 17.482405802593437]
Diversité génétique : 0.36257503128144464
Score médian : 47.06290698758806, 14 parents
----
Step : 34, 54 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 181.11922905976883, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 17.482405802593437, 0.7337558950106406, 3.311001779953031, 8.995932616980381, 3.7790293528864285]
Diversité génétique : 0.35722429972013875
Score médian : 47.06290698758806, 18 parents
----
Step : 35, 56 individuals, scores :
[17.21116421595514, 51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 173.42839497251754, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 17.482405802593437, 0.3690020853359602, 1.287147189749557, 99.92315719919144, 35.258501948760454, 1.196147269708774, 0.717517378486303]
Diversité génétique : 0.3594816922825556
Score médian : 47.59599167690199, 12 parents
----
Sauvegarde effectuée
Step : 36, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 181.8100694280458, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, -2.8722979815593517, 0.8933203387097628, 11.941350130148486, 2.7754188554968535, -2.1861945965424026]
Diversité génétique : 0.3605926754619225
Score médian : 47.59599167690199, 16 parents
----
Step : 37, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 174.5082126617294, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 11.941350130148486, 58.8222888871101, -81.73992572328775, 1.1682679258500144, -0.32090311284377476, -0.4242420572028716, -1.2581404070823772]
Diversité génétique : 0.3593293190972406
Score médian : 49.55545560711731, 14 parents
----
Step : 38, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.09759789957806, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, -7.802677059185824, -0.1269232049340763, 307.21165876088264, 0.10582285787229843, 3.2567166069554903, -0.6328065615282865]
Diversité génétique : 0.36789791001158095
Score médian : 49.55545560711731, 14 parents
----
Step : 39, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 17.766972192654425, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 19.418717128457907, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.79826613659384, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 19.687300754229025, 9.115691801825378, 22.293073972910495, 3.085138487821972, -0.6662508093414834, 8.273125901322638]
Diversité génétique : 0.3676491502524145
Score médian : 49.55545560711731, 12 parents
----
Step : 40, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 176.36292994838257, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 4.119406318960045, 22.293073972910495, -0.16302693993448292, -2.9252141264731732, 13.93230097360175, 3.1241227327057994]
Diversité génétique : 0.369284157023047
Score médian : 49.55545560711731, 18 parents
----
Sauvegarde effectuée
Step : 41, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.46445071204468, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 13.93230097360175, 0.1768845123248969, 1.2565513289680816, -4.075349826906701, 33.68131537600304, -569.2036929545197, 1.8953921601298713]
Diversité génétique : 0.36230667042895204
Score médian : 49.55545560711731, 16 parents
----
Step : 42, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.101656866792, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, -1.0540297530147678, -11.384528970943101, 3.327915036078174, -4.5433163915534704, -38.39267249615052, 3.1063952771261616]
Diversité génétique : 0.37046314905522193
Score médian : 49.55545560711731, 14 parents
----
Step : 43, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 182.85191161836138, 20.03203195515549, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, -34.54556657958487, 6.352502271681961, 240.4923202983196, 1.6554055999494577, 0.7027247386025767, 13.523445441715372]
Diversité génétique : 0.3723222440222002
Score médian : 52.27347783404155, 12 parents
----
Step : 44, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 187.37432503989905, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, -2.5200211292240646, 14.859743751466546, -0.26529459198645894, 2.3001171056751804, 9.252393508510615]
Diversité génétique : 0.3728797135102878
Score médian : 49.55545560711731, 12 parents
----
Step : 45, 53 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 179.68547819734565, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 14.859743751466546, 3.059956332232458, -6.25788102517741, 1.0391349339249463]
Diversité génétique : 0.3591570784769623
Score médian : 49.55545560711731, 12 parents
----
Sauvegarde effectuée
Step : 46, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 175.80667826133637, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 14.859743751466546, -2.3599733313692517, -12.313497153345073, 7.757312323153099, 4.703194534725483]
Diversité génétique : 0.36329651826090753
Score médian : 49.55545560711731, 16 parents
----
Step : 47, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 184.71207604146565, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 14.859743751466546, 1.0225901807997682, -47.6163815097012, 0.5096224202948934, -17.590901568347, -2.416510637634351, -1.436016285040023]
Diversité génétique : 0.375560533677269
Score médian : 49.55545560711731, 16 parents
----
Step : 48, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.675629973018, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 14.859743751466546, 311.46981946745683, 0.9856889482453595, 3.3442446447756518, 10.273758581415908, -1.5024922483361898, 3.2425932691879273, -10.964573536804023]
Diversité génétique : 0.37956857779024555
Score médian : 52.27347783404155, 16 parents
----
Step : 49, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 181.75710008023046, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 4.1334769834925265, 7.714540613499085, -0.9707308406040108, 0.9425688437165114, -5.7316161943171275, 9.133964984991636, 1.220663473481468]
Diversité génétique : 0.36806228093581156
Score médian : 52.27347783404155, 12 parents
----
Step : 50, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 183.1677945842013, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 1.2982954326001945, -23.97830536702643, 0.015496918524481906, 0.8851332411746754, 4.885634116556352]
Diversité génétique : 0.36593919559418125
Score médian : 52.27347783404155, 16 parents
----
Sauvegarde effectuée
Step : 51, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 182.01134025361992, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, -3.369334402044271, -120.98737978557664, 6.671821437329266, 19.245383309002772, 0.05936636284363102]
Diversité génétique : 0.36102246522529546
Score médian : 52.27347783404155, 16 parents
----
Step : 52, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.75609282595425, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 1.1659086702359585, 6.242777363314299, -4.49429163876872, 6.344094926816452, -0.9117569798467627, 0.38844207309263507]
Diversité génétique : 0.378690819201851
Score médian : 52.27347783404155, 10 parents
----
Step : 53, 53 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.57383993848003, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, -0.8074741806205602, -44.631712332402415, 6.811321551750924]
Diversité génétique : 0.3666666428845179
Score médian : 52.27347783404155, 14 parents
----
Step : 54, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 20.875166556674188, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 187.76250444370774, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, -1.585204129881158, 8.053401792212496, 66.35307028567881, 0.5391545757712672]
Diversité génétique : 0.3656130963606291
Score médian : 56.98618383293995, 16 parents
----
Step : 55, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 20.885013944286225, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 184.01640211835576, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 4.513776166821667, 4.278924568650065, -0.328446572206939, 1.6714952442215876, 0.681539017088753]
Diversité génétique : 0.376624903280586
Score médian : 56.98618383293995, 20 parents
----
Sauvegarde effectuée
Step : 56, 58 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 21.306519989523327, 24.56476156467991, 180.38013034855942, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, -3.4578175665691986, 7.105812027337381, 4.499710547776012, 4.634342061689181, 11.31103102674679, 0.43115954682242086, 32.10219757911006, -0.6983343339510355]
Diversité génétique : 0.36520296360016236
Score médian : 56.98618383293995, 12 parents
----
Step : 57, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 180.94705553922628, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 1.9102936903958723, 0.9732970871393186, 11.815753386033343, 10.331582953706537]
Diversité génétique : 0.38340607224101336
Score médian : 56.98618383293995, 12 parents
----
Step : 58, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 180.48411569095086, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 1.707506867491275, 2.276312364452015, 1.410472533272334, 1.669237149749148]
Diversité génétique : 0.38263412981960876
Score médian : 56.98618383293995, 12 parents
----
Step : 59, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 175.90231237689147, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 17.478695957092164, 7.902540795450118, 0.4950196202814289, 0.37458867587549355, 10.580425749314442]
Diversité génétique : 0.3824405544877107
Score médian : 56.98618383293995, 16 parents
----
Step : 60, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 180.96635705304644, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 7.157830344854986, -0.46884615788823053, -0.6027746433730512, -7.844111953212728, 1.299453067345293, -107.2564896722493]
Diversité génétique : 0.3811785358975549
Score médian : 56.98618383293995, 14 parents
----
Sauvegarde effectuée
Step : 61, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 21.969533309737805, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 181.35635300088748, 21.699060965184042, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, -6.810456482970996, 117.27052648287096, 0.17962681004462883, 59.906762881044465, 19.66609869162926]
Diversité génétique : 0.37841327727569973
Score médian : 62.91865705650906, 14 parents
----
Step : 62, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 179.1890449144017, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, -0.6900479616697901, 2.7953420640913422, -0.3103108332534678, -3.21748402175787, 3.885084871614217]
Diversité génétique : 0.3921075574808332
Score médian : 62.91865705650906, 16 parents
----
Step : 63, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 179.73542310479291, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, -37.757651566638444, 1.7860396990173082, 1.96918862781716, -0.4988559982747996, -75.0636850866083, -1.1069346012945136, 9.034154215713924]
Diversité génétique : 0.39019033085016386
Score médian : 62.91865705650906, 14 parents
----
Step : 64, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 180.41625211982424, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 20.87525984900766, 6.290137066682583, 3.807758498036173, 10.747887858472861, -27.141529768357714]
Diversité génétique : 0.39065556538617113
Score médian : 62.91865705650906, 10 parents
----
Step : 65, 53 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 167.02218521265863, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 22.064991187895387, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, -3.099157886496685, 5.582931587021992, 52.14310599822581]
Diversité génétique : 0.3788629115292588
Score médian : 62.91865705650906, 16 parents
----
Sauvegarde effectuée
Step : 66, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 174.58841408460262, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, -2.7931489037175714, -84.767959712297, 3.142378103812022, 1.4759704821705475, 0.37967946738894204]
Diversité génétique : 0.385589592437041
Score médian : 62.91865705650906, 16 parents
----
Step : 67, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 24.56476156467991, 179.54806018186454, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 22.293073972910495, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, -12.549314096815683, 35.309712100112904, 2.0958911925491015, 8.794223799264802, 1.7167455577982629]
Diversité génétique : 0.37891468141634127
Score médian : 65.81780335155611, 16 parents
----
Step : 68, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 181.0153396421244, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 2.1326390652926617, 0.0026512667849750097, 16.02558794262553, -5826.388084236966, -4.367409285960358, -3.06812079853295, 8.84237151382503]
Diversité génétique : 0.3772887700471305
Score médian : 65.81780335155611, 14 parents
----
Step : 69, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 180.5725280224278, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 16.02558794262553, 2.532157800110057, 28.237650639804254, 3.7085345547249995, -5.966392099964612, 12.976650001046604]
Diversité génétique : 0.3830973580213877
Score médian : 65.81780335155611, 12 parents
----
Step : 70, 53 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 179.29099943254977, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, 9.947210393000324, 3.008225209435758, -171.7323714485165]
Diversité génétique : 0.3902278757304761
Score médian : 65.81780335155611, 16 parents
----
Sauvegarde effectuée
Step : 71, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 182.19686356497388, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, 0.2163059531190128, -3.041657814471832, 4.061977232200664, 0.9599855106645427, 2.0094089632223735, 3.7008850364134975]
Diversité génétique : 0.37910737857273974
Score médian : 65.81780335155611, 16 parents
----
Step : 72, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 179.2709017239222, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, 0.7206626411253689, 16.311992020147656, 4.908369404045748, 0.4395015095313972, 4.027513398617358]
Diversité génétique : 0.37807379267330843
Score médian : 65.81780335155611, 14 parents
----
Impossible d'actualiser la position de Left knee link (D) 0 : contraintes insolubles <class 'Exception'>
Step : 73, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 189.30546827672597, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, 3.6980317840516923, -12.209735921182766, -inf, 9.129516054766253, 0.8800790873204168, 2.1348085660245797]
Diversité génétique : 0.38769694841246005
Score médian : 65.81780335155611, 10 parents
----
Step : 74, 52 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 180.685557220531, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, -144.51685768597926, -1.839947652078521]
Diversité génétique : 0.3876448606785773
Score médian : 65.81780335155611, 18 parents
----
Step : 75, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 180.92661342577162, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, -9.142125444634388, -45.626783577653995, 6.45560770281774, -6.474724737388233, -2.985922890555607, 7.158778961916114]
Diversité génétique : 0.39439278590872695
Score médian : 65.81780335155611, 16 parents
----
Sauvegarde effectuée
Step : 76, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 183.92685830280732, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, 0.710858456319292, 4.387106633013339, 7.152032644737934, 10.330376745876338, -0.6034274460076362, -0.021942772029738287]
Diversité génétique : 0.38229075276814684
Score médian : 65.81780335155611, 16 parents
----
Step : 77, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 179.938827364354, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, -0.6731498348136055, 0.06861985796755579, 1.4148634918635046, 3.4246751171846572, -1.1040784214846115, 1.233688860941664]
Diversité génétique : 0.3893745992759881
Score médian : 65.81780335155611, 16 parents
----
Step : 78, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 180.0387262909229, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, -5.071874281136668, -18.794876381118698, 4.589645420051616, -0.7247536913225412, 6.975864223704515, -31.998122988599324]
Diversité génétique : 0.38546681221880835
Score médian : 65.81780335155611, 18 parents
----
Step : 79, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 181.8973948252719, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, 0.23299482505409755, -1.125680974100796, -2.39649873209788, 17.387186409056657, 2.2080572677497594, -7.587226819638838, -4.712865909760836]
Diversité génétique : 0.3970368478978802
Score médian : 65.81780335155611, 16 parents
----
Step : 80, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 26.970627981518124, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 185.82934306327866, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, 48.899079752067465, 10.86896673798467, -1.2442647176621715, -1.510016864477123, 7.412482991631056]
Diversité génétique : 0.38526643057517146
Score médian : 65.81780335155611, 10 parents
----
Sauvegarde effectuée
Impossible d'actualiser la position de Left knee link (D) 0 : contraintes insolubles <class 'Exception'>
Step : 81, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 182.00363586769427, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 28.237650639804254, 48.899079752067465, -5.029765705356269, 261.10899955347446, -0.6561998748075509, -inf]
Diversité génétique : 0.3950525080058004
Score médian : 69.33788844523075, 18 parents
----
Step : 82, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 28.36443855086948, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 203.63589326784026, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, -0.49672978169557713, 0.4038259983976357, 3.02425559485017, 5.01042362416377, 42.08960383813729, 4.475324407502419, 0.18119941322546254]
Diversité génétique : 0.38142372537232044
Score médian : 69.33788844523075, 16 parents
----
Step : 83, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 181.01208803997648, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, -11.190775170564448, -0.18365120941534846, 3.4644627617889565, 5.789178152493072, -0.20434238208545172, -112.41123722189516, -4.249465465025419]
Diversité génétique : 0.3732177901300591
Score médian : 69.33788844523075, 20 parents
----
Step : 84, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 28.793496718570406, 179.98317868798534, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, -0.2977346568052774, 33.38066832142242, -0.28622247182880245, 1.335954898571939, -4.729673585263756, -0.8456381398030308]
Diversité génétique : 0.3700846074079476
Score médian : 69.33788844523075, 16 parents
----
Step : 85, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 180.3868996272439, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 33.38066832142242, 2.1636579045036126, 21.033759111853787, 3.914810739931967, 20.340760457773843, 0.16711058118494274, 0.40488472503561423]
Diversité génétique : 0.38625726432183627
Score médian : 69.33788844523075, 16 parents
----
Sauvegarde effectuée
Step : 86, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 179.30415943291743, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 33.38066832142242, 2.2604038624186606, 2.0301949673463247, 8.404573643504513, 8.366234276153016, 4.928803082294654]
Diversité génétique : 0.38951034265460016
Score médian : 69.33788844523075, 18 parents
----
Step : 87, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 28.873538321909905, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 180.71767050525378, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 33.38066832142242, 0.7357439002209063, 0.39682872719829093, 7.329859045189316, 4.694365508499857, 51.802575198611606, -0.15724892842293345]
Diversité génétique : 0.36814680058526633
Score médian : 69.33788844523075, 16 parents
----
Step : 88, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 180.67456067577606, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 33.38066832142242, 51.802575198611606, -16.750112775334692, 6.689620424487204, -4.915172077121501, -3.050693697082601, 0.8465822431130817]
Diversité génétique : 0.3754035451139375
Score médian : 69.33788844523075, 18 parents
----
Step : 89, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 31.34712308517308, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 180.89500093025828, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 33.38066832142242, 51.802575198611606, -49.97439427627566, 5.21157333382683, 0.21160701278542243, -33.87159665499033, -68.67746065221608, 126.07739544232633]
Diversité génétique : 0.38666739495469216
Score médian : 72.92473417629414, 14 parents
----
Step : 90, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 181.63276799814858, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 33.38066832142242, 51.802575198611606, 126.07739544232633, 2.204506077290935, 1.6878579065881658, 1.1763449526130727, -8.834832459860852, 8.074690435568481]
Diversité génétique : 0.37427112938392093
Score médian : 72.92473417629414, 14 parents
Step : 0, 75 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 34.38629301177432, 137.38032692236644, 35.33134901416509, 182.27086267160604, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 33.68131537600304, 311.46981946745683, 66.35307028567881, 45.00969502894021, 32.10219757911006, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 33.38066832142242, 51.802575198611606, 126.07739544232633, -3.709743965799391, 1.5590832944513013, -inf, 40.367814924862266, 13.39803827658028, 10.88245179920179, -2.7756948052934893, 3.564146601372112, 2.013422289574337, -10.750526849702238, 0.9690971541068066, -0.4397809018066577, 0.283703377095838, 67.2757407506788, 62.63285440122024, 1.7230245689838342, 8.906461321080947, 5.223991915450378, -1.0273854880028919, 5.828026106809004, 0.729740072657166, 189.6928043171786, 10.758719023943014, -6.522256356091078, 1.83403713025295]
Diversité génétique : 4.022093299715929
Score médian : 74.51057554658992, 18 parents
----
Sauvegarde effectuée
Step : 1, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 180.68532807480062, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, -326.0478054428613, 67.2757407506788, 62.63285440122024, -181.18852305678914, -2.828241929337068, 0.24157089631950796, -3.7646515896422104, 0.9996546508707075, 4.555133513912209, 4.615224093296181, -3.3065889797796433]
Diversité génétique : 4.130233241980506
Score médian : 72.92473417629414, 12 parents
----
Step : 2, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 181.80951534147889, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 4.555133513912209, 2.044748198833243, 0.49343699581061445, 5.857142712784869, -8.133108698047753, 0.38488284354205254, 1.219029716991345]
Diversité génétique : 4.082207360768211
Score médian : 72.92473417629414, 16 parents
----
Step : 3, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 183.96295604922605, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 4.555133513912209, 5.857142712784869, 46.998172402471596, 1.4911839130156082, 1.7630915453552745, 1.7191821523584343, 0.3530799304364908, 0.8039154663885332, 1.496066351036421]
Diversité génétique : 4.051921535290238
Score médian : 72.92473417629414, 14 parents
----
Step : 4, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 165.85082388853516, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 5.857142712784869, 46.998172402471596, -33.98506775215377, 5.8801749465335, 3.4847039898283523, 0.664637117530957, -0.1212044032884711]
Diversité génétique : 4.049568425839358
Score médian : 72.92473417629414, 16 parents
----
Step : 5, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 180.25052513080257, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 5.8801749465335, 9.668010634282918, 3.4126063788116223, -381.172511754788, -0.16876780776243686, -1.5741868520631062, 11.549582479931166, 5.87237964593808]
Diversité génétique : 4.038361340745332
Score médian : 72.92473417629414, 16 parents
----
Sauvegarde effectuée
Step : 6, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 179.43257297230863, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 1.6443439538299758, -0.41161125026985335, 300.7723329745354, -56.4701818440678, 0.7029142722703666, -12.310844331108148, 0.2850003125801985, 4.468450625596613]
Diversité génétique : 4.065818338695227
Score médian : 74.51057554658992, 10 parents
----
Step : 7, 53 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 181.27368371859316, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 1.9113142727365735, 0.19172449868392533, 0.30676435104642125]
Diversité génétique : 4.052210582098797
Score médian : 74.51057554658992, 14 parents
----
Step : 8, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 179.39689499389064, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 0.24870272123610998, 3.9437033435132087, -1.3946227731243983, 2.4680389034396137]
Diversité génétique : 4.054612941207964
Score médian : 74.51057554658992, 16 parents
----
Step : 9, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 34.752119603681265, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 178.04038622780058, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, -6.915205450212758, 47.68918195638233, 2.7049138605914678, 33.88175777191239, 0.24854501443936683, -0.49219414097266895, 3.6159067774656033]
Diversité génétique : 4.039902334730395
Score médian : 74.51057554658992, 14 parents
----
Step : 10, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 179.28282255177035, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 0.6741854923635322, -inf, 3.962675203704645, -14.724838158705136, 4.639909809899157]
Diversité génétique : 4.064379774433626
Score médian : 74.51057554658992, 16 parents
----
Sauvegarde effectuée
Step : 11, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 182.100253286167, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 2.884914253562573, 4.935406155402166, 10.54316312711883, 4.249482262186223, -0.5850044147286247]
Diversité génétique : 4.030132129474027
Score médian : 74.51057554658992, 12 parents
----
Impossible d'actualiser la position de Left knee link (D) 0 : contraintes insolubles <class 'Exception'>
Step : 12, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.33134901416509, 179.72757893124725, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, -6.162426341483733, -inf, 2.928395362590051]
Diversité génétique : 4.02678475736052
Score médian : 74.51057554658992, 14 parents
----
Step : 13, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 38.1525416098616, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.53957722859155, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 2.3826987358786234, 44.65856886047891, 24.132179456534768, 7.615962733201053, -35.78426687335202, 15.469651646481744]
Diversité génétique : 4.030708590045281
Score médian : 74.51057554658992, 16 parents
----
Step : 14, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.9428290071248, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 12.3234733385585, -0.7500406377638343, -0.0016942524385640514, 1.8063076678647365, 0.8134822937472242, 31.07683157859662, 2.856226541539969]
Diversité génétique : 3.9843005581613915
Score médian : 74.51057554658992, 16 parents
----
Step : 15, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.1847114903744, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 31.07683157859662, 0.9497579846590202, 1.371252257711505, -59.637785351780714, -0.05543018683219625, -42.88901644163007, -0.07674059911319653]
Diversité génétique : 4.0047397103981135
Score médian : 74.51057554658992, 18 parents
----
Sauvegarde effectuée
Step : 16, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 175.495647442613, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 31.07683157859662, -4.145933884643509, -1.6195801937620662, 1.8316625926734567, -6.778097216748256, 0.15564356734643636, 5.373669805728396, -6.2289188863769995]
Diversité génétique : 3.9319169799138067
Score médian : 74.51057554658992, 12 parents
----
Step : 17, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.3460907385908, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 31.07683157859662, 0.0060479990720847246, 0.742322662811689, -0.7183446218215107, 2.001128879388354]
Diversité génétique : 3.9839587822696694
Score médian : 74.51057554658992, 16 parents
----
Step : 18, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.00148405859846, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 31.07683157859662, 3.0527041845835843, 18.33028816605717, 4.266846385422456, 24.95213062820052, 9.420588674690636, 3.187025661328305]
Diversité génétique : 3.9820740495087796
Score médian : 74.51057554658992, 20 parents
----
Step : 19, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.3435104504874, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 31.07683157859662, -44.055987156041205, -18.332199978466058, -7.194266064204328, -2.0736869075378936, 2.401078931996752, -1.2447490776563224, -5.334844435379935]
Diversité génétique : 3.9960915835310606
Score médian : 74.51057554658992, 14 parents
----
Step : 20, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.12803612719082, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 31.07683157859662, -4.112709975634502, 0.908493376597429, -0.31588780360450525, 0.19158381430518656, 6.506728073799946]
Diversité génétique : 3.9878098964180455
Score médian : 74.51057554658992, 14 parents
----
Sauvegarde effectuée
Step : 21, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 183.56570555865946, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 31.07683157859662, -3.614536103509573, 1.8069643582435666, -0.5975789182209191, 0.3778564959027249, -0.4612534686835899, 13.921407695171652]
Diversité génétique : 4.000180558425314
Score médian : 74.51057554658992, 14 parents
----
Step : 22, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.94686510418381, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 31.07683157859662, 0.8004353585106084, -4.259131331968784, 2.635549123888264, 3.3518356129003584, 14.102420747774298]
Diversité génétique : 4.030877087351631
Score médian : 74.51057554658992, 12 parents
----
Step : 23, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.5315062255459, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 31.07683157859662, 86.7724812100257, 9.503018579341918, 4.149744132888723, -1.6971978946473616, 2.305473875897217]
Diversité génétique : 4.017033395952914
Score médian : 75.97615601428737, 16 parents
----
Step : 24, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.3425146317249, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 86.7724812100257, 1.349133573293521, 3.81350169830703, 6.369646702291581, -388.20209046012616, 1.1204275891120317, 13.544244980501647, 20.007907068122822]
Diversité génétique : 4.0167087959002785
Score médian : 75.97615601428737, 16 parents
----
Step : 25, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 38.867594075769304, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.29504195019393, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 38.284521364107995, 86.7724812100257, 129.0051637153012, 102.96213311383745, 2.397575795462314, 2.542616081701386, 2.9333314150199925]
Diversité génétique : 4.024905129432666
Score médian : 80.66478468147835, 16 parents
----
Sauvegarde effectuée
Step : 26, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.11910503004452, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 1.9500423087618255, 0.7487743315823746, 3.2386251107917667, -0.060574105879964535, -25.837460715565925, -42.932565717679324]
Diversité génétique : 4.017399113739323
Score médian : 77.90535609217007, 14 parents
----
Step : 27, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.32506576666674, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 0.8767738338033572, 10.433633659558645, 0.42950324775456244, -0.48780021551752184, -0.012838276607135385, 2.6031559644307043]
Diversité génétique : 4.018422697083898
Score médian : 77.90535609217007, 14 parents
----
Step : 28, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.32772539750135, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 2.899214405680144, 0.8518464490365267, 1.1642515236792395, 5.354384259924007, 0.9570077281063469, 0.2307087998564842, 0.660487754344232]
Diversité génétique : 4.093895666651328
Score médian : 77.90535609217007, 12 parents
----
Step : 29, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.97477627243228, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 5.354384259924007, -7.352032739632556, -0.644377010537306, 10.799686290639437, 0.4719554252829166, 1.1171031440376478]
Diversité génétique : 4.069970644510914
Score médian : 77.90535609217007, 16 parents
----
Step : 30, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.60587195916824, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 10.799686290639437, 3.0141833314684443, -2.0114201427724594, 2.9322630903330493, 47.873033734812275, 0.7093644441073321, 11.993428800054717]
Diversité génétique : 4.051514698609655
Score médian : 77.90535609217007, 16 parents
----
Sauvegarde effectuée
Step : 31, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 209.534916122578, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 42.08960383813729, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 0.021945082481384572, -2.020066887433906, 0.6029846611535649, 164.7461035270721, 2.7266157634161137]
Diversité génétique : 4.0798816850015385
Score médian : 80.66478468147835, 18 parents
----
Step : 32, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 187.20633942617212, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 6.254853900099665, -66.74125763637132, 5.872703780009237, -12.613919730761557, 26.689614778846764, -0.41327508065636176]
Diversité génétique : 4.121724803043034
Score médian : 80.66478468147835, 12 parents
----
Step : 33, 53 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.7798931856433, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, -3.58889841397465, -5.8115373573261735, -3.703925889589769]
Diversité génétique : 4.177783595960486
Score médian : 80.66478468147835, 18 parents
----
Step : 34, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 187.2583872647449, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 1.5118489476317378, -1.533325276099759, 0.4547387734115869, 2.1296844500171206, -16.666011245521087, -0.8896416506348251, 2.9636532930900756]
Diversité génétique : 4.097688795338574
Score médian : 80.66478468147835, 16 parents
----
Step : 35, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 44.18327277463945, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 184.7078317277107, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, -23.487601431300938, 49.12612132924567, -8.95694042169873, 1.0553345933305593, -3.605714188134254, 0.08689012335928975]
Diversité génétique : 4.115692440500496
Score médian : 80.66478468147835, 20 parents
----
Sauvegarde effectuée
Step : 36, 58 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.18847612784987, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 0.9951859809102118, 7.540680128237373, 8.85048905876802, -6.821305993314385, 11.409351458882389, 20.360152410886606, 2.503260833404179, 4.042250872257671]
Diversité génétique : 4.1259205056853325
Score médian : 80.66478468147835, 14 parents
----
Step : 37, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.68513148416235, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, -3.663390320309318, -3.4701403652094234, -52.439589365928875, 3.46269492615889, -0.048989023065868234]
Diversité génétique : 4.1424209710512905
Score médian : 80.66478468147835, 16 parents
----
Step : 38, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.2235735941919, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 6.170981890706956, 4.101828512847556, 0.31429059689316713, 21.820743899245052, 2.2708025396174234, 4.174776765847766]
Diversité génétique : 4.133214823964701
Score médian : 80.66478468147835, 12 parents
----
Step : 39, 53 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.67650018376307, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 3.590864397216669, -0.2689539155820203, 4.0022089824920375]
Diversité génétique : 4.213283013562982
Score médian : 80.66478468147835, 12 parents
----
Step : 40, 53 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 183.96690670682761, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 44.9251800475221, 47.21043783735726, 46.91537613781885, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 45.00969502894021, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 3.33277197656232, -3.5127671040287525, 5.787728658856106]
Diversité génétique : 4.165444424739072
Score médian : 80.66478468147835, 14 parents
Step : 0, 100 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.48721437628066, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67813.14654219801, 572.1614653815634, 16.98919257402642, 14.39046140502192, 1.8052699582051834, -0.010301132202966834, 1.1573183622823349, 1.7545396942302844, 35.80578544271879, 1.848894464209715, 3.875132957281315, -0.45053660949993746, -0.8083461868725245, 10.573377732866586, -13.436709473351744, -inf, 6.6620603570309225, -0.1387857002044474, -2.045395665478247, -69.98690828930586, 6.279364728578211, 34.82965110364933, 0.9430761005102437, 3.9973915722622513, -6.076561069468041, 4.049168743807945, 7.9362682058938185, -4.577570776680624, -0.5380379463024489, 13.018953909520333, 4.622470466191278, -163.14112024241547, -1.0901214932048202, 2.7385119910336355, 42.57578200872485, -0.6724934132500582, -0.3780941646298871, 0.7342012364877781, -1.3515718585224594, -0.3315983134616816, 734.0609117698696, 1.2235207572251092, 4.684649777103082, 1.9084465599821299, 2.480787688064986, -inf, -1.2938351735613773, 4.152696078734806, -inf, 0.3285604189159089, 1.2752638552659863, -inf, 1.1457189986984815]
Diversité génétique : 0.09954133497196817
Score médian : 90.31853688446981, 10 parents
----
Sauvegarde effectuée
Step : 1, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.2208333605364, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67928.19476508087, 572.1614653815634, 837.7886448732094, 0.9912439511364088, 24.039185871010755, -0.052818461832475516, 3.6036427298076434, 12.673728771212799]
Diversité génétique : 0.0800533579190722
Score médian : 90.31853688446981, 8 parents
----
Step : 2, 54 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.39133631316065, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67705.16458157067, 572.1614653815634, 574.0742777644218, 3.421789190075477, -676.5072250202692, 0.7121578766284015, -3.605204667870265]
Diversité génétique : 0.08369994941734156
Score médian : 90.31853688446981, 12 parents
----
Step : 3, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.0272835736138, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67871.96698985579, 572.1614653815634, 709.3569663328279, 1.5585475291274908, -11.226796325843026, -0.831598626313707, 2.4315655427395413, -2.6700378796496875, -0.6867644985089013]
Diversité génétique : 0.08010384313063058
Score médian : 90.31853688446981, 16 parents
----
Step : 4, 58 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.36666899406316, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67846.6280719084, 572.1614653815634, -5.9446896678816366, -0.0708253956638325, -5.654206920988122, 0.9673637935844777, 1.0761637667525703, -1.3757276420764661, 11.658775320580006, 7.849044652901203, -2.949085410717933]
Diversité génétique : 0.08096286800231192
Score médian : 87.60305879511301, 14 parents
----
Step : 5, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.28410625580872, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67814.59416420273, 572.1614653815634, 11.658775320580006, -6.665015298048852, 0.46103285163432856, -32.093803984645255, -40.90183672555593, -6.3686309397747705, 5.999148755970766, 8.925388660761788]
Diversité génétique : 0.08005782110150704
Score médian : 87.60305879511301, 14 parents
----
Sauvegarde effectuée
Step : 6, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.98805763804694, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67822.0463759929, 572.1614653815634, 11.658775320580006, 2.8488043487148724, 1.3953534536800871, -0.5504315048279153, -0.8064628663881936, 8.186322069067915, 0.6337086472365175, 2.4240555556389216]
Diversité génétique : 0.08024390766195816
Score médian : 87.60305879511301, 18 parents
----
Step : 7, 59 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 188.7670445739287, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 68028.23339760237, 572.1614653815634, 11.658775320580006, 4.485173806481026, 4.471736439549893, 0.41260318775570587, 0.6478434928961393, 3.8806745808829386, -0.9068312780590421, 5.364401328618693, -4.972228422755145, 10.935545472880873]
Diversité génétique : 0.07896441034205243
Score médian : 87.60305879511301, 16 parents
----
Step : 8, 58 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.5191887576005, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 68443.2312344042, 572.1614653815634, 11.658775320580006, 25.562173670561336, -1.003974614333659, 5.186546333218453, 1.9607720680460377, -6.94952015905585, -0.9056482383172053, 2.218237525400264, 7681.467893743489]
Diversité génétique : 0.08453226121619074
Score médian : 90.31853688446981, 12 parents
----
Step : 9, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.71488817098466, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67856.55192691406, 572.1614653815634, -22.832612114756028, -1.9335092292168796, 0.7282594523265385, 1.7523070454446696, -3.6629353129323876, -0.254650781518279, 1.9949452382627952]
Diversité génétique : 0.08427143326400421
Score médian : 87.60305879511301, 14 parents
----
Step : 10, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.51961547354497, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67848.19233259647, 572.1614653815634, 3.2747642136173782, 5.644978887959562, 2.2511998019272044, 4.759245265365789, -333.82611833052863, -2.4639139627598645, -13.633764935412001, 14.92029874643255]
Diversité génétique : 0.08176555877544836
Score médian : 87.60305879511301, 10 parents
----
Sauvegarde effectuée
Step : 11, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.69380604842044, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67849.77332411874, 572.1614653815634, 3.2600618856381445, 4.615416461174202, -7.695285659058315, -2.2132672235389284, 0.7665287457696002, 7.576388698580051]
Diversité génétique : 0.08227883283088742
Score médian : 87.60305879511301, 16 parents
----
Step : 12, 58 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.63739734330298, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67939.24290928528, 572.1614653815634, -1.3731678765684363, -43.60466325051648, -0.5734007439459207, 1.1681049451424195, 2.6954443543053825, -8.112171231523254, 5.627161257799898, 0.25905766661259744, -2.2230484262012946]
Diversité génétique : 0.08010303432931867
Score médian : 87.60305879511301, 10 parents
----
Step : 13, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 188.09659113997114, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67324.94196028773, 572.1614653815634, 5.627161257799898, 2.7035580686486758, -0.13104110062320676, 4.9214822015598525, 0.07822357582530272, 2.2199960905512426]
Diversité génétique : 0.08526987464256057
Score médian : 87.60305879511301, 12 parents
----
Step : 14, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.9348527207217, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 68030.34904438934, 572.1614653815634, 5.627161257799898, 2.0299595272119184, 3.827929792571847, 4.516897620899656, 2.1812206825967286, -3.616784738148137, 56.79775924221442]
Diversité génétique : 0.08181828064205879
Score médian : 87.60305879511301, 14 parents
----
Step : 15, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 246.36005312335223, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67910.33386499967, 572.1614653815634, -0.705220460615514, 6.462281650100346, 4.495927271279382, -1.4427617514903264, -3830.624784837936, -3.045968493710297, -1.780517807799426, 0.3964592327869147]
Diversité génétique : 0.08230913635853948
Score médian : 87.60305879511301, 14 parents
----
Sauvegarde effectuée
Step : 16, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.94337656628971, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67837.31777419294, 572.1614653815634, 6.462281650100346, -5.583520460307263, 0.3592499403969158, 1.4425347209713137, 2.0189435717752056, -1.2016869332410962, 87.16179830408609]
Diversité génétique : 0.08140273877234483
Score médian : 87.7977173421432, 10 parents
----
Step : 17, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.66816533204113, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 46.998172402471596, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67886.59651008908, 572.1614653815634, 87.16179830408609, 3.6293642732193083, 0.5053037713672732, -30.552943150572588, 1004.7053700820572, -1.9526480302462998]
Diversité génétique : 0.08255315680654328
Score médian : 90.31853688446981, 14 parents
----
Step : 18, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.29678427086643, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 47.21043783735726, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67866.45303115768, 572.1614653815634, 87.16179830408609, 1752.318659159667, 2.7409945244771508, -0.5537562994681864, 6.090689876040587, 6.17224837138721, 6.57216052007502, 241.28693390243805, -1.3911976778916826]
Diversité génétique : 0.08389635416672618
Score médian : 95.10614745708821, 16 parents
----
Step : 19, 58 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.51517637348738, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67842.38132778148, 572.1614653815634, 87.16179830408609, 805.1734409501058, 241.28693390243805, -25.370330599202756, 1.8037585959418787, -0.0171589117621333, -1.3747279955611655, 3.951798185006793, -14.498382960928526, 2.5348010393273475, 1.3355861406802676]
Diversité génétique : 0.08384927753325526
Score médian : 95.10614745708821, 20 parents
----
Step : 20, 60 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.78751591132985, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67913.85388251036, 572.1614653815634, 87.16179830408609, 1069.7062494707634, 241.28693390243805, 2.82430068985291, 0.5606008197752841, 2.4882221470083863, -1.1390266203067068, 6.3816119864685765, 6.235144539809844, -15.830537907093323, 8.6387190962919, -12.935887372158877, 39.937051669140736]
Diversité génétique : 0.08308440923456326
Score médian : 95.10614745708821, 12 parents
----
Sauvegarde effectuée
Step : 21, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.82986366216835, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67874.17345209369, 572.1614653815634, 87.16179830408609, 986.7789657288369, 241.28693390243805, 2.498485718441318, 31.497148623683003, 0.020494404888743798, -14.568202917958953, 4.548533617456309]
Diversité génétique : 0.08243367629449991
Score médian : 95.10614745708821, 12 parents
----
Step : 22, 56 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.37193673613268, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 47.68918195638233, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67826.53469967787, 572.1614653815634, 87.16179830408609, 823.5814766608065, 241.28693390243805, -4.203479625164624, 2.647187564742119, 29.5906048570346, -8.583412470519448, -0.14939374138018258, 66.3281107177521]
Diversité génétique : 0.08359846263781805
Score médian : 95.10614745708821, 10 parents
----
Step : 23, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.8543774168854, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 68081.52301034487, 572.1614653815634, 87.16179830408609, 941.2766457434323, 241.28693390243805, 66.3281107177521, 23.85664355356315, 0.19357371145010757, -0.31417553447284957, 4.784809384309806, 3.180181887895821]
Diversité génétique : 0.08570974595380185
Score médian : 95.10614745708821, 12 parents
----
Step : 24, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.38244766666062, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 47.873033734812275, 164.7461035270721, 49.12612132924567, 67841.12979715687, 572.1614653815634, 87.16179830408609, 329.20710533546213, 241.28693390243805, 66.3281107177521, -208.81407317881084, -65.6010464309163, -20.37602286237262, 142.1616752382506, -0.47649277559071196]
Diversité génétique : 0.08470160782545436
Score médian : 98.96600736231429, 14 parents
----
Step : 25, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.3505547503423, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 49.12612132924567, 67854.87956190653, 572.1614653815634, 87.16179830408609, 855.0258089367952, 241.28693390243805, 66.3281107177521, 142.1616752382506, -14.794880143204612, 12.25494243268086, 22.110858946014574, -1.506916873565171, -0.48575638418046035, 3.0626764141193847, 1.793838767290741]
Diversité génétique : 0.08734208825672807
Score médian : 98.96600736231429, 14 parents
----
Sauvegarde effectuée
Step : 26, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.44769204143432, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 49.12612132924567, 67943.2725340173, 572.1614653815634, 87.16179830408609, 526.0493752825116, 241.28693390243805, 66.3281107177521, 142.1616752382506, 5.721950192541241, 0.07535175134917166, 17.192091251620297, 9.7831352074598, -0.02605137403628677, 3.201223604645487, -0.056036314249653246]
Diversité génétique : 0.08672555443008305
Score médian : 98.96600736231429, 10 parents
----
Step : 27, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.8568699837393, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 49.12612132924567, 68067.09184797922, 572.1614653815634, 87.16179830408609, 671.386885219696, 241.28693390243805, 66.3281107177521, 142.1616752382506, 0.4443934960973739, -6.47265510752751, -7.7031260619827515, -11.551444541570222, 2.5884083013977213]
Diversité génétique : 0.08418273241947707
Score médian : 98.96600736231429, 14 parents
----
Step : 28, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.33831355143553, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 49.12612132924567, 64275.94858447049, 572.1614653815634, 87.16179830408609, 949.9211976249073, 241.28693390243805, 66.3281107177521, 142.1616752382506, -0.5870802030115134, 0.36849331787886014, 3.6195817111399795, 3.3728883449473015, -2.9669322400782936, 15.690536974512332, 0.8548535859244837]
Diversité génétique : 0.09140552586259447
Score médian : 98.96600736231429, 10 parents
----
Step : 29, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.60208262343437, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 49.12612132924567, 68602.3329223204, 572.1614653815634, 87.16179830408609, 2459.3788978947414, 241.28693390243805, 66.3281107177521, 142.1616752382506, -3.8779094790000346, 0.451950920680375, -20.74368588457353, 8.375145009613453, -6.509292601320474]
Diversité génétique : 0.0842948632590165
Score médian : 98.96600736231429, 22 parents
----
Step : 30, 61 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 131.2185613336382, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 49.12612132924567, 67845.17266033385, 572.1614653815634, 87.16179830408609, 1126.959145009286, 241.28693390243805, 66.3281107177521, 142.1616752382506, -0.4536905664286124, 3.7842552894422155, 0.07918257510390944, 0.3750403753106261, 0.18747614065972157, -2.6950970744665157, -0.3350237210981968, -0.5744925806935129, 0.9582046833410359, 25.709733184309528, 25.673389678218577]
Diversité génétique : 0.08567183549962883
Score médian : 98.96600736231429, 10 parents
Step : 0, 100 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 47.981545516446715, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.74772978606345, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 48.899079752067465, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 49.12612132924567, 67818.66914720759, 572.1614653815634, 87.16179830408609, 3779.260841179828, 241.28693390243805, 66.3281107177521, 142.1616752382506, -inf, 4.867168386433063, -4.261438225306395, -0.13615722420180926, -2.6802401635097657, -21.763891706788325, 94.2710061515451, -inf, 2.533857423247451, 4.6066237093212905, 5.901767307860636, -28.15694205242872, 10.204590187185365, -17.003550141851466, 0.32685698866861135, 1.9872877716087969, 0.07864278963482103, 10.599846948664412, 0.23676296618424633, -1.9584810853621215, 3.150133599835854, -1.2977873814332028, -2.275128347659586, 0.15640121404841797, 1.6508113102480244, -17.696484915831157, -20.782896084275613, -22.793792019278307, -6.779724321997532, 2.41443439680666, 1.9950443081111588, 3.0178478642617446, 113.98956105567936, 3.6313507151412328, 0.7695821890863753, 49.764335540463335, 0.36005903321197097, 2.353732497732208, -69.5423857898553, -0.9947973554334195, 6.348872284381189, -31.654329106654792, -0.7701410079757217, 3.232978880687362, 0.63110125679202, -0.3435690112009009, 2.113373113280171, 1.408351895059077, 1.7174837161928886, 2.7119813049348718]
Diversité génétique : 3.185878834860721
Score médian : 105.94117630555571, 16 parents
----
Sauvegarde effectuée
Step : 1, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.4289785581029, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67786.30264313663, 572.1614653815634, 87.16179830408609, 613.0905782210434, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 49.764335540463335, -0.6765726201046488, 36.212979488605335, -0.31610829279621605, 10.475296403703425, 1.0459280740666868, -24.649335113626698, 0.2180745754732267]
Diversité génétique : 1.9861534304902113
Score médian : 105.94117630555571, 14 parents
----
Step : 2, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 183.66074996053862, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67846.49412162852, 572.1614653815634, 87.16179830408609, 937.55897486963, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 49.764335540463335, -0.0723908245231418, 2.191397219969727, -7.1856906174771655, -16.875791307161823, 7.592916339247895, -1.9598763137359103, 0.935544194841322]
Diversité génétique : 2.073919730556857
Score médian : 105.94117630555571, 16 parents
----
Step : 3, 58 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 175.99822396439214, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67855.19900160257, 572.1614653815634, 87.16179830408609, 981.315840253576, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 49.764335540463335, 0.2742485996659353, 0.9455249113829648, -5.3438587670104845, -0.8165195902337161, -9.74525082617381, 1.1976602575904258, 1.7169183818055775, 0.16803279896080348]
Diversité génétique : 2.1540805262041607
Score médian : 105.94117630555571, 16 parents
----
Impossible d'actualiser la position de Left knee link (D) 0 : contraintes insolubles <class 'Exception'>
Step : 4, 57 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.37258260968434, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67867.99658121871, 572.1614653815634, 87.16179830408609, 865.0064109112516, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 49.764335540463335, 549.2937310522583, -inf, 3.60605244802754, 21.540552236046413, 14.630071790982225, 1.1248971384126665, -0.4680537880340807]
Diversité génétique : 2.00433767316694
Score médian : 112.97437823379968, 12 parents
----
Step : 5, 55 individuals, scores :
[51.129365697787904, 75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.68091193906236, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67909.89438335074, 572.1614653815634, 87.16179830408609, 916.8858021211647, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 305.97206859851843, 1471.7060686205189, 1.3325654220479553, -28.428212590218404, 6.9576579243646375, 0.029197267871390743]
Diversité génétique : 1.70990037819858
Score médian : 114.18892407099787, 16 parents
----
Sauvegarde effectuée
Step : 6, 57 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.50594030864133, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67500.19779613079, 572.1614653815634, 87.16179830408609, 955.9057716966012, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 84.056312037236, 1.1117314428542593, 10.337770231343582, 0.8502781778850426, 5.906309275819838, 0.08648470578190456, 1.385349179014592, 0.3130112023200375, -1.2007224431808121]
Diversité génétique : 2.138312004301995
Score médian : 105.94117630555571, 16 parents
----
Step : 7, 57 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.02448384242763, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68558.22119774361, 572.1614653815634, 87.16179830408609, 992.5455837365615, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, -32.23894954593278, -0.21266132672861404, 5.24692964798164, -15.735224069625607, 4.029587283628036, -1.8939570384783173, 5.141244895355409, 1.9956005148349205, -0.32367705044865763]
Diversité génétique : 2.1507218240753194
Score médian : 105.94117630555571, 14 parents
----
Step : 8, 56 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.8133554925918, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67825.6577910441, 572.1614653815634, 87.16179830408609, 1138.6071710666981, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 5.24692964798164, 5.141244895355409, 0.9440720062428467, -1.8175165230936785, -inf, -10.714192853727194, 0.0005363060107035764, 10.36494068804714]
Diversité génétique : 2.0284986973046513
Score médian : 105.94117630555571, 14 parents
----
Step : 9, 57 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.40732020417266, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67910.908405307, 572.1614653815634, 87.16179830408609, 922.8756810793949, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 5.24692964798164, 10.36494068804714, 0.6503565821180246, 2.0273691913981713, 2.043266237057961, 3.371592818689296, 2.2705286180605246, -0.5223280725646997, -0.14957168525256276]
Diversité génétique : 2.1452213503495057
Score médian : 105.94117630555571, 12 parents
----
Step : 10, 55 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.60087370600542, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67913.4132357615, 572.1614653815634, 87.16179830408609, 1184.257713363785, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 5.24692964798164, 10.36494068804714, 17.34220999713268, 1.582771370953081, 41.00851035387097, -0.8023976770662445, 221.98101648444936]
Diversité génétique : 1.886608560756494
Score médian : 112.97437823379968, 14 parents
----
Sauvegarde effectuée
Step : 11, 56 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.97906771613503, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67857.22750894174, 572.1614653815634, 87.16179830408609, 506.75604988709927, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 41.00851035387097, 190.5589889129492, 21.943376140522272, 0.23730930778132595, 4.696060464584983, -1.5470020110833425, -1.5882646242184004, 10.407375353484737]
Diversité génétique : 2.0284018705052835
Score médian : 112.97437823379968, 14 parents
----
Step : 12, 56 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.25021149292135, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67827.50717033225, 572.1614653815634, 87.16179830408609, 1162.7161999603757, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 41.00851035387097, 109.19574966846648, 3.806697245139725, -6.257625226718482, 6.991679779245679, -10.990174965462659, 375.1852957242596, 4.124682731868269]
Diversité génétique : 2.0030480711510132
Score médian : 112.97437823379968, 16 parents
----
Step : 13, 57 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 184.1868721364858, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67851.52724270578, 572.1614653815634, 87.16179830408609, 1023.7547560903181, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 791.9251336848105, 375.1852957242596, 8.14667386208991, 0.1866651836528321, 0.046825552484198014, -7.014639553046677, 1.0894391152682734, -4.012706905122539, -37.12255998446604]
Diversité génétique : 2.1368389376903973
Score médian : 114.18892407099787, 16 parents
----
Step : 14, 57 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.24425338340296, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 51.802575198611606, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68136.87136643408, 572.1614653815634, 87.16179830408609, 1859.2138551393923, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 5682.2833074013115, 375.1852957242596, 3.448083473670257, 0.14745044653259776, -2.5992754255534, 0.14210125788528277, 4.735285080627193, 105.45648503979737, 3.7515996142602943]
Diversité génétique : 2.141864556234032
Score médian : 114.18892407099787, 16 parents
----
Step : 15, 57 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.96323305538516, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67747.40045947654, 572.1614653815634, 87.16179830408609, 1292.2719926437635, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, -585.9231696201157, 375.1852957242596, 105.45648503979737, 1.1024727651701824, -10.893294614308818, 2.1366534146072302, -0.20013399645333899, -7.380322725081715, 2.057474242624406, 5.205450390103692]
Diversité génétique : 2.3615349083578487
Score médian : 112.97437823379968, 16 parents
----
Sauvegarde effectuée
Step : 16, 57 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.0836734792376, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67748.7542272369, 572.1614653815634, 87.16179830408609, 858.5029235202268, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 5.205450390103692, 11.177216409207892, 0.29973616809864667, 2.7031767351321747, -2.3901194357748787, 7.396505199178197, -12.551239684267529, -1.9631282145725324]
Diversité génétique : 2.2667683784598065
Score médian : 112.97437823379968, 12 parents
----
Step : 17, 55 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.7740746934803, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67937.52596220425, 572.1614653815634, 87.16179830408609, 679.4495997724966, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, -0.9874945423758452, 0.39042170430416584, 19.13025602401134, 12.523368600172406, 9.69322112508264, -0.17329322404685896]
Diversité génétique : 2.112151119687402
Score médian : 112.97437823379968, 14 parents
----
Step : 18, 56 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.39559906817007, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67872.75095977676, 572.1614653815634, 87.16179830408609, 312.96358951375544, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 2.234974191098753, 14.132915946338555, -0.9347289889481348, 0.925244022924232, 1.8210706411405548, -0.2282180311782971, -16.525575946598593]
Diversité génétique : 2.199530480000012
Score médian : 112.97437823379968, 14 parents
----
Step : 19, 56 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 184.05867626992833, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67373.13386168597, 572.1614653815634, 87.16179830408609, 969.816130556583, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 14.132915946338555, 72.38132147031637, 23.853247790371334, -31.672799521747464, 0.644895935055241, -10.647494591815464, -3.594205977123095]
Diversité génétique : 2.205650923725261
Score médian : 112.97437823379968, 12 parents
----
Step : 20, 56 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.10639821467416, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 52.14310599822581, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67849.42038117384, 572.1614653815634, 87.16179830408609, 1785.0260852455938, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 3.914198876549276, 164.7399820215974, -129.47924995102505, 7.969347419248813, 19.346258840233432, -3.0784178750890066]
Diversité génétique : 2.1587533286581637
Score médian : 114.18892407099787, 8 parents
----
Sauvegarde effectuée
Step : 21, 54 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 53.4175899702952, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.31915311897964, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67896.77909772896, 572.1614653815634, 87.16179830408609, 1241.4569410601903, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 2.9079028496696253, 63.9042043480916, -2.783764838148303, 1.3377000651246536]
Diversité génétique : 2.0905380748889404
Score médian : 114.18892407099787, 10 parents
----
Step : 22, 54 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.07709681283893, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 59.906762881044465, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67887.84703185981, 572.1614653815634, 87.16179830408609, 788.2782251821479, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 9.800024531259199, 537.8664603662527, 13.174449168626895, -1.0059154269049304]
Diversité génétique : 2.2108947997540445
Score médian : 115.82940678459369, 14 parents
----
Step : 23, 57 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 172.55018431845605, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67827.42869755189, 572.1614653815634, 87.16179830408609, 869.0654458937253, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 1174.4980206021173, 3.291442824549317, 7.187955948312869, 0.13650525456934176, 2.554016325781827, -0.2690466264629439, -0.31603633321932045, 11.445612606382708]
Diversité génétique : 2.5771038786510503
Score médian : 115.82940678459369, 12 parents
----
Step : 24, 55 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 29102.534025514535, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67876.26648932236, 572.1614653815634, 87.16179830408609, 1420.8670111209, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, -290.82338827767796, 0.5545484800528293, 2.486414753179863, 3.416912936030521, -2.3179607292781674, 3.4183468780544364]
Diversité génétique : 2.456795541208469
Score médian : 114.18892407099787, 14 parents
----
Step : 25, 57 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 176.16199801852395, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67933.77168695905, 572.1614653815634, 87.16179830408609, 888.5463246043699, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 3.4183468780544364, -0.09666939208416724, -1.3942498336154299, 5.935671484344699, 4.862852954812361, 33.208216964390644, -95.9805797308952, 3.6336905319752084]
Diversité génétique : 2.660851196319026
Score médian : 114.18892407099787, 18 parents
----
Sauvegarde effectuée
Step : 26, 58 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.48376969827424, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67578.06000861953, 572.1614653815634, 87.16179830408609, 1053.310860181051, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 33.208216964390644, 6.06565839593331, 1.2915932960163528, 36.632176934345644, -2.9909024248986302, 11.648331284246987, 7.484068751562608, 6.82858001564859, -3.3657326612548952]
Diversité génétique : 2.743713850445527
Score médian : 114.18892407099787, 12 parents
----
Step : 27, 55 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 168.9876677094411, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67677.28725585797, 572.1614653815634, 87.16179830408609, 980.02220489114, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 36.632176934345644, 1.4698855088883414, 77.82571996104772, 10.20474842366716, -1.5237717415236673, 3.520912344852306]
Diversité génétique : 2.4774582221375487
Score médian : 114.18892407099787, 14 parents
----
Step : 28, 56 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.40469786512057, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67820.75897162849, 572.1614653815634, 87.16179830408609, 1069.3577582409541, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 117.25230139560283, -3.6616691038578213, 3.087232759072909, 0.46582325074371794, -1.1194810351429558, -4.601632185709209, 0.3651605103831868]
Diversité génétique : 2.591540831177542
Score médian : 115.82029424095961, 14 parents
----
Step : 29, 57 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.68130165246404, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 22455.75961144664, 572.1614653815634, 87.16179830408609, 450.23814105697, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 98.82631920914856, 0.4970565903693532, -39.92415676337067, 38.87570312889123, 1.011888206639759, 0.7962776687350034, 5.313081580689777, -25.01010987925123]
Diversité génétique : 2.6175712075183943
Score médian : 114.18892407099787, 14 parents
----
Step : 30, 56 individuals, scores :
[75.49438934537424, 60.554777695584704, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.98788059997597, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67826.87271158487, 572.1614653815634, 87.16179830408609, 3000.19713077124, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 810.8498512936616, -1.1191194357789778, 10.575241512028088, 5.245846098676975, 0.9261078835138209, 944.358982023935, 2.049585879283805]
Diversité génétique : 2.5518295033294423
Score médian : 120.14653709900062, 12 parents
----
Sauvegarde effectuée
Step : 31, 55 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 183.82328781974684, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67839.46066403495, 572.1614653815634, 87.16179830408609, -2213.2106976022474, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 399.91294299971713, 36.07634505524224, 2.178869827438994, 3.127566635611469, 5.071887075006455, -0.44404266683825894, -2.4359853687350834]
Diversité génétique : 2.563486369089734
Score médian : 114.18892407099787, 18 parents
----
Step : 32, 58 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.34203405611592, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67630.12977320612, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 72.89339448731073, 64.86928960259422, 6.843173627955706, 0.6016699806386495, 0.28522025671230045, 8.010980449797783, 1.4300665985403433, -2.693245790826302, -1.1409213209629645, 9.676274150491881, -8.79573188819116]
Diversité génétique : 2.811968438607263
Score médian : 112.97437823379968, 14 parents
----
Step : 33, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 183.50019174275465, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67856.71479790709, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 194.02485105548217, 46.64772437815437, 9.676274150491881, 0.2942636585487305, 2.149692147357807, -28.20884935046479, -16.345474661102557, 10.14064041946518, -8.594240510588751]
Diversité génétique : 2.7292067181111643
Score médian : 114.18892407099787, 8 parents
----
Step : 34, 53 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 175.54525410760795, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67896.98546733426, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 73.81372200150406, 92.19626327349218, -2.7654970854203653, 0.7819156609929814, 4.989702525875061, -3.1628186926233353]
Diversité génétique : 2.5131495071537677
Score médian : 112.97437823379968, 14 parents
----
Step : 35, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.3013156097727, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68122.15137085774, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 7.981886478638375, -1218.0428292175366, 0.6672148448650899, -1.1281715358846882, 23.009906297631165, 6.723431231333832, 0.025256766364712305, -0.2656189971746603, 2.576721776746549]
Diversité génétique : 2.7840078105873047
Score médian : 112.97437823379968, 14 parents
----
Sauvegarde effectuée
Step : 36, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.80294007073397, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67893.75139419867, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, -59.965754135373075, 23.009906297631165, -12.083187340972394, 5.817832404225269, 2.427987993226895, -0.2395950098456805, 1.9103444483893222, -1012.3303206209615, -0.7448456254552641]
Diversité génétique : 2.8115114571546274
Score médian : 112.97437823379968, 10 parents
----
Step : 37, 54 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 183.99466661035655, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67896.25209540305, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 5.817832404225269, 2.5579459756947887, 4.186932710658059, 0.07862669722543844, 0.20399560225111776, 0.554721083476955]
Diversité génétique : 2.6918381082188456
Score médian : 112.97437823379968, 8 parents
----
Step : 38, 54 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.88221960490472, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67878.38702303858, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 5.817832404225269, 5.409698302410546, -124.9263734802658, 2.1282551902236833, -3.155001808413095, -1.8047586828467335]
Diversité génétique : 2.687453711479872
Score médian : 112.97437823379968, 10 parents
----
Step : 39, 55 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.05981976425727, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67718.79760907359, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 5.817832404225269, 5.496793953333108, -20.973429135017938, 0.5854758566207154, 2.2146941000664926, -72.64823533299558, 1.2124555286254102]
Diversité génétique : 2.757058759543345
Score médian : 112.97437823379968, 18 parents
----
Step : 40, 58 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.5077137939793, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67927.22279156711, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 5.817832404225269, 3.5481024578361287, -3.7209316027262105, -18.55046267954426, 1.211757060494542, -0.36706127786098547, -2.2524791076351813, 2.762300360952331, 2.120937026545182, 4.162230120675603]
Diversité génétique : 2.931548926142272
Score médian : 112.97437823379968, 18 parents
----
Sauvegarde effectuée
Step : 41, 58 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 176.65300123865416, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67824.6321047409, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 5.817832404225269, 5.213759589362731, -1.111746998165067, -1.9493745931862736, -0.08621717105119028, 12.958748845323061, 0.5404074358535303, 5.02165513454583, 1.6553141636952682, 3.0871843956734977]
Diversité génétique : 2.943850788749056
Score médian : 112.97437823379968, 8 parents
----
Step : 42, 54 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.19787383072807, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67887.5710916886, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 5.817832404225269, 12.958748845323061, 3.50094544626631, 2.8486753594221126, 1.4504965388592987, 0.22307055013356417]
Diversité génétique : 2.653188105404626
Score médian : 112.97437823379968, 16 parents
----
Step : 43, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.92359816822912, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67830.01628100294, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 5.817832404225269, 12.958748845323061, -0.5082473568857079, -20.66742533943231, -5.939253681904042, -6.227758350625157, 4.296094064926998, 33.276824327115875, -6.647483823254062]
Diversité génétique : 2.861538868941143
Score médian : 112.97437823379968, 12 parents
----
Step : 44, 55 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.20078798297968, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67924.54887405572, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 12.958748845323061, 33.276824327115875, -0.7417664675232303, -1.409318027291701, -2.25167719503847, 14.665179900775104, 21.576979440832996]
Diversité génétique : 2.704467212808956
Score médian : 112.97437823379968, 16 parents
----
Step : 45, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.0183894530401, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67866.27481783807, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 33.276824327115875, 21.576979440832996, 18.458039577982518, -0.4937821565567642, -0.5981703190059697, 0.9396962526479883, 3.4491770104760073, 7.658393718437584, 0.8944744866825565]
Diversité génétique : 2.8452450885711267
Score médian : 112.97437823379968, 10 parents
----
Sauvegarde effectuée
Step : 46, 54 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.47611397466895, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68748.70431982772, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 33.276824327115875, 21.576979440832996, 8.1014955132406, -407.91268108708294, 1.0284604932577224, -38.8553345275302]
Diversité génétique : 2.6442199732931693
Score médian : 112.97437823379968, 10 parents
----
Step : 47, 53 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.62029258348628, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67820.95800316107, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 33.276824327115875, 21.576979440832996, -0.2153638648664434, -6.156475329594214, 16.47923544877762]
Diversité génétique : 2.5014216898893085
Score médian : 112.97437823379968, 12 parents
----
Step : 48, 55 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.08321384707443, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67914.86709673739, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 33.276824327115875, 21.576979440832996, -1.0993511926935307, 0.9855046518565237, 2.7783233755196437, 0.5097863139274776, 17.32250124021051]
Diversité génétique : 2.707148276591145
Score médian : 112.97437823379968, 16 parents
----
Step : 49, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.34725708700586, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67866.41662874552, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 23.009906297631165, 33.276824327115875, 21.576979440832996, -1.09895893258947, 48.552414331147794, -14.181669662168883, 1.6914145139104875, 3.193977948482232, 1.9499043833221352, 262.64364186406374]
Diversité génétique : 2.85235252038149
Score médian : 114.18892407099787, 14 parents
----
Step : 50, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.49788171881445, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67999.20860354419, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 33.276824327115875, 48.552414331147794, 262.64364186406374, 27.630960391092604, 2731.176640987997, 2.411850418767185, 3.489780477364605, 2.379618484765176, -0.08746878910314362]
Diversité génétique : 2.832432668812012
Score médian : 115.82940678459369, 16 parents
----
Sauvegarde effectuée
Step : 51, 58 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 184.43409411821108, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67883.14140022946, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 2383.028646487909, -17.44013576428587, -15.861601921099595, -0.44490782435410364, 0.27449436013197454, 18.126355023933048, -2.846016113858797, 0.4165137596804258, 6.40507849511821]
Diversité génétique : 2.8440236420865377
Score médian : 115.82940678459369, 8 parents
----
Step : 52, 53 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.7207546042992, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67836.26068439383, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 2428.9783960784835, 3.5542241331808597, -681.8672109814106, 2.181482220655182]
Diversité génétique : 2.5397326229840287
Score médian : 115.82940678459369, 16 parents
----
Step : 53, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.6763371565962, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67893.67310142118, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 3242.6576616620023, 6.1166227772002975, -6.507487833029922, 5.423251975906907, 3.5623928829412783, 7.353271421032489, -2.127073999843505, -7.37721249922482]
Diversité génétique : 2.8827930686725547
Score médian : 115.82940678459369, 18 parents
----
Step : 54, 58 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.33319271979337, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68005.4847965293, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 2586.7669915274855, 19.912061332434828, 0.9766848858950022, 8.090209263651431, 1.0220859615780113, -3.0975317930804356, -52.57627605043418, 1.79417323801278, -0.4071931431468218]
Diversité génétique : 2.8567554887547635
Score médian : 115.82940678459369, 16 parents
----
Step : 55, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.92473886227015, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 69211.5020265142, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 2536.6772949408323, 2.166265757749804, -0.5306504354540632, 1.7262457464701255, 1.6045828300877434, 0.2629060606276069, -24.55654857177884, -10.34554879369497]
Diversité génétique : 2.7601640364598308
Score médian : 115.82940678459369, 14 parents
----
Sauvegarde effectuée
Step : 56, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.69582748729593, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 66412.02182103883, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 6139.727092650693, 0.4317861157391442, 7.483753784676224, 0.3238561231086682, 1.3783509965659408, -1.8486610542461237, 2.7144774920984314]
Diversité génétique : 2.839711856730919
Score médian : 115.82940678459369, 16 parents
----
Step : 57, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 183.13688022976368, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67878.50840544076, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 2318.1430848613813, -3.724511844180005, 0.6185678153269818, -5.263836688671075, 1.1316993642247304, -1.770020916109137, -0.5384803070643838, -0.0804982226051236]
Diversité génétique : 2.8530223311176894
Score médian : 115.82940678459369, 8 parents
----
Step : 58, 53 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.8064732191055, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67011.32849448545, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 2524.518773518815, 2.842201501898456, 3.690547061222878, 6.589809705422469]
Diversité génétique : 2.553592729691533
Score médian : 115.82940678459369, 10 parents
----
Step : 59, 54 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 184.12145563081475, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67868.25464167637, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 3021.7569254385535, -7.878299711707444, 2.6040070693575297, 0.0908743111720888, -4.519390928323227]
Diversité génétique : 2.6551402708438627
Score médian : 115.82940678459369, 14 parents
----
Impossible d'actualiser la position de Left knee link (D) 0 : contraintes insolubles <class 'Exception'>
Step : 60, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.044272823903, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67516.41040624381, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 2628.0023479085494, 5.768370226666331, 6.550947132036798, -0.7216986998301529, 15.383942918239315, 5.0343370677822, -inf, 0.9148379929616943]
Diversité génétique : 2.777723174357141
Score médian : 115.82940678459369, 16 parents
----
Sauvegarde effectuée
Step : 61, 58 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.20658342541552, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67890.296626388, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 48.552414331147794, 262.64364186406374, 2480.6108682528493, 2.0574536013371256, 3.166793692884005, 2.238162073169234, 1.0637076225040025, -1.683010511639707, -27292.60568296007, 0.06670167091011014, 980.8441577013808]
Diversité génétique : 2.8362434816180104
Score médian : 120.14653709900062, 12 parents
----
Step : 62, 55 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.83678883488923, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67858.10264261194, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2792.5405354454347, 980.8441577013808, 49.708112407774465, 3.37319232095475, 1.169723446314283, -6.523013319722512, -1.6253548006598646]
Diversité génétique : 2.6208270751454052
Score médian : 120.14653709900062, 14 parents
----
Step : 63, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.5010819271208, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67789.14844456517, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2545.1899866081476, 980.8441577013808, 6.156884530526039, -276.38762173829446, 6.9654527099362795, 33.06679266398368, 0.21269721913513845, -4.37156935783261]
Diversité génétique : 2.7070868593449844
Score médian : 120.14653709900062, 10 parents
----
Step : 64, 53 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.25182635014636, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67870.27659451228, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2570.5034680780036, 980.8441577013808, -0.6316439837380668, 56.294370781432114, 4.5995748203304]
Diversité génétique : 2.4269455308384353
Score médian : 120.14653709900062, 16 parents
----
Step : 65, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.1232156692818, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67838.08197333405, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2538.0560667709574, 980.8441577013808, -0.2746173881577132, 0.02739854128229563, 7.344278122060257, 20.07843158756427, -2.948991939015492, 9.113735168596332, -0.5608841354639683]
Diversité génétique : 2.66722532368662
Score médian : 120.14653709900062, 14 parents
----
Sauvegarde effectuée
Step : 66, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.5359373131724, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67900.87338999854, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2600.4353396275774, 980.8441577013808, 2.0454822731541142, 42.21138884002482, -0.5570341893033687, 2.5697734162933568, -0.28542637824740763, 0.16582407368263352, 3.912290085127153]
Diversité génétique : 2.7190357071468765
Score médian : 120.14653709900062, 14 parents
----
Step : 67, 55 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.3629867715662, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67881.1444915377, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 3251.180491696484, 980.8441577013808, 8.162747673225516, -0.8235252332707576, 3.8711815861566223, 0.3655879190138704, -2.9971839411218935]
Diversité génétique : 2.655229648810105
Score médian : 120.14653709900062, 14 parents
----
Step : 68, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.35026191094903, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67837.02024667837, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2688.9373048524167, 980.8441577013808, 1.6717982091382408, 2.4839012521485246, 2.4421535296449197, -0.6364139286751423, 5.541977848247693, 1.0707592012278537]
Diversité génétique : 2.626179437798382
Score médian : 120.14653709900062, 16 parents
----
Step : 69, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.18995781529244, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 62.63285440122024, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67852.5927781627, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2025.7716802168811, 980.8441577013808, 43.90985965939253, -0.4508833720982293, 4.715670933675754, 0.15544777796954598, 0.4805020794953197, -0.4542558357666892, 163.3794279983755]
Diversité génétique : 2.6761759842383044
Score médian : 124.54997157872832, 16 parents
----
Step : 70, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.8959475006349, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67938.50415790855, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2465.1645384495446, 980.8441577013808, 163.3794279983755, -1.0709201016031935, 0.5217381893803614, 1.0453578031300104, 29.01099873259554, -0.27661202595239376, 0.06413118092727256, 2.188068011513838]
Diversité génétique : 2.7834007474553224
Score médian : 124.54997157872832, 12 parents
----
Sauvegarde effectuée
Step : 71, 55 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.06978892443584, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67979.5784674226, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2465.746820003463, 980.8441577013808, 163.3794279983755, 2.5584635886398712, -0.22656694658714702, 6.229070174591575, 1.653141949934912, 0.6605150032180511]
Diversité génétique : 2.5462619420417107
Score médian : 124.54997157872832, 12 parents
----
Step : 72, 55 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.55367091862323, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67737.99598927354, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2705.075917861111, 980.8441577013808, 163.3794279983755, -2.3394359619639693, 1.0833527946791675, -0.9648989302815185, 11.470523112257183, 0.7179887813931084]
Diversité génétique : 2.6208874021833086
Score médian : 124.54997157872832, 16 parents
----
Step : 73, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.19304262217906, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67707.98556134437, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 3477.3767674578603, 980.8441577013808, 163.3794279983755, 3.49525402367973, 1.2378354216049292, 1.1210736405244353, 1.0085303291924572, -1.297430687094964, 0.4436607688722206, -12.587978081844629]
Diversité génétique : 2.7610632258044436
Score médian : 124.54997157872832, 12 parents
----
Step : 74, 54 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.57508952587028, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67626.59499749087, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 1723.3821859072718, 980.8441577013808, 163.3794279983755, -0.6101814846844261, -22.926514302903875, -3.790821736501726, 32.19004726651332]
Diversité génétique : 2.575153824598231
Score médian : 124.54997157872832, 14 parents
----
Step : 75, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.38064148264482, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67864.11980740028, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2634.759614226012, 980.8441577013808, 163.3794279983755, -224.83009531025183, 0.5820387538042414, -191.29055143910975, 2.2458252784438724, -0.025809058587511036, -1.094549438243121]
Diversité génétique : 2.664340028361416
Score médian : 124.54997157872832, 16 parents
----
Sauvegarde effectuée
Step : 76, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.98227060978033, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67728.540871288, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2505.5938359115216, 980.8441577013808, 163.3794279983755, 1.1051080513668428, -0.2319700157094221, 0.16764629321606456, -42.2297686493816, 15.042086369183348, 17.619732357818584]
Diversité génétique : 2.824208949609433
Score médian : 124.54997157872832, 14 parents
----
Step : 77, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.4623209221444, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68134.5546836561, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2822.5261071468435, 980.8441577013808, 163.3794279983755, 0.9970619338417752, 11.35829466197868, 0.0949742926503189, -2.1987049195147033, -1.9507789157212763, 5.317875846016182]
Diversité génétique : 2.751415816829046
Score médian : 124.54997157872832, 16 parents
----
Step : 78, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.75653666597898, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67928.27570738205, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 1080.2430482524824, 980.8441577013808, 163.3794279983755, 1.0442460707946348, 2.389622510295839, 3.003697700234305, 1.3743507569793985, -4.464351406319417, 2.8256911617725233, -0.13304269891569673]
Diversité génétique : 2.749530345790758
Score médian : 124.54997157872832, 16 parents
----
Step : 79, 57 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.2277580770011, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67492.39008860225, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 1576.0069812237587, 980.8441577013808, 163.3794279983755, 28.32121400113139, -3.8708865516587414, -1.0863804721974861, 1.432724352282194, -0.6821904199158291, -1.7848230685147877, -0.6421261310417095]
Diversité génétique : 2.7625305627112913
Score médian : 124.54997157872832, 16 parents
----
Step : 80, 56 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.30740648618794, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67870.52306097695, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 2922.9718724088657, 980.8441577013808, 163.3794279983755, -0.8851667286719601, -0.7801815050139685, -168.3425151506866, 12.289324529574209, 0.09236124221231456, -0.1994807756563361]
Diversité génétique : 2.7374428955261454
Score médian : 124.54997157872832, 14 parents
----
Step : 0, 100 individuals, scores :
[75.49438934537424, 65.28253641743342, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.79900099309484, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67931.82481852645, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 63.9042043480916, 262.64364186406374, 4240.284078452505, 980.8441577013808, 163.3794279983755, -1.7542276542348674, 3.7851569297667362, -4.300839639295023, 1.3455150766091433, 1.4772586712237505, -13.455587878723739, 4.954985254972727, 587.9974358942549, -inf, -1.8190921629861274, 4.8820312147260365, -86.13687152601422, 9.088540822146204, 43.4845610112298, 3.0156060876972752, 5.722667554112155, -2.871765378656865, 0.07179194179775954, 0.23444235600324917, -0.8540491341936812, 0.535135545308299, 5.643644997194591, -3.020942898395909, 110.1079203895096, -19.698337278215444, -0.6407710212116507, -9.393929243531947, 16.127961796215995, 4.599634778088999, 4.328230412176219, 4.201759992953282, -1.3130664422446003, 2.466634266132862, -35.51117113640951, 1.274015414382636, 1.1245034509966771, -32.14261983284405, -0.33651860996094823, 4.118253420295126, -inf, -11.656361360768233, -28.787975145552544, 10.358563968963745, 1.3697879539282587, 0.036020416959962186, 3.013703446690989, 3.851031685155618, -1.6585245238128998, 0.1741620326419716, 1.8913988384499985]
Diversité génétique : 0.6161731078001724
Score médian : 127.54127957881377, 12 parents
----
Sauvegarde effectuée
Step : 1, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.42211026929905, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67851.79120997823, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 3476.9953966450134, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, -8.176293124233426, -3.1470561444550262, 7.25762849244208, 58.69817803433443, -5.226953976543225, -14.765777619033265]
Diversité génétique : 0.46230150319031776
Score médian : 127.54127957881377, 12 parents
----
Step : 2, 55 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 168.55497294898424, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67844.25176581446, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2740.537879039323, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 1.1802981282229685, 3.89216050560946, 46.10392183842062, 0.30595998138458624, 1.417643177556214]
Diversité génétique : 0.4534571972526711
Score médian : 127.54127957881377, 10 parents
----
Step : 3, 54 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.275328721659, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67900.63670372168, 572.1614653815634, 87.16179830408609, 241.28693390243805, 66.3281107177521, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2611.9819361183736, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, -4.229966640949486, 185.70570974688454, 1.2397439274534958, 0.9816811283156042]
Diversité génétique : 0.46062611532895364
Score médian : 133.19274531883383, 12 parents
----
Step : 4, 55 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 225.9594033807409, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 63833.183472310586, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2809.74187757458, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, -0.7185300979598972, 0.6032790422820381, 1.5605759609423195, 7.443733750227408, 3.3815103530634216]
Diversité génétique : 0.46257620272225836
Score médian : 133.19274531883383, 12 parents
----
Step : 5, 54 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 184.08141950560022, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67852.21443740954, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2805.869455720353, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 0.7244498903543559, 5.0861299288281, -22.833475972106097, 6.786307447977887]
Diversité génétique : 0.46795392400474684
Score médian : 133.19274531883383, 14 parents
----
Sauvegarde effectuée
Step : 6, 55 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.9017995628078, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67983.42423845934, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2683.3586649043627, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 2.7459587861258963, -3.1554213072457733, 30.493157751728074, 7.729350123855332, -43.16577791540924]
Diversité génétique : 0.4719555783594317
Score médian : 133.19274531883383, 10 parents
----
Step : 7, 54 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.779468498929, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67960.65485184726, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2927.3463122772428, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 5.592688560863362, -729.5598096555451, -9.064251447327068, 4.1836146515450645]
Diversité génétique : 0.4667974645209711
Score médian : 133.19274531883383, 16 parents
----
Step : 8, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.66108833907668, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 66.35307028567881, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67785.49001874166, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2311.038758592746, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 0.486394611429576, -1.2111399880826408, -2.6004051992611164, 4.197068377166313, -0.9344037112378886]
Diversité génétique : 0.4982463455488807
Score médian : 139.7710010803085, 16 parents
----
Impossible d'actualiser la position de Left knee link (D) 0 : contraintes insolubles <class 'Exception'>
Step : 9, 57 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.11553763543435, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 67.2757407506788, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67690.31812527942, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2232.2789339385913, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 2.9181941689929096, -inf, 4.4575415689589235, 0.13409587340919674, 557.6966713976198, 7.11622412258204, 0.5220762247845003]
Diversité génétique : 0.5011606112084598
Score médian : 152.77055161831305, 14 parents
----
Step : 10, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.3948970266616, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67506.57069529095, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2812.4595495653216, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, -160.7497927845604, -0.2468592356327192, -0.03126943459162779, -0.6802701916823273, 0.47117951480019143, 7.41982661298744, -47.013630164701425]
Diversité génétique : 0.4589116264901947
Score médian : 139.7710010803085, 18 parents
----
Sauvegarde effectuée
Step : 11, 58 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.30396147174508, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67784.39516510184, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2609.169816245416, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 3.062881723359489, 40.48455453192062, 7.966824433389361, 6.268870905935543, 8.026598005845605, -1.9218673106628998, 9.108961832534545, 5.529198711560619, 37.85672301618112]
Diversité génétique : 0.5021292795348531
Score médian : 139.7710010803085, 14 parents
----
Step : 12, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.19182811504484, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67540.36896110384, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2506.7628939747883, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 40.48455453192062, 2.3150882658855263, 0.4619728212240987, -1.4107360075164102, 2.2629754704010994, 1.6219063888171403, 6.903903249973658]
Diversité génétique : 0.5071286638650329
Score médian : 139.7710010803085, 10 parents
----
Step : 13, 53 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.0672724247306, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67380.15307285512, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 3073.557835412932, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 40.48455453192062, 1.1018781991340052, -14.946156326247484, -6.067066635047445]
Diversité génétique : 0.47569472374053495
Score médian : 139.7710010803085, 12 parents
----
Step : 14, 55 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.4746955962689, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67738.76579322349, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2379.659575936192, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 40.48455453192062, -25.810556673442846, 0.0024476057398665793, 6.147665659672597, 4.257899864340002, -0.0043746174272602245]
Diversité génétique : 0.5046108753913278
Score médian : 139.7710010803085, 18 parents
----
Step : 15, 57 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.54730170429266, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67881.85087917214, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 3445.089184281268, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 40.48455453192062, 1.694437899817421, -1.7875537982423249, 0.2728399021545512, -1.9016991165296346, 26.268173871756666, 25.369776069216837, 0.45827723176384283]
Diversité génétique : 0.49499464750810457
Score médian : 139.7710010803085, 14 parents
----
Sauvegarde effectuée
Step : 16, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.30655966874818, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67677.82059003394, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2630.892385474706, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 40.48455453192062, -4.306428976140979, 1.617229861867571, 3.8615293665702652, 2.4248843287181048, 2.8437506933769843, 1.498748840854783]
Diversité génétique : 0.4683118230177206
Score médian : 139.7710010803085, 16 parents
----
Step : 17, 57 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 185.73894138033236, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67903.81727429638, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2737.518754860735, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 40.48455453192062, -12.062798142637527, -0.6949688161854991, -16.763699944858985, -1.919671241000477, -20.71564247095081, -5.5731877456184495, -10.48545147040478]
Diversité génétique : 0.4998819623620178
Score médian : 139.7710010803085, 10 parents
----
Step : 18, 53 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.54846989404388, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67671.16165483065, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 1847.4552816934931, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 40.48455453192062, 1.0296316090655364, 2.713635367605654, 1.8348339181657938]
Diversité génétique : 0.516013222547795
Score médian : 139.7710010803085, 10 parents
----
Step : 19, 55 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.91057267747365, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67325.21385028744, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2765.0755831031033, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 40.48455453192062, 0.8813622775330465, -0.47808773272099586, 2.1080984756138217, 0.6386473610659162, 3.5446730886425235]
Diversité génétique : 0.4985844847501808
Score médian : 139.7710010803085, 14 parents
----
Step : 20, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 187.9079972029034, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68018.14846689881, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 3387.6848935923226, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 40.48455453192062, -17.425446734979083, 6.255888312712606, -0.5716928220713668, -9.024557094005791, -122.51077473995139, 699.2724212160036]
Diversité génétique : 0.5140416948271662
Score médian : 152.77055161831305, 14 parents
----
Sauvegarde effectuée
Step : 21, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.8917823199378, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67945.3892337596, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2511.3960499788695, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, -794.6624497222759, 1.8742144964603853, -26.415945165949886, -0.9796674234576256, 0.42326088960465147, 0.07605223391483365, 0.9437820110642379]
Diversité génétique : 0.5093945410474436
Score médian : 139.7710010803085, 14 parents
----
Step : 22, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 183.75869832005964, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 66832.05170415377, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 4164.908105135184, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 1.468664224841559, -0.3954051987408815, -92.90825894693471, -0.9029605754644375, 67.65704976727473, 0.6415077695640568, 8.643758755393076]
Diversité génétique : 0.5096937461768638
Score médian : 139.7710010803085, 8 parents
----
Step : 23, 53 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.68885710871197, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67829.14968669644, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2678.6838977360294, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 152.95774391792014, -0.20157957312063093, 3.7148064684813344, -12.274213907813527]
Diversité génétique : 0.5072887031522954
Score médian : 147.55970957808537, 16 parents
----
Step : 24, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.20889134239388, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68037.89116478556, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 1852.6231201644296, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, -50.28562795360982, -8.016346991157848, -2.2346133264102694, -0.4951289555291204, -0.626384754791538, 4.840756897292114, 1.990862804734843]
Diversité génétique : 0.5476402668522172
Score médian : 139.7710010803085, 16 parents
----
Step : 25, 58 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.421067967714, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67874.55534296883, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2456.9613022956614, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 3.656435475592086, 1.3890885619745912, -0.13251819577976778, -12.140727263007358, -0.5111956531791516, 0.22158367398848072, 2.2426841641348476, -3.4991097682198977, 1.9349933069067549]
Diversité génétique : 0.5020588547630515
Score médian : 139.7710010803085, 16 parents
----
Sauvegarde effectuée
Step : 26, 57 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.4566953287731, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67782.8935931349, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2616.858338910738, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 5.843519913477771, 7.000289739047286, 0.32811111803769366, -0.38047332029967534, 4.481938785183477, 17.93508668446982, 0.3651087838522109, 4.878661386203455]
Diversité génétique : 0.5018329527041641
Score médian : 139.7710010803085, 14 parents
----
Step : 27, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.61741064139218, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67931.0366159569, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 289.297674644637, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 17.93508668446982, -2.810547632086902, 0.9698085943860376, -11.259819894326505, 5.245981153153348, -3.6959072010737484, 154.19610766882747]
Diversité génétique : 0.5013691711995778
Score médian : 148.17889145353905, 16 parents
----
Step : 28, 57 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.20897514382818, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67868.47036687321, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2845.449298597306, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, -1.3464774379260063, 5.033744059162207, -76.7437888555193, -10.378834566209376, 4.718552526593997, 0.8565366653030715, 0.16977766221467702]
Diversité génétique : 0.49867216367072087
Score médian : 148.17889145353905, 12 parents
----
Step : 29, 54 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.1624579583972, 88.43363638020031, 123.0225477151303, 488.7042019824926, 72.32270660478268, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67892.73025603434, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2548.162150971162, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 8.25200520478019, 66.19691507065092, 3089.595818411281, 2.0110721203027864]
Diversité génétique : 0.47302784141891674
Score médian : 158.7877678336015, 14 parents
----
Step : 30, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.34275252729276, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67882.598810484, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2704.6483601353225, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 0.7371733269081316, 4.369957670410754, -11.353464051713301, -2.7546097594613355, -5164.692982325725, 0.0613309012265995]
Diversité génétique : 0.49772473808979223
Score médian : 158.7877678336015, 10 parents
----
Sauvegarde effectuée
Step : 31, 54 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.78229578049465, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67767.45137889724, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2387.864576726208, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 0.7826514924612078, 0.8921324215758943, 5.301009306286193, -0.5275482999120535]
Diversité génétique : 0.47422991896331573
Score médian : 158.7877678336015, 18 parents
----
Step : 32, 57 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.01270733164378, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67909.40497604555, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 72.38132147031637, 164.7399820215974, 262.64364186406374, 2597.502013951269, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, -0.24036526110199047, 13.655959930538382, -9.350947147079516, 136.48081917335932, -15.360305885961875, 21.265566136772144, -0.964047777733859]
Diversité génétique : 0.507558854717005
Score médian : 158.7877678336015, 14 parents
----
Step : 33, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.27303085001293, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68940.10620463132, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2722.899652416273, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 4.884893382365954, 1.8577999862467542, 4.124084696765361, -82.82503690306594, -4.758457842681352, -5.443038281356358]
Diversité génétique : 0.47145329798589913
Score médian : 158.7877678336015, 12 parents
----
Step : 34, 54 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.62738376223066, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67860.34866961678, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 3144.4963288588533, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 2.110105539190082, -1.492880633173016, 7.989390158101241, -1.2993830653009824]
Diversité génétique : 0.45786170617896715
Score médian : 158.7877678336015, 14 parents
----
Step : 35, 56 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 73.5267617478056, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.7222817952898, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67863.41082391667, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2609.4401687284385, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 1.9276257889976713, 7.019385601194316, -0.6016062618693357, -11.925670769690148, -0.57255789298677]
Diversité génétique : 0.47997913481848337
Score médian : 164.05970500998643, 12 parents
----
Sauvegarde effectuée
Step : 36, 55 individuals, scores :
[75.49438934537424, 177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.66675575147218, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67773.32839832359, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 3437.05920416152, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, -2.143124830718768, 156.91126923097227, -0.0932873060408909, -36.39397432741082, 3.0639478259612556]
Diversité génétique : 0.4539922525731323
Score médian : 164.05970500998643, 16 parents
----
Step : 37, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 176.2750089327325, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67566.57617678301, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2429.7531046360223, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 1.1948486815721167, -4.004768352678434, 4.875379302506193, -0.8944798637959308, 4.66238294951903, 0.5867274528025457]
Diversité génétique : 0.4533245141575596
Score médian : 164.05970500998643, 12 parents
----
Step : 38, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 175.08927202129675, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67588.04430760052, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2713.779323709592, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 1.5137178751873723, -2.684416079752664, 3.0937243043485347, 6.065762415126281, -217.52404349850883]
Diversité génétique : 0.4653541720536285
Score médian : 164.05970500998643, 10 parents
----
Step : 39, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.8434341949194, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67876.31736477754, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2714.432153986597, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 23.663206663401777, 2.5142999561720556, 39.84523262189426, -1.5178199674624395]
Diversité génétique : 0.4634583474592093
Score médian : 164.05970500998643, 14 parents
----
Impossible d'actualiser la position de Left foot (H) 0 : contraintes insolubles <class 'Exception'>
Step : 40, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.9289397515571, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67975.36083615055, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2747.849231761223, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 0.8828002458882829, -0.044909913190629445, 2.3644704470302393, -2.7821708931033697, -inf]
Diversité génétique : 0.45724886578096946
Score médian : 164.05970500998643, 14 parents
----
Sauvegarde effectuée
Step : 41, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.23660810771858, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67668.33679634692, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2615.6789633678245, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 9.897993532604357, 1.36510473730001, -1.1857261046750096, 0.0981843299892867, 3.6861754356530088, 0.08067451547860748]
Diversité génétique : 0.45695417102192687
Score médian : 164.05970500998643, 16 parents
----
Step : 42, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.70082746661734, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67908.91583242359, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2734.3189373854425, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, -24.453014005179377, 1.539118369111562, -0.3358263517025555, -1.8032268489599113, -0.4819966103963161, 1.473980372117814]
Diversité génétique : 0.45002560914896744
Score médian : 164.05970500998643, 14 parents
----
Step : 43, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.46461940912297, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67811.94131816471, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2693.0468039179377, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, -0.09745687080402413, 20.746090887340134, 4.839488775347488, 46.02424361612454, -0.3942005561630622]
Diversité génétique : 0.4589358300411011
Score médian : 164.05970500998643, 12 parents
----
Step : 44, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.6432031730329, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67891.73326554605, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2616.186952447539, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 1.552968889871859, 1.0857469947866127, -0.9911792836682803, 3.317516530199536, -0.00069562676446848]
Diversité génétique : 0.4894050712395969
Score médian : 164.05970500998643, 14 parents
----
Step : 45, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 184.14341784602215, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68276.04055109943, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 2713.661194965828, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, -1.6532530745648777, -18.455067668521952, 1.1061926355090541, -0.30649252171576263, 0.8540534885438832, 1.7375093570092677, 11.180357817992654]
Diversité génétique : 0.48895781856928994
Score médian : 164.05970500998643, 14 parents
----
Sauvegarde effectuée
Step : 46, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.38980756629815, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67947.47572674953, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 4225.263860872533, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 0.9229922939930242, -0.3814088772862341, 2.102898627411731, -0.9137355842389132]
Diversité génétique : 0.4521359753608905
Score médian : 164.05970500998643, 12 parents
----
Step : 47, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.11909255609828, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67820.392906068, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, -2161.907746760473, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 10.298569300677338, 0.35080241770478915, 9.664782675649786, 1.73553557618396, 8.968760130608716, -0.8434313617481218]
Diversité génétique : 0.49043865292407934
Score médian : 160.14534861467388, 12 parents
----
Step : 48, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.88304149278179, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68014.55411719976, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 10.298569300677338, 39.951864819486175, 13.656335441870748, -1.0011573285904747, 5.062322744120892, -5.657465497123093]
Diversité génétique : 0.4298033731927249
Score médian : 160.14534861467388, 12 parents
----
Step : 49, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.40057416633041, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67748.75912220357, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 39.951864819486175, 1.0130586446565073, -0.2487267430854106, 2.5317033806377514, 0.4674146567073224, -7.584705462472464, -0.9516581539753132]
Diversité génétique : 0.46118542178897837
Score médian : 160.14534861467388, 20 parents
----
Step : 50, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.25871645810844, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67550.60711900606, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 39.951864819486175, -1.7828519887364709, -7.771371865508066, 4.825518689121684, 0.5226660731632007, 0.4613965900899564, -1.0393328332026186, 2.52308648800414, 1.1784937779081859]
Diversité génétique : 0.45377868592979564
Score médian : 160.14534861467388, 12 parents
----
Sauvegarde effectuée
Step : 51, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.3730205534371, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67832.1892132652, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 39.951864819486175, -0.3429161464444149, -0.18707136666594482, 0.45838090108975676, 0.8262279476412094, 0.3241394949363489]
Diversité génétique : 0.4553260688766781
Score médian : 160.14534861467388, 10 parents
----
Step : 52, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.78434868497143, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67838.39085553116, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 39.951864819486175, 0.9755670539572155, 3.1658343450779887, 13.627941072286932, -0.9488458447589744, 0.3091621448482204]
Diversité génétique : 0.4321897567225808
Score médian : 160.14534861467388, 12 parents
----
Step : 53, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.50822071973423, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67499.96897892728, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 39.951864819486175, 4.913983252288479, 0.5914925571726981, 44.90174415631353, -11.271949503453007, -2.6647026880122584]
Diversité génétique : 0.45669927357388124
Score médian : 160.14534861467388, 16 parents
----
Step : 54, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.2572876269227, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67922.18807294729, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 44.90174415631353, -1985.4471366588514, -86.69663440232537, 11.063360544666526, 24.417311294760108, 1.0805768346575282, -1.0963570679130101, 2.5656175192840363]
Diversité génétique : 0.45071658972811807
Score médian : 160.14534861467388, 14 parents
----
Step : 55, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 177.03271663099383, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67848.82552201489, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 44.90174415631353, 3.770313003545124, -1.424847155795397, -11.798671475515784, 0.7631723282094621, -0.20466382148707238, -1.4199123375631857]
Diversité génétique : 0.4486011190075342
Score médian : 160.14534861467388, 12 parents
----
Sauvegarde effectuée
Step : 56, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.68084813528597, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67950.4998143177, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 44.90174415631353, 1.576955766199922, 4.764662935248837, 3.010010422216872, -329.93207992181135]
Diversité génétique : 0.43520428126918
Score médian : 160.14534861467388, 16 parents
----
Step : 57, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.78403017458788, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67781.47007408697, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 44.90174415631353, -1.0559556595407094, -0.6052334030017799, 0.3959880316401502, -33.17254368657346, 860.5324437076264, 1.3028776565288651, -0.04343148428775189]
Diversité génétique : 0.4582138525267413
Score médian : 164.05970500998643, 12 parents
----
Step : 58, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.78695897613093, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67792.61875931613, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, -446.8110458962407, 70.3510633630191, 3.916596634128602, 1.754831301489197, 11.155668536339975]
Diversité génétique : 0.42856838527487345
Score médian : 160.14534861467388, 10 parents
----
Step : 59, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.3936468712355, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68067.46989302315, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 7.835379634090083, 1.4716868980745763, -1.047789456510523, -93.96868832519306, 0.5310531706805182]
Diversité génétique : 0.42396358093095254
Score médian : 160.14534861467388, 12 parents
----
Step : 60, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.4073851331685, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67658.21128852885, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 118.34610245899155, -3.6756756340356613, 0.11065845487011805, 2.0186841635964705, 6.867685305556706, -0.3549582163714767]
Diversité génétique : 0.45177993122613314
Score médian : 160.14534861467388, 16 parents
----
Sauvegarde effectuée
Step : 61, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.79295535537176, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67903.56530833314, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, -11.193682465475804, 0.5023628768288803, 6.918795853688238, 0.30497608385002006, 13.996692812678754, 13.826482935815209, 4.234059401129056, 0.7655669327337153]
Diversité génétique : 0.44421509120533964
Score médian : 160.14534861467388, 16 parents
----
Step : 62, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.60613829432893, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67754.03987789364, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 13.996692812678754, 3.811171291327842, -0.6586950166989032, 27.524727416832704, 1.0340702447170793, 5.68761878346549, 333.68788536433016, 1.1648883606382112]
Diversité génétique : 0.42173907382200865
Score médian : 164.05970500998643, 12 parents
----
Step : 63, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.7052586538735, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67730.75783959003, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 0.4843111533778424, -2.040342858970548, 6.834170934257358, 0.12032647848842147, -0.8353623620398603]
Diversité génétique : 0.47257472919825194
Score médian : 164.05970500998643, 16 parents
----
Impossible d'actualiser la position de Left foot (H) : contraintes insolubles <class 'Exception'>
Step : 64, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.19216575579975, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68075.51919359478, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 2.1175723134401863, -inf, 3.0828909916162743, -26.75421573073713, -0.03544155921770588, 0.2607707663645275, -1.7040095483972435]
Diversité génétique : 0.42390191472826333
Score médian : 164.05970500998643, 10 parents
----
Step : 65, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 35.16085461464891, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67848.59721049512, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, -3.8069753487128115, 1.4073922488879231, 4.433934495265363, -1.7178629555263114, -1.6141391602798953]
Diversité génétique : 0.4367957801012021
Score médian : 160.14534861467388, 18 parents
----
Sauvegarde effectuée
Step : 66, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.20900735819347, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67807.20084271693, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 13.825244664189729, 1.63680117194727, -3.926098847589646, -7.326784638050839, -64.19240115557064, 16.258001334501177, -0.48499066043703004, 6.719615184976334]
Diversité génétique : 0.46211268714227405
Score médian : 164.05970500998643, 16 parents
----
Step : 67, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.88420699402215, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67915.30629634195, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, -29.367892703166024, 0.7273808706828884, 0.9926273019751914, 0.4609133423194813, 0.7246428969272636, -2.831353666595775, -0.0216291896719996]
Diversité génétique : 0.4362348847154413
Score médian : 164.05970500998643, 14 parents
----
Step : 68, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.71317913657333, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67885.49811062565, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, -9.70063997722279, 7.35923896265177, 1.1203091332612003, -0.9963581264288444, 25.973167315710135]
Diversité génétique : 0.42388892367909325
Score médian : 164.05970500998643, 16 parents
----
Step : 69, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 168.69470764737045, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67896.11130167544, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, -1.6277288344643166, 1.0780486263230382, 5.459558129631359, -4.606908134625325, -82.87137748955247, -4.282906142597295, 0.38904909827993733]
Diversité génétique : 0.4665734190537509
Score médian : 164.05970500998643, 18 parents
----
Step : 70, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.51170037490974, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67740.98824277577, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 2.4066604512139853, 4.72203579094083, 58.434382720906136, -4.399250575755378, 4.483682981098715, -6.038471802983992, 10.216519878249448, -0.18581216059886818]
Diversité génétique : 0.4523546422075251
Score médian : 164.05970500998643, 14 parents
----
Sauvegarde effectuée
Step : 71, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.69778557948618, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67749.14888857896, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, -2.7712387282190822, -28.436775643354853, 7.824544747850868, -1.0051757767741265, 6.338397201382569, -2.142804269880433]
Diversité génétique : 0.41937937908678213
Score médian : 164.05970500998643, 10 parents
----
Step : 72, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 170.8501124262676, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 76.45792268320051, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67759.0115362948, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 6.799805936870968, -1.1970950101602842, 213.99341569496315, -0.8418330477017779]
Diversité génétique : 0.4283479848672692
Score médian : 164.74304277433475, 14 parents
----
Step : 73, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.183293744974, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67776.34538722513, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, -0.8874083660012602, -0.006447663547743338, 1.6488246837513822, 15.884104985055481, 6.661103055688256, -1.228166519872657]
Diversité génétique : 0.43571498664649083
Score médian : 164.74304277433475, 18 parents
----
Step : 74, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.29740938979907, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67845.87191155962, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 42.032392655891904, 1.6103412253545546, 6.169246695453267, 0.07745102383254088, 0.8902741365241088, 2.3606235801180833, -0.24591437637300376, 0.2065869370574499]
Diversité génétique : 0.4374292619679645
Score médian : 164.74304277433475, 10 parents
----
Step : 75, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.1186043972521, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 69556.61363939225, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, -0.6019129397824984, 3.3642706136773457, 1.3667494306113404, 0.6239149890961907]
Diversité génétique : 0.4366772414526216
Score médian : 164.74304277433475, 16 parents
----
Sauvegarde effectuée
Step : 76, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.285954745149, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67843.60172043182, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, -7.3991751218318225, 11.1747640502252, 38.51714424590168, 1.901512444196247, -1.2745333691604601, 1.5179499545140396, -5.819296431431825]
Diversité génétique : 0.4716875052586314
Score médian : 164.74304277433475, 10 parents
----
Step : 77, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 178.58402394543683, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67853.5703160362, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 0.7410867762055727, 0.35384656677645004, 1.538104343556008, 0.12272487839290244]
Diversité génétique : 0.4337412768689517
Score médian : 164.74304277433475, 14 parents
----
Step : 78, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.0790711826025, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67908.42286999081, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 3.054664813830648, 0.43208203824193697, 0.261550277557573, -0.6204123609478296, 33.24689056557931]
Diversité génétique : 0.43253133793790666
Score médian : 164.74304277433475, 16 parents
----
Step : 79, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 182.65885090559487, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67831.44518809425, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 2.2495229767129827, 6.053044092857721, -0.18972491035670516, 8.772960197865588, 1.0050383030662053, -0.46251767159311086, 3.5674723693094115]
Diversité génétique : 0.43092022710031297
Score médian : 164.74304277433475, 12 parents
----
Step : 80, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.5352414339038, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67574.76043492333, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, -0.2969256230520619, 7.740010234363382, 1.6921366757216054, -0.04738177011237854]
Diversité génétique : 0.4336048173292696
Score médian : 164.74304277433475, 14 parents
----
Step : 0, 100 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 176.43934160381218, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67891.17149817596, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 6.912771392765232, -inf, -0.11531817613195552, -0.2065284277944193, 1.2886967482732121, 7.6922472910201645, 33.44090789992423, -inf, 25.316701053829686, -0.8503002578643754, -inf, -0.008094881879766199, -0.6330182717222694, 2.5512011763860785, 3.6096797280553385, 54.16740272095066, 1.798028086848486, -12.957778756488562, -4.223571074002472, 0.3088878556736942, 3.51975418413164, -1.4556811020835048, 7.23149335813347, 3.527000890125933, -1.6036496109550564, 0.7624593010535711, -3.956499172585451, 6.558175582031988, 6.563780644352247, -4.11139797830815, 20.286752303109168, 8.700627024162506, 4.972987298913993, -0.6966570866159322, 0.18291659393848478, -2.1811399841881776, 0.1336257773644949, 0.27797327488396784, 1.4413678566469281, 1.785117860262693, 28.909326347662656, 0.3432288662760791, -178.00317963040888, -inf, -2.583728483762752, 3.7872397535478215, -0.5389647576099215, -1.8047851762303697, -0.22870998947650306, -1.2667629593180565]
Diversité génétique : 0.11254591032535056
Score médian : 164.74304277433475, 12 parents
----
Sauvegarde effectuée
Step : 1, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.2622897175135, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67877.07863428151, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, -1.1253448749368686, 0.31535150343084334, -0.2975588870425166, -1.736218571574037, -0.46868870727871864]
Diversité génétique : 0.09084300379882253
Score médian : 164.74304277433475, 14 parents
----
Step : 2, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.37759377299088, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67718.24969156134, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 6.931027192539699, -2.8028442469857584, -2.592715692425168, 1.6720969101242023, 4.412436408417106, 3.5593272635860562, -1.802254082544107]
Diversité génétique : 0.08886515219572268
Score médian : 164.74304277433475, 14 parents
----
Step : 3, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 180.7701527354566, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67825.18597760987, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 1.5012405849043111, 2.0238434753386967, -5.350973923336989, 0.46411692567695984, -855.5619272651638, 1.1343056542032526, 2.401327914719499]
Diversité génétique : 0.09334651976803517
Score médian : 164.74304277433475, 12 parents
----
Step : 4, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 188.72933257625783, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67719.18529942409, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 3.447738585756041, 39.55931758537483, 0.14086193841654004, 1.1947214877189158, 1.0122383668344102, 0.569318607515046]
Diversité génétique : 0.09298705765222992
Score médian : 164.74304277433475, 14 parents
----
Step : 5, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 176.51855649294944, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67872.34194355595, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 0.4919231591162183, -0.873131472817302, 0.3501444998452291, 5.111055668434328, 3.088094994428472, 5.813755053719395, 5.218649106037294]
Diversité génétique : 0.08964428226955087
Score médian : 164.74304277433475, 10 parents
----
Sauvegarde effectuée
Step : 6, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 185.35698757919204, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67900.69435209213, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, -1.1458440121133395, 1.106304149773941, 0.1926149573852717, 3.8860943831026606]
Diversité génétique : 0.09010832046650939
Score médian : 164.74304277433475, 12 parents
----
Step : 7, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 197.9808883206611, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 67885.35971461928, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, -1.0798883780470692, 1.3790178401926605, -0.6222612621558419, -0.06699279943888689, -0.8451803679799373, 0.310030124773575]
Diversité génétique : 0.09022165446781735
Score médian : 164.74304277433475, 14 parents
----
Step : 8, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 183.03547302370535, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 68155.79567800734, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 0.07283211929193405, 0.024045183698812533, -1.2841028248925472, -5.529252935724574, -16.55366360483615, -3.2841349222997573, -0.11713964200145797]
Diversité génétique : 0.09610783410357478
Score médian : 164.74304277433475, 18 parents
----
Step : 9, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 220.46741244017176, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, -352726.0596884717, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 1.221355995432965, -0.24429740314964404, 0.13384684916551018, 4.445883957041701, 4.488376515266268, 0.14664918374808125, -4.842934526417806]
Diversité génétique : 0.08929935244610636
Score médian : 164.05970500998643, 10 parents
----
Step : 10, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.64955050734736, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 1.056739164856892, -2.3417216342278038, 22.444071580568153, -0.67703357444298]
Diversité génétique : 0.09092488483387086
Score médian : 164.05970500998643, 16 parents
----
Sauvegarde effectuée
Step : 11, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.8066488830514, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, -111.28674172117472, 1.3973286108653746, -1.4856249933963188, 1.7734613221825335, -5.465950320932761, -0.6296464355622553, -2.9455259180449795, 65.88126942173245]
Diversité génétique : 0.09020275352536243
Score médian : 164.05970500998643, 14 parents
----
Step : 12, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 183.48402463225173, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 10.161475470450345, 2.3123448849453703, 1.1241977670760532, -0.8639827572609345, 11.569126137735454, -0.06538913231816314, -2.108728237703308]
Diversité génétique : 0.0892713411137581
Score médian : 164.05970500998643, 12 parents
----
Step : 13, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.78666033489583, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 5.253570117804964, 0.27267084284248094, -0.9889581286108348, -0.6770779544650634, -0.1951339684739928]
Diversité génétique : 0.09030356044414084
Score médian : 164.05970500998643, 12 parents
----
Step : 14, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 117.97161763972206, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 6.513076131885693, -1.0980859628833843, -0.8046131487452444, 1.496964657494485, 3.585794532843933, -14.269691471357389]
Diversité génétique : 0.09097267019629475
Score médian : 160.14534861467388, 20 parents
----
Step : 15, 60 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.9461340011545, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 0.46408446853734764, 4.446285791989864, 9.253566751627906, 1.866814194259402, 55.6379179362979, -0.3487810859375017, -43.150188818239414, 1.8643084163036237, 0.24205235205752584, 22.602666337277952]
Diversité génétique : 0.08997952517369512
Score médian : 164.05970500998643, 12 parents
----
Sauvegarde effectuée
Step : 16, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 181.70929898629362, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 6.608408113614962, 0.08487738398513982, 1.8088440668747467, -2.0925292974940333, 0.30215272470372656]
Diversité génétique : 0.09212288336919365
Score médian : 164.05970500998643, 14 parents
----
Step : 17, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 179.07412865867363, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, -32.56404946682529, 0.21098608371310676, -67.57137818187856, -10.700340350805853, -0.23032261152556047, -7.483803985145553]
Diversité génétique : 0.0880328519845587
Score médian : 164.05970500998643, 22 parents
----
Step : 18, 60 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 79.35278950113963, 81.97677986181709, 137.38032692236644, 177.71155124965756, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 1.3279392937278445, -7.049571185694613, 0.7681400050129055, 159.47574659603555, 9.911179519814079, -20.486137840545236, 1.5228821129286696, 419.68932959983835, 2.3702298594275546, 0.9182341077904376]
Diversité génétique : 0.08928021805328583
Score médian : 164.74304277433475, 10 parents
----
Step : 19, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 180.12091259696714, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, -8.164492128423051, 1.809886382930694, 0.734252667987986, -1.0228514581014772, 5.554791388382099]
Diversité génétique : 0.09122699771682925
Score médian : 164.74304277433475, 16 parents
----
Step : 20, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 180.32841102201164, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 0.36542515584547436, 0.3072490447417583, 0.03814496487081886, -196.2564343804222, 0.12499595921923644, 7.287718132332595, 1.00259821512399, 0.09587209464901804]
Diversité génétique : 0.09110482423832722
Score médian : 164.74304277433475, 12 parents
----
Sauvegarde effectuée
Step : 21, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 179.13692485575436, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 5.706523819610362, -6.28379396345528, 4.133325148477215, 3.1300730909713357, -0.4373392580105676]
Diversité génétique : 0.08956869193288915
Score médian : 164.74304277433475, 14 parents
----
Impossible d'actualiser la position de Left foot (H) 0 : contraintes insolubles <class 'Exception'>
Step : 22, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 190.34924381012863, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, -inf, 6.457386807714642, -4.428609721233594, 1.0045267140258742, -7.824688061402591, 2.9243325043369683, 2.4448459702190553]
Diversité génétique : 0.09484310653756628
Score médian : 164.74304277433475, 14 parents
----
Step : 23, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 181.6571788193347, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 0.6988342198242681, 6.314660089176378, -0.7497917734316867, -2.5640781671861284, 5.625604823977047, 2.5793281176687586]
Diversité génétique : 0.08934431607942915
Score médian : 164.74304277433475, 14 parents
----
Step : 24, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 167.52448891153978, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, -0.2993918034896779, 0.7375576583278499, 14.09357516750808, 1.7670484387279246, 13.432709470465928, 1.084320916446637, -17.900255904075102]
Diversité génétique : 0.08936875294609725
Score médian : 164.74304277433475, 14 parents
----
Step : 25, 57 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 180.5870906373652, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, -0.006977450631186952, 1.5220121999178118, 1.7618669691495605, 1.424710575802672, -0.821126304332644, -0.8721392001174485, 2.1748681060317367]
Diversité génétique : 0.08926168187214878
Score médian : 164.74304277433475, 16 parents
----
Sauvegarde effectuée
Step : 26, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 173.62519331184106, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, -0.27742217844598066, 18.632155730173544, 0.8272436169545757, 15.169730196664426, -0.5747115823282589, 0.4305119737099048, -1.3220749703221606, 5.986162726377217]
Diversité génétique : 0.09270218560192885
Score médian : 164.74304277433475, 12 parents
----
Step : 27, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 180.4483220076507, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, -1.4714612663980846, -103.1189563764574, 4.320229888734345, 1.5785584951152656, -5.630006323718984, 1.679174781073449]
Diversité génétique : 0.08938565978132228
Score médian : 164.74304277433475, 12 parents
----
Step : 28, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, -192.04660234839793, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 2.4453868844212776, -161.85524159139246, -4.0761306274988405, -2.800355760404931, 0.18380122846026214, 6.664988535005692]
Diversité génétique : 0.08894377509914812
Score médian : 164.05970500998643, 12 parents
----
Step : 29, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 6.664988535005692, -7.885701657549997, 3.7903093259951572, 1.1866659424736876, -0.19489785113397967, 2.399928634163265]
Diversité génétique : 0.0929221274186424
Score médian : 164.05970500998643, 14 parents
----
Step : 30, 56 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 6.664988535005692, -0.1634586571710633, 0.7473913921369009, 0.8025982468822837, 0.3484629645223153, -10.229366845830166, -0.7914132103212411]
Diversité génétique : 0.08935023891171258
Score médian : 164.05970500998643, 12 parents
----
Sauvegarde effectuée
Step : 31, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 6.664988535005692, 1.3759772288679855, 27.562972219888, 0.4338335170455137, -1.2474895659757794, -2.6441619016791296]
Diversité génétique : 0.09272618127123793
Score médian : 164.05970500998643, 10 parents
----
Step : 32, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 27.562972219888, 0.350607442988163, 2.4956354089337505, -0.34307339435685047, 3.679428060547337]
Diversité génétique : 0.08904636443072865
Score médian : 164.05970500998643, 18 parents
----
Step : 33, 59 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 27.562972219888, 5.785311501658671, 0.8352306116496536, 0.13705986374974768, -0.08870138697765634, 39.923138690803164, -5.384334411189645, 2.3088999557029144, -1.6791854305256189, -0.9825926027910454]
Diversité génétique : 0.08839313740493267
Score médian : 164.05970500998643, 18 parents
----
Step : 34, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 39.923138690803164, 0.6956809797117134, -102.3440486027802, -0.23027433427241056, -0.6716962623321137, 1.1308856533020466, -0.5368639087739757, 5.992903218820434, -4.649606698166917]
Diversité génétique : 0.08885575318306138
Score médian : 164.05970500998643, 18 parents
----
Step : 35, 59 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 39.923138690803164, -5.3523632445745495, 5.2889365196398, 1.8213928133800534, 1.1309995010106142, -1.0982401519684006, 0.30349076403861985, 0.009077159820580397, -0.9071166439407917, 3.0340287030645983]
Diversité génétique : 0.09037121611069235
Score médian : 164.05970500998643, 18 parents
----
Sauvegarde effectuée
Step : 36, 59 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 39.923138690803164, 8.949738402652684, 0.43439583382701014, 7.924323713498886, -558.2570118187386, 4.720307779943037, -0.826575493103255, -423.5366167699207, 1.4603859864070852, -0.8302628815050621]
Diversité génétique : 0.09577219414538886
Score médian : 164.05970500998643, 10 parents
----
Step : 37, 54 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 39.923138690803164, 0.5755040326745812, 5.566864884436712, 3.7759030370403543, -0.19697411153436048]
Diversité génétique : 0.0905832590708832
Score médian : 164.05970500998643, 16 parents
----
Step : 38, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 39.923138690803164, 13.524649376573937, -6.454209677921885, -162.69594423719772, -0.8882461319228986, -12.893190851101707, 22.30526898775841, -0.10389241554776717, 2.010025845750316]
Diversité génétique : 0.09535580382464653
Score médian : 164.05970500998643, 12 parents
----
Step : 39, 55 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 39.923138690803164, -0.1752539333429309, -0.03822337290017626, -5976.300230529019, 9.357460088180442, -52.54906166578522]
Diversité génétique : 0.09219131894802403
Score médian : 164.05970500998643, 16 parents
----
Step : 40, 58 individuals, scores :
[177.7432235157822, 731.521015764888, 248.66475694327502, 114.3882870863164, 111.95919541191999, 137.38032692236644, 88.43363638020031, 123.0225477151303, 488.7042019824926, 197.3582996884317, 98.00885752543712, 92.2034373887393, 99.92315719919144, 307.21165876088264, 311.46981946745683, 117.27052648287096, 220.04175024416278, 261.10899955347446, 126.07739544232633, 300.7723329745354, 86.7724812100257, 129.0051637153012, 164.7461035270721, 572.1614653815634, 87.16179830408609, 241.28693390243805, 142.1616752382506, 94.2710061515451, 113.98956105567936, 375.1852957242596, 105.45648503979737, 164.7399820215974, 262.64364186406374, 980.8441577013808, 163.3794279983755, 587.9974358942549, 110.1079203895096, 185.70570974688454, 303.61958827759565, 154.19610766882747, 3089.595818411281, 136.48081917335932, 488508.78377548145, 156.91126923097227, 333.68788536433016, 213.99341569496315, 95.74755042441832, 159.47574659603555, 419.68932959983835, 39.923138690803164, 7.623700689850741, -0.6819087923754528, 0.47404976298046336, -54.29096248933967, 1.1296816316233314, 1.1536091154733648, -138.6736810822532, 3.733040557422579]
Diversité génétique : 0.09203324179461649
Score médian : 164.05970500998643, 14 parents
----
"""
pop = list(map(lambda x: int(x),
               re.findall(r'(\d{1,3}) individuals,', d)))
stan = list(map(lambda x: float(x),
                re.findall(r'Genetic diversity: (\d.\d*)', d)))
med = list(map(lambda x: float(x),
               re.findall(r'Median score: (\d.\d*)', d)))

i = min(len(med), len(stan))
fig = plt.figure()
plt.grid()

med_ax = fig.add_subplot(111)
med_ax.plot(range(i), med[:i], c='g')
med_ax.set_ylabel('Median yield (%)', color='g')
med_ax.tick_params(axis='y', colors='g')

stan_ax = med_ax.twinx()
stan_ax.plot(range(i), [j for j in stan[:i]], c='b')
stan_ax.set_ylabel('Genetic standard deviation', color='b')
stan_ax.tick_params(colors='b', pad=10, labelcolor='b')

pop_ax = med_ax.twinx()
pop_ax.plot(range(i), pop[:i], c='r')
pop_ax.set_ylabel("Population", color='r')
pop_ax.tick_params(direction="in", colors='r', pad=-25, labelcolor='r')

med_ax.set_xlabel('Step')
fig.suptitle("Evolution of a population")
plt.show()
