import { Resource, IResource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IAction } from './action';
import { IotSql } from './iot-sql';
/**
 * (experimental) Represents an AWS IoT Rule.
 *
 * @experimental
 */
export interface ITopicRule extends IResource {
    /**
     * (experimental) The value of the topic rule Amazon Resource Name (ARN), such as arn:aws:iot:us-east-2:123456789012:rule/rule_name.
     *
     * @experimental
     * @attribute true
     */
    readonly topicRuleArn: string;
    /**
     * (experimental) The name topic rule.
     *
     * @experimental
     * @attribute true
     */
    readonly topicRuleName: string;
}
/**
 * (experimental) Properties for defining an AWS IoT Rule.
 *
 * @experimental
 */
export interface TopicRuleProps {
    /**
     * (experimental) The name of the topic rule.
     *
     * @default None
     * @experimental
     */
    readonly topicRuleName?: string;
    /**
     * (experimental) The actions associated with the topic rule.
     *
     * @default No actions will be perform
     * @experimental
     */
    readonly actions?: IAction[];
    /**
     * (experimental) A textual description of the topic rule.
     *
     * @default None
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The action AWS IoT performs when it is unable to perform a rule's action.
     *
     * @default - no action will be performed
     * @experimental
     */
    readonly errorAction?: IAction;
    /**
     * (experimental) Specifies whether the rule is enabled.
     *
     * @default true
     * @experimental
     */
    readonly enabled?: boolean;
    /**
     * (experimental) A simplified SQL syntax to filter messages received on an MQTT topic and push the data elsewhere.
     *
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html
     * @experimental
     */
    readonly sql: IotSql;
}
/**
 * (experimental) Defines an AWS IoT Rule in this stack.
 *
 * @experimental
 */
export declare class TopicRule extends Resource implements ITopicRule {
    /**
     * (experimental) Import an existing AWS IoT Rule provided an ARN.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param topicRuleArn AWS IoT Rule ARN (i.e. arn:aws:iot:<region>:<account-id>:rule/MyRule).
     * @experimental
     */
    static fromTopicRuleArn(scope: Construct, id: string, topicRuleArn: string): ITopicRule;
    /**
     * (experimental) Arn of this topic rule.
     *
     * @experimental
     * @attribute true
     */
    readonly topicRuleArn: string;
    /**
     * (experimental) Name of this topic rule.
     *
     * @experimental
     * @attribute true
     */
    readonly topicRuleName: string;
    private readonly actions;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TopicRuleProps);
    /**
     * (experimental) Add a action to the topic rule.
     *
     * @param action the action to associate with the topic rule.
     * @experimental
     */
    addAction(action: IAction): void;
}
