import * as codepipeline from '@aws-cdk/aws-codepipeline';
import { SecretValue } from '@aws-cdk/core';
import { Action } from '../action';
import { Construct } from '@aws-cdk/core';
/**
 * If and how the GitHub source action should be triggered.
 *
 * @stability stable
 */
export declare enum GitHubTrigger {
    /**
     * @stability stable
     */
    NONE = "None",
    /**
     * @stability stable
     */
    POLL = "Poll",
    /**
     * @stability stable
     */
    WEBHOOK = "WebHook"
}
/**
 * The CodePipeline variables emitted by GitHub source Action.
 *
 * @stability stable
 */
export interface GitHubSourceVariables {
    /**
     * The name of the repository this action points to.
     *
     * @stability stable
     */
    readonly repositoryName: string;
    /**
     * The name of the branch this action tracks.
     *
     * @stability stable
     */
    readonly branchName: string;
    /**
     * The date the currently last commit on the tracked branch was authored, in ISO-8601 format.
     *
     * @stability stable
     */
    readonly authorDate: string;
    /**
     * The date the currently last commit on the tracked branch was committed, in ISO-8601 format.
     *
     * @stability stable
     */
    readonly committerDate: string;
    /**
     * The SHA1 hash of the currently last commit on the tracked branch.
     *
     * @stability stable
     */
    readonly commitId: string;
    /**
     * The message of the currently last commit on the tracked branch.
     *
     * @stability stable
     */
    readonly commitMessage: string;
    /**
     * The GitHub API URL of the currently last commit on the tracked branch.
     *
     * @stability stable
     */
    readonly commitUrl: string;
}
/**
 * Construction properties of the {@link GitHubSourceAction GitHub source action}.
 *
 * @stability stable
 */
export interface GitHubSourceActionProps extends codepipeline.CommonActionProps {
    /**
     * @stability stable
     */
    readonly output: codepipeline.Artifact;
    /**
     * The GitHub account/user that owns the repo.
     *
     * @stability stable
     */
    readonly owner: string;
    /**
     * The name of the repo, without the username.
     *
     * @stability stable
     */
    readonly repo: string;
    /**
     * The branch to use.
     *
     * @default "master"
     * @stability stable
     */
    readonly branch?: string;
    /**
     * A GitHub OAuth token to use for authentication.
     *
     * It is recommended to use a Secrets Manager `Secret` to obtain the token:
     *
     *    const oauth = cdk.SecretValue.secretsManager('my-github-token');
     *    new GitHubSource(this, 'GitHubAction', { oauthToken: oauth, ... });
     *
     * The GitHub Personal Access Token should have these scopes:
     *
     * * **repo** - to read the repository
     * * **admin:repo_hook** - if you plan to use webhooks (true by default)
     *
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/appendix-github-oauth.html#GitHub-create-personal-token-CLI
     * @stability stable
     */
    readonly oauthToken: SecretValue;
    /**
     * How AWS CodePipeline should be triggered.
     *
     * With the default value "WEBHOOK", a webhook is created in GitHub that triggers the action
     * With "POLL", CodePipeline periodically checks the source for changes
     * With "None", the action is not triggered through changes in the source
     *
     * To use `WEBHOOK`, your GitHub Personal Access Token should have
     * **admin:repo_hook** scope (in addition to the regular **repo** scope).
     *
     * @default GitHubTrigger.WEBHOOK
     * @stability stable
     */
    readonly trigger?: GitHubTrigger;
}
/**
 * Source that is provided by a GitHub repository.
 *
 * @stability stable
 */
export declare class GitHubSourceAction extends Action {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: GitHubSourceActionProps);
    /**
     * The variables emitted by this action.
     *
     * @stability stable
     */
    get variables(): GitHubSourceVariables;
    /**
     * The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @stability stable
     */
    protected bound(scope: Construct, stage: codepipeline.IStage, _options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
