"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManualApprovalAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const sns = require("@aws-cdk/aws-sns");
const subs = require("@aws-cdk/aws-sns-subscriptions");
const action_1 = require("./action");
/**
 * Manual approval action.
 *
 * @stability stable
 */
class ManualApprovalAction extends action_1.Action {
    /**
     * @stability stable
     */
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 0, maxOutputs: 0 },
        });
        this.props = props;
    }
    /**
     * @stability stable
     */
    get notificationTopic() {
        return this._notificationTopic;
    }
    /**
     * The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @stability stable
     */
    bound(scope, _stage, options) {
        var _b;
        if (this.props.notificationTopic) {
            this._notificationTopic = this.props.notificationTopic;
        }
        else if ((this.props.notifyEmails || []).length > 0) {
            this._notificationTopic = new sns.Topic(scope, 'TopicResource');
        }
        if (this._notificationTopic) {
            this._notificationTopic.grantPublish(options.role);
            for (const notifyEmail of this.props.notifyEmails || []) {
                this._notificationTopic.addSubscription(new subs.EmailSubscription(notifyEmail));
            }
        }
        return {
            configuration: undefinedIfAllValuesAreEmpty({
                NotificationArn: (_b = this._notificationTopic) === null || _b === void 0 ? void 0 : _b.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            }),
        };
    }
}
exports.ManualApprovalAction = ManualApprovalAction;
_a = JSII_RTTI_SYMBOL_1;
ManualApprovalAction[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.ManualApprovalAction", version: "1.93.0" };
function undefinedIfAllValuesAreEmpty(object) {
    return Object.values(object).some(v => v !== undefined) ? object : undefined;
}
//# sourceMappingURL=data:application/json;base64,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