"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceCatalogDeployAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const action_1 = require("../action");
/**
 * (experimental) CodePipeline action to connect to an existing ServiceCatalog product.
 *
 * **Note**: this class is still experimental, and may have breaking changes in the future!
 *
 * @experimental
 */
class ServiceCatalogDeployAction extends action_1.Action {
    /**
     * @experimental
     */
    constructor(props) {
        super({
            ...props,
            provider: 'ServiceCatalog',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.templatePath.artifact],
        });
        this.templatePath = props.templatePath.fileName;
        this.productVersionName = props.productVersionName;
        this.productVersionDescription = props.productVersionDescription;
        this.productId = props.productId;
        this.productType = 'CLOUD_FORMATION_TEMPLATE';
    }
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    bound(_scope, _stage, options) {
        options.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSServiceCatalogAdminFullAccess'));
        // Attempt at least privilege; using this alone fails with "invalid template".
        // Should construct ARN: 'arn:aws:catalog:<region>:<accountID>:product/' + this.scProductId
        // options.role.addToPolicy(new PolicyStatement({
        //   resources: ['*'],
        //   actions: ['servicecatalog:UpdateProduct', 'servicecatalog:ListProvisioningArtifacts', 'servicecatalog:CreateProvisioningArtifact'],
        // }));
        // the Action's Role needs to read from the Bucket to get artifacts
        options.bucket.grantRead(options.role);
        return {
            configuration: {
                TemplateFilePath: this.templatePath,
                ProductVersionName: this.productVersionName,
                ProductVersionDescription: this.productVersionDescription,
                ProductType: this.productType,
                ProductId: this.productId,
            },
        };
    }
}
exports.ServiceCatalogDeployAction = ServiceCatalogDeployAction;
_a = JSII_RTTI_SYMBOL_1;
ServiceCatalogDeployAction[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.ServiceCatalogDeployAction", version: "1.93.0" };
//# sourceMappingURL=data:application/json;base64,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