# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'AlertTargetRouteArgs',
    'CloudIntegrationNewRelicMetricFilterArgs',
    'DashboardParameterDetailArgs',
    'DashboardSectionArgs',
    'DashboardSectionRowArgs',
    'DashboardSectionRowChartArgs',
    'DashboardSectionRowChartChartSettingArgs',
    'DashboardSectionRowChartSourceArgs',
    'MetricsPolicyPolicyRuleArgs',
    'MetricsPolicyPolicyRuleTagArgs',
]

@pulumi.input_type
class AlertTargetRouteArgs:
    def __init__(__self__, *,
                 method: pulumi.Input[str],
                 target: pulumi.Input[str],
                 filter: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] method: The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "target", target)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def method(self) -> pulumi.Input[str]:
        """
        The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[str]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[str]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[str]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "filter", value)


@pulumi.input_type
class CloudIntegrationNewRelicMetricFilterArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[str],
                 metric_filter_regex: pulumi.Input[str]):
        """
        :param pulumi.Input[str] app_name: The name of a NewRelic App.
        :param pulumi.Input[str] metric_filter_regex: A regular expression that a metric name must match (case-insensitively) in order to be ingested.
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "metric_filter_regex", metric_filter_regex)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[str]:
        """
        The name of a NewRelic App.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> pulumi.Input[str]:
        """
        A regular expression that a metric name must match (case-insensitively) in order to be ingested.
        """
        return pulumi.get(self, "metric_filter_regex")

    @metric_filter_regex.setter
    def metric_filter_regex(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_filter_regex", value)


@pulumi.input_type
class DashboardParameterDetailArgs:
    def __init__(__self__, *,
                 default_value: pulumi.Input[str],
                 hide_from_view: pulumi.Input[bool],
                 label: pulumi.Input[str],
                 name: pulumi.Input[str],
                 parameter_type: pulumi.Input[str],
                 values_to_readable_strings: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 dynamic_field_type: Optional[pulumi.Input[str]] = None,
                 query_value: Optional[pulumi.Input[str]] = None,
                 tag_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] default_value: The default value of the parameter.
        :param pulumi.Input[bool] hide_from_view: If `true` the parameter will only be shown on the edit view of the dashboard.
        :param pulumi.Input[str] label: The label for the parameter.
        :param pulumi.Input[str] name: The name of the parameters.
        :param pulumi.Input[str] parameter_type: The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] values_to_readable_strings: A string->string map.  At least one of the keys must match the value of
               `default_value`.
        :param pulumi.Input[str] dynamic_field_type: For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
               `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        :param pulumi.Input[str] query_value: For `DYNAMIC` parameter types, the query to execute to return values.
        :param pulumi.Input[str] tag_key: for `TAG_KEY` dynamic field types, the tag key to return.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "hide_from_view", hide_from_view)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "values_to_readable_strings", values_to_readable_strings)
        if dynamic_field_type is not None:
            pulumi.set(__self__, "dynamic_field_type", dynamic_field_type)
        if query_value is not None:
            pulumi.set(__self__, "query_value", query_value)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> pulumi.Input[str]:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="hideFromView")
    def hide_from_view(self) -> pulumi.Input[bool]:
        """
        If `true` the parameter will only be shown on the edit view of the dashboard.
        """
        return pulumi.get(self, "hide_from_view")

    @hide_from_view.setter
    def hide_from_view(self, value: pulumi.Input[bool]):
        pulumi.set(self, "hide_from_view", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        The label for the parameter.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> pulumi.Input[str]:
        """
        The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        """
        return pulumi.get(self, "parameter_type")

    @parameter_type.setter
    def parameter_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_type", value)

    @property
    @pulumi.getter(name="valuesToReadableStrings")
    def values_to_readable_strings(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        A string->string map.  At least one of the keys must match the value of
        `default_value`.
        """
        return pulumi.get(self, "values_to_readable_strings")

    @values_to_readable_strings.setter
    def values_to_readable_strings(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "values_to_readable_strings", value)

    @property
    @pulumi.getter(name="dynamicFieldType")
    def dynamic_field_type(self) -> Optional[pulumi.Input[str]]:
        """
        For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
        `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        """
        return pulumi.get(self, "dynamic_field_type")

    @dynamic_field_type.setter
    def dynamic_field_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dynamic_field_type", value)

    @property
    @pulumi.getter(name="queryValue")
    def query_value(self) -> Optional[pulumi.Input[str]]:
        """
        For `DYNAMIC` parameter types, the query to execute to return values.
        """
        return pulumi.get(self, "query_value")

    @query_value.setter
    def query_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_value", value)

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[pulumi.Input[str]]:
        """
        for `TAG_KEY` dynamic field types, the tag key to return.
        """
        return pulumi.get(self, "tag_key")

    @tag_key.setter
    def tag_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_key", value)


@pulumi.input_type
class DashboardSectionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 rows: pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowArgs']]]):
        """
        :param pulumi.Input[str] name: Name of this section.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowArgs']]] rows: See dashboard section rows.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rows", rows)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of this section.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rows(self) -> pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowArgs']]]:
        """
        See dashboard section rows.
        """
        return pulumi.get(self, "rows")

    @rows.setter
    def rows(self, value: pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowArgs']]]):
        pulumi.set(self, "rows", value)


@pulumi.input_type
class DashboardSectionRowArgs:
    def __init__(__self__, *,
                 charts: pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowChartArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowChartArgs']]] charts: Charts in this section. See dashboard chart.
        """
        pulumi.set(__self__, "charts", charts)

    @property
    @pulumi.getter
    def charts(self) -> pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowChartArgs']]]:
        """
        Charts in this section. See dashboard chart.
        """
        return pulumi.get(self, "charts")

    @charts.setter
    def charts(self, value: pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowChartArgs']]]):
        pulumi.set(self, "charts", value)


@pulumi.input_type
class DashboardSectionRowChartArgs:
    def __init__(__self__, *,
                 chart_setting: pulumi.Input['DashboardSectionRowChartChartSettingArgs'],
                 name: pulumi.Input[str],
                 sources: pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowChartSourceArgs']]],
                 summarization: pulumi.Input[str],
                 units: pulumi.Input[str],
                 base: Optional[pulumi.Input[int]] = None,
                 chart_attribute: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['DashboardSectionRowChartChartSettingArgs'] chart_setting: Chart settings. See chart settings.
        :param pulumi.Input[str] name: Name of the source.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowChartSourceArgs']]] sources: Query expression to plot on the chart. See chart source queries.
        :param pulumi.Input[str] summarization: Summarization strategy for the chart. MEAN is default. Valid options are, `MEAN`, 
               `MEDIAN`, `MIN`, `MAX`, `SUM`, `COUNT`, `LAST`, `FIRST`.
        :param pulumi.Input[str] units: String to label the units of the chart on the Y-Axis.
        :param pulumi.Input[int] base: The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        :param pulumi.Input[str] description: Description of the chart.
        """
        pulumi.set(__self__, "chart_setting", chart_setting)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "summarization", summarization)
        pulumi.set(__self__, "units", units)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if chart_attribute is not None:
            pulumi.set(__self__, "chart_attribute", chart_attribute)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="chartSetting")
    def chart_setting(self) -> pulumi.Input['DashboardSectionRowChartChartSettingArgs']:
        """
        Chart settings. See chart settings.
        """
        return pulumi.get(self, "chart_setting")

    @chart_setting.setter
    def chart_setting(self, value: pulumi.Input['DashboardSectionRowChartChartSettingArgs']):
        pulumi.set(self, "chart_setting", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowChartSourceArgs']]]:
        """
        Query expression to plot on the chart. See chart source queries.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input['DashboardSectionRowChartSourceArgs']]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter
    def summarization(self) -> pulumi.Input[str]:
        """
        Summarization strategy for the chart. MEAN is default. Valid options are, `MEAN`, 
        `MEDIAN`, `MIN`, `MAX`, `SUM`, `COUNT`, `LAST`, `FIRST`.
        """
        return pulumi.get(self, "summarization")

    @summarization.setter
    def summarization(self, value: pulumi.Input[str]):
        pulumi.set(self, "summarization", value)

    @property
    @pulumi.getter
    def units(self) -> pulumi.Input[str]:
        """
        String to label the units of the chart on the Y-Axis.
        """
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: pulumi.Input[str]):
        pulumi.set(self, "units", value)

    @property
    @pulumi.getter
    def base(self) -> Optional[pulumi.Input[int]]:
        """
        The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        """
        return pulumi.get(self, "base")

    @base.setter
    def base(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "base", value)

    @property
    @pulumi.getter(name="chartAttribute")
    def chart_attribute(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "chart_attribute")

    @chart_attribute.setter
    def chart_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chart_attribute", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class DashboardSectionRowChartChartSettingArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 auto_column_tags: Optional[pulumi.Input[bool]] = None,
                 column_tags: Optional[pulumi.Input[str]] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expected_data_spacing: Optional[pulumi.Input[int]] = None,
                 fixed_legend_display_stats: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 fixed_legend_enabled: Optional[pulumi.Input[bool]] = None,
                 fixed_legend_filter_field: Optional[pulumi.Input[str]] = None,
                 fixed_legend_filter_limit: Optional[pulumi.Input[int]] = None,
                 fixed_legend_filter_sort: Optional[pulumi.Input[str]] = None,
                 fixed_legend_hide_label: Optional[pulumi.Input[bool]] = None,
                 fixed_legend_position: Optional[pulumi.Input[str]] = None,
                 fixed_legend_use_raw_stats: Optional[pulumi.Input[bool]] = None,
                 group_by_source: Optional[pulumi.Input[bool]] = None,
                 invert_dynamic_legend_hover_control: Optional[pulumi.Input[bool]] = None,
                 line_type: Optional[pulumi.Input[str]] = None,
                 max: Optional[pulumi.Input[float]] = None,
                 min: Optional[pulumi.Input[float]] = None,
                 num_tags: Optional[pulumi.Input[int]] = None,
                 plain_markdown_content: Optional[pulumi.Input[str]] = None,
                 show_hosts: Optional[pulumi.Input[bool]] = None,
                 show_labels: Optional[pulumi.Input[bool]] = None,
                 show_raw_values: Optional[pulumi.Input[bool]] = None,
                 sort_values_descending: Optional[pulumi.Input[bool]] = None,
                 sparkline_decimal_precision: Optional[pulumi.Input[int]] = None,
                 sparkline_display_color: Optional[pulumi.Input[str]] = None,
                 sparkline_display_font_size: Optional[pulumi.Input[str]] = None,
                 sparkline_display_horizontal_position: Optional[pulumi.Input[str]] = None,
                 sparkline_display_postfix: Optional[pulumi.Input[str]] = None,
                 sparkline_display_prefix: Optional[pulumi.Input[str]] = None,
                 sparkline_display_value_type: Optional[pulumi.Input[str]] = None,
                 sparkline_display_vertical_position: Optional[pulumi.Input[str]] = None,
                 sparkline_fill_color: Optional[pulumi.Input[str]] = None,
                 sparkline_line_color: Optional[pulumi.Input[str]] = None,
                 sparkline_size: Optional[pulumi.Input[str]] = None,
                 sparkline_value_color_map_apply_to: Optional[pulumi.Input[str]] = None,
                 sparkline_value_color_map_colors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sparkline_value_color_map_values: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 sparkline_value_color_map_values_v2s: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]] = None,
                 sparkline_value_text_map_texts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sparkline_value_text_map_thresholds: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]] = None,
                 stack_type: Optional[pulumi.Input[str]] = None,
                 tag_mode: Optional[pulumi.Input[str]] = None,
                 time_based_coloring: Optional[pulumi.Input[bool]] = None,
                 window_size: Optional[pulumi.Input[int]] = None,
                 windowing: Optional[pulumi.Input[str]] = None,
                 xmax: Optional[pulumi.Input[float]] = None,
                 xmin: Optional[pulumi.Input[float]] = None,
                 y0_scale_si_by1024: Optional[pulumi.Input[bool]] = None,
                 y0_unit_autoscaling: Optional[pulumi.Input[bool]] = None,
                 y1_scale_si_by1024: Optional[pulumi.Input[bool]] = None,
                 y1_unit_autoscaling: Optional[pulumi.Input[bool]] = None,
                 y1_units: Optional[pulumi.Input[str]] = None,
                 y1max: Optional[pulumi.Input[float]] = None,
                 y1min: Optional[pulumi.Input[float]] = None,
                 ymax: Optional[pulumi.Input[float]] = None,
                 ymin: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] type: Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to 
               the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the
               Markdown display, and `sparkline` to the Single Stat view. Valid options are `line`, `scatterplot`,
               `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`,
               `top-k`, `status-list`, and `histogram`.
        :param pulumi.Input[bool] auto_column_tags: This setting is deprecated.
        :param pulumi.Input[str] column_tags: This setting is deprecated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_tags: For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        :param pulumi.Input[int] expected_data_spacing: Threshold (in seconds) for time delta between consecutive points in a series
               above which a dotted line will replace a solid in in line plots. Default is 60.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fixed_legend_display_stats: For a chart with a fixed legend, a list of statistics to display in the legend.
        :param pulumi.Input[bool] fixed_legend_enabled: Whether to enable a fixed tabular legend adjacent to the chart.
        :param pulumi.Input[str] fixed_legend_filter_field: Statistic to use for determining whether a series is displayed on the fixed legend.
               Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        :param pulumi.Input[int] fixed_legend_filter_limit: Number of series to include in the fixed legend.
        :param pulumi.Input[str] fixed_legend_filter_sort: Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options
               are `TOP`, and `BOTTOM`.
        :param pulumi.Input[bool] fixed_legend_hide_label: This setting is deprecated.
        :param pulumi.Input[str] fixed_legend_position: Where the fixed legend should be displayed with respect to the chart.
               Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        :param pulumi.Input[bool] fixed_legend_use_raw_stats: If `true`, the legend uses non-summarized stats instead of summarized.
        :param pulumi.Input[bool] group_by_source: For the tabular view, whether to group multi metrics into a single row by a common source.
               If `false`, each source is displayed in its own row.  if `true`, multiple metrics for the same host are displayed as different
               columns in the same row.
        :param pulumi.Input[bool] invert_dynamic_legend_hover_control: Whether to disable the display of the floating legend (but
               reenable it when the ctrl-key is pressed).
        :param pulumi.Input[str] line_type: Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, 
               `step-after`, `basis`, `cardinal`, and `monotone`.
        :param pulumi.Input[float] max: Max value of the Y-axis. Set to null or leave blank for auto.
        :param pulumi.Input[float] min: Min value of the Y-axis. Set to null or leave blank for auto.
        :param pulumi.Input[int] num_tags: For the tabular view defines how many point tags to display.
        :param pulumi.Input[str] plain_markdown_content: The markdown content for a Markdown display, in plain text.
        :param pulumi.Input[bool] show_hosts: For the tabular view, whether to display sources. Default is `true`.
        :param pulumi.Input[bool] show_labels: For the tabular view, whether to display labels. Default is `true`.
        :param pulumi.Input[bool] show_raw_values: For the tabular view, whether to display raw values. Default is `false`.
        :param pulumi.Input[bool] sort_values_descending: For the tabular view, whether to display values in descending order. Default is `false`.
        :param pulumi.Input[int] sparkline_decimal_precision: For the single stat view, the decimal precision of the displayed number.
        :param pulumi.Input[str] sparkline_display_color: For the single stat view, the color of the displayed text (when not dynamically determined). 
               Values should be in `rgba(,,,,)` format.
        :param pulumi.Input[str] sparkline_display_font_size: For the single stat view, the font size of the displayed text, in percent.
        :param pulumi.Input[str] sparkline_display_horizontal_position: For the single stat view, the horizontal position of the displayed text.
               Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        :param pulumi.Input[str] sparkline_display_postfix: For the single stat view, a string to append to the displayed text.
        :param pulumi.Input[str] sparkline_display_prefix: For the single stat view, a string to add before the displayed text.
        :param pulumi.Input[str] sparkline_display_value_type: For the single stat view, where to display the name of the query or the value of the query.
               Valid options are `VALUE` or `LABEL`.
        :param pulumi.Input[str] sparkline_display_vertical_position: This setting is deprecated.
        :param pulumi.Input[str] sparkline_fill_color: For the single stat view, the color of the background fill.  Values should be
               in `rgba(,,,,)`.
        :param pulumi.Input[str] sparkline_line_color: For the single stat view, the color of the line.  Values should be in `rgba(,,,,)` format.
        :param pulumi.Input[str] sparkline_size: For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart.
               Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        :param pulumi.Input[str] sparkline_value_color_map_apply_to: For the single stat view, whether to apply dynamic color settings to 
               the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sparkline_value_color_map_colors: For the single stat view, A list of colors that differing query values map to. 
               Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in `rgba(,,,,)`.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] sparkline_value_color_map_values: This setting is deprecated.
        :param pulumi.Input[Sequence[pulumi.Input[float]]] sparkline_value_color_map_values_v2s: For the single stat view, a list of boundaries for mapping different
               query values to colors.  Must contain one element less than `sparkline_value_color_map_colors`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sparkline_value_text_map_texts: For the single stat view, a list of display text values that different query
               values map to.  Must contain one more element than `sparkline_value_text_map_thresholds`.
        :param pulumi.Input[Sequence[pulumi.Input[float]]] sparkline_value_text_map_thresholds: For the single stat view, a list of threshold boundaries for 
               mapping different query values to display text.  Must contain one element less than `sparkline_value_text_map_text`.
        :param pulumi.Input[str] stack_type: Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means
               stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to
               center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        :param pulumi.Input[str] tag_mode: For the tabular view, which mode to use to determine which point tags to display.
               Valid options are `all`, `top`, or `custom`.
        :param pulumi.Input[bool] time_based_coloring: For x-y scatterplots, whether to color more recent points as darker than older points.
        :param pulumi.Input[int] window_size: Width, in minutes, of the time window to use for `last` windowing.
        :param pulumi.Input[str] windowing: For the tabular view, whether to use the full time window for the query or the last X minutes.
               Valid options are `full` or `last`.
        :param pulumi.Input[float] xmax: For x-y scatterplots, max value for the X-axis. Set to null for auto.
        :param pulumi.Input[float] xmin: For x-y scatterplots, min value for the X-axis. Set to null for auto.
        :param pulumi.Input[bool] y0_scale_si_by1024: Whether to scale numerical magnitude labels for left Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        :param pulumi.Input[bool] y0_unit_autoscaling: Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        :param pulumi.Input[bool] y1_scale_si_by1024: Whether to scale numerical magnitude labels for right Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        :param pulumi.Input[bool] y1_unit_autoscaling: Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        :param pulumi.Input[str] y1_units: For plots with multiple Y-axes, units for right side Y-axis.
        :param pulumi.Input[float] y1max: For plots with multiple Y-axes, max value for the right side Y-axis. Set null for auto.
        :param pulumi.Input[float] y1min: For plots with multiple Y-axes, min value for the right side Y-axis. Set null for auto.
        :param pulumi.Input[float] ymax: For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        :param pulumi.Input[float] ymin: For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        pulumi.set(__self__, "type", type)
        if auto_column_tags is not None:
            pulumi.set(__self__, "auto_column_tags", auto_column_tags)
        if column_tags is not None:
            pulumi.set(__self__, "column_tags", column_tags)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if expected_data_spacing is not None:
            pulumi.set(__self__, "expected_data_spacing", expected_data_spacing)
        if fixed_legend_display_stats is not None:
            pulumi.set(__self__, "fixed_legend_display_stats", fixed_legend_display_stats)
        if fixed_legend_enabled is not None:
            pulumi.set(__self__, "fixed_legend_enabled", fixed_legend_enabled)
        if fixed_legend_filter_field is not None:
            pulumi.set(__self__, "fixed_legend_filter_field", fixed_legend_filter_field)
        if fixed_legend_filter_limit is not None:
            pulumi.set(__self__, "fixed_legend_filter_limit", fixed_legend_filter_limit)
        if fixed_legend_filter_sort is not None:
            pulumi.set(__self__, "fixed_legend_filter_sort", fixed_legend_filter_sort)
        if fixed_legend_hide_label is not None:
            pulumi.set(__self__, "fixed_legend_hide_label", fixed_legend_hide_label)
        if fixed_legend_position is not None:
            pulumi.set(__self__, "fixed_legend_position", fixed_legend_position)
        if fixed_legend_use_raw_stats is not None:
            pulumi.set(__self__, "fixed_legend_use_raw_stats", fixed_legend_use_raw_stats)
        if group_by_source is not None:
            pulumi.set(__self__, "group_by_source", group_by_source)
        if invert_dynamic_legend_hover_control is not None:
            pulumi.set(__self__, "invert_dynamic_legend_hover_control", invert_dynamic_legend_hover_control)
        if line_type is not None:
            pulumi.set(__self__, "line_type", line_type)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if num_tags is not None:
            pulumi.set(__self__, "num_tags", num_tags)
        if plain_markdown_content is not None:
            pulumi.set(__self__, "plain_markdown_content", plain_markdown_content)
        if show_hosts is not None:
            pulumi.set(__self__, "show_hosts", show_hosts)
        if show_labels is not None:
            pulumi.set(__self__, "show_labels", show_labels)
        if show_raw_values is not None:
            pulumi.set(__self__, "show_raw_values", show_raw_values)
        if sort_values_descending is not None:
            pulumi.set(__self__, "sort_values_descending", sort_values_descending)
        if sparkline_decimal_precision is not None:
            pulumi.set(__self__, "sparkline_decimal_precision", sparkline_decimal_precision)
        if sparkline_display_color is not None:
            pulumi.set(__self__, "sparkline_display_color", sparkline_display_color)
        if sparkline_display_font_size is not None:
            pulumi.set(__self__, "sparkline_display_font_size", sparkline_display_font_size)
        if sparkline_display_horizontal_position is not None:
            pulumi.set(__self__, "sparkline_display_horizontal_position", sparkline_display_horizontal_position)
        if sparkline_display_postfix is not None:
            pulumi.set(__self__, "sparkline_display_postfix", sparkline_display_postfix)
        if sparkline_display_prefix is not None:
            pulumi.set(__self__, "sparkline_display_prefix", sparkline_display_prefix)
        if sparkline_display_value_type is not None:
            pulumi.set(__self__, "sparkline_display_value_type", sparkline_display_value_type)
        if sparkline_display_vertical_position is not None:
            pulumi.set(__self__, "sparkline_display_vertical_position", sparkline_display_vertical_position)
        if sparkline_fill_color is not None:
            pulumi.set(__self__, "sparkline_fill_color", sparkline_fill_color)
        if sparkline_line_color is not None:
            pulumi.set(__self__, "sparkline_line_color", sparkline_line_color)
        if sparkline_size is not None:
            pulumi.set(__self__, "sparkline_size", sparkline_size)
        if sparkline_value_color_map_apply_to is not None:
            pulumi.set(__self__, "sparkline_value_color_map_apply_to", sparkline_value_color_map_apply_to)
        if sparkline_value_color_map_colors is not None:
            pulumi.set(__self__, "sparkline_value_color_map_colors", sparkline_value_color_map_colors)
        if sparkline_value_color_map_values is not None:
            pulumi.set(__self__, "sparkline_value_color_map_values", sparkline_value_color_map_values)
        if sparkline_value_color_map_values_v2s is not None:
            pulumi.set(__self__, "sparkline_value_color_map_values_v2s", sparkline_value_color_map_values_v2s)
        if sparkline_value_text_map_texts is not None:
            pulumi.set(__self__, "sparkline_value_text_map_texts", sparkline_value_text_map_texts)
        if sparkline_value_text_map_thresholds is not None:
            pulumi.set(__self__, "sparkline_value_text_map_thresholds", sparkline_value_text_map_thresholds)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)
        if tag_mode is not None:
            pulumi.set(__self__, "tag_mode", tag_mode)
        if time_based_coloring is not None:
            pulumi.set(__self__, "time_based_coloring", time_based_coloring)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)
        if windowing is not None:
            pulumi.set(__self__, "windowing", windowing)
        if xmax is not None:
            pulumi.set(__self__, "xmax", xmax)
        if xmin is not None:
            pulumi.set(__self__, "xmin", xmin)
        if y0_scale_si_by1024 is not None:
            pulumi.set(__self__, "y0_scale_si_by1024", y0_scale_si_by1024)
        if y0_unit_autoscaling is not None:
            pulumi.set(__self__, "y0_unit_autoscaling", y0_unit_autoscaling)
        if y1_scale_si_by1024 is not None:
            pulumi.set(__self__, "y1_scale_si_by1024", y1_scale_si_by1024)
        if y1_unit_autoscaling is not None:
            pulumi.set(__self__, "y1_unit_autoscaling", y1_unit_autoscaling)
        if y1_units is not None:
            pulumi.set(__self__, "y1_units", y1_units)
        if y1max is not None:
            pulumi.set(__self__, "y1max", y1max)
        if y1min is not None:
            pulumi.set(__self__, "y1min", y1min)
        if ymax is not None:
            pulumi.set(__self__, "ymax", ymax)
        if ymin is not None:
            pulumi.set(__self__, "ymin", ymin)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to 
        the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the
        Markdown display, and `sparkline` to the Single Stat view. Valid options are `line`, `scatterplot`,
        `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`,
        `top-k`, `status-list`, and `histogram`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="autoColumnTags")
    def auto_column_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "auto_column_tags")

    @auto_column_tags.setter
    def auto_column_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_column_tags", value)

    @property
    @pulumi.getter(name="columnTags")
    def column_tags(self) -> Optional[pulumi.Input[str]]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "column_tags")

    @column_tags.setter
    def column_tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column_tags", value)

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_tags", value)

    @property
    @pulumi.getter(name="expectedDataSpacing")
    def expected_data_spacing(self) -> Optional[pulumi.Input[int]]:
        """
        Threshold (in seconds) for time delta between consecutive points in a series
        above which a dotted line will replace a solid in in line plots. Default is 60.
        """
        return pulumi.get(self, "expected_data_spacing")

    @expected_data_spacing.setter
    def expected_data_spacing(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_data_spacing", value)

    @property
    @pulumi.getter(name="fixedLegendDisplayStats")
    def fixed_legend_display_stats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        For a chart with a fixed legend, a list of statistics to display in the legend.
        """
        return pulumi.get(self, "fixed_legend_display_stats")

    @fixed_legend_display_stats.setter
    def fixed_legend_display_stats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fixed_legend_display_stats", value)

    @property
    @pulumi.getter(name="fixedLegendEnabled")
    def fixed_legend_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable a fixed tabular legend adjacent to the chart.
        """
        return pulumi.get(self, "fixed_legend_enabled")

    @fixed_legend_enabled.setter
    def fixed_legend_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fixed_legend_enabled", value)

    @property
    @pulumi.getter(name="fixedLegendFilterField")
    def fixed_legend_filter_field(self) -> Optional[pulumi.Input[str]]:
        """
        Statistic to use for determining whether a series is displayed on the fixed legend.
        Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        """
        return pulumi.get(self, "fixed_legend_filter_field")

    @fixed_legend_filter_field.setter
    def fixed_legend_filter_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_legend_filter_field", value)

    @property
    @pulumi.getter(name="fixedLegendFilterLimit")
    def fixed_legend_filter_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Number of series to include in the fixed legend.
        """
        return pulumi.get(self, "fixed_legend_filter_limit")

    @fixed_legend_filter_limit.setter
    def fixed_legend_filter_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fixed_legend_filter_limit", value)

    @property
    @pulumi.getter(name="fixedLegendFilterSort")
    def fixed_legend_filter_sort(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options
        are `TOP`, and `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_filter_sort")

    @fixed_legend_filter_sort.setter
    def fixed_legend_filter_sort(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_legend_filter_sort", value)

    @property
    @pulumi.getter(name="fixedLegendHideLabel")
    def fixed_legend_hide_label(self) -> Optional[pulumi.Input[bool]]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "fixed_legend_hide_label")

    @fixed_legend_hide_label.setter
    def fixed_legend_hide_label(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fixed_legend_hide_label", value)

    @property
    @pulumi.getter(name="fixedLegendPosition")
    def fixed_legend_position(self) -> Optional[pulumi.Input[str]]:
        """
        Where the fixed legend should be displayed with respect to the chart.
        Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_position")

    @fixed_legend_position.setter
    def fixed_legend_position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_legend_position", value)

    @property
    @pulumi.getter(name="fixedLegendUseRawStats")
    def fixed_legend_use_raw_stats(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the legend uses non-summarized stats instead of summarized.
        """
        return pulumi.get(self, "fixed_legend_use_raw_stats")

    @fixed_legend_use_raw_stats.setter
    def fixed_legend_use_raw_stats(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fixed_legend_use_raw_stats", value)

    @property
    @pulumi.getter(name="groupBySource")
    def group_by_source(self) -> Optional[pulumi.Input[bool]]:
        """
        For the tabular view, whether to group multi metrics into a single row by a common source.
        If `false`, each source is displayed in its own row.  if `true`, multiple metrics for the same host are displayed as different
        columns in the same row.
        """
        return pulumi.get(self, "group_by_source")

    @group_by_source.setter
    def group_by_source(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "group_by_source", value)

    @property
    @pulumi.getter(name="invertDynamicLegendHoverControl")
    def invert_dynamic_legend_hover_control(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable the display of the floating legend (but
        reenable it when the ctrl-key is pressed).
        """
        return pulumi.get(self, "invert_dynamic_legend_hover_control")

    @invert_dynamic_legend_hover_control.setter
    def invert_dynamic_legend_hover_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_dynamic_legend_hover_control", value)

    @property
    @pulumi.getter(name="lineType")
    def line_type(self) -> Optional[pulumi.Input[str]]:
        """
        Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, 
        `step-after`, `basis`, `cardinal`, and `monotone`.
        """
        return pulumi.get(self, "line_type")

    @line_type.setter
    def line_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line_type", value)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[float]]:
        """
        Max value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[float]]:
        """
        Min value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min", value)

    @property
    @pulumi.getter(name="numTags")
    def num_tags(self) -> Optional[pulumi.Input[int]]:
        """
        For the tabular view defines how many point tags to display.
        """
        return pulumi.get(self, "num_tags")

    @num_tags.setter
    def num_tags(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_tags", value)

    @property
    @pulumi.getter(name="plainMarkdownContent")
    def plain_markdown_content(self) -> Optional[pulumi.Input[str]]:
        """
        The markdown content for a Markdown display, in plain text.
        """
        return pulumi.get(self, "plain_markdown_content")

    @plain_markdown_content.setter
    def plain_markdown_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plain_markdown_content", value)

    @property
    @pulumi.getter(name="showHosts")
    def show_hosts(self) -> Optional[pulumi.Input[bool]]:
        """
        For the tabular view, whether to display sources. Default is `true`.
        """
        return pulumi.get(self, "show_hosts")

    @show_hosts.setter
    def show_hosts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_hosts", value)

    @property
    @pulumi.getter(name="showLabels")
    def show_labels(self) -> Optional[pulumi.Input[bool]]:
        """
        For the tabular view, whether to display labels. Default is `true`.
        """
        return pulumi.get(self, "show_labels")

    @show_labels.setter
    def show_labels(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_labels", value)

    @property
    @pulumi.getter(name="showRawValues")
    def show_raw_values(self) -> Optional[pulumi.Input[bool]]:
        """
        For the tabular view, whether to display raw values. Default is `false`.
        """
        return pulumi.get(self, "show_raw_values")

    @show_raw_values.setter
    def show_raw_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_raw_values", value)

    @property
    @pulumi.getter(name="sortValuesDescending")
    def sort_values_descending(self) -> Optional[pulumi.Input[bool]]:
        """
        For the tabular view, whether to display values in descending order. Default is `false`.
        """
        return pulumi.get(self, "sort_values_descending")

    @sort_values_descending.setter
    def sort_values_descending(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sort_values_descending", value)

    @property
    @pulumi.getter(name="sparklineDecimalPrecision")
    def sparkline_decimal_precision(self) -> Optional[pulumi.Input[int]]:
        """
        For the single stat view, the decimal precision of the displayed number.
        """
        return pulumi.get(self, "sparkline_decimal_precision")

    @sparkline_decimal_precision.setter
    def sparkline_decimal_precision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sparkline_decimal_precision", value)

    @property
    @pulumi.getter(name="sparklineDisplayColor")
    def sparkline_display_color(self) -> Optional[pulumi.Input[str]]:
        """
        For the single stat view, the color of the displayed text (when not dynamically determined). 
        Values should be in `rgba(,,,,)` format.
        """
        return pulumi.get(self, "sparkline_display_color")

    @sparkline_display_color.setter
    def sparkline_display_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_display_color", value)

    @property
    @pulumi.getter(name="sparklineDisplayFontSize")
    def sparkline_display_font_size(self) -> Optional[pulumi.Input[str]]:
        """
        For the single stat view, the font size of the displayed text, in percent.
        """
        return pulumi.get(self, "sparkline_display_font_size")

    @sparkline_display_font_size.setter
    def sparkline_display_font_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_display_font_size", value)

    @property
    @pulumi.getter(name="sparklineDisplayHorizontalPosition")
    def sparkline_display_horizontal_position(self) -> Optional[pulumi.Input[str]]:
        """
        For the single stat view, the horizontal position of the displayed text.
        Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        """
        return pulumi.get(self, "sparkline_display_horizontal_position")

    @sparkline_display_horizontal_position.setter
    def sparkline_display_horizontal_position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_display_horizontal_position", value)

    @property
    @pulumi.getter(name="sparklineDisplayPostfix")
    def sparkline_display_postfix(self) -> Optional[pulumi.Input[str]]:
        """
        For the single stat view, a string to append to the displayed text.
        """
        return pulumi.get(self, "sparkline_display_postfix")

    @sparkline_display_postfix.setter
    def sparkline_display_postfix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_display_postfix", value)

    @property
    @pulumi.getter(name="sparklineDisplayPrefix")
    def sparkline_display_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        For the single stat view, a string to add before the displayed text.
        """
        return pulumi.get(self, "sparkline_display_prefix")

    @sparkline_display_prefix.setter
    def sparkline_display_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_display_prefix", value)

    @property
    @pulumi.getter(name="sparklineDisplayValueType")
    def sparkline_display_value_type(self) -> Optional[pulumi.Input[str]]:
        """
        For the single stat view, where to display the name of the query or the value of the query.
        Valid options are `VALUE` or `LABEL`.
        """
        return pulumi.get(self, "sparkline_display_value_type")

    @sparkline_display_value_type.setter
    def sparkline_display_value_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_display_value_type", value)

    @property
    @pulumi.getter(name="sparklineDisplayVerticalPosition")
    def sparkline_display_vertical_position(self) -> Optional[pulumi.Input[str]]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_display_vertical_position")

    @sparkline_display_vertical_position.setter
    def sparkline_display_vertical_position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_display_vertical_position", value)

    @property
    @pulumi.getter(name="sparklineFillColor")
    def sparkline_fill_color(self) -> Optional[pulumi.Input[str]]:
        """
        For the single stat view, the color of the background fill.  Values should be
        in `rgba(,,,,)`.
        """
        return pulumi.get(self, "sparkline_fill_color")

    @sparkline_fill_color.setter
    def sparkline_fill_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_fill_color", value)

    @property
    @pulumi.getter(name="sparklineLineColor")
    def sparkline_line_color(self) -> Optional[pulumi.Input[str]]:
        """
        For the single stat view, the color of the line.  Values should be in `rgba(,,,,)` format.
        """
        return pulumi.get(self, "sparkline_line_color")

    @sparkline_line_color.setter
    def sparkline_line_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_line_color", value)

    @property
    @pulumi.getter(name="sparklineSize")
    def sparkline_size(self) -> Optional[pulumi.Input[str]]:
        """
        For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart.
        Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        """
        return pulumi.get(self, "sparkline_size")

    @sparkline_size.setter
    def sparkline_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_size", value)

    @property
    @pulumi.getter(name="sparklineValueColorMapApplyTo")
    def sparkline_value_color_map_apply_to(self) -> Optional[pulumi.Input[str]]:
        """
        For the single stat view, whether to apply dynamic color settings to 
        the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        """
        return pulumi.get(self, "sparkline_value_color_map_apply_to")

    @sparkline_value_color_map_apply_to.setter
    def sparkline_value_color_map_apply_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sparkline_value_color_map_apply_to", value)

    @property
    @pulumi.getter(name="sparklineValueColorMapColors")
    def sparkline_value_color_map_colors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        For the single stat view, A list of colors that differing query values map to. 
        Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in `rgba(,,,,)`.
        """
        return pulumi.get(self, "sparkline_value_color_map_colors")

    @sparkline_value_color_map_colors.setter
    def sparkline_value_color_map_colors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sparkline_value_color_map_colors", value)

    @property
    @pulumi.getter(name="sparklineValueColorMapValues")
    def sparkline_value_color_map_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_value_color_map_values")

    @sparkline_value_color_map_values.setter
    def sparkline_value_color_map_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "sparkline_value_color_map_values", value)

    @property
    @pulumi.getter(name="sparklineValueColorMapValuesV2s")
    def sparkline_value_color_map_values_v2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]:
        """
        For the single stat view, a list of boundaries for mapping different
        query values to colors.  Must contain one element less than `sparkline_value_color_map_colors`.
        """
        return pulumi.get(self, "sparkline_value_color_map_values_v2s")

    @sparkline_value_color_map_values_v2s.setter
    def sparkline_value_color_map_values_v2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]):
        pulumi.set(self, "sparkline_value_color_map_values_v2s", value)

    @property
    @pulumi.getter(name="sparklineValueTextMapTexts")
    def sparkline_value_text_map_texts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        For the single stat view, a list of display text values that different query
        values map to.  Must contain one more element than `sparkline_value_text_map_thresholds`.
        """
        return pulumi.get(self, "sparkline_value_text_map_texts")

    @sparkline_value_text_map_texts.setter
    def sparkline_value_text_map_texts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sparkline_value_text_map_texts", value)

    @property
    @pulumi.getter(name="sparklineValueTextMapThresholds")
    def sparkline_value_text_map_thresholds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]:
        """
        For the single stat view, a list of threshold boundaries for 
        mapping different query values to display text.  Must contain one element less than `sparkline_value_text_map_text`.
        """
        return pulumi.get(self, "sparkline_value_text_map_thresholds")

    @sparkline_value_text_map_thresholds.setter
    def sparkline_value_text_map_thresholds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]):
        pulumi.set(self, "sparkline_value_text_map_thresholds", value)

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means
        stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to
        center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        """
        return pulumi.get(self, "stack_type")

    @stack_type.setter
    def stack_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_type", value)

    @property
    @pulumi.getter(name="tagMode")
    def tag_mode(self) -> Optional[pulumi.Input[str]]:
        """
        For the tabular view, which mode to use to determine which point tags to display.
        Valid options are `all`, `top`, or `custom`.
        """
        return pulumi.get(self, "tag_mode")

    @tag_mode.setter
    def tag_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_mode", value)

    @property
    @pulumi.getter(name="timeBasedColoring")
    def time_based_coloring(self) -> Optional[pulumi.Input[bool]]:
        """
        For x-y scatterplots, whether to color more recent points as darker than older points.
        """
        return pulumi.get(self, "time_based_coloring")

    @time_based_coloring.setter
    def time_based_coloring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "time_based_coloring", value)

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[int]]:
        """
        Width, in minutes, of the time window to use for `last` windowing.
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "window_size", value)

    @property
    @pulumi.getter
    def windowing(self) -> Optional[pulumi.Input[str]]:
        """
        For the tabular view, whether to use the full time window for the query or the last X minutes.
        Valid options are `full` or `last`.
        """
        return pulumi.get(self, "windowing")

    @windowing.setter
    def windowing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "windowing", value)

    @property
    @pulumi.getter
    def xmax(self) -> Optional[pulumi.Input[float]]:
        """
        For x-y scatterplots, max value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmax")

    @xmax.setter
    def xmax(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "xmax", value)

    @property
    @pulumi.getter
    def xmin(self) -> Optional[pulumi.Input[float]]:
        """
        For x-y scatterplots, min value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmin")

    @xmin.setter
    def xmin(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "xmin", value)

    @property
    @pulumi.getter(name="y0ScaleSiBy1024")
    def y0_scale_si_by1024(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to scale numerical magnitude labels for left Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        """
        return pulumi.get(self, "y0_scale_si_by1024")

    @y0_scale_si_by1024.setter
    def y0_scale_si_by1024(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "y0_scale_si_by1024", value)

    @property
    @pulumi.getter(name="y0UnitAutoscaling")
    def y0_unit_autoscaling(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y0_unit_autoscaling")

    @y0_unit_autoscaling.setter
    def y0_unit_autoscaling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "y0_unit_autoscaling", value)

    @property
    @pulumi.getter(name="y1ScaleSiBy1024")
    def y1_scale_si_by1024(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to scale numerical magnitude labels for right Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        """
        return pulumi.get(self, "y1_scale_si_by1024")

    @y1_scale_si_by1024.setter
    def y1_scale_si_by1024(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "y1_scale_si_by1024", value)

    @property
    @pulumi.getter(name="y1UnitAutoscaling")
    def y1_unit_autoscaling(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y1_unit_autoscaling")

    @y1_unit_autoscaling.setter
    def y1_unit_autoscaling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "y1_unit_autoscaling", value)

    @property
    @pulumi.getter(name="y1Units")
    def y1_units(self) -> Optional[pulumi.Input[str]]:
        """
        For plots with multiple Y-axes, units for right side Y-axis.
        """
        return pulumi.get(self, "y1_units")

    @y1_units.setter
    def y1_units(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "y1_units", value)

    @property
    @pulumi.getter
    def y1max(self) -> Optional[pulumi.Input[float]]:
        """
        For plots with multiple Y-axes, max value for the right side Y-axis. Set null for auto.
        """
        return pulumi.get(self, "y1max")

    @y1max.setter
    def y1max(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "y1max", value)

    @property
    @pulumi.getter
    def y1min(self) -> Optional[pulumi.Input[float]]:
        """
        For plots with multiple Y-axes, min value for the right side Y-axis. Set null for auto.
        """
        return pulumi.get(self, "y1min")

    @y1min.setter
    def y1min(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "y1min", value)

    @property
    @pulumi.getter
    def ymax(self) -> Optional[pulumi.Input[float]]:
        """
        For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymax")

    @ymax.setter
    def ymax(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ymax", value)

    @property
    @pulumi.getter
    def ymin(self) -> Optional[pulumi.Input[float]]:
        """
        For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymin")

    @ymin.setter
    def ymin(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ymin", value)


@pulumi.input_type
class DashboardSectionRowChartSourceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 query: pulumi.Input[str],
                 disabled: Optional[pulumi.Input[bool]] = None,
                 query_builder_enabled: Optional[pulumi.Input[bool]] = None,
                 scatter_plot_source: Optional[pulumi.Input[str]] = None,
                 source_description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of the source.
        :param pulumi.Input[str] query: Query expression to plot on the chart.
        :param pulumi.Input[bool] disabled: Whether the source is disabled.
        :param pulumi.Input[bool] query_builder_enabled: Whether or not this source line should have the query builder enabled.
        :param pulumi.Input[str] scatter_plot_source: For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        :param pulumi.Input[str] source_description: A description for the purpose of this source.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if query_builder_enabled is not None:
            pulumi.set(__self__, "query_builder_enabled", query_builder_enabled)
        if scatter_plot_source is not None:
            pulumi.set(__self__, "scatter_plot_source", scatter_plot_source)
        if source_description is not None:
            pulumi.set(__self__, "source_description", source_description)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        Query expression to plot on the chart.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the source is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="queryBuilderEnabled")
    def query_builder_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this source line should have the query builder enabled.
        """
        return pulumi.get(self, "query_builder_enabled")

    @query_builder_enabled.setter
    def query_builder_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_builder_enabled", value)

    @property
    @pulumi.getter(name="scatterPlotSource")
    def scatter_plot_source(self) -> Optional[pulumi.Input[str]]:
        """
        For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        """
        return pulumi.get(self, "scatter_plot_source")

    @scatter_plot_source.setter
    def scatter_plot_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scatter_plot_source", value)

    @property
    @pulumi.getter(name="sourceDescription")
    def source_description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the purpose of this source.
        """
        return pulumi.get(self, "source_description")

    @source_description.setter
    def source_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_description", value)


@pulumi.input_type
class MetricsPolicyPolicyRuleArgs:
    def __init__(__self__, *,
                 access_type: pulumi.Input[str],
                 description: pulumi.Input[str],
                 name: pulumi.Input[str],
                 prefixes: pulumi.Input[Sequence[pulumi.Input[str]]],
                 tags_anded: pulumi.Input[bool],
                 account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleTagArgs']]]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] access_type: Valid options are `ALLOW` and `BLOCK`.
        :param pulumi.Input[str] description: A detailed description of the Metrics Policy. The description is visible only when you edit the rule.
        :param pulumi.Input[str] name: The unique name identifier for a Metrics Policy. The name is visible on the Metrics Security Policy page.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prefixes: List of prefixes to match metrics on. You can specify the full metric name or use a wildcard character in metric names, sources, or point tags. The wildcard character alone (*) means all metrics.
        :param pulumi.Input[bool] tags_anded: Bool where `true` require all tags are met by selected metrics, else `false` select metrics that match any give tag.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] account_ids: List of account ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: List of role ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        :param pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleTagArgs']]] tags: List of Key/Value tags to select target metrics for policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_group_ids: List of user group ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "prefixes", prefixes)
        pulumi.set(__self__, "tags_anded", tags_anded)
        if account_ids is not None:
            pulumi.set(__self__, "account_ids", account_ids)
        if role_ids is not None:
            pulumi.set(__self__, "role_ids", role_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_group_ids is not None:
            pulumi.set(__self__, "user_group_ids", user_group_ids)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Input[str]:
        """
        Valid options are `ALLOW` and `BLOCK`.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_type", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        A detailed description of the Metrics Policy. The description is visible only when you edit the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The unique name identifier for a Metrics Policy. The name is visible on the Metrics Security Policy page.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def prefixes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of prefixes to match metrics on. You can specify the full metric name or use a wildcard character in metric names, sources, or point tags. The wildcard character alone (*) means all metrics.
        """
        return pulumi.get(self, "prefixes")

    @prefixes.setter
    def prefixes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "prefixes", value)

    @property
    @pulumi.getter(name="tagsAnded")
    def tags_anded(self) -> pulumi.Input[bool]:
        """
        Bool where `true` require all tags are met by selected metrics, else `false` select metrics that match any give tag.
        """
        return pulumi.get(self, "tags_anded")

    @tags_anded.setter
    def tags_anded(self, value: pulumi.Input[bool]):
        pulumi.set(self, "tags_anded", value)

    @property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of account ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        return pulumi.get(self, "account_ids")

    @account_ids.setter
    def account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "account_ids", value)

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of role ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        return pulumi.get(self, "role_ids")

    @role_ids.setter
    def role_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleTagArgs']]]]:
        """
        List of Key/Value tags to select target metrics for policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user group ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        return pulumi.get(self, "user_group_ids")

    @user_group_ids.setter
    def user_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_group_ids", value)


@pulumi.input_type
class MetricsPolicyPolicyRuleTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The tag's key.
        :param pulumi.Input[str] value: The tag's value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The tag's key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The tag's value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


