# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetAlertResult',
    'AwaitableGetAlertResult',
    'get_alert',
    'get_alert_output',
]

@pulumi.output_type
class GetAlertResult:
    """
    A collection of values returned by getAlert.
    """
    def __init__(__self__, additional_information=None, alert_type=None, can_modifies=None, can_views=None, condition=None, conditions=None, display_expression=None, evaluate_realtime_data=None, failing_host_label_pairs=None, id=None, in_maintenance_host_label_pairs=None, include_obsolete_metrics=None, minutes=None, name=None, notification_resend_frequency_minutes=None, process_rate_minutes=None, resolve_after_minutes=None, severity=None, severity_lists=None, statuses=None, tags=None, target=None, targets=None):
        if additional_information and not isinstance(additional_information, str):
            raise TypeError("Expected argument 'additional_information' to be a str")
        pulumi.set(__self__, "additional_information", additional_information)
        if alert_type and not isinstance(alert_type, str):
            raise TypeError("Expected argument 'alert_type' to be a str")
        pulumi.set(__self__, "alert_type", alert_type)
        if can_modifies and not isinstance(can_modifies, list):
            raise TypeError("Expected argument 'can_modifies' to be a list")
        pulumi.set(__self__, "can_modifies", can_modifies)
        if can_views and not isinstance(can_views, list):
            raise TypeError("Expected argument 'can_views' to be a list")
        pulumi.set(__self__, "can_views", can_views)
        if condition and not isinstance(condition, str):
            raise TypeError("Expected argument 'condition' to be a str")
        pulumi.set(__self__, "condition", condition)
        if conditions and not isinstance(conditions, dict):
            raise TypeError("Expected argument 'conditions' to be a dict")
        pulumi.set(__self__, "conditions", conditions)
        if display_expression and not isinstance(display_expression, str):
            raise TypeError("Expected argument 'display_expression' to be a str")
        pulumi.set(__self__, "display_expression", display_expression)
        if evaluate_realtime_data and not isinstance(evaluate_realtime_data, bool):
            raise TypeError("Expected argument 'evaluate_realtime_data' to be a bool")
        pulumi.set(__self__, "evaluate_realtime_data", evaluate_realtime_data)
        if failing_host_label_pairs and not isinstance(failing_host_label_pairs, list):
            raise TypeError("Expected argument 'failing_host_label_pairs' to be a list")
        pulumi.set(__self__, "failing_host_label_pairs", failing_host_label_pairs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if in_maintenance_host_label_pairs and not isinstance(in_maintenance_host_label_pairs, list):
            raise TypeError("Expected argument 'in_maintenance_host_label_pairs' to be a list")
        pulumi.set(__self__, "in_maintenance_host_label_pairs", in_maintenance_host_label_pairs)
        if include_obsolete_metrics and not isinstance(include_obsolete_metrics, bool):
            raise TypeError("Expected argument 'include_obsolete_metrics' to be a bool")
        pulumi.set(__self__, "include_obsolete_metrics", include_obsolete_metrics)
        if minutes and not isinstance(minutes, int):
            raise TypeError("Expected argument 'minutes' to be a int")
        pulumi.set(__self__, "minutes", minutes)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notification_resend_frequency_minutes and not isinstance(notification_resend_frequency_minutes, int):
            raise TypeError("Expected argument 'notification_resend_frequency_minutes' to be a int")
        pulumi.set(__self__, "notification_resend_frequency_minutes", notification_resend_frequency_minutes)
        if process_rate_minutes and not isinstance(process_rate_minutes, int):
            raise TypeError("Expected argument 'process_rate_minutes' to be a int")
        pulumi.set(__self__, "process_rate_minutes", process_rate_minutes)
        if resolve_after_minutes and not isinstance(resolve_after_minutes, int):
            raise TypeError("Expected argument 'resolve_after_minutes' to be a int")
        pulumi.set(__self__, "resolve_after_minutes", resolve_after_minutes)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if severity_lists and not isinstance(severity_lists, list):
            raise TypeError("Expected argument 'severity_lists' to be a list")
        pulumi.set(__self__, "severity_lists", severity_lists)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)
        if targets and not isinstance(targets, dict):
            raise TypeError("Expected argument 'targets' to be a dict")
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> str:
        """
        User-supplied additional explanatory information about this alert.
        """
        return pulumi.get(self, "additional_information")

    @property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> str:
        """
        The type of alert in Wavefront.
        """
        return pulumi.get(self, "alert_type")

    @property
    @pulumi.getter(name="canModifies")
    def can_modifies(self) -> Sequence[str]:
        """
        A list of users or groups that can modify the alert.
        """
        return pulumi.get(self, "can_modifies")

    @property
    @pulumi.getter(name="canViews")
    def can_views(self) -> Sequence[str]:
        """
        A list of users or groups that can view the alert.
        """
        return pulumi.get(self, "can_views")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        A Wavefront query that is evaluated at regular intervals (default is 1 minute). The alert fires and notifications are triggered when a data series matching this query evaluates to a non-zero value for a set number of consecutive minutes.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def conditions(self) -> Mapping[str, str]:
        """
        A map of severity to condition for which this alert will trigger.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="displayExpression")
    def display_expression(self) -> str:
        """
        A second query the results of which are displayed in the alert user interface instead of the condition query.
        """
        return pulumi.get(self, "display_expression")

    @property
    @pulumi.getter(name="evaluateRealtimeData")
    def evaluate_realtime_data(self) -> bool:
        """
        A Boolean flag to enable real-time evaluation.
        """
        return pulumi.get(self, "evaluate_realtime_data")

    @property
    @pulumi.getter(name="failingHostLabelPairs")
    def failing_host_label_pairs(self) -> Sequence['outputs.GetAlertFailingHostLabelPairResult']:
        """
        A list of failing host label pairs.
        """
        return pulumi.get(self, "failing_host_label_pairs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the alert in Wavefront.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inMaintenanceHostLabelPairs")
    def in_maintenance_host_label_pairs(self) -> Sequence['outputs.GetAlertInMaintenanceHostLabelPairResult']:
        """
        A list of in maintenance host label pairs.
        """
        return pulumi.get(self, "in_maintenance_host_label_pairs")

    @property
    @pulumi.getter(name="includeObsoleteMetrics")
    def include_obsolete_metrics(self) -> bool:
        """
        A Boolean flag indicating whether to include obsolete metrics or not.
        """
        return pulumi.get(self, "include_obsolete_metrics")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        The number of consecutive minutes that a series matching the condition query must evaluate to "true" (non-zero value) before the alert fires.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the alert as it is displayed in Wavefront.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationResendFrequencyMinutes")
    def notification_resend_frequency_minutes(self) -> int:
        """
        How often to re-trigger a continually failing alert.
        """
        return pulumi.get(self, "notification_resend_frequency_minutes")

    @property
    @pulumi.getter(name="processRateMinutes")
    def process_rate_minutes(self) -> int:
        """
        The specified query is executed every `process_rate_minutes` minutes.
        """
        return pulumi.get(self, "process_rate_minutes")

    @property
    @pulumi.getter(name="resolveAfterMinutes")
    def resolve_after_minutes(self) -> int:
        """
        The number of consecutive minutes that a firing series matching the condition query must evaluate to "false" (zero value) before the alert resolves.
        """
        return pulumi.get(self, "resolve_after_minutes")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The severity of the alert.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="severityLists")
    def severity_lists(self) -> Sequence[str]:
        return pulumi.get(self, "severity_lists")

    @property
    @pulumi.getter
    def statuses(self) -> Sequence[str]:
        """
        The status of the alert.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A set of tags assigned to the alert.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        An email address or integration endpoint (such as PagerDuty or webhook) to notify when the alert status changes.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Mapping[str, str]]:
        """
        A comma-separated list of the email addresses or integration endpoints (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
        """
        return pulumi.get(self, "targets")


class AwaitableGetAlertResult(GetAlertResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertResult(
            additional_information=self.additional_information,
            alert_type=self.alert_type,
            can_modifies=self.can_modifies,
            can_views=self.can_views,
            condition=self.condition,
            conditions=self.conditions,
            display_expression=self.display_expression,
            evaluate_realtime_data=self.evaluate_realtime_data,
            failing_host_label_pairs=self.failing_host_label_pairs,
            id=self.id,
            in_maintenance_host_label_pairs=self.in_maintenance_host_label_pairs,
            include_obsolete_metrics=self.include_obsolete_metrics,
            minutes=self.minutes,
            name=self.name,
            notification_resend_frequency_minutes=self.notification_resend_frequency_minutes,
            process_rate_minutes=self.process_rate_minutes,
            resolve_after_minutes=self.resolve_after_minutes,
            severity=self.severity,
            severity_lists=self.severity_lists,
            statuses=self.statuses,
            tags=self.tags,
            target=self.target,
            targets=self.targets)


def get_alert(id: Optional[str] = None,
              targets: Optional[Mapping[str, str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertResult:
    """
    Use this data source to get information about a Wavefront alert by its ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_wavefront as wavefront

    example = wavefront.get_alert(id="alert-id")
    ```


    :param str id: The ID associated with the alert data to be fetched.
    :param Mapping[str, str] targets: A comma-separated list of the email addresses or integration endpoints (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['targets'] = targets
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('wavefront:index/getAlert:getAlert', __args__, opts=opts, typ=GetAlertResult).value

    return AwaitableGetAlertResult(
        additional_information=__ret__.additional_information,
        alert_type=__ret__.alert_type,
        can_modifies=__ret__.can_modifies,
        can_views=__ret__.can_views,
        condition=__ret__.condition,
        conditions=__ret__.conditions,
        display_expression=__ret__.display_expression,
        evaluate_realtime_data=__ret__.evaluate_realtime_data,
        failing_host_label_pairs=__ret__.failing_host_label_pairs,
        id=__ret__.id,
        in_maintenance_host_label_pairs=__ret__.in_maintenance_host_label_pairs,
        include_obsolete_metrics=__ret__.include_obsolete_metrics,
        minutes=__ret__.minutes,
        name=__ret__.name,
        notification_resend_frequency_minutes=__ret__.notification_resend_frequency_minutes,
        process_rate_minutes=__ret__.process_rate_minutes,
        resolve_after_minutes=__ret__.resolve_after_minutes,
        severity=__ret__.severity,
        severity_lists=__ret__.severity_lists,
        statuses=__ret__.statuses,
        tags=__ret__.tags,
        target=__ret__.target,
        targets=__ret__.targets)


@_utilities.lift_output_func(get_alert)
def get_alert_output(id: Optional[pulumi.Input[str]] = None,
                     targets: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlertResult]:
    """
    Use this data source to get information about a Wavefront alert by its ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_wavefront as wavefront

    example = wavefront.get_alert(id="alert-id")
    ```


    :param str id: The ID associated with the alert data to be fetched.
    :param Mapping[str, str] targets: A comma-separated list of the email addresses or integration endpoints (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
    """
    ...
