# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetDerivedMetricResult',
    'AwaitableGetDerivedMetricResult',
    'get_derived_metric',
    'get_derived_metric_output',
]

@pulumi.output_type
class GetDerivedMetricResult:
    """
    A collection of values returned by getDerivedMetric.
    """
    def __init__(__self__, additional_information=None, create_user_id=None, created_epoch_millis=None, deleted=None, hosts_useds=None, id=None, in_trash=None, include_obsolete_metrics=None, last_error_message=None, last_failed_time=None, last_processed_millis=None, last_query_time=None, metrics_useds=None, minutes=None, name=None, points_scanned_at_last_query=None, process_rate_minutes=None, query=None, query_failing=None, query_qb_enabled=None, statuses=None, tags=None, update_user_id=None, updated_epoch_millis=None):
        if additional_information and not isinstance(additional_information, str):
            raise TypeError("Expected argument 'additional_information' to be a str")
        pulumi.set(__self__, "additional_information", additional_information)
        if create_user_id and not isinstance(create_user_id, str):
            raise TypeError("Expected argument 'create_user_id' to be a str")
        pulumi.set(__self__, "create_user_id", create_user_id)
        if created_epoch_millis and not isinstance(created_epoch_millis, int):
            raise TypeError("Expected argument 'created_epoch_millis' to be a int")
        pulumi.set(__self__, "created_epoch_millis", created_epoch_millis)
        if deleted and not isinstance(deleted, bool):
            raise TypeError("Expected argument 'deleted' to be a bool")
        pulumi.set(__self__, "deleted", deleted)
        if hosts_useds and not isinstance(hosts_useds, list):
            raise TypeError("Expected argument 'hosts_useds' to be a list")
        pulumi.set(__self__, "hosts_useds", hosts_useds)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if in_trash and not isinstance(in_trash, bool):
            raise TypeError("Expected argument 'in_trash' to be a bool")
        pulumi.set(__self__, "in_trash", in_trash)
        if include_obsolete_metrics and not isinstance(include_obsolete_metrics, bool):
            raise TypeError("Expected argument 'include_obsolete_metrics' to be a bool")
        pulumi.set(__self__, "include_obsolete_metrics", include_obsolete_metrics)
        if last_error_message and not isinstance(last_error_message, str):
            raise TypeError("Expected argument 'last_error_message' to be a str")
        pulumi.set(__self__, "last_error_message", last_error_message)
        if last_failed_time and not isinstance(last_failed_time, int):
            raise TypeError("Expected argument 'last_failed_time' to be a int")
        pulumi.set(__self__, "last_failed_time", last_failed_time)
        if last_processed_millis and not isinstance(last_processed_millis, int):
            raise TypeError("Expected argument 'last_processed_millis' to be a int")
        pulumi.set(__self__, "last_processed_millis", last_processed_millis)
        if last_query_time and not isinstance(last_query_time, int):
            raise TypeError("Expected argument 'last_query_time' to be a int")
        pulumi.set(__self__, "last_query_time", last_query_time)
        if metrics_useds and not isinstance(metrics_useds, list):
            raise TypeError("Expected argument 'metrics_useds' to be a list")
        pulumi.set(__self__, "metrics_useds", metrics_useds)
        if minutes and not isinstance(minutes, int):
            raise TypeError("Expected argument 'minutes' to be a int")
        pulumi.set(__self__, "minutes", minutes)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if points_scanned_at_last_query and not isinstance(points_scanned_at_last_query, int):
            raise TypeError("Expected argument 'points_scanned_at_last_query' to be a int")
        pulumi.set(__self__, "points_scanned_at_last_query", points_scanned_at_last_query)
        if process_rate_minutes and not isinstance(process_rate_minutes, int):
            raise TypeError("Expected argument 'process_rate_minutes' to be a int")
        pulumi.set(__self__, "process_rate_minutes", process_rate_minutes)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if query_failing and not isinstance(query_failing, bool):
            raise TypeError("Expected argument 'query_failing' to be a bool")
        pulumi.set(__self__, "query_failing", query_failing)
        if query_qb_enabled and not isinstance(query_qb_enabled, bool):
            raise TypeError("Expected argument 'query_qb_enabled' to be a bool")
        pulumi.set(__self__, "query_qb_enabled", query_qb_enabled)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if update_user_id and not isinstance(update_user_id, str):
            raise TypeError("Expected argument 'update_user_id' to be a str")
        pulumi.set(__self__, "update_user_id", update_user_id)
        if updated_epoch_millis and not isinstance(updated_epoch_millis, int):
            raise TypeError("Expected argument 'updated_epoch_millis' to be a int")
        pulumi.set(__self__, "updated_epoch_millis", updated_epoch_millis)

    @property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> str:
        """
        User-supplied additional explanatory information about the derived metric.
        """
        return pulumi.get(self, "additional_information")

    @property
    @pulumi.getter(name="createUserId")
    def create_user_id(self) -> str:
        """
        The ID of the user who created the derived metric.
        """
        return pulumi.get(self, "create_user_id")

    @property
    @pulumi.getter(name="createdEpochMillis")
    def created_epoch_millis(self) -> int:
        """
        The timestamp in epoch milliseconds indicating when the derived metric is created.
        """
        return pulumi.get(self, "created_epoch_millis")

    @property
    @pulumi.getter
    def deleted(self) -> bool:
        """
        A Boolean flag indicating whether the derived metric is deleted or not.
        """
        return pulumi.get(self, "deleted")

    @property
    @pulumi.getter(name="hostsUseds")
    def hosts_useds(self) -> Sequence[str]:
        """
        A list of hosts used in the derived metric.
        """
        return pulumi.get(self, "hosts_useds")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the derived metric in Wavefront.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inTrash")
    def in_trash(self) -> bool:
        """
        A Boolean variable indicating trash status.
        """
        return pulumi.get(self, "in_trash")

    @property
    @pulumi.getter(name="includeObsoleteMetrics")
    def include_obsolete_metrics(self) -> bool:
        """
        A Boolean flag indicating whether to include obsolete metrics or not.
        """
        return pulumi.get(self, "include_obsolete_metrics")

    @property
    @pulumi.getter(name="lastErrorMessage")
    def last_error_message(self) -> str:
        """
        Last error message occurred.
        """
        return pulumi.get(self, "last_error_message")

    @property
    @pulumi.getter(name="lastFailedTime")
    def last_failed_time(self) -> int:
        """
        Timestamp of the last failed derived metric.
        """
        return pulumi.get(self, "last_failed_time")

    @property
    @pulumi.getter(name="lastProcessedMillis")
    def last_processed_millis(self) -> int:
        """
        The last processed timestamp.
        """
        return pulumi.get(self, "last_processed_millis")

    @property
    @pulumi.getter(name="lastQueryTime")
    def last_query_time(self) -> int:
        """
        The timestamp indicating the last time the query was executed.
        """
        return pulumi.get(self, "last_query_time")

    @property
    @pulumi.getter(name="metricsUseds")
    def metrics_useds(self) -> Sequence[str]:
        """
        A list of metrics used in the derived metric.
        """
        return pulumi.get(self, "metrics_useds")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        How frequently the query generating the derived metric is run.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the derived metric in Wavefront.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pointsScannedAtLastQuery")
    def points_scanned_at_last_query(self) -> int:
        """
        The number of points scanned when last query was executed.
        """
        return pulumi.get(self, "points_scanned_at_last_query")

    @property
    @pulumi.getter(name="processRateMinutes")
    def process_rate_minutes(self) -> int:
        """
        The specified query is executed every `process_rate_minutes` minutes.
        """
        return pulumi.get(self, "process_rate_minutes")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        A Wavefront query that is evaluated at regular intervals (default is 1 minute).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="queryFailing")
    def query_failing(self) -> bool:
        """
        A Boolean variable indicating whether query is failing for the derived metric.
        """
        return pulumi.get(self, "query_failing")

    @property
    @pulumi.getter(name="queryQbEnabled")
    def query_qb_enabled(self) -> bool:
        """
        A Boolean flag for enabling `query_qb`
        """
        return pulumi.get(self, "query_qb_enabled")

    @property
    @pulumi.getter
    def statuses(self) -> Sequence[str]:
        """
        The status of the derived metric.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A set of tags assigned to the derived metric.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateUserId")
    def update_user_id(self) -> str:
        """
        The ID of the user who updated the derived metric.
        """
        return pulumi.get(self, "update_user_id")

    @property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> int:
        """
        The timestamp in epoch milliseconds indicating when the derived metric is updated.
        """
        return pulumi.get(self, "updated_epoch_millis")


class AwaitableGetDerivedMetricResult(GetDerivedMetricResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDerivedMetricResult(
            additional_information=self.additional_information,
            create_user_id=self.create_user_id,
            created_epoch_millis=self.created_epoch_millis,
            deleted=self.deleted,
            hosts_useds=self.hosts_useds,
            id=self.id,
            in_trash=self.in_trash,
            include_obsolete_metrics=self.include_obsolete_metrics,
            last_error_message=self.last_error_message,
            last_failed_time=self.last_failed_time,
            last_processed_millis=self.last_processed_millis,
            last_query_time=self.last_query_time,
            metrics_useds=self.metrics_useds,
            minutes=self.minutes,
            name=self.name,
            points_scanned_at_last_query=self.points_scanned_at_last_query,
            process_rate_minutes=self.process_rate_minutes,
            query=self.query,
            query_failing=self.query_failing,
            query_qb_enabled=self.query_qb_enabled,
            statuses=self.statuses,
            tags=self.tags,
            update_user_id=self.update_user_id,
            updated_epoch_millis=self.updated_epoch_millis)


def get_derived_metric(id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDerivedMetricResult:
    """
    Use this data source to get information about a certain Wavefront derived metric by its ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_wavefront as wavefront

    example = wavefront.get_derived_metric(id="derived_metric_id")
    ```


    :param str id: The ID associated with the derived metric data to be fetched.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('wavefront:index/getDerivedMetric:getDerivedMetric', __args__, opts=opts, typ=GetDerivedMetricResult).value

    return AwaitableGetDerivedMetricResult(
        additional_information=__ret__.additional_information,
        create_user_id=__ret__.create_user_id,
        created_epoch_millis=__ret__.created_epoch_millis,
        deleted=__ret__.deleted,
        hosts_useds=__ret__.hosts_useds,
        id=__ret__.id,
        in_trash=__ret__.in_trash,
        include_obsolete_metrics=__ret__.include_obsolete_metrics,
        last_error_message=__ret__.last_error_message,
        last_failed_time=__ret__.last_failed_time,
        last_processed_millis=__ret__.last_processed_millis,
        last_query_time=__ret__.last_query_time,
        metrics_useds=__ret__.metrics_useds,
        minutes=__ret__.minutes,
        name=__ret__.name,
        points_scanned_at_last_query=__ret__.points_scanned_at_last_query,
        process_rate_minutes=__ret__.process_rate_minutes,
        query=__ret__.query,
        query_failing=__ret__.query_failing,
        query_qb_enabled=__ret__.query_qb_enabled,
        statuses=__ret__.statuses,
        tags=__ret__.tags,
        update_user_id=__ret__.update_user_id,
        updated_epoch_millis=__ret__.updated_epoch_millis)


@_utilities.lift_output_func(get_derived_metric)
def get_derived_metric_output(id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDerivedMetricResult]:
    """
    Use this data source to get information about a certain Wavefront derived metric by its ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_wavefront as wavefront

    example = wavefront.get_derived_metric(id="derived_metric_id")
    ```


    :param str id: The ID associated with the derived metric data to be fetched.
    """
    ...
