# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, customer=None, email=None, id=None, last_successful_login=None, permissions=None, user_group_ids=None):
        if customer and not isinstance(customer, str):
            raise TypeError("Expected argument 'customer' to be a str")
        pulumi.set(__self__, "customer", customer)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_successful_login and not isinstance(last_successful_login, int):
            raise TypeError("Expected argument 'last_successful_login' to be a int")
        pulumi.set(__self__, "last_successful_login", last_successful_login)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if user_group_ids and not isinstance(user_group_ids, list):
            raise TypeError("Expected argument 'user_group_ids' to be a list")
        pulumi.set(__self__, "user_group_ids", user_group_ids)

    @property
    @pulumi.getter
    def customer(self) -> str:
        """
        The customer the user is associated with.
        """
        return pulumi.get(self, "customer")

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastSuccessfulLogin")
    def last_successful_login(self) -> int:
        """
        When the user last logged in to Wavefront.
        """
        return pulumi.get(self, "last_successful_login")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        List of permissions granted to a user.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Sequence[str]:
        """
        List of User Group Ids the user is a member of.
        """
        return pulumi.get(self, "user_group_ids")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            customer=self.customer,
            email=self.email,
            id=self.id,
            last_successful_login=self.last_successful_login,
            permissions=self.permissions,
            user_group_ids=self.user_group_ids)


def get_user(email: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Use this data source to get information for a given user by email from Wavefront.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_wavefront as wavefront

    example = wavefront.get_user(email="example.user@example.com")
    ```


    :param str email: The email associated with the user data to be fetched.
    """
    __args__ = dict()
    __args__['email'] = email
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('wavefront:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        customer=__ret__.customer,
        email=__ret__.email,
        id=__ret__.id,
        last_successful_login=__ret__.last_successful_login,
        permissions=__ret__.permissions,
        user_group_ids=__ret__.user_group_ids)


@_utilities.lift_output_func(get_user)
def get_user_output(email: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    Use this data source to get information for a given user by email from Wavefront.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_wavefront as wavefront

    example = wavefront.get_user(email="example.user@example.com")
    ```


    :param str email: The email associated with the user data to be fetched.
    """
    ...
