# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricsPolicyArgs', 'MetricsPolicy']

@pulumi.input_type
class MetricsPolicyArgs:
    def __init__(__self__, *,
                 policy_rules: pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleArgs']]]):
        """
        The set of arguments for constructing a MetricsPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleArgs']]] policy_rules: List of Metrics Policies, must have at least one entry.
        """
        pulumi.set(__self__, "policy_rules", policy_rules)

    @property
    @pulumi.getter(name="policyRules")
    def policy_rules(self) -> pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleArgs']]]:
        """
        List of Metrics Policies, must have at least one entry.
        """
        return pulumi.get(self, "policy_rules")

    @policy_rules.setter
    def policy_rules(self, value: pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleArgs']]]):
        pulumi.set(self, "policy_rules", value)


@pulumi.input_type
class _MetricsPolicyState:
    def __init__(__self__, *,
                 customer: Optional[pulumi.Input[str]] = None,
                 policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleArgs']]]] = None,
                 updated_epoch_millis: Optional[pulumi.Input[int]] = None,
                 updater_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MetricsPolicy resources.
        :param pulumi.Input[str] customer: The customer the user is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleArgs']]] policy_rules: List of Metrics Policies, must have at least one entry.
        :param pulumi.Input[int] updated_epoch_millis: When the policy was applied in epoch_millis.
        :param pulumi.Input[str] updater_id: The account_id who applied the current policy.
        """
        if customer is not None:
            pulumi.set(__self__, "customer", customer)
        if policy_rules is not None:
            pulumi.set(__self__, "policy_rules", policy_rules)
        if updated_epoch_millis is not None:
            pulumi.set(__self__, "updated_epoch_millis", updated_epoch_millis)
        if updater_id is not None:
            pulumi.set(__self__, "updater_id", updater_id)

    @property
    @pulumi.getter
    def customer(self) -> Optional[pulumi.Input[str]]:
        """
        The customer the user is associated with.
        """
        return pulumi.get(self, "customer")

    @customer.setter
    def customer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer", value)

    @property
    @pulumi.getter(name="policyRules")
    def policy_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleArgs']]]]:
        """
        List of Metrics Policies, must have at least one entry.
        """
        return pulumi.get(self, "policy_rules")

    @policy_rules.setter
    def policy_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricsPolicyPolicyRuleArgs']]]]):
        pulumi.set(self, "policy_rules", value)

    @property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> Optional[pulumi.Input[int]]:
        """
        When the policy was applied in epoch_millis.
        """
        return pulumi.get(self, "updated_epoch_millis")

    @updated_epoch_millis.setter
    def updated_epoch_millis(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "updated_epoch_millis", value)

    @property
    @pulumi.getter(name="updaterId")
    def updater_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account_id who applied the current policy.
        """
        return pulumi.get(self, "updater_id")

    @updater_id.setter
    def updater_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updater_id", value)


class MetricsPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricsPolicyPolicyRuleArgs']]]]] = None,
                 __props__=None):
        """
        Provides a Wavefront Metrics Policy Resource. This allows management of Metrics Policy to control access to time series, histograms, and delta counters

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        everyone = wavefront.get_default_user_group()
        main = wavefront.MetricsPolicy("main", policy_rules=[wavefront.MetricsPolicyPolicyRuleArgs(
            name="Allow All Metrics",
            description="Predefined policy rule. Allows access to all metrics (timeseries, histograms, and counters) for all accounts. If this rule is removed, all accounts can access all metrics if there are no matching blocking rules.",
            prefixes=["*"],
            tags_anded=False,
            access_type="ALLOW",
            user_group_ids=[everyone.group_id],
        )])
        ```
        ## Data Source

        Provides a Wavefront Metrics Policy Data Source. This allows looking up the current policy and associated rules.

        ### Example

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        policy_metrics_policy = wavefront.get_metrics_policy()
        pulumi.export("policy", policy_metrics_policy)
        ```

        ## Import

        Users can be imported by using the `updated_epoch_millis`, e.g.

        ```sh
         $ pulumi import wavefront:index/metricsPolicy:MetricsPolicy some_metrics_policy 1651846476678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricsPolicyPolicyRuleArgs']]]] policy_rules: List of Metrics Policies, must have at least one entry.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricsPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Wavefront Metrics Policy Resource. This allows management of Metrics Policy to control access to time series, histograms, and delta counters

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        everyone = wavefront.get_default_user_group()
        main = wavefront.MetricsPolicy("main", policy_rules=[wavefront.MetricsPolicyPolicyRuleArgs(
            name="Allow All Metrics",
            description="Predefined policy rule. Allows access to all metrics (timeseries, histograms, and counters) for all accounts. If this rule is removed, all accounts can access all metrics if there are no matching blocking rules.",
            prefixes=["*"],
            tags_anded=False,
            access_type="ALLOW",
            user_group_ids=[everyone.group_id],
        )])
        ```
        ## Data Source

        Provides a Wavefront Metrics Policy Data Source. This allows looking up the current policy and associated rules.

        ### Example

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        policy_metrics_policy = wavefront.get_metrics_policy()
        pulumi.export("policy", policy_metrics_policy)
        ```

        ## Import

        Users can be imported by using the `updated_epoch_millis`, e.g.

        ```sh
         $ pulumi import wavefront:index/metricsPolicy:MetricsPolicy some_metrics_policy 1651846476678
        ```

        :param str resource_name: The name of the resource.
        :param MetricsPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricsPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricsPolicyPolicyRuleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricsPolicyArgs.__new__(MetricsPolicyArgs)

            if policy_rules is None and not opts.urn:
                raise TypeError("Missing required property 'policy_rules'")
            __props__.__dict__["policy_rules"] = policy_rules
            __props__.__dict__["customer"] = None
            __props__.__dict__["updated_epoch_millis"] = None
            __props__.__dict__["updater_id"] = None
        super(MetricsPolicy, __self__).__init__(
            'wavefront:index/metricsPolicy:MetricsPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            customer: Optional[pulumi.Input[str]] = None,
            policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricsPolicyPolicyRuleArgs']]]]] = None,
            updated_epoch_millis: Optional[pulumi.Input[int]] = None,
            updater_id: Optional[pulumi.Input[str]] = None) -> 'MetricsPolicy':
        """
        Get an existing MetricsPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customer: The customer the user is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricsPolicyPolicyRuleArgs']]]] policy_rules: List of Metrics Policies, must have at least one entry.
        :param pulumi.Input[int] updated_epoch_millis: When the policy was applied in epoch_millis.
        :param pulumi.Input[str] updater_id: The account_id who applied the current policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricsPolicyState.__new__(_MetricsPolicyState)

        __props__.__dict__["customer"] = customer
        __props__.__dict__["policy_rules"] = policy_rules
        __props__.__dict__["updated_epoch_millis"] = updated_epoch_millis
        __props__.__dict__["updater_id"] = updater_id
        return MetricsPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def customer(self) -> pulumi.Output[str]:
        """
        The customer the user is associated with.
        """
        return pulumi.get(self, "customer")

    @property
    @pulumi.getter(name="policyRules")
    def policy_rules(self) -> pulumi.Output[Sequence['outputs.MetricsPolicyPolicyRule']]:
        """
        List of Metrics Policies, must have at least one entry.
        """
        return pulumi.get(self, "policy_rules")

    @property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> pulumi.Output[int]:
        """
        When the policy was applied in epoch_millis.
        """
        return pulumi.get(self, "updated_epoch_millis")

    @property
    @pulumi.getter(name="updaterId")
    def updater_id(self) -> pulumi.Output[str]:
        """
        The account_id who applied the current policy.
        """
        return pulumi.get(self, "updater_id")

