# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'AlertTargetRoute',
    'CloudIntegrationNewRelicMetricFilter',
    'DashboardParameterDetail',
    'DashboardSection',
    'DashboardSectionRow',
    'DashboardSectionRowChart',
    'DashboardSectionRowChartChartSetting',
    'DashboardSectionRowChartSource',
    'MetricsPolicyPolicyRule',
    'MetricsPolicyPolicyRuleTag',
    'GetAlertFailingHostLabelPairResult',
    'GetAlertInMaintenanceHostLabelPairResult',
    'GetAlertsAlertResult',
    'GetAlertsAlertFailingHostLabelPairResult',
    'GetAlertsAlertInMaintenanceHostLabelPairResult',
    'GetDashboardParameterDetailResult',
    'GetDashboardSectionResult',
    'GetDashboardSectionRowResult',
    'GetDashboardSectionRowChartResult',
    'GetDashboardSectionRowChartChartSettingResult',
    'GetDashboardSectionRowChartSourceResult',
    'GetDashboardsDashboardResult',
    'GetDashboardsDashboardParameterDetailResult',
    'GetDashboardsDashboardSectionResult',
    'GetDashboardsDashboardSectionRowResult',
    'GetDashboardsDashboardSectionRowChartResult',
    'GetDashboardsDashboardSectionRowChartChartSettingResult',
    'GetDashboardsDashboardSectionRowChartSourceResult',
    'GetDerivedMetricsDerivedMetricResult',
    'GetEventsEventResult',
    'GetExternalLinksExternalLinkResult',
    'GetMaintenanceWindowAllMaintenanceWindowResult',
    'GetMetricsPolicyPolicyRuleResult',
    'GetMetricsPolicyPolicyRuleTagResult',
    'GetRolesRoleResult',
    'GetUserGroupsUserGroupResult',
    'GetUsersUserResult',
]

@pulumi.output_type
class AlertTargetRoute(dict):
    def __init__(__self__, *,
                 method: str,
                 target: str,
                 filter: Optional[Mapping[str, str]] = None):
        """
        :param str method: The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "target", target)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def target(self) -> str:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def filter(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "filter")


@pulumi.output_type
class CloudIntegrationNewRelicMetricFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appName":
            suggest = "app_name"
        elif key == "metricFilterRegex":
            suggest = "metric_filter_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudIntegrationNewRelicMetricFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudIntegrationNewRelicMetricFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudIntegrationNewRelicMetricFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_name: str,
                 metric_filter_regex: str):
        """
        :param str app_name: The name of a NewRelic App.
        :param str metric_filter_regex: A regular expression that a metric name must match (case-insensitively) in order to be ingested.
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "metric_filter_regex", metric_filter_regex)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> str:
        """
        The name of a NewRelic App.
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> str:
        """
        A regular expression that a metric name must match (case-insensitively) in order to be ingested.
        """
        return pulumi.get(self, "metric_filter_regex")


@pulumi.output_type
class DashboardParameterDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "hideFromView":
            suggest = "hide_from_view"
        elif key == "parameterType":
            suggest = "parameter_type"
        elif key == "valuesToReadableStrings":
            suggest = "values_to_readable_strings"
        elif key == "dynamicFieldType":
            suggest = "dynamic_field_type"
        elif key == "queryValue":
            suggest = "query_value"
        elif key == "tagKey":
            suggest = "tag_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardParameterDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardParameterDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardParameterDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: str,
                 hide_from_view: bool,
                 label: str,
                 name: str,
                 parameter_type: str,
                 values_to_readable_strings: Mapping[str, str],
                 dynamic_field_type: Optional[str] = None,
                 query_value: Optional[str] = None,
                 tag_key: Optional[str] = None):
        """
        :param str default_value: The default value of the parameter.
        :param bool hide_from_view: If `true` the parameter will only be shown on the edit view of the dashboard.
        :param str label: The label for the parameter.
        :param str name: The name of the parameters.
        :param str parameter_type: The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        :param Mapping[str, str] values_to_readable_strings: A string->string map.  At least one of the keys must match the value of
               `default_value`.
        :param str dynamic_field_type: For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
               `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        :param str query_value: For `DYNAMIC` parameter types, the query to execute to return values.
        :param str tag_key: for `TAG_KEY` dynamic field types, the tag key to return.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "hide_from_view", hide_from_view)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "values_to_readable_strings", values_to_readable_strings)
        if dynamic_field_type is not None:
            pulumi.set(__self__, "dynamic_field_type", dynamic_field_type)
        if query_value is not None:
            pulumi.set(__self__, "query_value", query_value)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> str:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="hideFromView")
    def hide_from_view(self) -> bool:
        """
        If `true` the parameter will only be shown on the edit view of the dashboard.
        """
        return pulumi.get(self, "hide_from_view")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        The label for the parameter.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> str:
        """
        The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        """
        return pulumi.get(self, "parameter_type")

    @property
    @pulumi.getter(name="valuesToReadableStrings")
    def values_to_readable_strings(self) -> Mapping[str, str]:
        """
        A string->string map.  At least one of the keys must match the value of
        `default_value`.
        """
        return pulumi.get(self, "values_to_readable_strings")

    @property
    @pulumi.getter(name="dynamicFieldType")
    def dynamic_field_type(self) -> Optional[str]:
        """
        For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
        `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        """
        return pulumi.get(self, "dynamic_field_type")

    @property
    @pulumi.getter(name="queryValue")
    def query_value(self) -> Optional[str]:
        """
        For `DYNAMIC` parameter types, the query to execute to return values.
        """
        return pulumi.get(self, "query_value")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[str]:
        """
        for `TAG_KEY` dynamic field types, the tag key to return.
        """
        return pulumi.get(self, "tag_key")


@pulumi.output_type
class DashboardSection(dict):
    def __init__(__self__, *,
                 name: str,
                 rows: Sequence['outputs.DashboardSectionRow']):
        """
        :param str name: Name of this section.
        :param Sequence['DashboardSectionRowArgs'] rows: See dashboard section rows.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rows", rows)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of this section.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rows(self) -> Sequence['outputs.DashboardSectionRow']:
        """
        See dashboard section rows.
        """
        return pulumi.get(self, "rows")


@pulumi.output_type
class DashboardSectionRow(dict):
    def __init__(__self__, *,
                 charts: Sequence['outputs.DashboardSectionRowChart']):
        """
        :param Sequence['DashboardSectionRowChartArgs'] charts: Charts in this section. See dashboard chart.
        """
        pulumi.set(__self__, "charts", charts)

    @property
    @pulumi.getter
    def charts(self) -> Sequence['outputs.DashboardSectionRowChart']:
        """
        Charts in this section. See dashboard chart.
        """
        return pulumi.get(self, "charts")


@pulumi.output_type
class DashboardSectionRowChart(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartSetting":
            suggest = "chart_setting"
        elif key == "chartAttribute":
            suggest = "chart_attribute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSectionRowChart. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSectionRowChart.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSectionRowChart.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chart_setting: 'outputs.DashboardSectionRowChartChartSetting',
                 name: str,
                 sources: Sequence['outputs.DashboardSectionRowChartSource'],
                 summarization: str,
                 units: str,
                 base: Optional[int] = None,
                 chart_attribute: Optional[str] = None,
                 description: Optional[str] = None):
        """
        :param 'DashboardSectionRowChartChartSettingArgs' chart_setting: Chart settings. See chart settings.
        :param str name: Name of the source.
        :param Sequence['DashboardSectionRowChartSourceArgs'] sources: Query expression to plot on the chart. See chart source queries.
        :param str summarization: Summarization strategy for the chart. MEAN is default. Valid options are, `MEAN`, 
               `MEDIAN`, `MIN`, `MAX`, `SUM`, `COUNT`, `LAST`, `FIRST`.
        :param str units: String to label the units of the chart on the Y-Axis.
        :param int base: The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        :param str description: Description of the chart.
        """
        pulumi.set(__self__, "chart_setting", chart_setting)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "summarization", summarization)
        pulumi.set(__self__, "units", units)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if chart_attribute is not None:
            pulumi.set(__self__, "chart_attribute", chart_attribute)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="chartSetting")
    def chart_setting(self) -> 'outputs.DashboardSectionRowChartChartSetting':
        """
        Chart settings. See chart settings.
        """
        return pulumi.get(self, "chart_setting")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.DashboardSectionRowChartSource']:
        """
        Query expression to plot on the chart. See chart source queries.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def summarization(self) -> str:
        """
        Summarization strategy for the chart. MEAN is default. Valid options are, `MEAN`, 
        `MEDIAN`, `MIN`, `MAX`, `SUM`, `COUNT`, `LAST`, `FIRST`.
        """
        return pulumi.get(self, "summarization")

    @property
    @pulumi.getter
    def units(self) -> str:
        """
        String to label the units of the chart on the Y-Axis.
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def base(self) -> Optional[int]:
        """
        The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter(name="chartAttribute")
    def chart_attribute(self) -> Optional[str]:
        return pulumi.get(self, "chart_attribute")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class DashboardSectionRowChartChartSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoColumnTags":
            suggest = "auto_column_tags"
        elif key == "columnTags":
            suggest = "column_tags"
        elif key == "customTags":
            suggest = "custom_tags"
        elif key == "expectedDataSpacing":
            suggest = "expected_data_spacing"
        elif key == "fixedLegendDisplayStats":
            suggest = "fixed_legend_display_stats"
        elif key == "fixedLegendEnabled":
            suggest = "fixed_legend_enabled"
        elif key == "fixedLegendFilterField":
            suggest = "fixed_legend_filter_field"
        elif key == "fixedLegendFilterLimit":
            suggest = "fixed_legend_filter_limit"
        elif key == "fixedLegendFilterSort":
            suggest = "fixed_legend_filter_sort"
        elif key == "fixedLegendHideLabel":
            suggest = "fixed_legend_hide_label"
        elif key == "fixedLegendPosition":
            suggest = "fixed_legend_position"
        elif key == "fixedLegendUseRawStats":
            suggest = "fixed_legend_use_raw_stats"
        elif key == "groupBySource":
            suggest = "group_by_source"
        elif key == "invertDynamicLegendHoverControl":
            suggest = "invert_dynamic_legend_hover_control"
        elif key == "lineType":
            suggest = "line_type"
        elif key == "numTags":
            suggest = "num_tags"
        elif key == "plainMarkdownContent":
            suggest = "plain_markdown_content"
        elif key == "showHosts":
            suggest = "show_hosts"
        elif key == "showLabels":
            suggest = "show_labels"
        elif key == "showRawValues":
            suggest = "show_raw_values"
        elif key == "sortValuesDescending":
            suggest = "sort_values_descending"
        elif key == "sparklineDecimalPrecision":
            suggest = "sparkline_decimal_precision"
        elif key == "sparklineDisplayColor":
            suggest = "sparkline_display_color"
        elif key == "sparklineDisplayFontSize":
            suggest = "sparkline_display_font_size"
        elif key == "sparklineDisplayHorizontalPosition":
            suggest = "sparkline_display_horizontal_position"
        elif key == "sparklineDisplayPostfix":
            suggest = "sparkline_display_postfix"
        elif key == "sparklineDisplayPrefix":
            suggest = "sparkline_display_prefix"
        elif key == "sparklineDisplayValueType":
            suggest = "sparkline_display_value_type"
        elif key == "sparklineDisplayVerticalPosition":
            suggest = "sparkline_display_vertical_position"
        elif key == "sparklineFillColor":
            suggest = "sparkline_fill_color"
        elif key == "sparklineLineColor":
            suggest = "sparkline_line_color"
        elif key == "sparklineSize":
            suggest = "sparkline_size"
        elif key == "sparklineValueColorMapApplyTo":
            suggest = "sparkline_value_color_map_apply_to"
        elif key == "sparklineValueColorMapColors":
            suggest = "sparkline_value_color_map_colors"
        elif key == "sparklineValueColorMapValues":
            suggest = "sparkline_value_color_map_values"
        elif key == "sparklineValueColorMapValuesV2s":
            suggest = "sparkline_value_color_map_values_v2s"
        elif key == "sparklineValueTextMapTexts":
            suggest = "sparkline_value_text_map_texts"
        elif key == "sparklineValueTextMapThresholds":
            suggest = "sparkline_value_text_map_thresholds"
        elif key == "stackType":
            suggest = "stack_type"
        elif key == "tagMode":
            suggest = "tag_mode"
        elif key == "timeBasedColoring":
            suggest = "time_based_coloring"
        elif key == "windowSize":
            suggest = "window_size"
        elif key == "y0ScaleSiBy1024":
            suggest = "y0_scale_si_by1024"
        elif key == "y0UnitAutoscaling":
            suggest = "y0_unit_autoscaling"
        elif key == "y1ScaleSiBy1024":
            suggest = "y1_scale_si_by1024"
        elif key == "y1UnitAutoscaling":
            suggest = "y1_unit_autoscaling"
        elif key == "y1Units":
            suggest = "y1_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSectionRowChartChartSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSectionRowChartChartSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSectionRowChartChartSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 auto_column_tags: Optional[bool] = None,
                 column_tags: Optional[str] = None,
                 custom_tags: Optional[Sequence[str]] = None,
                 expected_data_spacing: Optional[int] = None,
                 fixed_legend_display_stats: Optional[Sequence[str]] = None,
                 fixed_legend_enabled: Optional[bool] = None,
                 fixed_legend_filter_field: Optional[str] = None,
                 fixed_legend_filter_limit: Optional[int] = None,
                 fixed_legend_filter_sort: Optional[str] = None,
                 fixed_legend_hide_label: Optional[bool] = None,
                 fixed_legend_position: Optional[str] = None,
                 fixed_legend_use_raw_stats: Optional[bool] = None,
                 group_by_source: Optional[bool] = None,
                 invert_dynamic_legend_hover_control: Optional[bool] = None,
                 line_type: Optional[str] = None,
                 max: Optional[float] = None,
                 min: Optional[float] = None,
                 num_tags: Optional[int] = None,
                 plain_markdown_content: Optional[str] = None,
                 show_hosts: Optional[bool] = None,
                 show_labels: Optional[bool] = None,
                 show_raw_values: Optional[bool] = None,
                 sort_values_descending: Optional[bool] = None,
                 sparkline_decimal_precision: Optional[int] = None,
                 sparkline_display_color: Optional[str] = None,
                 sparkline_display_font_size: Optional[str] = None,
                 sparkline_display_horizontal_position: Optional[str] = None,
                 sparkline_display_postfix: Optional[str] = None,
                 sparkline_display_prefix: Optional[str] = None,
                 sparkline_display_value_type: Optional[str] = None,
                 sparkline_display_vertical_position: Optional[str] = None,
                 sparkline_fill_color: Optional[str] = None,
                 sparkline_line_color: Optional[str] = None,
                 sparkline_size: Optional[str] = None,
                 sparkline_value_color_map_apply_to: Optional[str] = None,
                 sparkline_value_color_map_colors: Optional[Sequence[str]] = None,
                 sparkline_value_color_map_values: Optional[Sequence[int]] = None,
                 sparkline_value_color_map_values_v2s: Optional[Sequence[float]] = None,
                 sparkline_value_text_map_texts: Optional[Sequence[str]] = None,
                 sparkline_value_text_map_thresholds: Optional[Sequence[float]] = None,
                 stack_type: Optional[str] = None,
                 tag_mode: Optional[str] = None,
                 time_based_coloring: Optional[bool] = None,
                 window_size: Optional[int] = None,
                 windowing: Optional[str] = None,
                 xmax: Optional[float] = None,
                 xmin: Optional[float] = None,
                 y0_scale_si_by1024: Optional[bool] = None,
                 y0_unit_autoscaling: Optional[bool] = None,
                 y1_scale_si_by1024: Optional[bool] = None,
                 y1_unit_autoscaling: Optional[bool] = None,
                 y1_units: Optional[str] = None,
                 y1max: Optional[float] = None,
                 y1min: Optional[float] = None,
                 ymax: Optional[float] = None,
                 ymin: Optional[float] = None):
        """
        :param str type: Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to 
               the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the
               Markdown display, and `sparkline` to the Single Stat view. Valid options are `line`, `scatterplot`,
               `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`,
               `top-k`, `status-list`, and `histogram`.
        :param bool auto_column_tags: This setting is deprecated.
        :param str column_tags: This setting is deprecated.
        :param Sequence[str] custom_tags: For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        :param int expected_data_spacing: Threshold (in seconds) for time delta between consecutive points in a series
               above which a dotted line will replace a solid in in line plots. Default is 60.
        :param Sequence[str] fixed_legend_display_stats: For a chart with a fixed legend, a list of statistics to display in the legend.
        :param bool fixed_legend_enabled: Whether to enable a fixed tabular legend adjacent to the chart.
        :param str fixed_legend_filter_field: Statistic to use for determining whether a series is displayed on the fixed legend.
               Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        :param int fixed_legend_filter_limit: Number of series to include in the fixed legend.
        :param str fixed_legend_filter_sort: Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options
               are `TOP`, and `BOTTOM`.
        :param bool fixed_legend_hide_label: This setting is deprecated.
        :param str fixed_legend_position: Where the fixed legend should be displayed with respect to the chart.
               Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        :param bool fixed_legend_use_raw_stats: If `true`, the legend uses non-summarized stats instead of summarized.
        :param bool group_by_source: For the tabular view, whether to group multi metrics into a single row by a common source.
               If `false`, each source is displayed in its own row.  if `true`, multiple metrics for the same host are displayed as different
               columns in the same row.
        :param bool invert_dynamic_legend_hover_control: Whether to disable the display of the floating legend (but
               reenable it when the ctrl-key is pressed).
        :param str line_type: Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, 
               `step-after`, `basis`, `cardinal`, and `monotone`.
        :param float max: Max value of the Y-axis. Set to null or leave blank for auto.
        :param float min: Min value of the Y-axis. Set to null or leave blank for auto.
        :param int num_tags: For the tabular view defines how many point tags to display.
        :param str plain_markdown_content: The markdown content for a Markdown display, in plain text.
        :param bool show_hosts: For the tabular view, whether to display sources. Default is `true`.
        :param bool show_labels: For the tabular view, whether to display labels. Default is `true`.
        :param bool show_raw_values: For the tabular view, whether to display raw values. Default is `false`.
        :param bool sort_values_descending: For the tabular view, whether to display values in descending order. Default is `false`.
        :param int sparkline_decimal_precision: For the single stat view, the decimal precision of the displayed number.
        :param str sparkline_display_color: For the single stat view, the color of the displayed text (when not dynamically determined). 
               Values should be in `rgba(,,,,)` format.
        :param str sparkline_display_font_size: For the single stat view, the font size of the displayed text, in percent.
        :param str sparkline_display_horizontal_position: For the single stat view, the horizontal position of the displayed text.
               Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        :param str sparkline_display_postfix: For the single stat view, a string to append to the displayed text.
        :param str sparkline_display_prefix: For the single stat view, a string to add before the displayed text.
        :param str sparkline_display_value_type: For the single stat view, where to display the name of the query or the value of the query.
               Valid options are `VALUE` or `LABEL`.
        :param str sparkline_display_vertical_position: This setting is deprecated.
        :param str sparkline_fill_color: For the single stat view, the color of the background fill.  Values should be
               in `rgba(,,,,)`.
        :param str sparkline_line_color: For the single stat view, the color of the line.  Values should be in `rgba(,,,,)` format.
        :param str sparkline_size: For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart.
               Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        :param str sparkline_value_color_map_apply_to: For the single stat view, whether to apply dynamic color settings to 
               the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        :param Sequence[str] sparkline_value_color_map_colors: For the single stat view, A list of colors that differing query values map to. 
               Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in `rgba(,,,,)`.
        :param Sequence[int] sparkline_value_color_map_values: This setting is deprecated.
        :param Sequence[float] sparkline_value_color_map_values_v2s: For the single stat view, a list of boundaries for mapping different
               query values to colors.  Must contain one element less than `sparkline_value_color_map_colors`.
        :param Sequence[str] sparkline_value_text_map_texts: For the single stat view, a list of display text values that different query
               values map to.  Must contain one more element than `sparkline_value_text_map_thresholds`.
        :param Sequence[float] sparkline_value_text_map_thresholds: For the single stat view, a list of threshold boundaries for 
               mapping different query values to display text.  Must contain one element less than `sparkline_value_text_map_text`.
        :param str stack_type: Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means
               stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to
               center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        :param str tag_mode: For the tabular view, which mode to use to determine which point tags to display.
               Valid options are `all`, `top`, or `custom`.
        :param bool time_based_coloring: For x-y scatterplots, whether to color more recent points as darker than older points.
        :param int window_size: Width, in minutes, of the time window to use for `last` windowing.
        :param str windowing: For the tabular view, whether to use the full time window for the query or the last X minutes.
               Valid options are `full` or `last`.
        :param float xmax: For x-y scatterplots, max value for the X-axis. Set to null for auto.
        :param float xmin: For x-y scatterplots, min value for the X-axis. Set to null for auto.
        :param bool y0_scale_si_by1024: Whether to scale numerical magnitude labels for left Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        :param bool y0_unit_autoscaling: Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        :param bool y1_scale_si_by1024: Whether to scale numerical magnitude labels for right Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        :param bool y1_unit_autoscaling: Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        :param str y1_units: For plots with multiple Y-axes, units for right side Y-axis.
        :param float y1max: For plots with multiple Y-axes, max value for the right side Y-axis. Set null for auto.
        :param float y1min: For plots with multiple Y-axes, min value for the right side Y-axis. Set null for auto.
        :param float ymax: For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        :param float ymin: For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        pulumi.set(__self__, "type", type)
        if auto_column_tags is not None:
            pulumi.set(__self__, "auto_column_tags", auto_column_tags)
        if column_tags is not None:
            pulumi.set(__self__, "column_tags", column_tags)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if expected_data_spacing is not None:
            pulumi.set(__self__, "expected_data_spacing", expected_data_spacing)
        if fixed_legend_display_stats is not None:
            pulumi.set(__self__, "fixed_legend_display_stats", fixed_legend_display_stats)
        if fixed_legend_enabled is not None:
            pulumi.set(__self__, "fixed_legend_enabled", fixed_legend_enabled)
        if fixed_legend_filter_field is not None:
            pulumi.set(__self__, "fixed_legend_filter_field", fixed_legend_filter_field)
        if fixed_legend_filter_limit is not None:
            pulumi.set(__self__, "fixed_legend_filter_limit", fixed_legend_filter_limit)
        if fixed_legend_filter_sort is not None:
            pulumi.set(__self__, "fixed_legend_filter_sort", fixed_legend_filter_sort)
        if fixed_legend_hide_label is not None:
            pulumi.set(__self__, "fixed_legend_hide_label", fixed_legend_hide_label)
        if fixed_legend_position is not None:
            pulumi.set(__self__, "fixed_legend_position", fixed_legend_position)
        if fixed_legend_use_raw_stats is not None:
            pulumi.set(__self__, "fixed_legend_use_raw_stats", fixed_legend_use_raw_stats)
        if group_by_source is not None:
            pulumi.set(__self__, "group_by_source", group_by_source)
        if invert_dynamic_legend_hover_control is not None:
            pulumi.set(__self__, "invert_dynamic_legend_hover_control", invert_dynamic_legend_hover_control)
        if line_type is not None:
            pulumi.set(__self__, "line_type", line_type)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if num_tags is not None:
            pulumi.set(__self__, "num_tags", num_tags)
        if plain_markdown_content is not None:
            pulumi.set(__self__, "plain_markdown_content", plain_markdown_content)
        if show_hosts is not None:
            pulumi.set(__self__, "show_hosts", show_hosts)
        if show_labels is not None:
            pulumi.set(__self__, "show_labels", show_labels)
        if show_raw_values is not None:
            pulumi.set(__self__, "show_raw_values", show_raw_values)
        if sort_values_descending is not None:
            pulumi.set(__self__, "sort_values_descending", sort_values_descending)
        if sparkline_decimal_precision is not None:
            pulumi.set(__self__, "sparkline_decimal_precision", sparkline_decimal_precision)
        if sparkline_display_color is not None:
            pulumi.set(__self__, "sparkline_display_color", sparkline_display_color)
        if sparkline_display_font_size is not None:
            pulumi.set(__self__, "sparkline_display_font_size", sparkline_display_font_size)
        if sparkline_display_horizontal_position is not None:
            pulumi.set(__self__, "sparkline_display_horizontal_position", sparkline_display_horizontal_position)
        if sparkline_display_postfix is not None:
            pulumi.set(__self__, "sparkline_display_postfix", sparkline_display_postfix)
        if sparkline_display_prefix is not None:
            pulumi.set(__self__, "sparkline_display_prefix", sparkline_display_prefix)
        if sparkline_display_value_type is not None:
            pulumi.set(__self__, "sparkline_display_value_type", sparkline_display_value_type)
        if sparkline_display_vertical_position is not None:
            pulumi.set(__self__, "sparkline_display_vertical_position", sparkline_display_vertical_position)
        if sparkline_fill_color is not None:
            pulumi.set(__self__, "sparkline_fill_color", sparkline_fill_color)
        if sparkline_line_color is not None:
            pulumi.set(__self__, "sparkline_line_color", sparkline_line_color)
        if sparkline_size is not None:
            pulumi.set(__self__, "sparkline_size", sparkline_size)
        if sparkline_value_color_map_apply_to is not None:
            pulumi.set(__self__, "sparkline_value_color_map_apply_to", sparkline_value_color_map_apply_to)
        if sparkline_value_color_map_colors is not None:
            pulumi.set(__self__, "sparkline_value_color_map_colors", sparkline_value_color_map_colors)
        if sparkline_value_color_map_values is not None:
            pulumi.set(__self__, "sparkline_value_color_map_values", sparkline_value_color_map_values)
        if sparkline_value_color_map_values_v2s is not None:
            pulumi.set(__self__, "sparkline_value_color_map_values_v2s", sparkline_value_color_map_values_v2s)
        if sparkline_value_text_map_texts is not None:
            pulumi.set(__self__, "sparkline_value_text_map_texts", sparkline_value_text_map_texts)
        if sparkline_value_text_map_thresholds is not None:
            pulumi.set(__self__, "sparkline_value_text_map_thresholds", sparkline_value_text_map_thresholds)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)
        if tag_mode is not None:
            pulumi.set(__self__, "tag_mode", tag_mode)
        if time_based_coloring is not None:
            pulumi.set(__self__, "time_based_coloring", time_based_coloring)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)
        if windowing is not None:
            pulumi.set(__self__, "windowing", windowing)
        if xmax is not None:
            pulumi.set(__self__, "xmax", xmax)
        if xmin is not None:
            pulumi.set(__self__, "xmin", xmin)
        if y0_scale_si_by1024 is not None:
            pulumi.set(__self__, "y0_scale_si_by1024", y0_scale_si_by1024)
        if y0_unit_autoscaling is not None:
            pulumi.set(__self__, "y0_unit_autoscaling", y0_unit_autoscaling)
        if y1_scale_si_by1024 is not None:
            pulumi.set(__self__, "y1_scale_si_by1024", y1_scale_si_by1024)
        if y1_unit_autoscaling is not None:
            pulumi.set(__self__, "y1_unit_autoscaling", y1_unit_autoscaling)
        if y1_units is not None:
            pulumi.set(__self__, "y1_units", y1_units)
        if y1max is not None:
            pulumi.set(__self__, "y1max", y1max)
        if y1min is not None:
            pulumi.set(__self__, "y1min", y1min)
        if ymax is not None:
            pulumi.set(__self__, "ymax", ymax)
        if ymin is not None:
            pulumi.set(__self__, "ymin", ymin)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to 
        the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the
        Markdown display, and `sparkline` to the Single Stat view. Valid options are `line`, `scatterplot`,
        `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`,
        `top-k`, `status-list`, and `histogram`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="autoColumnTags")
    def auto_column_tags(self) -> Optional[bool]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "auto_column_tags")

    @property
    @pulumi.getter(name="columnTags")
    def column_tags(self) -> Optional[str]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "column_tags")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Sequence[str]]:
        """
        For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        """
        return pulumi.get(self, "custom_tags")

    @property
    @pulumi.getter(name="expectedDataSpacing")
    def expected_data_spacing(self) -> Optional[int]:
        """
        Threshold (in seconds) for time delta between consecutive points in a series
        above which a dotted line will replace a solid in in line plots. Default is 60.
        """
        return pulumi.get(self, "expected_data_spacing")

    @property
    @pulumi.getter(name="fixedLegendDisplayStats")
    def fixed_legend_display_stats(self) -> Optional[Sequence[str]]:
        """
        For a chart with a fixed legend, a list of statistics to display in the legend.
        """
        return pulumi.get(self, "fixed_legend_display_stats")

    @property
    @pulumi.getter(name="fixedLegendEnabled")
    def fixed_legend_enabled(self) -> Optional[bool]:
        """
        Whether to enable a fixed tabular legend adjacent to the chart.
        """
        return pulumi.get(self, "fixed_legend_enabled")

    @property
    @pulumi.getter(name="fixedLegendFilterField")
    def fixed_legend_filter_field(self) -> Optional[str]:
        """
        Statistic to use for determining whether a series is displayed on the fixed legend.
        Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        """
        return pulumi.get(self, "fixed_legend_filter_field")

    @property
    @pulumi.getter(name="fixedLegendFilterLimit")
    def fixed_legend_filter_limit(self) -> Optional[int]:
        """
        Number of series to include in the fixed legend.
        """
        return pulumi.get(self, "fixed_legend_filter_limit")

    @property
    @pulumi.getter(name="fixedLegendFilterSort")
    def fixed_legend_filter_sort(self) -> Optional[str]:
        """
        Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options
        are `TOP`, and `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_filter_sort")

    @property
    @pulumi.getter(name="fixedLegendHideLabel")
    def fixed_legend_hide_label(self) -> Optional[bool]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "fixed_legend_hide_label")

    @property
    @pulumi.getter(name="fixedLegendPosition")
    def fixed_legend_position(self) -> Optional[str]:
        """
        Where the fixed legend should be displayed with respect to the chart.
        Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_position")

    @property
    @pulumi.getter(name="fixedLegendUseRawStats")
    def fixed_legend_use_raw_stats(self) -> Optional[bool]:
        """
        If `true`, the legend uses non-summarized stats instead of summarized.
        """
        return pulumi.get(self, "fixed_legend_use_raw_stats")

    @property
    @pulumi.getter(name="groupBySource")
    def group_by_source(self) -> Optional[bool]:
        """
        For the tabular view, whether to group multi metrics into a single row by a common source.
        If `false`, each source is displayed in its own row.  if `true`, multiple metrics for the same host are displayed as different
        columns in the same row.
        """
        return pulumi.get(self, "group_by_source")

    @property
    @pulumi.getter(name="invertDynamicLegendHoverControl")
    def invert_dynamic_legend_hover_control(self) -> Optional[bool]:
        """
        Whether to disable the display of the floating legend (but
        reenable it when the ctrl-key is pressed).
        """
        return pulumi.get(self, "invert_dynamic_legend_hover_control")

    @property
    @pulumi.getter(name="lineType")
    def line_type(self) -> Optional[str]:
        """
        Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, 
        `step-after`, `basis`, `cardinal`, and `monotone`.
        """
        return pulumi.get(self, "line_type")

    @property
    @pulumi.getter
    def max(self) -> Optional[float]:
        """
        Max value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[float]:
        """
        Min value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="numTags")
    def num_tags(self) -> Optional[int]:
        """
        For the tabular view defines how many point tags to display.
        """
        return pulumi.get(self, "num_tags")

    @property
    @pulumi.getter(name="plainMarkdownContent")
    def plain_markdown_content(self) -> Optional[str]:
        """
        The markdown content for a Markdown display, in plain text.
        """
        return pulumi.get(self, "plain_markdown_content")

    @property
    @pulumi.getter(name="showHosts")
    def show_hosts(self) -> Optional[bool]:
        """
        For the tabular view, whether to display sources. Default is `true`.
        """
        return pulumi.get(self, "show_hosts")

    @property
    @pulumi.getter(name="showLabels")
    def show_labels(self) -> Optional[bool]:
        """
        For the tabular view, whether to display labels. Default is `true`.
        """
        return pulumi.get(self, "show_labels")

    @property
    @pulumi.getter(name="showRawValues")
    def show_raw_values(self) -> Optional[bool]:
        """
        For the tabular view, whether to display raw values. Default is `false`.
        """
        return pulumi.get(self, "show_raw_values")

    @property
    @pulumi.getter(name="sortValuesDescending")
    def sort_values_descending(self) -> Optional[bool]:
        """
        For the tabular view, whether to display values in descending order. Default is `false`.
        """
        return pulumi.get(self, "sort_values_descending")

    @property
    @pulumi.getter(name="sparklineDecimalPrecision")
    def sparkline_decimal_precision(self) -> Optional[int]:
        """
        For the single stat view, the decimal precision of the displayed number.
        """
        return pulumi.get(self, "sparkline_decimal_precision")

    @property
    @pulumi.getter(name="sparklineDisplayColor")
    def sparkline_display_color(self) -> Optional[str]:
        """
        For the single stat view, the color of the displayed text (when not dynamically determined). 
        Values should be in `rgba(,,,,)` format.
        """
        return pulumi.get(self, "sparkline_display_color")

    @property
    @pulumi.getter(name="sparklineDisplayFontSize")
    def sparkline_display_font_size(self) -> Optional[str]:
        """
        For the single stat view, the font size of the displayed text, in percent.
        """
        return pulumi.get(self, "sparkline_display_font_size")

    @property
    @pulumi.getter(name="sparklineDisplayHorizontalPosition")
    def sparkline_display_horizontal_position(self) -> Optional[str]:
        """
        For the single stat view, the horizontal position of the displayed text.
        Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        """
        return pulumi.get(self, "sparkline_display_horizontal_position")

    @property
    @pulumi.getter(name="sparklineDisplayPostfix")
    def sparkline_display_postfix(self) -> Optional[str]:
        """
        For the single stat view, a string to append to the displayed text.
        """
        return pulumi.get(self, "sparkline_display_postfix")

    @property
    @pulumi.getter(name="sparklineDisplayPrefix")
    def sparkline_display_prefix(self) -> Optional[str]:
        """
        For the single stat view, a string to add before the displayed text.
        """
        return pulumi.get(self, "sparkline_display_prefix")

    @property
    @pulumi.getter(name="sparklineDisplayValueType")
    def sparkline_display_value_type(self) -> Optional[str]:
        """
        For the single stat view, where to display the name of the query or the value of the query.
        Valid options are `VALUE` or `LABEL`.
        """
        return pulumi.get(self, "sparkline_display_value_type")

    @property
    @pulumi.getter(name="sparklineDisplayVerticalPosition")
    def sparkline_display_vertical_position(self) -> Optional[str]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_display_vertical_position")

    @property
    @pulumi.getter(name="sparklineFillColor")
    def sparkline_fill_color(self) -> Optional[str]:
        """
        For the single stat view, the color of the background fill.  Values should be
        in `rgba(,,,,)`.
        """
        return pulumi.get(self, "sparkline_fill_color")

    @property
    @pulumi.getter(name="sparklineLineColor")
    def sparkline_line_color(self) -> Optional[str]:
        """
        For the single stat view, the color of the line.  Values should be in `rgba(,,,,)` format.
        """
        return pulumi.get(self, "sparkline_line_color")

    @property
    @pulumi.getter(name="sparklineSize")
    def sparkline_size(self) -> Optional[str]:
        """
        For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart.
        Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        """
        return pulumi.get(self, "sparkline_size")

    @property
    @pulumi.getter(name="sparklineValueColorMapApplyTo")
    def sparkline_value_color_map_apply_to(self) -> Optional[str]:
        """
        For the single stat view, whether to apply dynamic color settings to 
        the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        """
        return pulumi.get(self, "sparkline_value_color_map_apply_to")

    @property
    @pulumi.getter(name="sparklineValueColorMapColors")
    def sparkline_value_color_map_colors(self) -> Optional[Sequence[str]]:
        """
        For the single stat view, A list of colors that differing query values map to. 
        Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in `rgba(,,,,)`.
        """
        return pulumi.get(self, "sparkline_value_color_map_colors")

    @property
    @pulumi.getter(name="sparklineValueColorMapValues")
    def sparkline_value_color_map_values(self) -> Optional[Sequence[int]]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_value_color_map_values")

    @property
    @pulumi.getter(name="sparklineValueColorMapValuesV2s")
    def sparkline_value_color_map_values_v2s(self) -> Optional[Sequence[float]]:
        """
        For the single stat view, a list of boundaries for mapping different
        query values to colors.  Must contain one element less than `sparkline_value_color_map_colors`.
        """
        return pulumi.get(self, "sparkline_value_color_map_values_v2s")

    @property
    @pulumi.getter(name="sparklineValueTextMapTexts")
    def sparkline_value_text_map_texts(self) -> Optional[Sequence[str]]:
        """
        For the single stat view, a list of display text values that different query
        values map to.  Must contain one more element than `sparkline_value_text_map_thresholds`.
        """
        return pulumi.get(self, "sparkline_value_text_map_texts")

    @property
    @pulumi.getter(name="sparklineValueTextMapThresholds")
    def sparkline_value_text_map_thresholds(self) -> Optional[Sequence[float]]:
        """
        For the single stat view, a list of threshold boundaries for 
        mapping different query values to display text.  Must contain one element less than `sparkline_value_text_map_text`.
        """
        return pulumi.get(self, "sparkline_value_text_map_thresholds")

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[str]:
        """
        Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means
        stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to
        center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        """
        return pulumi.get(self, "stack_type")

    @property
    @pulumi.getter(name="tagMode")
    def tag_mode(self) -> Optional[str]:
        """
        For the tabular view, which mode to use to determine which point tags to display.
        Valid options are `all`, `top`, or `custom`.
        """
        return pulumi.get(self, "tag_mode")

    @property
    @pulumi.getter(name="timeBasedColoring")
    def time_based_coloring(self) -> Optional[bool]:
        """
        For x-y scatterplots, whether to color more recent points as darker than older points.
        """
        return pulumi.get(self, "time_based_coloring")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[int]:
        """
        Width, in minutes, of the time window to use for `last` windowing.
        """
        return pulumi.get(self, "window_size")

    @property
    @pulumi.getter
    def windowing(self) -> Optional[str]:
        """
        For the tabular view, whether to use the full time window for the query or the last X minutes.
        Valid options are `full` or `last`.
        """
        return pulumi.get(self, "windowing")

    @property
    @pulumi.getter
    def xmax(self) -> Optional[float]:
        """
        For x-y scatterplots, max value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmax")

    @property
    @pulumi.getter
    def xmin(self) -> Optional[float]:
        """
        For x-y scatterplots, min value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmin")

    @property
    @pulumi.getter(name="y0ScaleSiBy1024")
    def y0_scale_si_by1024(self) -> Optional[bool]:
        """
        Whether to scale numerical magnitude labels for left Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        """
        return pulumi.get(self, "y0_scale_si_by1024")

    @property
    @pulumi.getter(name="y0UnitAutoscaling")
    def y0_unit_autoscaling(self) -> Optional[bool]:
        """
        Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y0_unit_autoscaling")

    @property
    @pulumi.getter(name="y1ScaleSiBy1024")
    def y1_scale_si_by1024(self) -> Optional[bool]:
        """
        Whether to scale numerical magnitude labels for right Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        """
        return pulumi.get(self, "y1_scale_si_by1024")

    @property
    @pulumi.getter(name="y1UnitAutoscaling")
    def y1_unit_autoscaling(self) -> Optional[bool]:
        """
        Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y1_unit_autoscaling")

    @property
    @pulumi.getter(name="y1Units")
    def y1_units(self) -> Optional[str]:
        """
        For plots with multiple Y-axes, units for right side Y-axis.
        """
        return pulumi.get(self, "y1_units")

    @property
    @pulumi.getter
    def y1max(self) -> Optional[float]:
        """
        For plots with multiple Y-axes, max value for the right side Y-axis. Set null for auto.
        """
        return pulumi.get(self, "y1max")

    @property
    @pulumi.getter
    def y1min(self) -> Optional[float]:
        """
        For plots with multiple Y-axes, min value for the right side Y-axis. Set null for auto.
        """
        return pulumi.get(self, "y1min")

    @property
    @pulumi.getter
    def ymax(self) -> Optional[float]:
        """
        For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymax")

    @property
    @pulumi.getter
    def ymin(self) -> Optional[float]:
        """
        For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymin")


@pulumi.output_type
class DashboardSectionRowChartSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryBuilderEnabled":
            suggest = "query_builder_enabled"
        elif key == "scatterPlotSource":
            suggest = "scatter_plot_source"
        elif key == "sourceDescription":
            suggest = "source_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSectionRowChartSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSectionRowChartSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSectionRowChartSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 query: str,
                 disabled: Optional[bool] = None,
                 query_builder_enabled: Optional[bool] = None,
                 scatter_plot_source: Optional[str] = None,
                 source_description: Optional[str] = None):
        """
        :param str name: Name of the source.
        :param str query: Query expression to plot on the chart.
        :param bool disabled: Whether the source is disabled.
        :param bool query_builder_enabled: Whether or not this source line should have the query builder enabled.
        :param str scatter_plot_source: For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        :param str source_description: A description for the purpose of this source.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if query_builder_enabled is not None:
            pulumi.set(__self__, "query_builder_enabled", query_builder_enabled)
        if scatter_plot_source is not None:
            pulumi.set(__self__, "scatter_plot_source", scatter_plot_source)
        if source_description is not None:
            pulumi.set(__self__, "source_description", source_description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Query expression to plot on the chart.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Whether the source is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="queryBuilderEnabled")
    def query_builder_enabled(self) -> Optional[bool]:
        """
        Whether or not this source line should have the query builder enabled.
        """
        return pulumi.get(self, "query_builder_enabled")

    @property
    @pulumi.getter(name="scatterPlotSource")
    def scatter_plot_source(self) -> Optional[str]:
        """
        For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        """
        return pulumi.get(self, "scatter_plot_source")

    @property
    @pulumi.getter(name="sourceDescription")
    def source_description(self) -> Optional[str]:
        """
        A description for the purpose of this source.
        """
        return pulumi.get(self, "source_description")


@pulumi.output_type
class MetricsPolicyPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "tagsAnded":
            suggest = "tags_anded"
        elif key == "accountIds":
            suggest = "account_ids"
        elif key == "roleIds":
            suggest = "role_ids"
        elif key == "userGroupIds":
            suggest = "user_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricsPolicyPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricsPolicyPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricsPolicyPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: str,
                 description: str,
                 name: str,
                 prefixes: Sequence[str],
                 tags_anded: bool,
                 account_ids: Optional[Sequence[str]] = None,
                 role_ids: Optional[Sequence[str]] = None,
                 tags: Optional[Sequence['outputs.MetricsPolicyPolicyRuleTag']] = None,
                 user_group_ids: Optional[Sequence[str]] = None):
        """
        :param str access_type: Valid options are `ALLOW` and `BLOCK`.
        :param str description: A detailed description of the Metrics Policy. The description is visible only when you edit the rule.
        :param str name: The unique name identifier for a Metrics Policy. The name is visible on the Metrics Security Policy page.
        :param Sequence[str] prefixes: List of prefixes to match metrics on. You can specify the full metric name or use a wildcard character in metric names, sources, or point tags. The wildcard character alone (*) means all metrics.
        :param bool tags_anded: Bool where `true` require all tags are met by selected metrics, else `false` select metrics that match any give tag.
        :param Sequence[str] account_ids: List of account ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        :param Sequence[str] role_ids: List of role ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        :param Sequence['MetricsPolicyPolicyRuleTagArgs'] tags: List of Key/Value tags to select target metrics for policy.
        :param Sequence[str] user_group_ids: List of user group ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "prefixes", prefixes)
        pulumi.set(__self__, "tags_anded", tags_anded)
        if account_ids is not None:
            pulumi.set(__self__, "account_ids", account_ids)
        if role_ids is not None:
            pulumi.set(__self__, "role_ids", role_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_group_ids is not None:
            pulumi.set(__self__, "user_group_ids", user_group_ids)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> str:
        """
        Valid options are `ALLOW` and `BLOCK`.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A detailed description of the Metrics Policy. The description is visible only when you edit the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name identifier for a Metrics Policy. The name is visible on the Metrics Security Policy page.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def prefixes(self) -> Sequence[str]:
        """
        List of prefixes to match metrics on. You can specify the full metric name or use a wildcard character in metric names, sources, or point tags. The wildcard character alone (*) means all metrics.
        """
        return pulumi.get(self, "prefixes")

    @property
    @pulumi.getter(name="tagsAnded")
    def tags_anded(self) -> bool:
        """
        Bool where `true` require all tags are met by selected metrics, else `false` select metrics that match any give tag.
        """
        return pulumi.get(self, "tags_anded")

    @property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Optional[Sequence[str]]:
        """
        List of account ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        return pulumi.get(self, "account_ids")

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Optional[Sequence[str]]:
        """
        List of role ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        return pulumi.get(self, "role_ids")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.MetricsPolicyPolicyRuleTag']]:
        """
        List of Key/Value tags to select target metrics for policy.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Optional[Sequence[str]]:
        """
        List of user group ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        return pulumi.get(self, "user_group_ids")


@pulumi.output_type
class MetricsPolicyPolicyRuleTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The tag's key.
        :param str value: The tag's value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The tag's key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The tag's value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAlertFailingHostLabelPairResult(dict):
    def __init__(__self__, *,
                 firing: int,
                 host: str):
        pulumi.set(__self__, "firing", firing)
        pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def firing(self) -> int:
        return pulumi.get(self, "firing")

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")


@pulumi.output_type
class GetAlertInMaintenanceHostLabelPairResult(dict):
    def __init__(__self__, *,
                 firing: int,
                 host: str):
        pulumi.set(__self__, "firing", firing)
        pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def firing(self) -> int:
        return pulumi.get(self, "firing")

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")


@pulumi.output_type
class GetAlertsAlertResult(dict):
    def __init__(__self__, *,
                 additional_information: str,
                 alert_type: str,
                 can_modifies: Sequence[str],
                 can_views: Sequence[str],
                 condition: str,
                 conditions: Mapping[str, str],
                 display_expression: str,
                 evaluate_realtime_data: bool,
                 failing_host_label_pairs: Sequence['outputs.GetAlertsAlertFailingHostLabelPairResult'],
                 id: str,
                 in_maintenance_host_label_pairs: Sequence['outputs.GetAlertsAlertInMaintenanceHostLabelPairResult'],
                 include_obsolete_metrics: bool,
                 minutes: int,
                 name: str,
                 notification_resend_frequency_minutes: int,
                 process_rate_minutes: int,
                 resolve_after_minutes: int,
                 severity: str,
                 severity_lists: Sequence[str],
                 statuses: Sequence[str],
                 tags: Sequence[str],
                 target: str,
                 targets: Optional[Mapping[str, str]] = None):
        """
        :param str additional_information: User-supplied additional explanatory information about this alert.
        :param str alert_type: The type of alert in Wavefront.
        :param Sequence[str] can_modifies: A list of users or groups that can modify the alert.
        :param Sequence[str] can_views: A list of users or groups that can view the alert.
        :param str condition: A Wavefront query that is evaluated at regular intervals (default is 1 minute). The alert fires and notifications are triggered when a data series matching this query evaluates to a non-zero value for a set number of consecutive minutes.
        :param Mapping[str, str] conditions: A map of severity to condition for which this alert will trigger.
        :param str display_expression: A second query the results of which are displayed in the alert user interface instead of the condition query.
        :param bool evaluate_realtime_data: A Boolean flag to enable real-time evaluation.
        :param Sequence['GetAlertsAlertFailingHostLabelPairArgs'] failing_host_label_pairs: A list of failing host label pairs.
        :param str id: The ID of the alert in Wavefront.
        :param Sequence['GetAlertsAlertInMaintenanceHostLabelPairArgs'] in_maintenance_host_label_pairs: A list of in maintenance host label pairs.
        :param bool include_obsolete_metrics: A Boolean flag indicating whether to include obsolete metrics or not.
        :param int minutes: The number of consecutive minutes that a series matching the condition query must evaluate to "true" (non-zero value) before the alert fires.
        :param str name: The name of the alert as it is displayed in Wavefront.
        :param int notification_resend_frequency_minutes: How often to re-trigger a continually failing alert.
        :param int process_rate_minutes: The specified query is executed every `process_rate_minutes` minutes.
        :param int resolve_after_minutes: The number of consecutive minutes that a firing series matching the condition query must evaluate to "false" (zero value) before the alert resolves.
        :param str severity: The severity of the alert.
        :param Sequence[str] statuses: The status of the alert.
        :param Sequence[str] tags: A set of tags assigned to the alert.
        :param str target: An email address or integration endpoint (such as PagerDuty or webhook) to notify when the alert status changes.
        :param Mapping[str, str] targets: A comma-separated list of the email addresses or integration endpoints (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
        """
        pulumi.set(__self__, "additional_information", additional_information)
        pulumi.set(__self__, "alert_type", alert_type)
        pulumi.set(__self__, "can_modifies", can_modifies)
        pulumi.set(__self__, "can_views", can_views)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "display_expression", display_expression)
        pulumi.set(__self__, "evaluate_realtime_data", evaluate_realtime_data)
        pulumi.set(__self__, "failing_host_label_pairs", failing_host_label_pairs)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "in_maintenance_host_label_pairs", in_maintenance_host_label_pairs)
        pulumi.set(__self__, "include_obsolete_metrics", include_obsolete_metrics)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notification_resend_frequency_minutes", notification_resend_frequency_minutes)
        pulumi.set(__self__, "process_rate_minutes", process_rate_minutes)
        pulumi.set(__self__, "resolve_after_minutes", resolve_after_minutes)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "severity_lists", severity_lists)
        pulumi.set(__self__, "statuses", statuses)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "target", target)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> str:
        """
        User-supplied additional explanatory information about this alert.
        """
        return pulumi.get(self, "additional_information")

    @property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> str:
        """
        The type of alert in Wavefront.
        """
        return pulumi.get(self, "alert_type")

    @property
    @pulumi.getter(name="canModifies")
    def can_modifies(self) -> Sequence[str]:
        """
        A list of users or groups that can modify the alert.
        """
        return pulumi.get(self, "can_modifies")

    @property
    @pulumi.getter(name="canViews")
    def can_views(self) -> Sequence[str]:
        """
        A list of users or groups that can view the alert.
        """
        return pulumi.get(self, "can_views")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        A Wavefront query that is evaluated at regular intervals (default is 1 minute). The alert fires and notifications are triggered when a data series matching this query evaluates to a non-zero value for a set number of consecutive minutes.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def conditions(self) -> Mapping[str, str]:
        """
        A map of severity to condition for which this alert will trigger.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="displayExpression")
    def display_expression(self) -> str:
        """
        A second query the results of which are displayed in the alert user interface instead of the condition query.
        """
        return pulumi.get(self, "display_expression")

    @property
    @pulumi.getter(name="evaluateRealtimeData")
    def evaluate_realtime_data(self) -> bool:
        """
        A Boolean flag to enable real-time evaluation.
        """
        return pulumi.get(self, "evaluate_realtime_data")

    @property
    @pulumi.getter(name="failingHostLabelPairs")
    def failing_host_label_pairs(self) -> Sequence['outputs.GetAlertsAlertFailingHostLabelPairResult']:
        """
        A list of failing host label pairs.
        """
        return pulumi.get(self, "failing_host_label_pairs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the alert in Wavefront.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inMaintenanceHostLabelPairs")
    def in_maintenance_host_label_pairs(self) -> Sequence['outputs.GetAlertsAlertInMaintenanceHostLabelPairResult']:
        """
        A list of in maintenance host label pairs.
        """
        return pulumi.get(self, "in_maintenance_host_label_pairs")

    @property
    @pulumi.getter(name="includeObsoleteMetrics")
    def include_obsolete_metrics(self) -> bool:
        """
        A Boolean flag indicating whether to include obsolete metrics or not.
        """
        return pulumi.get(self, "include_obsolete_metrics")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        The number of consecutive minutes that a series matching the condition query must evaluate to "true" (non-zero value) before the alert fires.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the alert as it is displayed in Wavefront.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationResendFrequencyMinutes")
    def notification_resend_frequency_minutes(self) -> int:
        """
        How often to re-trigger a continually failing alert.
        """
        return pulumi.get(self, "notification_resend_frequency_minutes")

    @property
    @pulumi.getter(name="processRateMinutes")
    def process_rate_minutes(self) -> int:
        """
        The specified query is executed every `process_rate_minutes` minutes.
        """
        return pulumi.get(self, "process_rate_minutes")

    @property
    @pulumi.getter(name="resolveAfterMinutes")
    def resolve_after_minutes(self) -> int:
        """
        The number of consecutive minutes that a firing series matching the condition query must evaluate to "false" (zero value) before the alert resolves.
        """
        return pulumi.get(self, "resolve_after_minutes")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The severity of the alert.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="severityLists")
    def severity_lists(self) -> Sequence[str]:
        return pulumi.get(self, "severity_lists")

    @property
    @pulumi.getter
    def statuses(self) -> Sequence[str]:
        """
        The status of the alert.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A set of tags assigned to the alert.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        An email address or integration endpoint (such as PagerDuty or webhook) to notify when the alert status changes.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Mapping[str, str]]:
        """
        A comma-separated list of the email addresses or integration endpoints (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class GetAlertsAlertFailingHostLabelPairResult(dict):
    def __init__(__self__, *,
                 firing: int,
                 host: str):
        pulumi.set(__self__, "firing", firing)
        pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def firing(self) -> int:
        return pulumi.get(self, "firing")

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")


@pulumi.output_type
class GetAlertsAlertInMaintenanceHostLabelPairResult(dict):
    def __init__(__self__, *,
                 firing: int,
                 host: str):
        pulumi.set(__self__, "firing", firing)
        pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def firing(self) -> int:
        return pulumi.get(self, "firing")

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")


@pulumi.output_type
class GetDashboardParameterDetailResult(dict):
    def __init__(__self__, *,
                 default_value: str,
                 dynamic_field_type: str,
                 hide_from_view: bool,
                 label: str,
                 parameter_type: str,
                 query_value: str,
                 tag_key: str,
                 values_to_readable_strings: Mapping[str, str]):
        """
        :param str default_value: The default value of the parameter.
        :param str dynamic_field_type: For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
               `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        :param bool hide_from_view: If `true` the parameter will only be shown on the edit view of the dashboard.
        :param str label: The label for the parameter.
        :param str parameter_type: The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        :param str query_value: For `DYNAMIC` parameter types, the query to execute to return values.
        :param str tag_key: For `TAG_KEY` dynamic field types, the tag key to return.
        :param Mapping[str, str] values_to_readable_strings: A string to string map. At least one of the keys must match the value of
               `default_value`.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "dynamic_field_type", dynamic_field_type)
        pulumi.set(__self__, "hide_from_view", hide_from_view)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "query_value", query_value)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "values_to_readable_strings", values_to_readable_strings)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> str:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="dynamicFieldType")
    def dynamic_field_type(self) -> str:
        """
        For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
        `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        """
        return pulumi.get(self, "dynamic_field_type")

    @property
    @pulumi.getter(name="hideFromView")
    def hide_from_view(self) -> bool:
        """
        If `true` the parameter will only be shown on the edit view of the dashboard.
        """
        return pulumi.get(self, "hide_from_view")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        The label for the parameter.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> str:
        """
        The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        """
        return pulumi.get(self, "parameter_type")

    @property
    @pulumi.getter(name="queryValue")
    def query_value(self) -> str:
        """
        For `DYNAMIC` parameter types, the query to execute to return values.
        """
        return pulumi.get(self, "query_value")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> str:
        """
        For `TAG_KEY` dynamic field types, the tag key to return.
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="valuesToReadableStrings")
    def values_to_readable_strings(self) -> Mapping[str, str]:
        """
        A string to string map. At least one of the keys must match the value of
        `default_value`.
        """
        return pulumi.get(self, "values_to_readable_strings")


@pulumi.output_type
class GetDashboardSectionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 rows: Sequence['outputs.GetDashboardSectionRowResult']):
        """
        :param str name: The name of the parameters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rows", rows)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rows(self) -> Sequence['outputs.GetDashboardSectionRowResult']:
        return pulumi.get(self, "rows")


@pulumi.output_type
class GetDashboardSectionRowResult(dict):
    def __init__(__self__, *,
                 charts: Sequence['outputs.GetDashboardSectionRowChartResult'],
                 height_factor: int,
                 name: str):
        """
        :param str name: The name of the parameters.
        """
        pulumi.set(__self__, "charts", charts)
        pulumi.set(__self__, "height_factor", height_factor)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def charts(self) -> Sequence['outputs.GetDashboardSectionRowChartResult']:
        return pulumi.get(self, "charts")

    @property
    @pulumi.getter(name="heightFactor")
    def height_factor(self) -> int:
        return pulumi.get(self, "height_factor")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDashboardSectionRowChartResult(dict):
    def __init__(__self__, *,
                 base: int,
                 chart_attributes: str,
                 chart_settings: Sequence['outputs.GetDashboardSectionRowChartChartSettingResult'],
                 description: str,
                 include_obsolete_metrics: bool,
                 interpolate_points_key: bool,
                 name: str,
                 no_default_events: bool,
                 sources: Sequence['outputs.GetDashboardSectionRowChartSourceResult'],
                 summarization: str,
                 units: str):
        """
        :param int base: The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        :param str description: Description of the chart.
        :param str name: The name of the parameters.
        :param str summarization: Summarization strategy for the chart. MEAN is default.
        :param str units: String to label the units of the chart on the Y-Axis.
        """
        pulumi.set(__self__, "base", base)
        pulumi.set(__self__, "chart_attributes", chart_attributes)
        pulumi.set(__self__, "chart_settings", chart_settings)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "include_obsolete_metrics", include_obsolete_metrics)
        pulumi.set(__self__, "interpolate_points_key", interpolate_points_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "no_default_events", no_default_events)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "summarization", summarization)
        pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter
    def base(self) -> int:
        """
        The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter(name="chartAttributes")
    def chart_attributes(self) -> str:
        return pulumi.get(self, "chart_attributes")

    @property
    @pulumi.getter(name="chartSettings")
    def chart_settings(self) -> Sequence['outputs.GetDashboardSectionRowChartChartSettingResult']:
        return pulumi.get(self, "chart_settings")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="includeObsoleteMetrics")
    def include_obsolete_metrics(self) -> bool:
        return pulumi.get(self, "include_obsolete_metrics")

    @property
    @pulumi.getter(name="interpolatePointsKey")
    def interpolate_points_key(self) -> bool:
        return pulumi.get(self, "interpolate_points_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noDefaultEvents")
    def no_default_events(self) -> bool:
        return pulumi.get(self, "no_default_events")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetDashboardSectionRowChartSourceResult']:
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def summarization(self) -> str:
        """
        Summarization strategy for the chart. MEAN is default.
        """
        return pulumi.get(self, "summarization")

    @property
    @pulumi.getter
    def units(self) -> str:
        """
        String to label the units of the chart on the Y-Axis.
        """
        return pulumi.get(self, "units")


@pulumi.output_type
class GetDashboardSectionRowChartChartSettingResult(dict):
    def __init__(__self__, *,
                 auto_column_tags: bool,
                 column_tags: str,
                 custom_tags: Sequence[str],
                 expected_data_spacing: int,
                 fixed_legend_display_stats: Sequence[str],
                 fixed_legend_enabled: bool,
                 fixed_legend_filter_field: str,
                 fixed_legend_filter_limit: int,
                 fixed_legend_filter_sort: str,
                 fixed_legend_hide_label: bool,
                 fixed_legend_position: str,
                 fixed_legend_use_raw_stats: bool,
                 group_by_source: bool,
                 invert_dynamic_legend_hover_control: bool,
                 line_type: str,
                 max: float,
                 min: float,
                 num_tags: int,
                 plain_markdown_content: str,
                 show_hosts: bool,
                 show_labels: bool,
                 show_raw_values: bool,
                 sort_values_descending: bool,
                 sparkline_decimal_precision: int,
                 sparkline_display_color: str,
                 sparkline_display_font_size: str,
                 sparkline_display_horizontal_position: str,
                 sparkline_display_postfix: str,
                 sparkline_display_prefix: str,
                 sparkline_display_value_type: str,
                 sparkline_display_vertical_position: str,
                 sparkline_fill_color: str,
                 sparkline_line_color: str,
                 sparkline_size: str,
                 sparkline_value_color_map_apply_to: str,
                 sparkline_value_color_map_colors: Sequence[str],
                 sparkline_value_color_map_values: Sequence[int],
                 sparkline_value_color_map_values_v2s: Sequence[float],
                 sparkline_value_text_map_texts: Sequence[str],
                 sparkline_value_text_map_thresholds: Sequence[float],
                 stack_type: str,
                 tag_mode: str,
                 time_based_coloring: bool,
                 type: str,
                 window_size: int,
                 windowing: str,
                 xmax: float,
                 xmin: float,
                 y0_scale_si_by1024: bool,
                 y0_unit_autoscaling: bool,
                 y1_max: float,
                 y1_min: float,
                 y1_scale_si_by1024: bool,
                 y1_unit_autoscaling: bool,
                 y1_units: str,
                 ymax: float,
                 ymin: float):
        """
        :param bool auto_column_tags: This setting is deprecated.
        :param str column_tags: This setting is deprecated.
        :param Sequence[str] custom_tags: For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        :param int expected_data_spacing: Threshold (in seconds) for time delta between consecutive points in a series above which a dotted line will replace a solid in line plots. Default is 60.
        :param Sequence[str] fixed_legend_display_stats: (Optional) For a chart with a fixed legend, a list of statistics to display in the legend.
        :param bool fixed_legend_enabled: (Optional) Whether to enable a fixed tabular legend adjacent to the chart.
        :param str fixed_legend_filter_field: (Optional) Statistic to use for determining whether a series is displayed on the fixed legend. Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        :param int fixed_legend_filter_limit: (Optional) Number of series to include in the fixed legend.
        :param str fixed_legend_filter_sort: (Optional) Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options are `TOP`, and `BOTTOM`.
        :param bool fixed_legend_hide_label: (Optional) This setting is deprecated.
        :param str fixed_legend_position: (Optional)  Where the fixed legend should be displayed with respect to the chart. Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        :param bool fixed_legend_use_raw_stats: (Optional) If `true`, the legend uses non-summarized stats instead of summarized.
        :param bool group_by_source: For the tabular view, whether to group multi metrics into a single row by a common source. If set to `false`, each source is displayed in its own row. If set to `true`, multiple metrics for the same host are displayed as different columns in the same row.
        :param bool invert_dynamic_legend_hover_control: (Optional) Whether to disable the display of the floating legend (but reenable it when the ctrl-key is pressed).
        :param str line_type: Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, `step-after`, `basis`, `cardinal`, and `monotone`.
        :param float max: Max value of the Y-axis. Set to null or leave blank for auto.
        :param float min: Min value of the Y-axis. Set to null or leave blank for auto.
        :param int num_tags: For the tabular view defines how many point tags to display.
        :param str plain_markdown_content: The markdown content for a Markdown display, in plain text.
        :param bool show_hosts: For the tabular view, whether to display sources. Default is `true`.
        :param bool show_labels: For the tabular view, whether to display labels. Default is `true`.
        :param bool show_raw_values: For the tabular view, whether to display raw values. Default is `false`.
        :param bool sort_values_descending: For the tabular view, whether to display values in descending order. Default is `false`.
        :param int sparkline_decimal_precision: For the single stat view, the decimal precision of the displayed number.
        :param str sparkline_display_color: For the single stat view, the color of the displayed text (when not dynamically determined). Values should be in RGBA format.
        :param str sparkline_display_font_size: For the single stat view, the font size of the displayed text, in percent.
        :param str sparkline_display_horizontal_position: For the single stat view, the horizontal position of the displayed text. Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        :param str sparkline_display_postfix: For the single stat view, a string to append to the displayed text.
        :param str sparkline_display_prefix: For the single stat view, a string to add before the displayed text.
        :param str sparkline_display_value_type: For the single stat view, where to display the name of the query or the value of the query. Valid options are `VALUE` or `LABEL`.
        :param str sparkline_display_vertical_position: This setting is deprecated.
        :param str sparkline_fill_color: For the single stat view, the color of the background fill. Values should be in RGBA format.
        :param str sparkline_line_color: For the single stat view, the color of the line. Values should be in RGBA format.
        :param str sparkline_size: For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart. Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        :param str sparkline_value_color_map_apply_to: For the single stat view, whether to apply dynamic color settings to the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        :param Sequence[str] sparkline_value_color_map_colors: For the single stat view, a list of colors that differing query values map to. Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in RGBA format.
        :param Sequence[int] sparkline_value_color_map_values: This setting is deprecated.
        :param Sequence[float] sparkline_value_color_map_values_v2s: For the single stat view, a list of boundaries for mapping different query values to colors. Must contain one element less than `sparkline_value_color_map_colors`.
        :param Sequence[str] sparkline_value_text_map_texts: For the single stat view, a list of display text values that different query values map to. Must contain one more element than `sparkline_value_text_map_thresholds`.
        :param Sequence[float] sparkline_value_text_map_thresholds: For the single stat view, a list of threshold boundaries for mapping different query values to display text. Must contain one element less than `sparkline_value_text_map_text`.
        :param str stack_type: Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        :param str tag_mode: For the tabular view, which mode to use to determine which point tags to display. Valid options are `all`, `top`, or `custom`.
        :param bool time_based_coloring: For x-y scatterplots, whether to color more recent points as darker than older points.
        :param str type: Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the Markdown display, and `sparkline` to the Single Stat view. Valid options are `line`, `scatterplot`,
               `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`, `top-k`, `status-list`, and `histogram`.
        :param int window_size: Width, in minutes, of the time window to use for `last` windowing.
        :param str windowing: For the tabular view, whether to use the full time window for the query or the last X minutes. Valid options are `full` or `last`.
        :param float xmax: For x-y scatterplots, max value for the X-axis. Set to null for auto.
        :param float xmin: For x-y scatterplots, min value for the X-axis. Set to null for auto.
        :param bool y0_unit_autoscaling: (Optional) Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        :param bool y1_unit_autoscaling: (Optional) Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        :param str y1_units: For plots with multiple Y-axes, units for right side Y-axis.
        :param float ymax: For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        :param float ymin: For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        pulumi.set(__self__, "auto_column_tags", auto_column_tags)
        pulumi.set(__self__, "column_tags", column_tags)
        pulumi.set(__self__, "custom_tags", custom_tags)
        pulumi.set(__self__, "expected_data_spacing", expected_data_spacing)
        pulumi.set(__self__, "fixed_legend_display_stats", fixed_legend_display_stats)
        pulumi.set(__self__, "fixed_legend_enabled", fixed_legend_enabled)
        pulumi.set(__self__, "fixed_legend_filter_field", fixed_legend_filter_field)
        pulumi.set(__self__, "fixed_legend_filter_limit", fixed_legend_filter_limit)
        pulumi.set(__self__, "fixed_legend_filter_sort", fixed_legend_filter_sort)
        pulumi.set(__self__, "fixed_legend_hide_label", fixed_legend_hide_label)
        pulumi.set(__self__, "fixed_legend_position", fixed_legend_position)
        pulumi.set(__self__, "fixed_legend_use_raw_stats", fixed_legend_use_raw_stats)
        pulumi.set(__self__, "group_by_source", group_by_source)
        pulumi.set(__self__, "invert_dynamic_legend_hover_control", invert_dynamic_legend_hover_control)
        pulumi.set(__self__, "line_type", line_type)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "num_tags", num_tags)
        pulumi.set(__self__, "plain_markdown_content", plain_markdown_content)
        pulumi.set(__self__, "show_hosts", show_hosts)
        pulumi.set(__self__, "show_labels", show_labels)
        pulumi.set(__self__, "show_raw_values", show_raw_values)
        pulumi.set(__self__, "sort_values_descending", sort_values_descending)
        pulumi.set(__self__, "sparkline_decimal_precision", sparkline_decimal_precision)
        pulumi.set(__self__, "sparkline_display_color", sparkline_display_color)
        pulumi.set(__self__, "sparkline_display_font_size", sparkline_display_font_size)
        pulumi.set(__self__, "sparkline_display_horizontal_position", sparkline_display_horizontal_position)
        pulumi.set(__self__, "sparkline_display_postfix", sparkline_display_postfix)
        pulumi.set(__self__, "sparkline_display_prefix", sparkline_display_prefix)
        pulumi.set(__self__, "sparkline_display_value_type", sparkline_display_value_type)
        pulumi.set(__self__, "sparkline_display_vertical_position", sparkline_display_vertical_position)
        pulumi.set(__self__, "sparkline_fill_color", sparkline_fill_color)
        pulumi.set(__self__, "sparkline_line_color", sparkline_line_color)
        pulumi.set(__self__, "sparkline_size", sparkline_size)
        pulumi.set(__self__, "sparkline_value_color_map_apply_to", sparkline_value_color_map_apply_to)
        pulumi.set(__self__, "sparkline_value_color_map_colors", sparkline_value_color_map_colors)
        pulumi.set(__self__, "sparkline_value_color_map_values", sparkline_value_color_map_values)
        pulumi.set(__self__, "sparkline_value_color_map_values_v2s", sparkline_value_color_map_values_v2s)
        pulumi.set(__self__, "sparkline_value_text_map_texts", sparkline_value_text_map_texts)
        pulumi.set(__self__, "sparkline_value_text_map_thresholds", sparkline_value_text_map_thresholds)
        pulumi.set(__self__, "stack_type", stack_type)
        pulumi.set(__self__, "tag_mode", tag_mode)
        pulumi.set(__self__, "time_based_coloring", time_based_coloring)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "window_size", window_size)
        pulumi.set(__self__, "windowing", windowing)
        pulumi.set(__self__, "xmax", xmax)
        pulumi.set(__self__, "xmin", xmin)
        pulumi.set(__self__, "y0_scale_si_by1024", y0_scale_si_by1024)
        pulumi.set(__self__, "y0_unit_autoscaling", y0_unit_autoscaling)
        pulumi.set(__self__, "y1_max", y1_max)
        pulumi.set(__self__, "y1_min", y1_min)
        pulumi.set(__self__, "y1_scale_si_by1024", y1_scale_si_by1024)
        pulumi.set(__self__, "y1_unit_autoscaling", y1_unit_autoscaling)
        pulumi.set(__self__, "y1_units", y1_units)
        pulumi.set(__self__, "ymax", ymax)
        pulumi.set(__self__, "ymin", ymin)

    @property
    @pulumi.getter(name="autoColumnTags")
    def auto_column_tags(self) -> bool:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "auto_column_tags")

    @property
    @pulumi.getter(name="columnTags")
    def column_tags(self) -> str:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "column_tags")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Sequence[str]:
        """
        For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        """
        return pulumi.get(self, "custom_tags")

    @property
    @pulumi.getter(name="expectedDataSpacing")
    def expected_data_spacing(self) -> int:
        """
        Threshold (in seconds) for time delta between consecutive points in a series above which a dotted line will replace a solid in line plots. Default is 60.
        """
        return pulumi.get(self, "expected_data_spacing")

    @property
    @pulumi.getter(name="fixedLegendDisplayStats")
    def fixed_legend_display_stats(self) -> Sequence[str]:
        """
        (Optional) For a chart with a fixed legend, a list of statistics to display in the legend.
        """
        return pulumi.get(self, "fixed_legend_display_stats")

    @property
    @pulumi.getter(name="fixedLegendEnabled")
    def fixed_legend_enabled(self) -> bool:
        """
        (Optional) Whether to enable a fixed tabular legend adjacent to the chart.
        """
        return pulumi.get(self, "fixed_legend_enabled")

    @property
    @pulumi.getter(name="fixedLegendFilterField")
    def fixed_legend_filter_field(self) -> str:
        """
        (Optional) Statistic to use for determining whether a series is displayed on the fixed legend. Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        """
        return pulumi.get(self, "fixed_legend_filter_field")

    @property
    @pulumi.getter(name="fixedLegendFilterLimit")
    def fixed_legend_filter_limit(self) -> int:
        """
        (Optional) Number of series to include in the fixed legend.
        """
        return pulumi.get(self, "fixed_legend_filter_limit")

    @property
    @pulumi.getter(name="fixedLegendFilterSort")
    def fixed_legend_filter_sort(self) -> str:
        """
        (Optional) Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options are `TOP`, and `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_filter_sort")

    @property
    @pulumi.getter(name="fixedLegendHideLabel")
    def fixed_legend_hide_label(self) -> bool:
        """
        (Optional) This setting is deprecated.
        """
        return pulumi.get(self, "fixed_legend_hide_label")

    @property
    @pulumi.getter(name="fixedLegendPosition")
    def fixed_legend_position(self) -> str:
        """
        (Optional)  Where the fixed legend should be displayed with respect to the chart. Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_position")

    @property
    @pulumi.getter(name="fixedLegendUseRawStats")
    def fixed_legend_use_raw_stats(self) -> bool:
        """
        (Optional) If `true`, the legend uses non-summarized stats instead of summarized.
        """
        return pulumi.get(self, "fixed_legend_use_raw_stats")

    @property
    @pulumi.getter(name="groupBySource")
    def group_by_source(self) -> bool:
        """
        For the tabular view, whether to group multi metrics into a single row by a common source. If set to `false`, each source is displayed in its own row. If set to `true`, multiple metrics for the same host are displayed as different columns in the same row.
        """
        return pulumi.get(self, "group_by_source")

    @property
    @pulumi.getter(name="invertDynamicLegendHoverControl")
    def invert_dynamic_legend_hover_control(self) -> bool:
        """
        (Optional) Whether to disable the display of the floating legend (but reenable it when the ctrl-key is pressed).
        """
        return pulumi.get(self, "invert_dynamic_legend_hover_control")

    @property
    @pulumi.getter(name="lineType")
    def line_type(self) -> str:
        """
        Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, `step-after`, `basis`, `cardinal`, and `monotone`.
        """
        return pulumi.get(self, "line_type")

    @property
    @pulumi.getter
    def max(self) -> float:
        """
        Max value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> float:
        """
        Min value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="numTags")
    def num_tags(self) -> int:
        """
        For the tabular view defines how many point tags to display.
        """
        return pulumi.get(self, "num_tags")

    @property
    @pulumi.getter(name="plainMarkdownContent")
    def plain_markdown_content(self) -> str:
        """
        The markdown content for a Markdown display, in plain text.
        """
        return pulumi.get(self, "plain_markdown_content")

    @property
    @pulumi.getter(name="showHosts")
    def show_hosts(self) -> bool:
        """
        For the tabular view, whether to display sources. Default is `true`.
        """
        return pulumi.get(self, "show_hosts")

    @property
    @pulumi.getter(name="showLabels")
    def show_labels(self) -> bool:
        """
        For the tabular view, whether to display labels. Default is `true`.
        """
        return pulumi.get(self, "show_labels")

    @property
    @pulumi.getter(name="showRawValues")
    def show_raw_values(self) -> bool:
        """
        For the tabular view, whether to display raw values. Default is `false`.
        """
        return pulumi.get(self, "show_raw_values")

    @property
    @pulumi.getter(name="sortValuesDescending")
    def sort_values_descending(self) -> bool:
        """
        For the tabular view, whether to display values in descending order. Default is `false`.
        """
        return pulumi.get(self, "sort_values_descending")

    @property
    @pulumi.getter(name="sparklineDecimalPrecision")
    def sparkline_decimal_precision(self) -> int:
        """
        For the single stat view, the decimal precision of the displayed number.
        """
        return pulumi.get(self, "sparkline_decimal_precision")

    @property
    @pulumi.getter(name="sparklineDisplayColor")
    def sparkline_display_color(self) -> str:
        """
        For the single stat view, the color of the displayed text (when not dynamically determined). Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_display_color")

    @property
    @pulumi.getter(name="sparklineDisplayFontSize")
    def sparkline_display_font_size(self) -> str:
        """
        For the single stat view, the font size of the displayed text, in percent.
        """
        return pulumi.get(self, "sparkline_display_font_size")

    @property
    @pulumi.getter(name="sparklineDisplayHorizontalPosition")
    def sparkline_display_horizontal_position(self) -> str:
        """
        For the single stat view, the horizontal position of the displayed text. Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        """
        return pulumi.get(self, "sparkline_display_horizontal_position")

    @property
    @pulumi.getter(name="sparklineDisplayPostfix")
    def sparkline_display_postfix(self) -> str:
        """
        For the single stat view, a string to append to the displayed text.
        """
        return pulumi.get(self, "sparkline_display_postfix")

    @property
    @pulumi.getter(name="sparklineDisplayPrefix")
    def sparkline_display_prefix(self) -> str:
        """
        For the single stat view, a string to add before the displayed text.
        """
        return pulumi.get(self, "sparkline_display_prefix")

    @property
    @pulumi.getter(name="sparklineDisplayValueType")
    def sparkline_display_value_type(self) -> str:
        """
        For the single stat view, where to display the name of the query or the value of the query. Valid options are `VALUE` or `LABEL`.
        """
        return pulumi.get(self, "sparkline_display_value_type")

    @property
    @pulumi.getter(name="sparklineDisplayVerticalPosition")
    def sparkline_display_vertical_position(self) -> str:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_display_vertical_position")

    @property
    @pulumi.getter(name="sparklineFillColor")
    def sparkline_fill_color(self) -> str:
        """
        For the single stat view, the color of the background fill. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_fill_color")

    @property
    @pulumi.getter(name="sparklineLineColor")
    def sparkline_line_color(self) -> str:
        """
        For the single stat view, the color of the line. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_line_color")

    @property
    @pulumi.getter(name="sparklineSize")
    def sparkline_size(self) -> str:
        """
        For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart. Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        """
        return pulumi.get(self, "sparkline_size")

    @property
    @pulumi.getter(name="sparklineValueColorMapApplyTo")
    def sparkline_value_color_map_apply_to(self) -> str:
        """
        For the single stat view, whether to apply dynamic color settings to the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        """
        return pulumi.get(self, "sparkline_value_color_map_apply_to")

    @property
    @pulumi.getter(name="sparklineValueColorMapColors")
    def sparkline_value_color_map_colors(self) -> Sequence[str]:
        """
        For the single stat view, a list of colors that differing query values map to. Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_value_color_map_colors")

    @property
    @pulumi.getter(name="sparklineValueColorMapValues")
    def sparkline_value_color_map_values(self) -> Sequence[int]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_value_color_map_values")

    @property
    @pulumi.getter(name="sparklineValueColorMapValuesV2s")
    def sparkline_value_color_map_values_v2s(self) -> Sequence[float]:
        """
        For the single stat view, a list of boundaries for mapping different query values to colors. Must contain one element less than `sparkline_value_color_map_colors`.
        """
        return pulumi.get(self, "sparkline_value_color_map_values_v2s")

    @property
    @pulumi.getter(name="sparklineValueTextMapTexts")
    def sparkline_value_text_map_texts(self) -> Sequence[str]:
        """
        For the single stat view, a list of display text values that different query values map to. Must contain one more element than `sparkline_value_text_map_thresholds`.
        """
        return pulumi.get(self, "sparkline_value_text_map_texts")

    @property
    @pulumi.getter(name="sparklineValueTextMapThresholds")
    def sparkline_value_text_map_thresholds(self) -> Sequence[float]:
        """
        For the single stat view, a list of threshold boundaries for mapping different query values to display text. Must contain one element less than `sparkline_value_text_map_text`.
        """
        return pulumi.get(self, "sparkline_value_text_map_thresholds")

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> str:
        """
        Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        """
        return pulumi.get(self, "stack_type")

    @property
    @pulumi.getter(name="tagMode")
    def tag_mode(self) -> str:
        """
        For the tabular view, which mode to use to determine which point tags to display. Valid options are `all`, `top`, or `custom`.
        """
        return pulumi.get(self, "tag_mode")

    @property
    @pulumi.getter(name="timeBasedColoring")
    def time_based_coloring(self) -> bool:
        """
        For x-y scatterplots, whether to color more recent points as darker than older points.
        """
        return pulumi.get(self, "time_based_coloring")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the Markdown display, and `sparkline` to the Single Stat view. Valid options are `line`, `scatterplot`,
        `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`, `top-k`, `status-list`, and `histogram`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> int:
        """
        Width, in minutes, of the time window to use for `last` windowing.
        """
        return pulumi.get(self, "window_size")

    @property
    @pulumi.getter
    def windowing(self) -> str:
        """
        For the tabular view, whether to use the full time window for the query or the last X minutes. Valid options are `full` or `last`.
        """
        return pulumi.get(self, "windowing")

    @property
    @pulumi.getter
    def xmax(self) -> float:
        """
        For x-y scatterplots, max value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmax")

    @property
    @pulumi.getter
    def xmin(self) -> float:
        """
        For x-y scatterplots, min value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmin")

    @property
    @pulumi.getter(name="y0ScaleSiBy1024")
    def y0_scale_si_by1024(self) -> bool:
        return pulumi.get(self, "y0_scale_si_by1024")

    @property
    @pulumi.getter(name="y0UnitAutoscaling")
    def y0_unit_autoscaling(self) -> bool:
        """
        (Optional) Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y0_unit_autoscaling")

    @property
    @pulumi.getter(name="y1Max")
    def y1_max(self) -> float:
        return pulumi.get(self, "y1_max")

    @property
    @pulumi.getter(name="y1Min")
    def y1_min(self) -> float:
        return pulumi.get(self, "y1_min")

    @property
    @pulumi.getter(name="y1ScaleSiBy1024")
    def y1_scale_si_by1024(self) -> bool:
        return pulumi.get(self, "y1_scale_si_by1024")

    @property
    @pulumi.getter(name="y1UnitAutoscaling")
    def y1_unit_autoscaling(self) -> bool:
        """
        (Optional) Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y1_unit_autoscaling")

    @property
    @pulumi.getter(name="y1Units")
    def y1_units(self) -> str:
        """
        For plots with multiple Y-axes, units for right side Y-axis.
        """
        return pulumi.get(self, "y1_units")

    @property
    @pulumi.getter
    def ymax(self) -> float:
        """
        For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymax")

    @property
    @pulumi.getter
    def ymin(self) -> float:
        """
        For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymin")


@pulumi.output_type
class GetDashboardSectionRowChartSourceResult(dict):
    def __init__(__self__, *,
                 disabled: bool,
                 name: str,
                 query: str,
                 querybuilder_enabled: bool,
                 scatter_plot_source: str,
                 secondary_axis: bool,
                 source_color: str,
                 source_description: str):
        """
        :param bool disabled: Whether the source is disabled.
        :param str name: The name of the parameters.
        :param str query: Query expression to plot on the chart.
        :param str scatter_plot_source: For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        :param str source_description: A description for the purpose of this source.
        """
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "querybuilder_enabled", querybuilder_enabled)
        pulumi.set(__self__, "scatter_plot_source", scatter_plot_source)
        pulumi.set(__self__, "secondary_axis", secondary_axis)
        pulumi.set(__self__, "source_color", source_color)
        pulumi.set(__self__, "source_description", source_description)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether the source is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Query expression to plot on the chart.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="querybuilderEnabled")
    def querybuilder_enabled(self) -> bool:
        return pulumi.get(self, "querybuilder_enabled")

    @property
    @pulumi.getter(name="scatterPlotSource")
    def scatter_plot_source(self) -> str:
        """
        For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        """
        return pulumi.get(self, "scatter_plot_source")

    @property
    @pulumi.getter(name="secondaryAxis")
    def secondary_axis(self) -> bool:
        return pulumi.get(self, "secondary_axis")

    @property
    @pulumi.getter(name="sourceColor")
    def source_color(self) -> str:
        return pulumi.get(self, "source_color")

    @property
    @pulumi.getter(name="sourceDescription")
    def source_description(self) -> str:
        """
        A description for the purpose of this source.
        """
        return pulumi.get(self, "source_description")


@pulumi.output_type
class GetDashboardsDashboardResult(dict):
    def __init__(__self__, *,
                 can_modifies: Sequence[str],
                 can_views: Sequence[str],
                 chart_title_bg_color: str,
                 chart_title_color: str,
                 chart_title_scalar: int,
                 created_epoch_millis: int,
                 creator_id: str,
                 customer: str,
                 default_end_time: int,
                 default_start_time: int,
                 default_time_window: str,
                 deleted: bool,
                 description: str,
                 display_description: bool,
                 display_query_parameters: bool,
                 display_section_table_of_contents: bool,
                 event_filter_type: str,
                 event_query: str,
                 favorite: bool,
                 hidden: bool,
                 id: str,
                 name: str,
                 num_charts: int,
                 num_favorites: int,
                 parameter_details: Sequence['outputs.GetDashboardsDashboardParameterDetailResult'],
                 parameters: Mapping[str, Any],
                 sections: Sequence['outputs.GetDashboardsDashboardSectionResult'],
                 system_owned: bool,
                 tags: Sequence[str],
                 updated_epoch_millis: int,
                 updater_id: str,
                 url: str,
                 views_last_day: int,
                 views_last_month: int,
                 views_last_week: int):
        """
        :param Sequence[str] can_modifies: A list of users that have modify ACL access to the dashboard.
        :param Sequence[str] can_views: A list of users that have view ACL access to the dashboard.
        :param str description: Description of the chart.
        :param bool display_query_parameters: Whether the dashboard parameters section is opened by default when the dashboard is shown.
        :param bool display_section_table_of_contents: Whether the "pills" quick-linked the sections of the dashboard are displayed by default when the dashboard is shown.
        :param str event_filter_type: How charts belonging to this dashboard should display events. `BYCHART` is default if
               unspecified. Valid options are: `BYCHART`, `AUTOMATIC`, `ALL`, `NONE`, `BYDASHBOARD`, and `BYCHARTANDDASHBOARD`.
        :param str name: The name of the parameters.
        :param Sequence['GetDashboardsDashboardParameterDetailArgs'] parameter_details: The current JSON representation of dashboard parameters. See parameter details.
        :param Sequence[str] tags: A set of tags to assign to this resource.
        :param str url: Unique identifier, also a URL slug of the dashboard.
        """
        pulumi.set(__self__, "can_modifies", can_modifies)
        pulumi.set(__self__, "can_views", can_views)
        pulumi.set(__self__, "chart_title_bg_color", chart_title_bg_color)
        pulumi.set(__self__, "chart_title_color", chart_title_color)
        pulumi.set(__self__, "chart_title_scalar", chart_title_scalar)
        pulumi.set(__self__, "created_epoch_millis", created_epoch_millis)
        pulumi.set(__self__, "creator_id", creator_id)
        pulumi.set(__self__, "customer", customer)
        pulumi.set(__self__, "default_end_time", default_end_time)
        pulumi.set(__self__, "default_start_time", default_start_time)
        pulumi.set(__self__, "default_time_window", default_time_window)
        pulumi.set(__self__, "deleted", deleted)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_description", display_description)
        pulumi.set(__self__, "display_query_parameters", display_query_parameters)
        pulumi.set(__self__, "display_section_table_of_contents", display_section_table_of_contents)
        pulumi.set(__self__, "event_filter_type", event_filter_type)
        pulumi.set(__self__, "event_query", event_query)
        pulumi.set(__self__, "favorite", favorite)
        pulumi.set(__self__, "hidden", hidden)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "num_charts", num_charts)
        pulumi.set(__self__, "num_favorites", num_favorites)
        pulumi.set(__self__, "parameter_details", parameter_details)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "sections", sections)
        pulumi.set(__self__, "system_owned", system_owned)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "updated_epoch_millis", updated_epoch_millis)
        pulumi.set(__self__, "updater_id", updater_id)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "views_last_day", views_last_day)
        pulumi.set(__self__, "views_last_month", views_last_month)
        pulumi.set(__self__, "views_last_week", views_last_week)

    @property
    @pulumi.getter(name="canModifies")
    def can_modifies(self) -> Sequence[str]:
        """
        A list of users that have modify ACL access to the dashboard.
        """
        return pulumi.get(self, "can_modifies")

    @property
    @pulumi.getter(name="canViews")
    def can_views(self) -> Sequence[str]:
        """
        A list of users that have view ACL access to the dashboard.
        """
        return pulumi.get(self, "can_views")

    @property
    @pulumi.getter(name="chartTitleBgColor")
    def chart_title_bg_color(self) -> str:
        return pulumi.get(self, "chart_title_bg_color")

    @property
    @pulumi.getter(name="chartTitleColor")
    def chart_title_color(self) -> str:
        return pulumi.get(self, "chart_title_color")

    @property
    @pulumi.getter(name="chartTitleScalar")
    def chart_title_scalar(self) -> int:
        return pulumi.get(self, "chart_title_scalar")

    @property
    @pulumi.getter(name="createdEpochMillis")
    def created_epoch_millis(self) -> int:
        return pulumi.get(self, "created_epoch_millis")

    @property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> str:
        return pulumi.get(self, "creator_id")

    @property
    @pulumi.getter
    def customer(self) -> str:
        return pulumi.get(self, "customer")

    @property
    @pulumi.getter(name="defaultEndTime")
    def default_end_time(self) -> int:
        return pulumi.get(self, "default_end_time")

    @property
    @pulumi.getter(name="defaultStartTime")
    def default_start_time(self) -> int:
        return pulumi.get(self, "default_start_time")

    @property
    @pulumi.getter(name="defaultTimeWindow")
    def default_time_window(self) -> str:
        return pulumi.get(self, "default_time_window")

    @property
    @pulumi.getter
    def deleted(self) -> bool:
        return pulumi.get(self, "deleted")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayDescription")
    def display_description(self) -> bool:
        return pulumi.get(self, "display_description")

    @property
    @pulumi.getter(name="displayQueryParameters")
    def display_query_parameters(self) -> bool:
        """
        Whether the dashboard parameters section is opened by default when the dashboard is shown.
        """
        return pulumi.get(self, "display_query_parameters")

    @property
    @pulumi.getter(name="displaySectionTableOfContents")
    def display_section_table_of_contents(self) -> bool:
        """
        Whether the "pills" quick-linked the sections of the dashboard are displayed by default when the dashboard is shown.
        """
        return pulumi.get(self, "display_section_table_of_contents")

    @property
    @pulumi.getter(name="eventFilterType")
    def event_filter_type(self) -> str:
        """
        How charts belonging to this dashboard should display events. `BYCHART` is default if
        unspecified. Valid options are: `BYCHART`, `AUTOMATIC`, `ALL`, `NONE`, `BYDASHBOARD`, and `BYCHARTANDDASHBOARD`.
        """
        return pulumi.get(self, "event_filter_type")

    @property
    @pulumi.getter(name="eventQuery")
    def event_query(self) -> str:
        return pulumi.get(self, "event_query")

    @property
    @pulumi.getter
    def favorite(self) -> bool:
        return pulumi.get(self, "favorite")

    @property
    @pulumi.getter
    def hidden(self) -> bool:
        return pulumi.get(self, "hidden")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numCharts")
    def num_charts(self) -> int:
        return pulumi.get(self, "num_charts")

    @property
    @pulumi.getter(name="numFavorites")
    def num_favorites(self) -> int:
        return pulumi.get(self, "num_favorites")

    @property
    @pulumi.getter(name="parameterDetails")
    def parameter_details(self) -> Sequence['outputs.GetDashboardsDashboardParameterDetailResult']:
        """
        The current JSON representation of dashboard parameters. See parameter details.
        """
        return pulumi.get(self, "parameter_details")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, Any]:
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def sections(self) -> Sequence['outputs.GetDashboardsDashboardSectionResult']:
        return pulumi.get(self, "sections")

    @property
    @pulumi.getter(name="systemOwned")
    def system_owned(self) -> bool:
        return pulumi.get(self, "system_owned")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A set of tags to assign to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> int:
        return pulumi.get(self, "updated_epoch_millis")

    @property
    @pulumi.getter(name="updaterId")
    def updater_id(self) -> str:
        return pulumi.get(self, "updater_id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Unique identifier, also a URL slug of the dashboard.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="viewsLastDay")
    def views_last_day(self) -> int:
        return pulumi.get(self, "views_last_day")

    @property
    @pulumi.getter(name="viewsLastMonth")
    def views_last_month(self) -> int:
        return pulumi.get(self, "views_last_month")

    @property
    @pulumi.getter(name="viewsLastWeek")
    def views_last_week(self) -> int:
        return pulumi.get(self, "views_last_week")


@pulumi.output_type
class GetDashboardsDashboardParameterDetailResult(dict):
    def __init__(__self__, *,
                 default_value: str,
                 dynamic_field_type: str,
                 hide_from_view: bool,
                 label: str,
                 parameter_type: str,
                 query_value: str,
                 tag_key: str,
                 values_to_readable_strings: Mapping[str, str]):
        """
        :param str default_value: The default value of the parameter.
        :param str dynamic_field_type: For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
               `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        :param bool hide_from_view: If `true` the parameter will only be shown on the edit view of the dashboard.
        :param str label: The label for the parameter.
        :param str parameter_type: The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        :param str query_value: For `DYNAMIC` parameter types, the query to execute to return values.
        :param str tag_key: For `TAG_KEY` dynamic field types, the tag key to return.
        :param Mapping[str, str] values_to_readable_strings: A string to string map. At least one of the keys must match the value of
               `default_value`.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "dynamic_field_type", dynamic_field_type)
        pulumi.set(__self__, "hide_from_view", hide_from_view)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "query_value", query_value)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "values_to_readable_strings", values_to_readable_strings)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> str:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="dynamicFieldType")
    def dynamic_field_type(self) -> str:
        """
        For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
        `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        """
        return pulumi.get(self, "dynamic_field_type")

    @property
    @pulumi.getter(name="hideFromView")
    def hide_from_view(self) -> bool:
        """
        If `true` the parameter will only be shown on the edit view of the dashboard.
        """
        return pulumi.get(self, "hide_from_view")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        The label for the parameter.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> str:
        """
        The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        """
        return pulumi.get(self, "parameter_type")

    @property
    @pulumi.getter(name="queryValue")
    def query_value(self) -> str:
        """
        For `DYNAMIC` parameter types, the query to execute to return values.
        """
        return pulumi.get(self, "query_value")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> str:
        """
        For `TAG_KEY` dynamic field types, the tag key to return.
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="valuesToReadableStrings")
    def values_to_readable_strings(self) -> Mapping[str, str]:
        """
        A string to string map. At least one of the keys must match the value of
        `default_value`.
        """
        return pulumi.get(self, "values_to_readable_strings")


@pulumi.output_type
class GetDashboardsDashboardSectionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 rows: Sequence['outputs.GetDashboardsDashboardSectionRowResult']):
        """
        :param str name: The name of the parameters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rows", rows)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rows(self) -> Sequence['outputs.GetDashboardsDashboardSectionRowResult']:
        return pulumi.get(self, "rows")


@pulumi.output_type
class GetDashboardsDashboardSectionRowResult(dict):
    def __init__(__self__, *,
                 charts: Sequence['outputs.GetDashboardsDashboardSectionRowChartResult'],
                 height_factor: int,
                 name: str):
        """
        :param str name: The name of the parameters.
        """
        pulumi.set(__self__, "charts", charts)
        pulumi.set(__self__, "height_factor", height_factor)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def charts(self) -> Sequence['outputs.GetDashboardsDashboardSectionRowChartResult']:
        return pulumi.get(self, "charts")

    @property
    @pulumi.getter(name="heightFactor")
    def height_factor(self) -> int:
        return pulumi.get(self, "height_factor")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDashboardsDashboardSectionRowChartResult(dict):
    def __init__(__self__, *,
                 base: int,
                 chart_attributes: str,
                 chart_settings: Sequence['outputs.GetDashboardsDashboardSectionRowChartChartSettingResult'],
                 description: str,
                 include_obsolete_metrics: bool,
                 interpolate_points_key: bool,
                 name: str,
                 no_default_events: bool,
                 sources: Sequence['outputs.GetDashboardsDashboardSectionRowChartSourceResult'],
                 summarization: str,
                 units: str):
        """
        :param int base: The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        :param str description: Description of the chart.
        :param str name: The name of the parameters.
        :param str summarization: Summarization strategy for the chart. MEAN is default.
        :param str units: String to label the units of the chart on the Y-Axis.
        """
        pulumi.set(__self__, "base", base)
        pulumi.set(__self__, "chart_attributes", chart_attributes)
        pulumi.set(__self__, "chart_settings", chart_settings)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "include_obsolete_metrics", include_obsolete_metrics)
        pulumi.set(__self__, "interpolate_points_key", interpolate_points_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "no_default_events", no_default_events)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "summarization", summarization)
        pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter
    def base(self) -> int:
        """
        The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter(name="chartAttributes")
    def chart_attributes(self) -> str:
        return pulumi.get(self, "chart_attributes")

    @property
    @pulumi.getter(name="chartSettings")
    def chart_settings(self) -> Sequence['outputs.GetDashboardsDashboardSectionRowChartChartSettingResult']:
        return pulumi.get(self, "chart_settings")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="includeObsoleteMetrics")
    def include_obsolete_metrics(self) -> bool:
        return pulumi.get(self, "include_obsolete_metrics")

    @property
    @pulumi.getter(name="interpolatePointsKey")
    def interpolate_points_key(self) -> bool:
        return pulumi.get(self, "interpolate_points_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noDefaultEvents")
    def no_default_events(self) -> bool:
        return pulumi.get(self, "no_default_events")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetDashboardsDashboardSectionRowChartSourceResult']:
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def summarization(self) -> str:
        """
        Summarization strategy for the chart. MEAN is default.
        """
        return pulumi.get(self, "summarization")

    @property
    @pulumi.getter
    def units(self) -> str:
        """
        String to label the units of the chart on the Y-Axis.
        """
        return pulumi.get(self, "units")


@pulumi.output_type
class GetDashboardsDashboardSectionRowChartChartSettingResult(dict):
    def __init__(__self__, *,
                 auto_column_tags: bool,
                 column_tags: str,
                 custom_tags: Sequence[str],
                 expected_data_spacing: int,
                 fixed_legend_display_stats: Sequence[str],
                 fixed_legend_enabled: bool,
                 fixed_legend_filter_field: str,
                 fixed_legend_filter_limit: int,
                 fixed_legend_filter_sort: str,
                 fixed_legend_hide_label: bool,
                 fixed_legend_position: str,
                 fixed_legend_use_raw_stats: bool,
                 group_by_source: bool,
                 invert_dynamic_legend_hover_control: bool,
                 line_type: str,
                 max: float,
                 min: float,
                 num_tags: int,
                 plain_markdown_content: str,
                 show_hosts: bool,
                 show_labels: bool,
                 show_raw_values: bool,
                 sort_values_descending: bool,
                 sparkline_decimal_precision: int,
                 sparkline_display_color: str,
                 sparkline_display_font_size: str,
                 sparkline_display_horizontal_position: str,
                 sparkline_display_postfix: str,
                 sparkline_display_prefix: str,
                 sparkline_display_value_type: str,
                 sparkline_display_vertical_position: str,
                 sparkline_fill_color: str,
                 sparkline_line_color: str,
                 sparkline_size: str,
                 sparkline_value_color_map_apply_to: str,
                 sparkline_value_color_map_colors: Sequence[str],
                 sparkline_value_color_map_values: Sequence[int],
                 sparkline_value_color_map_values_v2s: Sequence[float],
                 sparkline_value_text_map_texts: Sequence[str],
                 sparkline_value_text_map_thresholds: Sequence[float],
                 stack_type: str,
                 tag_mode: str,
                 time_based_coloring: bool,
                 type: str,
                 window_size: int,
                 windowing: str,
                 xmax: float,
                 xmin: float,
                 y0_scale_si_by1024: bool,
                 y0_unit_autoscaling: bool,
                 y1_max: float,
                 y1_min: float,
                 y1_scale_si_by1024: bool,
                 y1_unit_autoscaling: bool,
                 y1_units: str,
                 ymax: float,
                 ymin: float):
        """
        :param bool auto_column_tags: This setting is deprecated.
        :param str column_tags: This setting is deprecated.
        :param Sequence[str] custom_tags: For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        :param int expected_data_spacing: Threshold (in seconds) for time delta between consecutive points in a series above which a dotted line will replace a solid in line plots. Default is 60.
        :param Sequence[str] fixed_legend_display_stats: (Optional) For a chart with a fixed legend, a list of statistics to display in the legend.
        :param bool fixed_legend_enabled: (Optional) Whether to enable a fixed tabular legend adjacent to the chart.
        :param str fixed_legend_filter_field: (Optional) Statistic to use for determining whether a series is displayed on the fixed legend. Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        :param int fixed_legend_filter_limit: (Optional) Number of series to include in the fixed legend.
        :param str fixed_legend_filter_sort: (Optional) Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options are `TOP`, and `BOTTOM`.
        :param bool fixed_legend_hide_label: (Optional) This setting is deprecated.
        :param str fixed_legend_position: (Optional)  Where the fixed legend should be displayed with respect to the chart. Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        :param bool fixed_legend_use_raw_stats: (Optional) If `true`, the legend uses non-summarized stats instead of summarized.
        :param bool group_by_source: For the tabular view, whether to group multi metrics into a single row by a common source. If set to `false`, each source is displayed in its own row. If set to `true`, multiple metrics for the same host are displayed as different columns in the same row.
        :param bool invert_dynamic_legend_hover_control: (Optional) Whether to disable the display of the floating legend (but reenable it when the ctrl-key is pressed).
        :param str line_type: Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, `step-after`, `basis`, `cardinal`, and `monotone`.
        :param float max: Max value of the Y-axis. Set to null or leave blank for auto.
        :param float min: Min value of the Y-axis. Set to null or leave blank for auto.
        :param int num_tags: For the tabular view defines how many point tags to display.
        :param str plain_markdown_content: The markdown content for a Markdown display, in plain text.
        :param bool show_hosts: For the tabular view, whether to display sources. Default is `true`.
        :param bool show_labels: For the tabular view, whether to display labels. Default is `true`.
        :param bool show_raw_values: For the tabular view, whether to display raw values. Default is `false`.
        :param bool sort_values_descending: For the tabular view, whether to display values in descending order. Default is `false`.
        :param int sparkline_decimal_precision: For the single stat view, the decimal precision of the displayed number.
        :param str sparkline_display_color: For the single stat view, the color of the displayed text (when not dynamically determined). Values should be in RGBA format.
        :param str sparkline_display_font_size: For the single stat view, the font size of the displayed text, in percent.
        :param str sparkline_display_horizontal_position: For the single stat view, the horizontal position of the displayed text. Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        :param str sparkline_display_postfix: For the single stat view, a string to append to the displayed text.
        :param str sparkline_display_prefix: For the single stat view, a string to add before the displayed text.
        :param str sparkline_display_value_type: For the single stat view, where to display the name of the query or the value of the query. Valid options are `VALUE` or `LABEL`.
        :param str sparkline_display_vertical_position: This setting is deprecated.
        :param str sparkline_fill_color: For the single stat view, the color of the background fill. Values should be in RGBA format.
        :param str sparkline_line_color: For the single stat view, the color of the line. Values should be in RGBA format.
        :param str sparkline_size: For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart. Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        :param str sparkline_value_color_map_apply_to: For the single stat view, whether to apply dynamic color settings to the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        :param Sequence[str] sparkline_value_color_map_colors: For the single stat view, a list of colors that differing query values map to. Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in RGBA format.
        :param Sequence[int] sparkline_value_color_map_values: This setting is deprecated.
        :param Sequence[float] sparkline_value_color_map_values_v2s: For the single stat view, a list of boundaries for mapping different query values to colors. Must contain one element less than `sparkline_value_color_map_colors`.
        :param Sequence[str] sparkline_value_text_map_texts: For the single stat view, a list of display text values that different query values map to. Must contain one more element than `sparkline_value_text_map_thresholds`.
        :param Sequence[float] sparkline_value_text_map_thresholds: For the single stat view, a list of threshold boundaries for mapping different query values to display text. Must contain one element less than `sparkline_value_text_map_text`.
        :param str stack_type: Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        :param str tag_mode: For the tabular view, which mode to use to determine which point tags to display. Valid options are `all`, `top`, or `custom`.
        :param bool time_based_coloring: For x-y scatterplots, whether to color more recent points as darker than older points.
        :param str type: Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the Markdown display, and `sparkline` to the Single Stat view. Valid options are `line`, `scatterplot`, `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`, `top-k`, `status-list`, and `histogram`.
        :param int window_size: Width, in minutes, of the time window to use for `last` windowing.
        :param str windowing: For the tabular view, whether to use the full time window for the query or the last X minutes. Valid options are `full` or `last`.
        :param float xmax: For x-y scatterplots, max value for the X-axis. Set to null for auto.
        :param float xmin: For x-y scatterplots, min value for the X-axis. Set to null for auto.
        :param bool y0_unit_autoscaling: (Optional) Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        :param bool y1_unit_autoscaling: (Optional) Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        :param str y1_units: For plots with multiple Y-axes, units for right side Y-axis.
        :param float ymax: For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        :param float ymin: For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        pulumi.set(__self__, "auto_column_tags", auto_column_tags)
        pulumi.set(__self__, "column_tags", column_tags)
        pulumi.set(__self__, "custom_tags", custom_tags)
        pulumi.set(__self__, "expected_data_spacing", expected_data_spacing)
        pulumi.set(__self__, "fixed_legend_display_stats", fixed_legend_display_stats)
        pulumi.set(__self__, "fixed_legend_enabled", fixed_legend_enabled)
        pulumi.set(__self__, "fixed_legend_filter_field", fixed_legend_filter_field)
        pulumi.set(__self__, "fixed_legend_filter_limit", fixed_legend_filter_limit)
        pulumi.set(__self__, "fixed_legend_filter_sort", fixed_legend_filter_sort)
        pulumi.set(__self__, "fixed_legend_hide_label", fixed_legend_hide_label)
        pulumi.set(__self__, "fixed_legend_position", fixed_legend_position)
        pulumi.set(__self__, "fixed_legend_use_raw_stats", fixed_legend_use_raw_stats)
        pulumi.set(__self__, "group_by_source", group_by_source)
        pulumi.set(__self__, "invert_dynamic_legend_hover_control", invert_dynamic_legend_hover_control)
        pulumi.set(__self__, "line_type", line_type)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "num_tags", num_tags)
        pulumi.set(__self__, "plain_markdown_content", plain_markdown_content)
        pulumi.set(__self__, "show_hosts", show_hosts)
        pulumi.set(__self__, "show_labels", show_labels)
        pulumi.set(__self__, "show_raw_values", show_raw_values)
        pulumi.set(__self__, "sort_values_descending", sort_values_descending)
        pulumi.set(__self__, "sparkline_decimal_precision", sparkline_decimal_precision)
        pulumi.set(__self__, "sparkline_display_color", sparkline_display_color)
        pulumi.set(__self__, "sparkline_display_font_size", sparkline_display_font_size)
        pulumi.set(__self__, "sparkline_display_horizontal_position", sparkline_display_horizontal_position)
        pulumi.set(__self__, "sparkline_display_postfix", sparkline_display_postfix)
        pulumi.set(__self__, "sparkline_display_prefix", sparkline_display_prefix)
        pulumi.set(__self__, "sparkline_display_value_type", sparkline_display_value_type)
        pulumi.set(__self__, "sparkline_display_vertical_position", sparkline_display_vertical_position)
        pulumi.set(__self__, "sparkline_fill_color", sparkline_fill_color)
        pulumi.set(__self__, "sparkline_line_color", sparkline_line_color)
        pulumi.set(__self__, "sparkline_size", sparkline_size)
        pulumi.set(__self__, "sparkline_value_color_map_apply_to", sparkline_value_color_map_apply_to)
        pulumi.set(__self__, "sparkline_value_color_map_colors", sparkline_value_color_map_colors)
        pulumi.set(__self__, "sparkline_value_color_map_values", sparkline_value_color_map_values)
        pulumi.set(__self__, "sparkline_value_color_map_values_v2s", sparkline_value_color_map_values_v2s)
        pulumi.set(__self__, "sparkline_value_text_map_texts", sparkline_value_text_map_texts)
        pulumi.set(__self__, "sparkline_value_text_map_thresholds", sparkline_value_text_map_thresholds)
        pulumi.set(__self__, "stack_type", stack_type)
        pulumi.set(__self__, "tag_mode", tag_mode)
        pulumi.set(__self__, "time_based_coloring", time_based_coloring)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "window_size", window_size)
        pulumi.set(__self__, "windowing", windowing)
        pulumi.set(__self__, "xmax", xmax)
        pulumi.set(__self__, "xmin", xmin)
        pulumi.set(__self__, "y0_scale_si_by1024", y0_scale_si_by1024)
        pulumi.set(__self__, "y0_unit_autoscaling", y0_unit_autoscaling)
        pulumi.set(__self__, "y1_max", y1_max)
        pulumi.set(__self__, "y1_min", y1_min)
        pulumi.set(__self__, "y1_scale_si_by1024", y1_scale_si_by1024)
        pulumi.set(__self__, "y1_unit_autoscaling", y1_unit_autoscaling)
        pulumi.set(__self__, "y1_units", y1_units)
        pulumi.set(__self__, "ymax", ymax)
        pulumi.set(__self__, "ymin", ymin)

    @property
    @pulumi.getter(name="autoColumnTags")
    def auto_column_tags(self) -> bool:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "auto_column_tags")

    @property
    @pulumi.getter(name="columnTags")
    def column_tags(self) -> str:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "column_tags")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Sequence[str]:
        """
        For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        """
        return pulumi.get(self, "custom_tags")

    @property
    @pulumi.getter(name="expectedDataSpacing")
    def expected_data_spacing(self) -> int:
        """
        Threshold (in seconds) for time delta between consecutive points in a series above which a dotted line will replace a solid in line plots. Default is 60.
        """
        return pulumi.get(self, "expected_data_spacing")

    @property
    @pulumi.getter(name="fixedLegendDisplayStats")
    def fixed_legend_display_stats(self) -> Sequence[str]:
        """
        (Optional) For a chart with a fixed legend, a list of statistics to display in the legend.
        """
        return pulumi.get(self, "fixed_legend_display_stats")

    @property
    @pulumi.getter(name="fixedLegendEnabled")
    def fixed_legend_enabled(self) -> bool:
        """
        (Optional) Whether to enable a fixed tabular legend adjacent to the chart.
        """
        return pulumi.get(self, "fixed_legend_enabled")

    @property
    @pulumi.getter(name="fixedLegendFilterField")
    def fixed_legend_filter_field(self) -> str:
        """
        (Optional) Statistic to use for determining whether a series is displayed on the fixed legend. Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        """
        return pulumi.get(self, "fixed_legend_filter_field")

    @property
    @pulumi.getter(name="fixedLegendFilterLimit")
    def fixed_legend_filter_limit(self) -> int:
        """
        (Optional) Number of series to include in the fixed legend.
        """
        return pulumi.get(self, "fixed_legend_filter_limit")

    @property
    @pulumi.getter(name="fixedLegendFilterSort")
    def fixed_legend_filter_sort(self) -> str:
        """
        (Optional) Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options are `TOP`, and `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_filter_sort")

    @property
    @pulumi.getter(name="fixedLegendHideLabel")
    def fixed_legend_hide_label(self) -> bool:
        """
        (Optional) This setting is deprecated.
        """
        return pulumi.get(self, "fixed_legend_hide_label")

    @property
    @pulumi.getter(name="fixedLegendPosition")
    def fixed_legend_position(self) -> str:
        """
        (Optional)  Where the fixed legend should be displayed with respect to the chart. Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_position")

    @property
    @pulumi.getter(name="fixedLegendUseRawStats")
    def fixed_legend_use_raw_stats(self) -> bool:
        """
        (Optional) If `true`, the legend uses non-summarized stats instead of summarized.
        """
        return pulumi.get(self, "fixed_legend_use_raw_stats")

    @property
    @pulumi.getter(name="groupBySource")
    def group_by_source(self) -> bool:
        """
        For the tabular view, whether to group multi metrics into a single row by a common source. If set to `false`, each source is displayed in its own row. If set to `true`, multiple metrics for the same host are displayed as different columns in the same row.
        """
        return pulumi.get(self, "group_by_source")

    @property
    @pulumi.getter(name="invertDynamicLegendHoverControl")
    def invert_dynamic_legend_hover_control(self) -> bool:
        """
        (Optional) Whether to disable the display of the floating legend (but reenable it when the ctrl-key is pressed).
        """
        return pulumi.get(self, "invert_dynamic_legend_hover_control")

    @property
    @pulumi.getter(name="lineType")
    def line_type(self) -> str:
        """
        Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, `step-after`, `basis`, `cardinal`, and `monotone`.
        """
        return pulumi.get(self, "line_type")

    @property
    @pulumi.getter
    def max(self) -> float:
        """
        Max value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> float:
        """
        Min value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="numTags")
    def num_tags(self) -> int:
        """
        For the tabular view defines how many point tags to display.
        """
        return pulumi.get(self, "num_tags")

    @property
    @pulumi.getter(name="plainMarkdownContent")
    def plain_markdown_content(self) -> str:
        """
        The markdown content for a Markdown display, in plain text.
        """
        return pulumi.get(self, "plain_markdown_content")

    @property
    @pulumi.getter(name="showHosts")
    def show_hosts(self) -> bool:
        """
        For the tabular view, whether to display sources. Default is `true`.
        """
        return pulumi.get(self, "show_hosts")

    @property
    @pulumi.getter(name="showLabels")
    def show_labels(self) -> bool:
        """
        For the tabular view, whether to display labels. Default is `true`.
        """
        return pulumi.get(self, "show_labels")

    @property
    @pulumi.getter(name="showRawValues")
    def show_raw_values(self) -> bool:
        """
        For the tabular view, whether to display raw values. Default is `false`.
        """
        return pulumi.get(self, "show_raw_values")

    @property
    @pulumi.getter(name="sortValuesDescending")
    def sort_values_descending(self) -> bool:
        """
        For the tabular view, whether to display values in descending order. Default is `false`.
        """
        return pulumi.get(self, "sort_values_descending")

    @property
    @pulumi.getter(name="sparklineDecimalPrecision")
    def sparkline_decimal_precision(self) -> int:
        """
        For the single stat view, the decimal precision of the displayed number.
        """
        return pulumi.get(self, "sparkline_decimal_precision")

    @property
    @pulumi.getter(name="sparklineDisplayColor")
    def sparkline_display_color(self) -> str:
        """
        For the single stat view, the color of the displayed text (when not dynamically determined). Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_display_color")

    @property
    @pulumi.getter(name="sparklineDisplayFontSize")
    def sparkline_display_font_size(self) -> str:
        """
        For the single stat view, the font size of the displayed text, in percent.
        """
        return pulumi.get(self, "sparkline_display_font_size")

    @property
    @pulumi.getter(name="sparklineDisplayHorizontalPosition")
    def sparkline_display_horizontal_position(self) -> str:
        """
        For the single stat view, the horizontal position of the displayed text. Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        """
        return pulumi.get(self, "sparkline_display_horizontal_position")

    @property
    @pulumi.getter(name="sparklineDisplayPostfix")
    def sparkline_display_postfix(self) -> str:
        """
        For the single stat view, a string to append to the displayed text.
        """
        return pulumi.get(self, "sparkline_display_postfix")

    @property
    @pulumi.getter(name="sparklineDisplayPrefix")
    def sparkline_display_prefix(self) -> str:
        """
        For the single stat view, a string to add before the displayed text.
        """
        return pulumi.get(self, "sparkline_display_prefix")

    @property
    @pulumi.getter(name="sparklineDisplayValueType")
    def sparkline_display_value_type(self) -> str:
        """
        For the single stat view, where to display the name of the query or the value of the query. Valid options are `VALUE` or `LABEL`.
        """
        return pulumi.get(self, "sparkline_display_value_type")

    @property
    @pulumi.getter(name="sparklineDisplayVerticalPosition")
    def sparkline_display_vertical_position(self) -> str:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_display_vertical_position")

    @property
    @pulumi.getter(name="sparklineFillColor")
    def sparkline_fill_color(self) -> str:
        """
        For the single stat view, the color of the background fill. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_fill_color")

    @property
    @pulumi.getter(name="sparklineLineColor")
    def sparkline_line_color(self) -> str:
        """
        For the single stat view, the color of the line. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_line_color")

    @property
    @pulumi.getter(name="sparklineSize")
    def sparkline_size(self) -> str:
        """
        For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart. Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        """
        return pulumi.get(self, "sparkline_size")

    @property
    @pulumi.getter(name="sparklineValueColorMapApplyTo")
    def sparkline_value_color_map_apply_to(self) -> str:
        """
        For the single stat view, whether to apply dynamic color settings to the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        """
        return pulumi.get(self, "sparkline_value_color_map_apply_to")

    @property
    @pulumi.getter(name="sparklineValueColorMapColors")
    def sparkline_value_color_map_colors(self) -> Sequence[str]:
        """
        For the single stat view, a list of colors that differing query values map to. Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_value_color_map_colors")

    @property
    @pulumi.getter(name="sparklineValueColorMapValues")
    def sparkline_value_color_map_values(self) -> Sequence[int]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_value_color_map_values")

    @property
    @pulumi.getter(name="sparklineValueColorMapValuesV2s")
    def sparkline_value_color_map_values_v2s(self) -> Sequence[float]:
        """
        For the single stat view, a list of boundaries for mapping different query values to colors. Must contain one element less than `sparkline_value_color_map_colors`.
        """
        return pulumi.get(self, "sparkline_value_color_map_values_v2s")

    @property
    @pulumi.getter(name="sparklineValueTextMapTexts")
    def sparkline_value_text_map_texts(self) -> Sequence[str]:
        """
        For the single stat view, a list of display text values that different query values map to. Must contain one more element than `sparkline_value_text_map_thresholds`.
        """
        return pulumi.get(self, "sparkline_value_text_map_texts")

    @property
    @pulumi.getter(name="sparklineValueTextMapThresholds")
    def sparkline_value_text_map_thresholds(self) -> Sequence[float]:
        """
        For the single stat view, a list of threshold boundaries for mapping different query values to display text. Must contain one element less than `sparkline_value_text_map_text`.
        """
        return pulumi.get(self, "sparkline_value_text_map_thresholds")

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> str:
        """
        Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        """
        return pulumi.get(self, "stack_type")

    @property
    @pulumi.getter(name="tagMode")
    def tag_mode(self) -> str:
        """
        For the tabular view, which mode to use to determine which point tags to display. Valid options are `all`, `top`, or `custom`.
        """
        return pulumi.get(self, "tag_mode")

    @property
    @pulumi.getter(name="timeBasedColoring")
    def time_based_coloring(self) -> bool:
        """
        For x-y scatterplots, whether to color more recent points as darker than older points.
        """
        return pulumi.get(self, "time_based_coloring")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the Markdown display, and `sparkline` to the Single Stat view. Valid options are `line`, `scatterplot`, `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`, `top-k`, `status-list`, and `histogram`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> int:
        """
        Width, in minutes, of the time window to use for `last` windowing.
        """
        return pulumi.get(self, "window_size")

    @property
    @pulumi.getter
    def windowing(self) -> str:
        """
        For the tabular view, whether to use the full time window for the query or the last X minutes. Valid options are `full` or `last`.
        """
        return pulumi.get(self, "windowing")

    @property
    @pulumi.getter
    def xmax(self) -> float:
        """
        For x-y scatterplots, max value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmax")

    @property
    @pulumi.getter
    def xmin(self) -> float:
        """
        For x-y scatterplots, min value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmin")

    @property
    @pulumi.getter(name="y0ScaleSiBy1024")
    def y0_scale_si_by1024(self) -> bool:
        return pulumi.get(self, "y0_scale_si_by1024")

    @property
    @pulumi.getter(name="y0UnitAutoscaling")
    def y0_unit_autoscaling(self) -> bool:
        """
        (Optional) Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y0_unit_autoscaling")

    @property
    @pulumi.getter(name="y1Max")
    def y1_max(self) -> float:
        return pulumi.get(self, "y1_max")

    @property
    @pulumi.getter(name="y1Min")
    def y1_min(self) -> float:
        return pulumi.get(self, "y1_min")

    @property
    @pulumi.getter(name="y1ScaleSiBy1024")
    def y1_scale_si_by1024(self) -> bool:
        return pulumi.get(self, "y1_scale_si_by1024")

    @property
    @pulumi.getter(name="y1UnitAutoscaling")
    def y1_unit_autoscaling(self) -> bool:
        """
        (Optional) Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y1_unit_autoscaling")

    @property
    @pulumi.getter(name="y1Units")
    def y1_units(self) -> str:
        """
        For plots with multiple Y-axes, units for right side Y-axis.
        """
        return pulumi.get(self, "y1_units")

    @property
    @pulumi.getter
    def ymax(self) -> float:
        """
        For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymax")

    @property
    @pulumi.getter
    def ymin(self) -> float:
        """
        For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymin")


@pulumi.output_type
class GetDashboardsDashboardSectionRowChartSourceResult(dict):
    def __init__(__self__, *,
                 disabled: bool,
                 name: str,
                 query: str,
                 querybuilder_enabled: bool,
                 scatter_plot_source: str,
                 secondary_axis: bool,
                 source_color: str,
                 source_description: str):
        """
        :param bool disabled: Whether the source is disabled.
        :param str name: The name of the parameters.
        :param str query: Query expression to plot on the chart.
        :param str scatter_plot_source: For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        :param str source_description: A description for the purpose of this source.
        """
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "querybuilder_enabled", querybuilder_enabled)
        pulumi.set(__self__, "scatter_plot_source", scatter_plot_source)
        pulumi.set(__self__, "secondary_axis", secondary_axis)
        pulumi.set(__self__, "source_color", source_color)
        pulumi.set(__self__, "source_description", source_description)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether the source is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Query expression to plot on the chart.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="querybuilderEnabled")
    def querybuilder_enabled(self) -> bool:
        return pulumi.get(self, "querybuilder_enabled")

    @property
    @pulumi.getter(name="scatterPlotSource")
    def scatter_plot_source(self) -> str:
        """
        For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        """
        return pulumi.get(self, "scatter_plot_source")

    @property
    @pulumi.getter(name="secondaryAxis")
    def secondary_axis(self) -> bool:
        return pulumi.get(self, "secondary_axis")

    @property
    @pulumi.getter(name="sourceColor")
    def source_color(self) -> str:
        return pulumi.get(self, "source_color")

    @property
    @pulumi.getter(name="sourceDescription")
    def source_description(self) -> str:
        """
        A description for the purpose of this source.
        """
        return pulumi.get(self, "source_description")


@pulumi.output_type
class GetDerivedMetricsDerivedMetricResult(dict):
    def __init__(__self__, *,
                 additional_information: str,
                 create_user_id: str,
                 created_epoch_millis: int,
                 deleted: bool,
                 hosts_useds: Sequence[str],
                 id: str,
                 in_trash: bool,
                 include_obsolete_metrics: bool,
                 last_error_message: str,
                 last_failed_time: int,
                 last_processed_millis: int,
                 last_query_time: int,
                 metrics_useds: Sequence[str],
                 minutes: int,
                 name: str,
                 points_scanned_at_last_query: int,
                 process_rate_minutes: int,
                 query: str,
                 query_failing: bool,
                 query_qb_enabled: bool,
                 statuses: Sequence[str],
                 tags: Sequence[str],
                 update_user_id: str,
                 updated_epoch_millis: int):
        """
        :param str additional_information: User-supplied additional explanatory information about the derived metric.
        :param str create_user_id: The ID of the user who created the derived metric.
        :param int created_epoch_millis: The timestamp in epoch milliseconds indicating when the derived metric is created.
        :param bool deleted: A Boolean flag indicating whether the derived metric is deleted or not.
        :param Sequence[str] hosts_useds: A list of hosts used in the derived metric.
        :param str id: The ID of the derived metric in Wavefront.
        :param bool in_trash: A Boolean variable indicating trash status.
        :param bool include_obsolete_metrics: A Boolean flag indicating whether to include obsolete metrics or not.
        :param str last_error_message: Last error message occurred.
        :param int last_failed_time: Timestamp of the last failed derived metric.
        :param int last_processed_millis: The last processed timestamp.
        :param int last_query_time: The timestamp indicating the last time the query was executed.
        :param Sequence[str] metrics_useds: A list of metrics used in the derived metric.
        :param int minutes: How frequently the query generating the derived metric is run.
        :param str name: The name of the derived metric in Wavefront.
        :param int points_scanned_at_last_query: The number of points scanned when the last query was executed.
        :param int process_rate_minutes: The specified query is executed every `process_rate_minutes` minutes.
        :param str query: A Wavefront query that is evaluated at regular intervals (default is 1 minute).
        :param bool query_failing: A Boolean variable indicating whether query is failing for the derived metric.
        :param bool query_qb_enabled: A Boolean flag for enabling `query_qb`
        :param Sequence[str] statuses: The status of the derived metric.
        :param Sequence[str] tags: A set of tags assigned to the derived metric.
        :param str update_user_id: The ID of the user who updated the derived metric.
        :param int updated_epoch_millis: The timestamp in epoch milliseconds indicating when the derived metric is updated.
        """
        pulumi.set(__self__, "additional_information", additional_information)
        pulumi.set(__self__, "create_user_id", create_user_id)
        pulumi.set(__self__, "created_epoch_millis", created_epoch_millis)
        pulumi.set(__self__, "deleted", deleted)
        pulumi.set(__self__, "hosts_useds", hosts_useds)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "in_trash", in_trash)
        pulumi.set(__self__, "include_obsolete_metrics", include_obsolete_metrics)
        pulumi.set(__self__, "last_error_message", last_error_message)
        pulumi.set(__self__, "last_failed_time", last_failed_time)
        pulumi.set(__self__, "last_processed_millis", last_processed_millis)
        pulumi.set(__self__, "last_query_time", last_query_time)
        pulumi.set(__self__, "metrics_useds", metrics_useds)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "points_scanned_at_last_query", points_scanned_at_last_query)
        pulumi.set(__self__, "process_rate_minutes", process_rate_minutes)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "query_failing", query_failing)
        pulumi.set(__self__, "query_qb_enabled", query_qb_enabled)
        pulumi.set(__self__, "statuses", statuses)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "update_user_id", update_user_id)
        pulumi.set(__self__, "updated_epoch_millis", updated_epoch_millis)

    @property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> str:
        """
        User-supplied additional explanatory information about the derived metric.
        """
        return pulumi.get(self, "additional_information")

    @property
    @pulumi.getter(name="createUserId")
    def create_user_id(self) -> str:
        """
        The ID of the user who created the derived metric.
        """
        return pulumi.get(self, "create_user_id")

    @property
    @pulumi.getter(name="createdEpochMillis")
    def created_epoch_millis(self) -> int:
        """
        The timestamp in epoch milliseconds indicating when the derived metric is created.
        """
        return pulumi.get(self, "created_epoch_millis")

    @property
    @pulumi.getter
    def deleted(self) -> bool:
        """
        A Boolean flag indicating whether the derived metric is deleted or not.
        """
        return pulumi.get(self, "deleted")

    @property
    @pulumi.getter(name="hostsUseds")
    def hosts_useds(self) -> Sequence[str]:
        """
        A list of hosts used in the derived metric.
        """
        return pulumi.get(self, "hosts_useds")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the derived metric in Wavefront.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inTrash")
    def in_trash(self) -> bool:
        """
        A Boolean variable indicating trash status.
        """
        return pulumi.get(self, "in_trash")

    @property
    @pulumi.getter(name="includeObsoleteMetrics")
    def include_obsolete_metrics(self) -> bool:
        """
        A Boolean flag indicating whether to include obsolete metrics or not.
        """
        return pulumi.get(self, "include_obsolete_metrics")

    @property
    @pulumi.getter(name="lastErrorMessage")
    def last_error_message(self) -> str:
        """
        Last error message occurred.
        """
        return pulumi.get(self, "last_error_message")

    @property
    @pulumi.getter(name="lastFailedTime")
    def last_failed_time(self) -> int:
        """
        Timestamp of the last failed derived metric.
        """
        return pulumi.get(self, "last_failed_time")

    @property
    @pulumi.getter(name="lastProcessedMillis")
    def last_processed_millis(self) -> int:
        """
        The last processed timestamp.
        """
        return pulumi.get(self, "last_processed_millis")

    @property
    @pulumi.getter(name="lastQueryTime")
    def last_query_time(self) -> int:
        """
        The timestamp indicating the last time the query was executed.
        """
        return pulumi.get(self, "last_query_time")

    @property
    @pulumi.getter(name="metricsUseds")
    def metrics_useds(self) -> Sequence[str]:
        """
        A list of metrics used in the derived metric.
        """
        return pulumi.get(self, "metrics_useds")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        How frequently the query generating the derived metric is run.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the derived metric in Wavefront.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pointsScannedAtLastQuery")
    def points_scanned_at_last_query(self) -> int:
        """
        The number of points scanned when the last query was executed.
        """
        return pulumi.get(self, "points_scanned_at_last_query")

    @property
    @pulumi.getter(name="processRateMinutes")
    def process_rate_minutes(self) -> int:
        """
        The specified query is executed every `process_rate_minutes` minutes.
        """
        return pulumi.get(self, "process_rate_minutes")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        A Wavefront query that is evaluated at regular intervals (default is 1 minute).
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="queryFailing")
    def query_failing(self) -> bool:
        """
        A Boolean variable indicating whether query is failing for the derived metric.
        """
        return pulumi.get(self, "query_failing")

    @property
    @pulumi.getter(name="queryQbEnabled")
    def query_qb_enabled(self) -> bool:
        """
        A Boolean flag for enabling `query_qb`
        """
        return pulumi.get(self, "query_qb_enabled")

    @property
    @pulumi.getter
    def statuses(self) -> Sequence[str]:
        """
        The status of the derived metric.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A set of tags assigned to the derived metric.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateUserId")
    def update_user_id(self) -> str:
        """
        The ID of the user who updated the derived metric.
        """
        return pulumi.get(self, "update_user_id")

    @property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> int:
        """
        The timestamp in epoch milliseconds indicating when the derived metric is updated.
        """
        return pulumi.get(self, "updated_epoch_millis")


@pulumi.output_type
class GetEventsEventResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 details: str,
                 endtime_key: int,
                 id: str,
                 is_ephemeral: bool,
                 name: str,
                 severity: str,
                 start_time: int,
                 tags: Sequence[str],
                 type: str):
        """
        :param Mapping[str, str] annotations: Annotations associated with the event.
        :param str details: The description of the event.
        :param str id: The ID of the event in Wavefront.
        :param bool is_ephemeral: A Boolean flag. If set to `true`, creates a point-in-time event (i.e. with no duration).
        :param str name: The name of the event in Wavefront.
        :param str severity: The severity category of the event.
        :param int start_time: The start time of the event in epoch milliseconds.
        :param Sequence[str] tags: A set of tags assigned to the event.
        :param str type: The type of the event.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "endtime_key", endtime_key)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_ephemeral", is_ephemeral)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Annotations associated with the event.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def details(self) -> str:
        """
        The description of the event.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="endtimeKey")
    def endtime_key(self) -> int:
        return pulumi.get(self, "endtime_key")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the event in Wavefront.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEphemeral")
    def is_ephemeral(self) -> bool:
        """
        A Boolean flag. If set to `true`, creates a point-in-time event (i.e. with no duration).
        """
        return pulumi.get(self, "is_ephemeral")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the event in Wavefront.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The severity category of the event.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> int:
        """
        The start time of the event in epoch milliseconds.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A set of tags assigned to the event.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the event.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetExternalLinksExternalLinkResult(dict):
    def __init__(__self__, *,
                 created_epoch_millis: int,
                 creator_id: str,
                 description: str,
                 id: str,
                 is_log_integration: bool,
                 metric_filter_regex: str,
                 name: str,
                 point_tag_filter_regexes: Mapping[str, str],
                 source_filter_regex: str,
                 template: str,
                 updated_epoch_millis: int,
                 updater_id: str):
        """
        :param int created_epoch_millis: The timestamp in epoch milliseconds indicating when the external link is created.
        :param str creator_id: The ID of the user who created the external link.
        :param str description: Human-readable description of the link.
        :param str id: The ID of the external link.
        :param bool is_log_integration: Whether this is a "Log Integration" subType of external link.
        :param str metric_filter_regex: Controls whether a link is displayed in the context menu of a highlighted series. If present, the metric name of the highlighted series must match this regular expression in order for the link to be displayed.
        :param str name: The name of the external link.
        :param Mapping[str, str] point_tag_filter_regexes: (Optional) Controls whether a link is displayed in the context menu of a highlighted
               series. This is a map from string to regular expression. The highlighted series must contain point tags whose
               keys are present in the keys of this map and whose values match the regular expressions associated with those
               keys in order for the link to be displayed.
        :param str source_filter_regex: Controls whether a link is displayed in the context menu of a highlighted series. If present, the source name of the highlighted series must match this regular expression in order for the link to be displayed.
        :param str template: The mustache template for the link. The template must expand to a full URL, including scheme, origin, etc.
        :param int updated_epoch_millis: The timestamp in epoch milliseconds indicating when the external link is updated.
        :param str updater_id: The ID of the user who updated the external link.
        """
        pulumi.set(__self__, "created_epoch_millis", created_epoch_millis)
        pulumi.set(__self__, "creator_id", creator_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_log_integration", is_log_integration)
        pulumi.set(__self__, "metric_filter_regex", metric_filter_regex)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "point_tag_filter_regexes", point_tag_filter_regexes)
        pulumi.set(__self__, "source_filter_regex", source_filter_regex)
        pulumi.set(__self__, "template", template)
        pulumi.set(__self__, "updated_epoch_millis", updated_epoch_millis)
        pulumi.set(__self__, "updater_id", updater_id)

    @property
    @pulumi.getter(name="createdEpochMillis")
    def created_epoch_millis(self) -> int:
        """
        The timestamp in epoch milliseconds indicating when the external link is created.
        """
        return pulumi.get(self, "created_epoch_millis")

    @property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> str:
        """
        The ID of the user who created the external link.
        """
        return pulumi.get(self, "creator_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Human-readable description of the link.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the external link.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLogIntegration")
    def is_log_integration(self) -> bool:
        """
        Whether this is a "Log Integration" subType of external link.
        """
        return pulumi.get(self, "is_log_integration")

    @property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> str:
        """
        Controls whether a link is displayed in the context menu of a highlighted series. If present, the metric name of the highlighted series must match this regular expression in order for the link to be displayed.
        """
        return pulumi.get(self, "metric_filter_regex")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the external link.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pointTagFilterRegexes")
    def point_tag_filter_regexes(self) -> Mapping[str, str]:
        """
        (Optional) Controls whether a link is displayed in the context menu of a highlighted
        series. This is a map from string to regular expression. The highlighted series must contain point tags whose
        keys are present in the keys of this map and whose values match the regular expressions associated with those
        keys in order for the link to be displayed.
        """
        return pulumi.get(self, "point_tag_filter_regexes")

    @property
    @pulumi.getter(name="sourceFilterRegex")
    def source_filter_regex(self) -> str:
        """
        Controls whether a link is displayed in the context menu of a highlighted series. If present, the source name of the highlighted series must match this regular expression in order for the link to be displayed.
        """
        return pulumi.get(self, "source_filter_regex")

    @property
    @pulumi.getter
    def template(self) -> str:
        """
        The mustache template for the link. The template must expand to a full URL, including scheme, origin, etc.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> int:
        """
        The timestamp in epoch milliseconds indicating when the external link is updated.
        """
        return pulumi.get(self, "updated_epoch_millis")

    @property
    @pulumi.getter(name="updaterId")
    def updater_id(self) -> str:
        """
        The ID of the user who updated the external link.
        """
        return pulumi.get(self, "updater_id")


@pulumi.output_type
class GetMaintenanceWindowAllMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 created_epoch_millis: int,
                 creator_id: str,
                 customer_id: str,
                 end_time_in_seconds: int,
                 event_name: str,
                 host_tag_group_host_names_group_anded: bool,
                 id: str,
                 reason: str,
                 relevant_customer_tags: Sequence[str],
                 relevant_host_names: Sequence[str],
                 relevant_host_tags: Sequence[str],
                 relevant_host_tags_anded: bool,
                 running_state: str,
                 sort_attr: int,
                 start_time_in_seconds: int,
                 title: str,
                 updated_epoch_millis: int,
                 updater_id: str):
        pulumi.set(__self__, "created_epoch_millis", created_epoch_millis)
        pulumi.set(__self__, "creator_id", creator_id)
        pulumi.set(__self__, "customer_id", customer_id)
        pulumi.set(__self__, "end_time_in_seconds", end_time_in_seconds)
        pulumi.set(__self__, "event_name", event_name)
        pulumi.set(__self__, "host_tag_group_host_names_group_anded", host_tag_group_host_names_group_anded)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "relevant_customer_tags", relevant_customer_tags)
        pulumi.set(__self__, "relevant_host_names", relevant_host_names)
        pulumi.set(__self__, "relevant_host_tags", relevant_host_tags)
        pulumi.set(__self__, "relevant_host_tags_anded", relevant_host_tags_anded)
        pulumi.set(__self__, "running_state", running_state)
        pulumi.set(__self__, "sort_attr", sort_attr)
        pulumi.set(__self__, "start_time_in_seconds", start_time_in_seconds)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "updated_epoch_millis", updated_epoch_millis)
        pulumi.set(__self__, "updater_id", updater_id)

    @property
    @pulumi.getter(name="createdEpochMillis")
    def created_epoch_millis(self) -> int:
        return pulumi.get(self, "created_epoch_millis")

    @property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> str:
        return pulumi.get(self, "creator_id")

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> str:
        return pulumi.get(self, "customer_id")

    @property
    @pulumi.getter(name="endTimeInSeconds")
    def end_time_in_seconds(self) -> int:
        return pulumi.get(self, "end_time_in_seconds")

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> str:
        return pulumi.get(self, "event_name")

    @property
    @pulumi.getter(name="hostTagGroupHostNamesGroupAnded")
    def host_tag_group_host_names_group_anded(self) -> bool:
        return pulumi.get(self, "host_tag_group_host_names_group_anded")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reason(self) -> str:
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="relevantCustomerTags")
    def relevant_customer_tags(self) -> Sequence[str]:
        return pulumi.get(self, "relevant_customer_tags")

    @property
    @pulumi.getter(name="relevantHostNames")
    def relevant_host_names(self) -> Sequence[str]:
        return pulumi.get(self, "relevant_host_names")

    @property
    @pulumi.getter(name="relevantHostTags")
    def relevant_host_tags(self) -> Sequence[str]:
        return pulumi.get(self, "relevant_host_tags")

    @property
    @pulumi.getter(name="relevantHostTagsAnded")
    def relevant_host_tags_anded(self) -> bool:
        return pulumi.get(self, "relevant_host_tags_anded")

    @property
    @pulumi.getter(name="runningState")
    def running_state(self) -> str:
        return pulumi.get(self, "running_state")

    @property
    @pulumi.getter(name="sortAttr")
    def sort_attr(self) -> int:
        return pulumi.get(self, "sort_attr")

    @property
    @pulumi.getter(name="startTimeInSeconds")
    def start_time_in_seconds(self) -> int:
        return pulumi.get(self, "start_time_in_seconds")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> int:
        return pulumi.get(self, "updated_epoch_millis")

    @property
    @pulumi.getter(name="updaterId")
    def updater_id(self) -> str:
        return pulumi.get(self, "updater_id")


@pulumi.output_type
class GetMetricsPolicyPolicyRuleResult(dict):
    def __init__(__self__, *,
                 access_type: str,
                 account_ids: Sequence[str],
                 description: str,
                 name: str,
                 prefixes: Sequence[str],
                 role_ids: Sequence[str],
                 tags: Sequence['outputs.GetMetricsPolicyPolicyRuleTagResult'],
                 tags_anded: bool,
                 user_group_ids: Sequence[str]):
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "account_ids", account_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "prefixes", prefixes)
        pulumi.set(__self__, "role_ids", role_ids)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "tags_anded", tags_anded)
        pulumi.set(__self__, "user_group_ids", user_group_ids)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> str:
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Sequence[str]:
        return pulumi.get(self, "account_ids")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def prefixes(self) -> Sequence[str]:
        return pulumi.get(self, "prefixes")

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Sequence[str]:
        return pulumi.get(self, "role_ids")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetMetricsPolicyPolicyRuleTagResult']:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAnded")
    def tags_anded(self) -> bool:
        return pulumi.get(self, "tags_anded")

    @property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Sequence[str]:
        return pulumi.get(self, "user_group_ids")


@pulumi.output_type
class GetMetricsPolicyPolicyRuleTagResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRolesRoleResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 name: str,
                 permissions: Sequence[str]):
        """
        :param str description: The Role's description.
        :param str id: The Role ID.
        :param str name: The Role Name.
        :param Sequence[str] permissions: List of Permissions (Strings) associated with Role.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The Role's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Role ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Role Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        List of Permissions (Strings) associated with Role.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GetUserGroupsUserGroupResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 name: str,
                 roles: Sequence[str],
                 users: Sequence[str]):
        """
        :param str description: The group description.
        :param str id: The group ID.
        :param str name: The group name.
        :param Sequence[str] roles: List of roles associated with the group.
        :param Sequence[str] users: List of users assigned to the group.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The group description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The group ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        List of roles associated with the group.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def users(self) -> Sequence[str]:
        """
        List of users assigned to the group.
        """
        return pulumi.get(self, "users")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 customer: str,
                 email: str,
                 last_successful_login: int,
                 permissions: Sequence[str],
                 user_group_ids: Sequence[str]):
        """
        :param str customer: The customer the user is associated with.
        :param int last_successful_login: When the user last logged in to Wavefront.
        :param Sequence[str] permissions: List of permissions granted to a user.
        :param Sequence[str] user_group_ids: List of User Group Ids the user is a member of.
        """
        pulumi.set(__self__, "customer", customer)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "last_successful_login", last_successful_login)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "user_group_ids", user_group_ids)

    @property
    @pulumi.getter
    def customer(self) -> str:
        """
        The customer the user is associated with.
        """
        return pulumi.get(self, "customer")

    @property
    @pulumi.getter
    def email(self) -> str:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="lastSuccessfulLogin")
    def last_successful_login(self) -> int:
        """
        When the user last logged in to Wavefront.
        """
        return pulumi.get(self, "last_successful_login")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        List of permissions granted to a user.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Sequence[str]:
        """
        List of User Group Ids the user is a member of.
        """
        return pulumi.get(self, "user_group_ids")


