# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['falocalrepo_server']

package_data = \
{'': ['*'],
 'falocalrepo_server': ['static/*', 'static/styles/*', 'templates/*']}

install_requires = \
['Pillow>=8.1.0,<9.0.0',
 'chardet>=4.0.0,<5.0.0',
 'falocalrepo-database>=4.19.3,<4.20.0',
 'flask>=1.1.2,<2.0.0',
 'gevent>=21.1.2,<22.0.0',
 'htmlmin>=0.1.0,<0.2.0']

entry_points = \
{'console_scripts': ['falocalrepo-server = falocalrepo_server.__main__:main']}

setup_kwargs = {
    'name': 'falocalrepo-server',
    'version': '1.13.4',
    'description': 'Web interface for falocalrepo.',
    'long_description': '# FALocalRepo-Server\n\n[![version_pypi](https://img.shields.io/pypi/v/falocalrepo-server?logo=pypi)](https://pypi.org/project/falocalrepo-server/)\n[![version_gitlab](https://img.shields.io/badge/dynamic/json?logo=gitlab&color=orange&label=gitlab&query=%24%5B%3A1%5D.name&url=https%3A%2F%2Fgitlab.com%2Fapi%2Fv4%2Fprojects%2Fmatteocampinoti94%252Ffalocalrepo-server%2Frepository%2Ftags)](https://gitlab.com/MatteoCampinoti94/falocalrepo-server)\n[![version_python](https://img.shields.io/pypi/pyversions/falocalrepo-server?logo=Python)](https://www.python.org)\n\nWeb interface for [falocalrepo](https://pypi.org/project/falocalrepo/).\n\n_Favicon by Fur Affinity._\n\n## Installation & Requirements\n\nTo install the program it is sufficient to use Python pip and get the package `falocalrepo-server`.\n\n```shell\npython3 -m pip install falocalrepo-server\n```\n\nPython 3.9 or above is needed to run this program, all other dependencies are handled by pip during installation. For\ninformation on how to install Python on your computer, refer to the official\nwebsite [Python.org](https://www.python.org/).\n\nFor the program to run, a properly formatted database created by falocalrepo needs to be present in the same folder.\n\n## Usage\n\n```\nfalocalrepo-server <database> [--host HOST] [--port PORT] [--ssl-cert SSL_CERT] [--ssl-key SSL_KEY] [--redirect-http]\n```\n\nThe server needs one argument pointing at the location of a valid [falocalrepo](https://pypi.org/project/falocalrepo/)\ndatabase and accepts optional arguments to manually set host, port, and an SSL certificate with key. By default, the\nserver is run on 0.0.0.0:80 for HTTP (without certificate) and 0.0.0.0:443 for HTTPS (with certificate).\n\nThe optional `--redirect-http` enables HTTP to HTTPS redirection from port 80 to the port selected to serve HTTPS.\n\nOnce the server is running the web app can be accessed at the address shown in the terminal.\n\n### Arguments\n\n|Argument|Default|\n|---|---|\n|`database`|None, mandatory argument|\n|`--host`|0.0.0.0|\n|`--port`|80 if no SSL certificate is given, 443 otherwise|\n|`--ssl-cert`|None|\n|`--ssl-key`|None|\n|`--redirect-http`|redirect all traffic from http://HOST:80 to https://HOST:PORT|\n\n### Examples\n\n```shell\n# Launch an HTTP server reachable from other machines using the server\'s hostname/IP\nfalocalrepo-server ~/FA.db\n```\n\n```shell\n# Launch a localhost-only server on port 8080\nfalocalrepo-server ~/FA.db --host 127.0.0.1 --port 8080\n```\n\n```shell\n# Launch an HTTPS server reachable from other machines using the server\'s hostname/IP\nfalocalrepo-server ~/FA.db --ssl-cert ~/FA.certificates/certificate.crt --ssl-key ~/FA.certificates/private.key \n```\n\n```shell\n# Launch a localhost-only HTTPS server on port 8443\nfalocalrepo-server ~/FA.db --host 127.0.0.1 --port 8443 --ssl-cert ~/FA.certificates/certificate.crt --ssl-key ~/FA.certificates/private.key \n```\n\n## Routes\n\n_Note:_ All the following paths are meant as paths from `<host>:<port>`.\n\n|Route                                    |Destination|\n|-----------------------------------------|---|\n|`/`                                      | Show home page with general information regarding the database|\n|`/browse/`                               | Redirects to `/browse/submissions/`|\n|`/browse/submissions/`                   | Browse submissions|\n|`/browse/journals/`                      | Browse journals|\n|`/browse/users/`                         | Browse users|\n|`/search/`                               | Redirects to `/search/submissions/`|\n|`/search/submissions/`                   | Search submissions|\n|`/search/journals/`                      | Search journals|\n|`/search/users/`                         | Search users|\n|`/user/<username>/`                      | Show information regarding a specific user|\n|`/gallery/<username>/`                   | Browse a user\'s gallery submissions|\n|`/scraps/<username>/`                    | Browse a user\'s scraps submissions|\n|`/submissions/<username>/`               | Browse a user\'s gallery & scraps submissions| \n|`/favorites/<username>/`                 | Browse a user\'s favorite submissions|\n|`/mentions/<username>/`                  | Browse the submissions where the user is mentioned|\n|`/journals/<username>/`                  | Browse a user\'s journals|\n|`/full/<submission id>/`                 | Redirect to `/submission/<submission id>/`|\n|`/view/<submission id>/`                 | Redirect to `/submission/<submission id>/`|\n|`/submission/<submission id>/`           | View a submission|\n|`/submission/<submission id>/file/`      | Open a submission file|\n|`/submission/<submission id>/thumbnail/` | Open a submission thumbnail (generated for image if no thumbnail is stored)|\n|`/submission/<submission id>/zip/`       | Download a submission\'s file, description, and metadata as a ZIP archive|\n|`/journal/<journal id>/`                 | View a journal|\n|`/journal/<journal id>/zip/`             | Download a journal\'s content and metadata as a ZIP archive|\n\n## Pages\n\n### Home\n\nThe home page displays general information about the database and contains links to browse and search pages for the\nvarious tables.\n\nThe information table displays the total number of submissions, journals, and users together with the version of the\ndatabase. Clicking on any of the counters open the relevant browse page.\n\nUnderneath the information table are buttons that open new search pages for submissions, journals, and users.\n\n### Browse & Search\n\nThe browse and search pages allow to explore the submissions/journals contained in the database. Searches are performed\ncase-insensitively using a simple syntax in the form `@field term [[| &] term ...]` which allows logic operators,\nparentheses and start/end of field matching, see [Query Language](#query-language) for details.\n\nSearch terms for submissions and journals default to the `any` field if none is used, while the `username` field is used\nfor users searches.\n\nThe controls at the top of the page allow to query the database and control the visualisation of the results.\n\n![browse controls](https://gitlab.com/MatteoCampinoti94/falocalrepo-server/-/raw/master/doc/browse.png)\n\nThe _Search_ input allows to insert the search query.\n\nThe _Add Field_ menu allows to insert a specific search field using a simple dropdown menu.\n\nThe _-_ button clears the search input field.\n\nThe _Sort By_ and _Order_ menus change the sorting field and order of the search results. Submissions and journals\ndefault to descending ID, while users default to ascending username.\n\nThe _View_ menu is only visible for submissions and allows changing between the (default) grid view to the list view\nused for journals and users. Submission thumbnails are visualised in both cases.\n\nThe _Search_ button submits the search request using the current query and sorting settings.\n\nUnder the search controls are the number of results and current page.\n\nUnder the results numbers are the page controls. _First_ leads to page 1, _Prev_ leads to the previous page, _Next_\nleads to the next page, and _Last_ leads to the last page. These controls are also available at the bottom of the page.\n\n#### Query Language\n\nThe query language used for this server is based on and improves the search syntax currently used by the Fur Affinity\nwebsite. Its basic elements are:\n\n* `@<field>` field specifier (e.g. `@title`), all database columns are available as search fields.\n  See [falocalrepo-database](https://pypi.org/project/falocalrepo-database/) for details on the available columns.\n* `()` parentheses, they can be used for better logic operations\n* `&` _AND_ logic operator, used between search terms\n* `|` _OR_ logic operator, used between search terms\n* `!` _NOT_ logic operator, used as prefix of search terms\n* `""` quotes, allow searching for literal strings without needing to escape\n* `%` match 0 or more characters\n* `_` match exactly 1 character\n* `^` start of field, when used at the start of a search term, it matches the beginning of the field\n* `$` end of field, when used at the end of a search term, it matches the end of the field\n\nAll other strings are considered search terms.\n\nThe search uses the `@any` field by default, allowing to do general searches without specifying a field.\n\nSearch terms that are not separated by a logic operator are considered _AND_ terms (i.e. `a b c` -> `a & b & c`).\n\nExcept for the `ID`, `AUTHOR`, and `USERNAME` fields, all search terms are searched through the whole content of the\nvarious fields: i.e. `@description cat` will match any item whose description field contains "cat". To match items that\ncontain only "cat" (or start with, end with, etc.), the `%`, `_`, `^`, and `$` operators need to be used (\ne.g. `@description ^cat`).\n\nSearch terms for `ID`, `AUTHOR`, and `USERNAME` are matched exactly as they are: i.e. `@author tom` will match only\nitems whose author field is exactly equal to "tom", to match items that contain "tom" the `%`, `_`, `^`, and `$`\noperators need to be used (e.g. `@author %tom%`).\n\n##### Examples\n\nSearch for journals/submissions containing water and either otter, lutrine, or mustelid, or water and either cat or\nfeline:\n\n`water ((otter | lutrine | mustelid) | (cat | feline))`\n\n`@any water & ((otter | lutrine | mustelid) | (cat | feline))`\n\nSearch for journals/submissions containing "cat" or "feline" but neither "mouse" nor "rodent":\n\n`(cat | feline) !mouse !rodent`\n\nSearch for general-rated submissions uploaded by a user whose name starts with "tom" that contain either "volleyball"\nor "volley" and "ball" separated by one character (e.g. "volley-ball") in any field:\n\n`@rating general @author tom% @any (volleyball | volley_ball)`\n\n`(volleyball | volley_ball) @rating general @author tom%`\n\nSearch for journals/submissions uploaded in 2020 except for March:\n\n`@date ^2020 !^2020-03`\n\nSearch for submissions uploaded in March 2021 (meaning the date has to start with `2021-03`) whose tags contain the\nexact tag "ball":\n\n`@date ^2021-03 @tags "|ball|"`\n\n`@date ^2021-03 @tags \\|ball\\|`\n\nSearch for journals/submissions where a specific user named "tom" is mentioned:\n\n`@mentions "|tom|"`\n\n`@mentions \\|tom\\|`\n\nSearch for submissions whose only favorite is a user named "alex":\n\n`@favorite ^\\|alex\\|$`\n\nSearch for users whose names contain "mark":\n\n`@username %mark%`\n\nSearch for journals/submissions whose title ends with "100%":\n\n`@title 100\\%$`\n\nSearch for journals/submissions whose title is exactly "cat":\n\n`@title ^cat$`\n\nSearch for text submissions with PDF files:\n\n`@type text @fileext pdf`\n\n### User\n\nThe user page shows information about submissions and journals related to a user (gallery, scraps, favorites, mentions,\nand journals) and what folders have been set for download. See [falocalrepo](https://pypi.org/project/falocalrepo/) for\nmore details on this.\n\nClicking on any of the counters opens the relevant results via the search interface, allowing to refine the search\nfurther.\n\n### Submission\n\nThe submission page shows the submission file (if present), the submission metadata, and the description.\n\nImage, audio, and plain text submission files are displayed directly in the page, others (e.g. PDF files) will display a\nlink to open them. For images, clicking on the images opens its file.\n\nThe metadata table contains clickable links to the user\'s page (see [User](#user) for details), tags, category, species,\ngender, rating, folder (gallery/scraps), and to user pages of favouring and mentioned users.\n\nThe description is displayed as-is except for user icons, which are replaced by `@username` styled links to avoid\ndisplay errors caused by expired icon links.\n\nUnder the metadata table are a number of buttons that allow to access the submission file, open its Fur Affinity\ncounterpart, and navigate the other submissions from the author.\n\n![submission controls](https://gitlab.com/MatteoCampinoti94/falocalrepo-server/-/raw/master/doc/submission.png)\n\nThe _Download File_ button opens the submission file in the current browser tab.\n\nThe _Download Submission as ZIP_ button generates a ZIP file containing the submission file, submission thumbnail,\ndescription HTML, and metadata in JSON format.\n\nThe _Open on Fur Affinity_ button opens the submission on Fur Affinity\n\nThe _Next_ and _Prev_ buttons lead to the next more recent and the previous less recent submissions respectively.\n\nThe _Gallery_, _All_, and _Scraps_ buttons open a search page with the user\'s gallery submissions, scraps and gallery\nsubmissions together, and scraps submissions respectively.\n\n### Journal\n\nThe journal page shows the journal metadata and content.\n\nThe metadata table contains clickable links to the user\'s page (see [User](#user) for details) and to user pages of\nmentioned users.\n\nUnder the metadata table are a number of buttons that allow to download the journal, open its Fur Affinity counterpart,\nand navigate the other journals from the same user.\n\n![journal controls](https://gitlab.com/MatteoCampinoti94/falocalrepo-server/-/raw/master/doc/journal.png)\n\nThe _Download Journal as ZIP_ button generates a ZIP file containing the journal content HTML and metadata in JSON\nformat.\n\nThe _Open on Fur Affinity_ button opens the journal on Fur Affinity\n\nThe _Next_ and _Prev_ buttons lead to the next more recent, and the previous less recent journals respectively.\n\nThe _All_ button opens a search page with all the user\'s journals.',
    'author': 'Matteo Campinoti',
    'author_email': 'matteo.campinoti94@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/MatteoCampinoti94/falocalrepo-server',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
