from enum import Enum

"""
The Role implementation.
"""


class Role(str, Enum):
    """
    Set of supported role strategies.
    """

    ALERT = "alert"
    CANVAS = "canvas"
    COLUMN_HEADER = "column header"
    COMBO_BOX = "combo box"
    DESKTOP_ICON = "desktop icon"
    INTERNAL_FRAME = "internal frame"
    OPTION_PANE = "option pane"
    WINDOW = "window"
    FRAME = "frame"
    DIALOG = "dialog"
    COLOR_CHOOSER = "color chooser"
    DIRECTORY_PANE = "directory pane"
    FILE_CHOOSER = "file chooser"
    FILLER = "filler"
    HYPERLINK = "hyperlink"
    ICON = "icon"
    LABEL = "label"
    ROOT_PANE = "root pane"
    GLASS_PANE = "glass pane"
    LAYERED_PANE = "layered pane"
    LIST = "list"
    LIST_ITEM = "list item"
    MENU_BAR = "menu bar"
    POPUP_MENU = "popup menu"
    MENU = "menu"
    MENU_ITEM = "menu item"
    SEPARATOR = "separator"
    PAGE_TAB_LIST = "page tab list"
    PAGE_TAB = "page tab"
    PANEL = "panel"
    PROGRESS_BAR = "progress bar"
    PASSWORD_TEXT = "password text"
    PUSH_BUTTON = "push button"
    TOGGLE_BUTTON = "toggle button"
    CHECK_BOX = "check box"
    RADIO_BUTTON = "radio button"
    ROW_HEADER = "row header"
    SCROLL_PANE = "scroll pane"
    SCROLL_BAR = "scroll bar"
    VIEW_PORT = "view port"
    SLIDER = "slider"
    SPLIT_PANE = "split pane"
    TABLE = "table"
    TEXT = "text"
    TREE = "tree"
    TOOL_BAR = "tool bar"
    TOOL_TIP = "tool tip"
    STATUS_BAR = "status bar"
    STATUSBAR = "statusbar"
    DATE_EDITOR = "date editor"
    SPIN_BOX = "spin box"
    FONT_CHOOSER = "font chooser"
    GROUP_BOX = "group box"
    HEADER = "header"
    FOOTER = "footer"
    PARAGRAPH = "paragraph"
    RULER = "ruler"
    EDIT_BAR = "edit bar"
    UNKNOWN = "unknown"
