import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudLanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/lan#datacenter_id DataIonoscloudLan#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/lan#id DataIonoscloudLan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/lan#name DataIonoscloudLan#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/lan#timeouts DataIonoscloudLan#timeouts}
    */
    readonly timeouts?: DataIonoscloudLanTimeouts;
}
export interface DataIonoscloudLanIpFailover {
}
export declare function dataIonoscloudLanIpFailoverToTerraform(struct?: DataIonoscloudLanIpFailover): any;
export declare class DataIonoscloudLanIpFailoverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudLanIpFailover | undefined;
    set internalValue(value: DataIonoscloudLanIpFailover | undefined);
    get ip(): string;
    get nicUuid(): string;
}
export declare class DataIonoscloudLanIpFailoverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudLanIpFailoverOutputReference;
}
export interface DataIonoscloudLanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/lan#create DataIonoscloudLan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/lan#default DataIonoscloudLan#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/lan#delete DataIonoscloudLan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/lan#update DataIonoscloudLan#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudLanTimeoutsToTerraform(struct?: DataIonoscloudLanTimeoutsOutputReference | DataIonoscloudLanTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudLanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudLanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudLanTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/lan ionoscloud_lan}
*/
export declare class DataIonoscloudLan extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_lan";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/lan ionoscloud_lan} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudLanConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudLanConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipFailover;
    get ipFailover(): DataIonoscloudLanIpFailoverList;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get pcc(): string;
    get public(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataIonoscloudLanTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudLanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudLanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
