import { Construct } from 'constructs';
export declare enum TriggerType {
    TO_PHONE_NUMBER = "ToPhoneNumber",
    REQUEST_URI_HOSTNAME = "RequestUriHostname"
}
export interface TargetApplications {
    /**
     * SipMediaApplicationId for SipRule (required)
     *
     * @default - none
     */
    readonly sipMediaApplicationId: string;
    /**
     * Priority for SipRule (required) - 1 to 25
     *
     * @default - none
     */
    readonly priority: number;
    /**
     * Region for SipRule (optional)
     *
     * @default - same region as stack deployment
     */
    readonly region?: string;
}
/**
 * Props for `SipRule`.
 */
export interface SipRuleProps {
    /**
     * Trigger Type for SipRule (required) - TO_PHONE_NUMBER or REQUEST_URI_HOSTNAME
     *
     * @default - none
     */
    readonly triggerType: TriggerType;
    /**
     * Trigger Value for SipRule (required) - EE.164 Phone Number or Voice Connector URI
     *
     * @default - none
     */
    readonly triggerValue: string;
    /**
     * name for SipRule (optional)
     *
     * @default - unique ID for resource
     */
    readonly name?: string;
    readonly targetApplications: Array<TargetApplications>;
}
export declare class ChimeSipRule extends Construct {
    readonly sipRuleId: string;
    constructor(scope: Construct, id: string, props: SipRuleProps);
}
