# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cythereal_magic.api_client import ApiClient


class InDevelopmentApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_ioc(self, ioc, **kwargs):  # noqa: E501
        """Returns an ioc object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ioc(ioc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ioc: A url encoded IoC (required)
        :return: IoCResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ioc_with_http_info(ioc, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ioc_with_http_info(ioc, **kwargs)  # noqa: E501
            return data

    def get_ioc_with_http_info(self, ioc, **kwargs):  # noqa: E501
        """Returns an ioc object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ioc_with_http_info(ioc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ioc: A url encoded IoC (required)
        :return: IoCResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ioc']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ioc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ioc' is set
        if ('ioc' not in params or
                params['ioc'] is None):
            raise ValueError("Missing the required parameter `ioc` when calling `get_ioc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ioc' in params:
            path_params['ioc'] = params['ioc']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/iocs/{ioc}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IoCResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_labels(self, file_hash, **kwargs):  # noqa: E501
        """Retrieves all the labels for a given binary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_labels(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: MagicLabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_labels_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.get_labels_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def get_labels_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Retrieves all the labels for a given binary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_labels_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: MagicLabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_labels" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `get_labels`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `get_labels`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/labels/{file_hash}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MagicLabelsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reanalyze_file(self, file_hash, **kwargs):  # noqa: E501
        """Re-analyzes the binary and updates the labels and scan data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reanalyze_file(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reanalyze_file_with_http_info(file_hash, **kwargs)  # noqa: E501
        else:
            (data) = self.reanalyze_file_with_http_info(file_hash, **kwargs)  # noqa: E501
            return data

    def reanalyze_file_with_http_info(self, file_hash, **kwargs):  # noqa: E501
        """Re-analyzes the binary and updates the labels and scan data  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reanalyze_file_with_http_info(file_hash, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_hash: A cryptographic hash of a file. Supported hashes are SHA1. (required)
        :return: SuccessResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_hash']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reanalyze_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_hash' is set
        if ('file_hash' not in params or
                params['file_hash'] is None):
            raise ValueError("Missing the required parameter `file_hash` when calling `reanalyze_file`")  # noqa: E501

        if 'file_hash' in params and not re.search(r'[a-fA-F0-9]{32}', params['file_hash']):  # noqa: E501
            raise ValueError("Invalid value for parameter `file_hash` when calling `reanalyze_file`, must conform to the pattern `/[a-fA-F0-9]{32}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'file_hash' in params:
            path_params['file_hash'] = params['file_hash']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_query_param']  # noqa: E501

        return self.api_client.call_api(
            '/labels/{file_hash}/reanalyze', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
