"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenerCertificate = void 0;
/**
 * A certificate source for an ELBv2 listener
 */
class ListenerCertificate {
    constructor(certificateArn) {
        this.certificateArn = certificateArn;
    }
    /**
     * Use an ACM certificate as a listener certificate
     */
    static fromCertificateManager(acmCertificate) {
        return new ListenerCertificate(acmCertificate.certificateArn);
    }
    /**
     * Use any certificate, identified by its ARN, as a listener certificate
     */
    static fromArn(certificateArn) {
        return new ListenerCertificate(certificateArn);
    }
}
exports.ListenerCertificate = ListenerCertificate;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdGVuZXItY2VydGlmaWNhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaXN0ZW5lci1jZXJ0aWZpY2F0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFZQTs7R0FFRztBQUNILE1BQWEsbUJBQW1CO0lBb0I5QixZQUFzQixjQUFzQjtRQUMxQyxJQUFJLENBQUMsY0FBYyxHQUFHLGNBQWMsQ0FBQztJQUN2QyxDQUFDO0lBckJEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLHNCQUFzQixDQUFDLGNBQWdDO1FBQ25FLE9BQU8sSUFBSSxtQkFBbUIsQ0FBQyxjQUFjLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDaEUsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLE9BQU8sQ0FBQyxjQUFzQjtRQUMxQyxPQUFPLElBQUksbUJBQW1CLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztDQVVGO0FBdkJELGtEQXVCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGFjbSBmcm9tICdAYXdzLWNkay9hd3MtY2VydGlmaWNhdGVtYW5hZ2VyJztcblxuLyoqXG4gKiBBIGNlcnRpZmljYXRlIHNvdXJjZSBmb3IgYW4gRUxCdjIgbGlzdGVuZXJcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJTGlzdGVuZXJDZXJ0aWZpY2F0ZSB7XG4gIC8qKlxuICAgKiBUaGUgQVJOIG9mIHRoZSBjZXJ0aWZpY2F0ZSB0byB1c2VcbiAgICovXG4gIHJlYWRvbmx5IGNlcnRpZmljYXRlQXJuOiBzdHJpbmc7XG59XG5cbi8qKlxuICogQSBjZXJ0aWZpY2F0ZSBzb3VyY2UgZm9yIGFuIEVMQnYyIGxpc3RlbmVyXG4gKi9cbmV4cG9ydCBjbGFzcyBMaXN0ZW5lckNlcnRpZmljYXRlIGltcGxlbWVudHMgSUxpc3RlbmVyQ2VydGlmaWNhdGUge1xuICAvKipcbiAgICogVXNlIGFuIEFDTSBjZXJ0aWZpY2F0ZSBhcyBhIGxpc3RlbmVyIGNlcnRpZmljYXRlXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21DZXJ0aWZpY2F0ZU1hbmFnZXIoYWNtQ2VydGlmaWNhdGU6IGFjbS5JQ2VydGlmaWNhdGUpIHtcbiAgICByZXR1cm4gbmV3IExpc3RlbmVyQ2VydGlmaWNhdGUoYWNtQ2VydGlmaWNhdGUuY2VydGlmaWNhdGVBcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIFVzZSBhbnkgY2VydGlmaWNhdGUsIGlkZW50aWZpZWQgYnkgaXRzIEFSTiwgYXMgYSBsaXN0ZW5lciBjZXJ0aWZpY2F0ZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tQXJuKGNlcnRpZmljYXRlQXJuOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gbmV3IExpc3RlbmVyQ2VydGlmaWNhdGUoY2VydGlmaWNhdGVBcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIGNlcnRpZmljYXRlIHRvIHVzZVxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGNlcnRpZmljYXRlQXJuOiBzdHJpbmc7XG5cbiAgcHJvdGVjdGVkIGNvbnN0cnVjdG9yKGNlcnRpZmljYXRlQXJuOiBzdHJpbmcpIHtcbiAgICB0aGlzLmNlcnRpZmljYXRlQXJuID0gY2VydGlmaWNhdGVBcm47XG4gIH1cbn1cbiJdfQ==