from google.protobuf import duration_pb2 as _duration_pb2
from google.protobuf import timestamp_pb2 as _timestamp_pb2
from . import objects_pb2 as _objects_pb2
from . import sort_direction_pb2 as _sort_direction_pb2
from . import task_status_pb2 as _task_status_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Iterable as _Iterable, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class TaskSummaryField(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = []
    TASK_SUMMARY_FIELD_UNSPECIFIED: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_TASK_ID: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_SESSION_ID: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_OWNER_POD_ID: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_INITIAL_TASK_ID: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_STATUS: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_CREATED_AT: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_SUBMITTED_AT: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_STARTED_AT: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_ENDED_AT: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_CREATION_TO_END_DURATION: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_PROCESSING_TO_END_DURATION: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_POD_TTL: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_POD_HOSTNAME: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_RECEIVED_AT: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_ACQUIRED_AT: _ClassVar[TaskSummaryField]
    TASK_SUMMARY_FIELD_ERROR: _ClassVar[TaskSummaryField]

class TaskOptionField(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = []
    TASK_OPTION_FIELD_UNSPECIFIED: _ClassVar[TaskOptionField]
    TASK_OPTION_FIELD_MAX_DURATION: _ClassVar[TaskOptionField]
    TASK_OPTION_FIELD_MAX_RETRIES: _ClassVar[TaskOptionField]
    TASK_OPTION_FIELD_PRIORITY: _ClassVar[TaskOptionField]
    TASK_OPTION_FIELD_PARTITION_ID: _ClassVar[TaskOptionField]
    TASK_OPTION_FIELD_APPLICATION_NAME: _ClassVar[TaskOptionField]
    TASK_OPTION_FIELD_APPLICATION_VERSION: _ClassVar[TaskOptionField]
    TASK_OPTION_FIELD_APPLICATION_NAMESPACE: _ClassVar[TaskOptionField]
    TASK_OPTION_FIELD_APPLICATION_SERVICE: _ClassVar[TaskOptionField]
    TASK_OPTION_FIELD_ENGINE_TYPE: _ClassVar[TaskOptionField]
TASK_SUMMARY_FIELD_UNSPECIFIED: TaskSummaryField
TASK_SUMMARY_FIELD_TASK_ID: TaskSummaryField
TASK_SUMMARY_FIELD_SESSION_ID: TaskSummaryField
TASK_SUMMARY_FIELD_OWNER_POD_ID: TaskSummaryField
TASK_SUMMARY_FIELD_INITIAL_TASK_ID: TaskSummaryField
TASK_SUMMARY_FIELD_STATUS: TaskSummaryField
TASK_SUMMARY_FIELD_CREATED_AT: TaskSummaryField
TASK_SUMMARY_FIELD_SUBMITTED_AT: TaskSummaryField
TASK_SUMMARY_FIELD_STARTED_AT: TaskSummaryField
TASK_SUMMARY_FIELD_ENDED_AT: TaskSummaryField
TASK_SUMMARY_FIELD_CREATION_TO_END_DURATION: TaskSummaryField
TASK_SUMMARY_FIELD_PROCESSING_TO_END_DURATION: TaskSummaryField
TASK_SUMMARY_FIELD_POD_TTL: TaskSummaryField
TASK_SUMMARY_FIELD_POD_HOSTNAME: TaskSummaryField
TASK_SUMMARY_FIELD_RECEIVED_AT: TaskSummaryField
TASK_SUMMARY_FIELD_ACQUIRED_AT: TaskSummaryField
TASK_SUMMARY_FIELD_ERROR: TaskSummaryField
TASK_OPTION_FIELD_UNSPECIFIED: TaskOptionField
TASK_OPTION_FIELD_MAX_DURATION: TaskOptionField
TASK_OPTION_FIELD_MAX_RETRIES: TaskOptionField
TASK_OPTION_FIELD_PRIORITY: TaskOptionField
TASK_OPTION_FIELD_PARTITION_ID: TaskOptionField
TASK_OPTION_FIELD_APPLICATION_NAME: TaskOptionField
TASK_OPTION_FIELD_APPLICATION_VERSION: TaskOptionField
TASK_OPTION_FIELD_APPLICATION_NAMESPACE: TaskOptionField
TASK_OPTION_FIELD_APPLICATION_SERVICE: TaskOptionField
TASK_OPTION_FIELD_ENGINE_TYPE: TaskOptionField

class TaskRaw(_message.Message):
    __slots__ = ["id", "session_id", "owner_pod_id", "initial_task_id", "parent_task_ids", "data_dependencies", "expected_output_ids", "retry_of_ids", "status", "status_message", "options", "created_at", "submitted_at", "started_at", "ended_at", "creation_to_end_duration", "processing_to_end_duration", "pod_ttl", "output", "pod_hostname", "received_at", "acquired_at"]
    class Output(_message.Message):
        __slots__ = ["success", "error"]
        SUCCESS_FIELD_NUMBER: _ClassVar[int]
        ERROR_FIELD_NUMBER: _ClassVar[int]
        success: bool
        error: str
        def __init__(self, success: bool = ..., error: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    SESSION_ID_FIELD_NUMBER: _ClassVar[int]
    OWNER_POD_ID_FIELD_NUMBER: _ClassVar[int]
    INITIAL_TASK_ID_FIELD_NUMBER: _ClassVar[int]
    PARENT_TASK_IDS_FIELD_NUMBER: _ClassVar[int]
    DATA_DEPENDENCIES_FIELD_NUMBER: _ClassVar[int]
    EXPECTED_OUTPUT_IDS_FIELD_NUMBER: _ClassVar[int]
    RETRY_OF_IDS_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    STATUS_MESSAGE_FIELD_NUMBER: _ClassVar[int]
    OPTIONS_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    SUBMITTED_AT_FIELD_NUMBER: _ClassVar[int]
    STARTED_AT_FIELD_NUMBER: _ClassVar[int]
    ENDED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATION_TO_END_DURATION_FIELD_NUMBER: _ClassVar[int]
    PROCESSING_TO_END_DURATION_FIELD_NUMBER: _ClassVar[int]
    POD_TTL_FIELD_NUMBER: _ClassVar[int]
    OUTPUT_FIELD_NUMBER: _ClassVar[int]
    POD_HOSTNAME_FIELD_NUMBER: _ClassVar[int]
    RECEIVED_AT_FIELD_NUMBER: _ClassVar[int]
    ACQUIRED_AT_FIELD_NUMBER: _ClassVar[int]
    id: str
    session_id: str
    owner_pod_id: str
    initial_task_id: str
    parent_task_ids: _containers.RepeatedScalarFieldContainer[str]
    data_dependencies: _containers.RepeatedScalarFieldContainer[str]
    expected_output_ids: _containers.RepeatedScalarFieldContainer[str]
    retry_of_ids: _containers.RepeatedScalarFieldContainer[str]
    status: _task_status_pb2.TaskStatus
    status_message: str
    options: _objects_pb2.TaskOptions
    created_at: _timestamp_pb2.Timestamp
    submitted_at: _timestamp_pb2.Timestamp
    started_at: _timestamp_pb2.Timestamp
    ended_at: _timestamp_pb2.Timestamp
    creation_to_end_duration: _duration_pb2.Duration
    processing_to_end_duration: _duration_pb2.Duration
    pod_ttl: _timestamp_pb2.Timestamp
    output: TaskRaw.Output
    pod_hostname: str
    received_at: _timestamp_pb2.Timestamp
    acquired_at: _timestamp_pb2.Timestamp
    def __init__(self, id: _Optional[str] = ..., session_id: _Optional[str] = ..., owner_pod_id: _Optional[str] = ..., initial_task_id: _Optional[str] = ..., parent_task_ids: _Optional[_Iterable[str]] = ..., data_dependencies: _Optional[_Iterable[str]] = ..., expected_output_ids: _Optional[_Iterable[str]] = ..., retry_of_ids: _Optional[_Iterable[str]] = ..., status: _Optional[_Union[_task_status_pb2.TaskStatus, str]] = ..., status_message: _Optional[str] = ..., options: _Optional[_Union[_objects_pb2.TaskOptions, _Mapping]] = ..., created_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., submitted_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., started_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., ended_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., creation_to_end_duration: _Optional[_Union[_duration_pb2.Duration, _Mapping]] = ..., processing_to_end_duration: _Optional[_Union[_duration_pb2.Duration, _Mapping]] = ..., pod_ttl: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., output: _Optional[_Union[TaskRaw.Output, _Mapping]] = ..., pod_hostname: _Optional[str] = ..., received_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., acquired_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class TaskSummary(_message.Message):
    __slots__ = ["id", "session_id", "owner_pod_id", "initial_task_id", "count_parent_task_ids", "count_data_dependencies", "count_expected_output_ids", "count_retry_of_ids", "status", "status_message", "options", "created_at", "submitted_at", "started_at", "ended_at", "creation_to_end_duration", "processing_to_end_duration", "pod_ttl", "error", "pod_hostname", "received_at", "acquired_at"]
    ID_FIELD_NUMBER: _ClassVar[int]
    SESSION_ID_FIELD_NUMBER: _ClassVar[int]
    OWNER_POD_ID_FIELD_NUMBER: _ClassVar[int]
    INITIAL_TASK_ID_FIELD_NUMBER: _ClassVar[int]
    COUNT_PARENT_TASK_IDS_FIELD_NUMBER: _ClassVar[int]
    COUNT_DATA_DEPENDENCIES_FIELD_NUMBER: _ClassVar[int]
    COUNT_EXPECTED_OUTPUT_IDS_FIELD_NUMBER: _ClassVar[int]
    COUNT_RETRY_OF_IDS_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    STATUS_MESSAGE_FIELD_NUMBER: _ClassVar[int]
    OPTIONS_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    SUBMITTED_AT_FIELD_NUMBER: _ClassVar[int]
    STARTED_AT_FIELD_NUMBER: _ClassVar[int]
    ENDED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATION_TO_END_DURATION_FIELD_NUMBER: _ClassVar[int]
    PROCESSING_TO_END_DURATION_FIELD_NUMBER: _ClassVar[int]
    POD_TTL_FIELD_NUMBER: _ClassVar[int]
    ERROR_FIELD_NUMBER: _ClassVar[int]
    POD_HOSTNAME_FIELD_NUMBER: _ClassVar[int]
    RECEIVED_AT_FIELD_NUMBER: _ClassVar[int]
    ACQUIRED_AT_FIELD_NUMBER: _ClassVar[int]
    id: str
    session_id: str
    owner_pod_id: str
    initial_task_id: str
    count_parent_task_ids: int
    count_data_dependencies: int
    count_expected_output_ids: int
    count_retry_of_ids: int
    status: _task_status_pb2.TaskStatus
    status_message: str
    options: _objects_pb2.TaskOptions
    created_at: _timestamp_pb2.Timestamp
    submitted_at: _timestamp_pb2.Timestamp
    started_at: _timestamp_pb2.Timestamp
    ended_at: _timestamp_pb2.Timestamp
    creation_to_end_duration: _duration_pb2.Duration
    processing_to_end_duration: _duration_pb2.Duration
    pod_ttl: _timestamp_pb2.Timestamp
    error: str
    pod_hostname: str
    received_at: _timestamp_pb2.Timestamp
    acquired_at: _timestamp_pb2.Timestamp
    def __init__(self, id: _Optional[str] = ..., session_id: _Optional[str] = ..., owner_pod_id: _Optional[str] = ..., initial_task_id: _Optional[str] = ..., count_parent_task_ids: _Optional[int] = ..., count_data_dependencies: _Optional[int] = ..., count_expected_output_ids: _Optional[int] = ..., count_retry_of_ids: _Optional[int] = ..., status: _Optional[_Union[_task_status_pb2.TaskStatus, str]] = ..., status_message: _Optional[str] = ..., options: _Optional[_Union[_objects_pb2.TaskOptions, _Mapping]] = ..., created_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., submitted_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., started_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., ended_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., creation_to_end_duration: _Optional[_Union[_duration_pb2.Duration, _Mapping]] = ..., processing_to_end_duration: _Optional[_Union[_duration_pb2.Duration, _Mapping]] = ..., pod_ttl: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., error: _Optional[str] = ..., pod_hostname: _Optional[str] = ..., received_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., acquired_at: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class TaskOptionGenericField(_message.Message):
    __slots__ = ["field"]
    FIELD_FIELD_NUMBER: _ClassVar[int]
    field: str
    def __init__(self, field: _Optional[str] = ...) -> None: ...

class TaskField(_message.Message):
    __slots__ = ["task_summary_field", "task_option_field", "task_option_generic_field"]
    TASK_SUMMARY_FIELD_FIELD_NUMBER: _ClassVar[int]
    TASK_OPTION_FIELD_FIELD_NUMBER: _ClassVar[int]
    TASK_OPTION_GENERIC_FIELD_FIELD_NUMBER: _ClassVar[int]
    task_summary_field: TaskSummaryField
    task_option_field: TaskOptionField
    task_option_generic_field: TaskOptionGenericField
    def __init__(self, task_summary_field: _Optional[_Union[TaskSummaryField, str]] = ..., task_option_field: _Optional[_Union[TaskOptionField, str]] = ..., task_option_generic_field: _Optional[_Union[TaskOptionGenericField, _Mapping]] = ...) -> None: ...

class ListTasksRequest(_message.Message):
    __slots__ = ["page", "page_size", "filter", "sort", "with_errors"]
    class Filter(_message.Message):
        __slots__ = ["session_id", "status", "created_after", "created_before", "started_after", "started_before", "ended_after", "ended_before"]
        SESSION_ID_FIELD_NUMBER: _ClassVar[int]
        STATUS_FIELD_NUMBER: _ClassVar[int]
        CREATED_AFTER_FIELD_NUMBER: _ClassVar[int]
        CREATED_BEFORE_FIELD_NUMBER: _ClassVar[int]
        STARTED_AFTER_FIELD_NUMBER: _ClassVar[int]
        STARTED_BEFORE_FIELD_NUMBER: _ClassVar[int]
        ENDED_AFTER_FIELD_NUMBER: _ClassVar[int]
        ENDED_BEFORE_FIELD_NUMBER: _ClassVar[int]
        session_id: str
        status: _containers.RepeatedScalarFieldContainer[_task_status_pb2.TaskStatus]
        created_after: _timestamp_pb2.Timestamp
        created_before: _timestamp_pb2.Timestamp
        started_after: _timestamp_pb2.Timestamp
        started_before: _timestamp_pb2.Timestamp
        ended_after: _timestamp_pb2.Timestamp
        ended_before: _timestamp_pb2.Timestamp
        def __init__(self, session_id: _Optional[str] = ..., status: _Optional[_Iterable[_Union[_task_status_pb2.TaskStatus, str]]] = ..., created_after: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., created_before: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., started_after: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., started_before: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., ended_after: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., ended_before: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...
    class Sort(_message.Message):
        __slots__ = ["field", "direction"]
        FIELD_FIELD_NUMBER: _ClassVar[int]
        DIRECTION_FIELD_NUMBER: _ClassVar[int]
        field: TaskField
        direction: _sort_direction_pb2.SortDirection
        def __init__(self, field: _Optional[_Union[TaskField, _Mapping]] = ..., direction: _Optional[_Union[_sort_direction_pb2.SortDirection, str]] = ...) -> None: ...
    PAGE_FIELD_NUMBER: _ClassVar[int]
    PAGE_SIZE_FIELD_NUMBER: _ClassVar[int]
    FILTER_FIELD_NUMBER: _ClassVar[int]
    SORT_FIELD_NUMBER: _ClassVar[int]
    WITH_ERRORS_FIELD_NUMBER: _ClassVar[int]
    page: int
    page_size: int
    filter: ListTasksRequest.Filter
    sort: ListTasksRequest.Sort
    with_errors: bool
    def __init__(self, page: _Optional[int] = ..., page_size: _Optional[int] = ..., filter: _Optional[_Union[ListTasksRequest.Filter, _Mapping]] = ..., sort: _Optional[_Union[ListTasksRequest.Sort, _Mapping]] = ..., with_errors: bool = ...) -> None: ...

class ListTasksResponse(_message.Message):
    __slots__ = ["tasks", "page", "page_size", "total"]
    TASKS_FIELD_NUMBER: _ClassVar[int]
    PAGE_FIELD_NUMBER: _ClassVar[int]
    PAGE_SIZE_FIELD_NUMBER: _ClassVar[int]
    TOTAL_FIELD_NUMBER: _ClassVar[int]
    tasks: _containers.RepeatedCompositeFieldContainer[TaskSummary]
    page: int
    page_size: int
    total: int
    def __init__(self, tasks: _Optional[_Iterable[_Union[TaskSummary, _Mapping]]] = ..., page: _Optional[int] = ..., page_size: _Optional[int] = ..., total: _Optional[int] = ...) -> None: ...

class ListTasksRawResponse(_message.Message):
    __slots__ = ["tasks", "page", "page_size", "total"]
    TASKS_FIELD_NUMBER: _ClassVar[int]
    PAGE_FIELD_NUMBER: _ClassVar[int]
    PAGE_SIZE_FIELD_NUMBER: _ClassVar[int]
    TOTAL_FIELD_NUMBER: _ClassVar[int]
    tasks: _containers.RepeatedCompositeFieldContainer[TaskRaw]
    page: int
    page_size: int
    total: int
    def __init__(self, tasks: _Optional[_Iterable[_Union[TaskRaw, _Mapping]]] = ..., page: _Optional[int] = ..., page_size: _Optional[int] = ..., total: _Optional[int] = ...) -> None: ...

class GetTaskRequest(_message.Message):
    __slots__ = ["task_id"]
    TASK_ID_FIELD_NUMBER: _ClassVar[int]
    task_id: str
    def __init__(self, task_id: _Optional[str] = ...) -> None: ...

class GetTaskResponse(_message.Message):
    __slots__ = ["task"]
    TASK_FIELD_NUMBER: _ClassVar[int]
    task: TaskRaw
    def __init__(self, task: _Optional[_Union[TaskRaw, _Mapping]] = ...) -> None: ...

class CancelTasksRequest(_message.Message):
    __slots__ = ["task_ids"]
    TASK_IDS_FIELD_NUMBER: _ClassVar[int]
    task_ids: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, task_ids: _Optional[_Iterable[str]] = ...) -> None: ...

class CancelTasksResponse(_message.Message):
    __slots__ = ["tasks"]
    TASKS_FIELD_NUMBER: _ClassVar[int]
    tasks: _containers.RepeatedCompositeFieldContainer[TaskSummary]
    def __init__(self, tasks: _Optional[_Iterable[_Union[TaskSummary, _Mapping]]] = ...) -> None: ...

class GetResultIdsRequest(_message.Message):
    __slots__ = ["task_id"]
    TASK_ID_FIELD_NUMBER: _ClassVar[int]
    task_id: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, task_id: _Optional[_Iterable[str]] = ...) -> None: ...

class GetResultIdsResponse(_message.Message):
    __slots__ = ["task_results"]
    class MapTaskResult(_message.Message):
        __slots__ = ["task_id", "result_ids"]
        TASK_ID_FIELD_NUMBER: _ClassVar[int]
        RESULT_IDS_FIELD_NUMBER: _ClassVar[int]
        task_id: str
        result_ids: _containers.RepeatedScalarFieldContainer[str]
        def __init__(self, task_id: _Optional[str] = ..., result_ids: _Optional[_Iterable[str]] = ...) -> None: ...
    TASK_RESULTS_FIELD_NUMBER: _ClassVar[int]
    task_results: _containers.RepeatedCompositeFieldContainer[GetResultIdsResponse.MapTaskResult]
    def __init__(self, task_results: _Optional[_Iterable[_Union[GetResultIdsResponse.MapTaskResult, _Mapping]]] = ...) -> None: ...

class CountTasksByStatusRequest(_message.Message):
    __slots__ = []
    def __init__(self) -> None: ...

class CountTasksByStatusResponse(_message.Message):
    __slots__ = ["status"]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    status: _containers.RepeatedCompositeFieldContainer[_objects_pb2.StatusCount]
    def __init__(self, status: _Optional[_Iterable[_Union[_objects_pb2.StatusCount, _Mapping]]] = ...) -> None: ...

class SubmitTasksRequest(_message.Message):
    __slots__ = ["session_id", "task_options", "task_creations"]
    class TaskCreation(_message.Message):
        __slots__ = ["expected_output_keys", "data_dependencies", "payload_id", "task_options"]
        EXPECTED_OUTPUT_KEYS_FIELD_NUMBER: _ClassVar[int]
        DATA_DEPENDENCIES_FIELD_NUMBER: _ClassVar[int]
        PAYLOAD_ID_FIELD_NUMBER: _ClassVar[int]
        TASK_OPTIONS_FIELD_NUMBER: _ClassVar[int]
        expected_output_keys: _containers.RepeatedScalarFieldContainer[str]
        data_dependencies: _containers.RepeatedScalarFieldContainer[str]
        payload_id: str
        task_options: _objects_pb2.TaskOptions
        def __init__(self, expected_output_keys: _Optional[_Iterable[str]] = ..., data_dependencies: _Optional[_Iterable[str]] = ..., payload_id: _Optional[str] = ..., task_options: _Optional[_Union[_objects_pb2.TaskOptions, _Mapping]] = ...) -> None: ...
    SESSION_ID_FIELD_NUMBER: _ClassVar[int]
    TASK_OPTIONS_FIELD_NUMBER: _ClassVar[int]
    TASK_CREATIONS_FIELD_NUMBER: _ClassVar[int]
    session_id: str
    task_options: _objects_pb2.TaskOptions
    task_creations: _containers.RepeatedCompositeFieldContainer[SubmitTasksRequest.TaskCreation]
    def __init__(self, session_id: _Optional[str] = ..., task_options: _Optional[_Union[_objects_pb2.TaskOptions, _Mapping]] = ..., task_creations: _Optional[_Iterable[_Union[SubmitTasksRequest.TaskCreation, _Mapping]]] = ...) -> None: ...

class SubmitTasksResponse(_message.Message):
    __slots__ = ["task_infos"]
    class TaskInfo(_message.Message):
        __slots__ = ["task_id", "expected_output_ids", "data_dependencies", "payload_id"]
        TASK_ID_FIELD_NUMBER: _ClassVar[int]
        EXPECTED_OUTPUT_IDS_FIELD_NUMBER: _ClassVar[int]
        DATA_DEPENDENCIES_FIELD_NUMBER: _ClassVar[int]
        PAYLOAD_ID_FIELD_NUMBER: _ClassVar[int]
        task_id: str
        expected_output_ids: _containers.RepeatedScalarFieldContainer[str]
        data_dependencies: _containers.RepeatedScalarFieldContainer[str]
        payload_id: str
        def __init__(self, task_id: _Optional[str] = ..., expected_output_ids: _Optional[_Iterable[str]] = ..., data_dependencies: _Optional[_Iterable[str]] = ..., payload_id: _Optional[str] = ...) -> None: ...
    TASK_INFOS_FIELD_NUMBER: _ClassVar[int]
    task_infos: _containers.RepeatedCompositeFieldContainer[SubmitTasksResponse.TaskInfo]
    def __init__(self, task_infos: _Optional[_Iterable[_Union[SubmitTasksResponse.TaskInfo, _Mapping]]] = ...) -> None: ...
