"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * An SNS dead letter queue destination configuration for a Lambda event source
 */
class SnsDlq {
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        this.topic.grantPublish(targetHandler);
        return {
            destination: this.topic.topicArn
        };
    }
}
exports.SnsDlq = SnsDlq;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNucy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFHQTs7R0FFRztBQUNILE1BQWEsTUFBTTtJQUNqQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7SUFFRDs7T0FFRztJQUNJLElBQUksQ0FBQyxPQUE0QixFQUFFLGFBQXdCO1FBQ2hFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBRXZDLE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ2pDLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFkRCx3QkFjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERscURlc3RpbmF0aW9uQ29uZmlnLCBJRXZlbnRTb3VyY2VEbHEsIElFdmVudFNvdXJjZU1hcHBpbmcsIElGdW5jdGlvbiB9IGZyb20gXCJAYXdzLWNkay9hd3MtbGFtYmRhXCI7XG5pbXBvcnQgKiBhcyBzbnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucyc7XG5cbi8qKlxuICogQW4gU05TIGRlYWQgbGV0dGVyIHF1ZXVlIGRlc3RpbmF0aW9uIGNvbmZpZ3VyYXRpb24gZm9yIGEgTGFtYmRhIGV2ZW50IHNvdXJjZVxuICovXG5leHBvcnQgY2xhc3MgU25zRGxxIGltcGxlbWVudHMgSUV2ZW50U291cmNlRGxxIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB0b3BpYzogc25zLklUb3BpYykge1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYSBkZXN0aW5hdGlvbiBjb25maWd1cmF0aW9uIGZvciB0aGUgRExRXG4gICAqL1xuICBwdWJsaWMgYmluZChfdGFyZ2V0OiBJRXZlbnRTb3VyY2VNYXBwaW5nLCB0YXJnZXRIYW5kbGVyOiBJRnVuY3Rpb24pOiBEbHFEZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgdGhpcy50b3BpYy5ncmFudFB1Ymxpc2godGFyZ2V0SGFuZGxlcik7XG5cbiAgICByZXR1cm4ge1xuICAgICAgZGVzdGluYXRpb246IHRoaXMudG9waWMudG9waWNBcm5cbiAgICB9O1xuICB9XG59XG4iXX0=