"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const kinesis = require("@aws-cdk/aws-kinesis");
const lambda = require("@aws-cdk/aws-lambda");
const sqs = require("@aws-cdk/aws-sqs");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
/*
 * Stack verification steps:
 * * aws kinesis put-record --stream-name <value of stack output: InputKinesisStreamName> --partition-key 123 --data testdata
 * * aws sqs receive-message --queue-url <value of stack output: DlqSqsQueueUrl> --max-number-of-messages 1 --query 'Messages[0].Body'
 * The last command should return a string that contains the Lambda function ARN in it.
 */
async function handler(event) {
    // tslint:disable-next-line:no-console
    console.log('event:', JSON.stringify(event, undefined, 2));
    throw new Error();
}
class KinesisWithDLQTest extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const fn = new lambda.Function(this, 'F', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.fromInline(`exports.handler = ${handler.toString()}`)
        });
        new core_1.CfnOutput(this, 'FunctionArn', { value: fn.functionArn });
        const stream = new kinesis.Stream(this, 'S');
        new core_1.CfnOutput(this, 'InputKinesisStreamName', { value: stream.streamName });
        const dlq = new sqs.Queue(this, 'Q');
        new core_1.CfnOutput(this, 'DlqSqsQueueUrl', { value: dlq.queueUrl });
        fn.addEventSource(new lib_1.KinesisEventSource(stream, {
            startingPosition: lambda.StartingPosition.TRIM_HORIZON,
            onFailure: new lib_1.SqsDlq(dlq),
            retryAttempts: 0,
        }));
    }
}
const app = new core_1.App();
new KinesisWithDLQTest(app, 'lambda-event-source-kinesis-with-dlq');
app.synth();
//# sourceMappingURL=data:application/json;base64,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