"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnApplication = exports.toJson_ImplicitGrantDefinition = exports.toJson_ResourceAccessDefinition = exports.toJson_IdTokenDefinition = exports.toJson_AccessTokenDefinition = exports.toJson_Oauth2PermissionScopeDefinition = exports.toJson_WebDefinition = exports.toJson_TimeoutsDefinition = exports.toJson_RequiredResourceAccessDefinition = exports.toJson_OptionalClaimsDefinition = exports.toJson_ApiDefinition = exports.toJson_Oauth2PermissionsDefinition = exports.toJson_AppRoleDefinition = exports.toJson_CfnApplicationProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnApplicationProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnApplicationProps(obj) {
    var _b, _c, _d, _e, _f, _g, _h, _j, _k;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AppRole': (_b = obj.appRole) === null || _b === void 0 ? void 0 : _b.map(y => toJson_AppRoleDefinition(y)),
        'AvailableToOtherTenants': obj.availableToOtherTenants,
        'DisplayName': obj.displayName,
        'FallbackPublicClientEnabled': obj.fallbackPublicClientEnabled,
        'GroupMembershipClaims': obj.groupMembershipClaims,
        'Homepage': obj.homepage,
        'IdentifierUris': (_c = obj.identifierUris) === null || _c === void 0 ? void 0 : _c.map(y => y),
        'LogoutUrl': obj.logoutUrl,
        'Name': obj.name,
        'Oauth2AllowImplicitFlow': obj.oauth2AllowImplicitFlow,
        'Oauth2Permissions': (_d = obj.oauth2Permissions) === null || _d === void 0 ? void 0 : _d.map(y => toJson_Oauth2PermissionsDefinition(y)),
        'Owners': (_e = obj.owners) === null || _e === void 0 ? void 0 : _e.map(y => y),
        'PreventDuplicateNames': obj.preventDuplicateNames,
        'PublicClient': obj.publicClient,
        'ReplyUrls': (_f = obj.replyUrls) === null || _f === void 0 ? void 0 : _f.map(y => y),
        'SignInAudience': obj.signInAudience,
        'Type': obj.type,
        'Api': (_g = obj.api) === null || _g === void 0 ? void 0 : _g.map(y => toJson_ApiDefinition(y)),
        'OptionalClaims': (_h = obj.optionalClaims) === null || _h === void 0 ? void 0 : _h.map(y => toJson_OptionalClaimsDefinition(y)),
        'RequiredResourceAccess': (_j = obj.requiredResourceAccess) === null || _j === void 0 ? void 0 : _j.map(y => toJson_RequiredResourceAccessDefinition(y)),
        'Timeouts': toJson_TimeoutsDefinition(obj.timeouts),
        'Web': (_k = obj.web) === null || _k === void 0 ? void 0 : _k.map(y => toJson_WebDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnApplicationProps = toJson_CfnApplicationProps;
/**
 * Converts an object of type 'AppRoleDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AppRoleDefinition(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AllowedMemberTypes': (_b = obj.allowedMemberTypes) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'Description': obj.description,
        'DisplayName': obj.displayName,
        'Enabled': obj.enabled,
        'Id': obj.id,
        'IsEnabled': obj.isEnabled,
        'Value': obj.value,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AppRoleDefinition = toJson_AppRoleDefinition;
/**
 * Converts an object of type 'Oauth2PermissionsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Oauth2PermissionsDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AdminConsentDescription': obj.adminConsentDescription,
        'AdminConsentDisplayName': obj.adminConsentDisplayName,
        'Id': obj.id,
        'IsEnabled': obj.isEnabled,
        'Type': obj.type,
        'UserConsentDescription': obj.userConsentDescription,
        'UserConsentDisplayName': obj.userConsentDisplayName,
        'Value': obj.value,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Oauth2PermissionsDefinition = toJson_Oauth2PermissionsDefinition;
/**
 * Converts an object of type 'ApiDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ApiDefinition(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Oauth2PermissionScope': (_b = obj.oauth2PermissionScope) === null || _b === void 0 ? void 0 : _b.map(y => toJson_Oauth2PermissionScopeDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ApiDefinition = toJson_ApiDefinition;
/**
 * Converts an object of type 'OptionalClaimsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_OptionalClaimsDefinition(obj) {
    var _b, _c;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccessToken': (_b = obj.accessToken) === null || _b === void 0 ? void 0 : _b.map(y => toJson_AccessTokenDefinition(y)),
        'IdToken': (_c = obj.idToken) === null || _c === void 0 ? void 0 : _c.map(y => toJson_IdTokenDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_OptionalClaimsDefinition = toJson_OptionalClaimsDefinition;
/**
 * Converts an object of type 'RequiredResourceAccessDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RequiredResourceAccessDefinition(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ResourceAppId': obj.resourceAppId,
        'ResourceAccess': (_b = obj.resourceAccess) === null || _b === void 0 ? void 0 : _b.map(y => toJson_ResourceAccessDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RequiredResourceAccessDefinition = toJson_RequiredResourceAccessDefinition;
/**
 * Converts an object of type 'TimeoutsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TimeoutsDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Create': obj.create,
        'Delete': obj.delete,
        'Read': obj.read,
        'Update': obj.update,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TimeoutsDefinition = toJson_TimeoutsDefinition;
/**
 * Converts an object of type 'WebDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_WebDefinition(obj) {
    var _b, _c;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'HomepageUrl': obj.homepageUrl,
        'LogoutUrl': obj.logoutUrl,
        'RedirectUris': (_b = obj.redirectUris) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'ImplicitGrant': (_c = obj.implicitGrant) === null || _c === void 0 ? void 0 : _c.map(y => toJson_ImplicitGrantDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_WebDefinition = toJson_WebDefinition;
/**
 * Converts an object of type 'Oauth2PermissionScopeDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Oauth2PermissionScopeDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AdminConsentDescription': obj.adminConsentDescription,
        'AdminConsentDisplayName': obj.adminConsentDisplayName,
        'Enabled': obj.enabled,
        'Id': obj.id,
        'Type': obj.type,
        'UserConsentDescription': obj.userConsentDescription,
        'UserConsentDisplayName': obj.userConsentDisplayName,
        'Value': obj.value,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Oauth2PermissionScopeDefinition = toJson_Oauth2PermissionScopeDefinition;
/**
 * Converts an object of type 'AccessTokenDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AccessTokenDefinition(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AdditionalProperties': (_b = obj.additionalProperties) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'Essential': obj.essential,
        'Name': obj.name,
        'Source': obj.source,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AccessTokenDefinition = toJson_AccessTokenDefinition;
/**
 * Converts an object of type 'IdTokenDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_IdTokenDefinition(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AdditionalProperties': (_b = obj.additionalProperties) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'Essential': obj.essential,
        'Name': obj.name,
        'Source': obj.source,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_IdTokenDefinition = toJson_IdTokenDefinition;
/**
 * Converts an object of type 'ResourceAccessDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ResourceAccessDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Id': obj.id,
        'Type': obj.type,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ResourceAccessDefinition = toJson_ResourceAccessDefinition;
/**
 * Converts an object of type 'ImplicitGrantDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ImplicitGrantDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccessTokenIssuanceEnabled': obj.accessTokenIssuanceEnabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ImplicitGrantDefinition = toJson_ImplicitGrantDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::AzureAD::Application`
 *
 * @cloudformationResource TF::AzureAD::Application
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnApplication extends cdk.CfnResource {
    /**
     * Create a new `TF::AzureAD::Application`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnApplication.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnApplicationProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrApplicationId = cdk.Token.asString(this.getAtt('ApplicationId'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrObjectId = cdk.Token.asString(this.getAtt('ObjectId'));
    }
}
exports.CfnApplication = CfnApplication;
_a = JSII_RTTI_SYMBOL_1;
CfnApplication[_a] = { fqn: "@cdk-cloudformation/tf-azuread-application.CfnApplication", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnApplication.CFN_RESOURCE_TYPE_NAME = "TF::AzureAD::Application";
//# sourceMappingURL=data:application/json;base64,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