#!/usr/bin/env python3
#
# Python ARM Radar Toolkit documentation build configuration file, created by
# sphinx-quickstart on Thu Jun 28 12:35:56 2018.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
import os
import re
import sys

extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.githubpages',
    'sphinx.ext.intersphinx',
    'sphinx.ext.mathjax',
    'sphinx.ext.viewcode',
    'IPython.sphinxext.ipython_directive',
    'IPython.sphinxext.ipython_console_highlighting',
    'matplotlib.sphinxext.plot_directive',
    'sphinx.ext.napoleon',
    'sphinx_copybutton',
    'sphinx_gallery.gen_gallery',
    'sphinx_gallery.load_style',
    'nbsphinx',
    'myst_nb',
    'ablog'
]

exclude_patterns = ['_build', '**.ipynb_checkpoints']

# only include examples if the BUILD_PYART_EXAMPLES env. variable is set
extensions.append('sphinx_gallery.gen_gallery')
sphinx_gallery_conf = {
    'examples_dirs': '../../examples',
    'gallery_dirs': 'examples'
}


# Configuration options for plot_directive. See:
# https://github.com/matplotlib/matplotlib/blob/f3ed922d935751e08494e5fb5311d3050a3b637b/lib/matplotlib/sphinxext/plot_directive.py#L81
plot_html_show_source_link = False
plot_html_show_formats = False
plot_formats = ['png']
plot_rcparams = {'savefig.bbox': 'tight'}

# Generate the API documentation when building
autoclass_content = "both"

autosummary_generate = True
autosummary_imported_members = True

# Otherwise, the Return parameter list looks different from the Parameters list
napoleon_use_rtype = False
# Otherwise, the Attributes parameter list looks different from the Parameters list
napoleon_use_ivar = True
napoleon_include_init_with_doc = False
napoleon_use_param = False

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = ['.rst', '.md', '.ipynb']

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = 'Py-ART'
copyright = '2013-2022, Py-ART developers'
author = 'Py-ART developers'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
import pyart
# The short X.Y version (including the .devXXXX suffix if present)
version = re.sub(r'^(\d+\.\d+)\.\d+(.*)', r'\1\2', pyart.__version__)
if 'dev' in version:
    # retain the .dev suffix, but clean it up
    version = re.sub(r'(\.dev\d*).*?$', r'\1', version)
else:
    # strip all other suffixes
    version = re.sub(r'^(\d+\.\d+).*?$', r'\1', version)
# The full version, including alpha/beta/rc tags.
release = pyart.__version__
# full Py-ART version in CI built docs
if 'CI' in os.environ and os.environ['CI'] == 'true':
    version = release
# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ["*.ipynb"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#

html_theme = 'pydata_sphinx_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    'google_analytics_id': 'G-JJEG3CV376',
    "github_url": "https://github.com/ARM-DOE/pyart",
    "twitter_url": "https://twitter.com/Py_ART",
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_css_files = ['pyart-theme.css']

html_js_files = ['doc_shared.js']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
html_sidebars = {
    'userguide': ['searchbox.html', 'sidebar-nav-bs.html'],
    'API': ['searchbox.html', 'sidebar-nav-bs.html'],
    'examples': ['searchbox.html', 'sidebar-nav-bs.html'],
    'notebook-gallery': ['searchbox.html', 'sidebar-nav-bs.html'],
    'blog': [
        'searchbox.html',
        'search-field.html',
        'sidebar-nav-bs.html',
        'postcard.html',
        'recentposts.html',
        'archives.html',
    ]
}

# Setup the blog portion
blog_baseurl = 'mgrover1.github.io/pyart/'
blog_title = 'PyART Blog'
blog_path = 'blog'
fontawesome_included = True
blog_post_pattern = 'blog_posts/*/*'
post_redirect_refresh = 1
post_auto_image = 1
post_auto_excerpt = 2

# Don't execute the jupyter notebooks
jupyter_execute_notebooks = 'off'

# Extra variables that will be available to the templates. Used to create the
# links to the Github repository sources and issues
html_context = {
    'doc_path': 'doc',
    'galleries': sphinx_gallery_conf['gallery_dirs'],
    'gallery_dir': dict(zip(sphinx_gallery_conf['gallery_dirs'],
                            sphinx_gallery_conf['examples_dirs'])),
    'api_dir': 'API/generated',
    'github_user': 'ARM-DOE',
    'github_repo': 'pyart',
    'github_version': 'main',
}

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'pyart'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'pyart.tex', 'Py-ART Documentation',
     'Contributors', 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'pyart', 'The Python ARM Radar Toolkit',
     [author], 1)
]

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {
    'python': ('https://docs.python.org/3/', None),
    'numpy': ('https://docs.scipy.org/doc/numpy/', None),
    'scipy': ('https://docs.scipy.org/doc/scipy/reference/', None),
    'pandas': ('https://pandas.pydata.org/pandas-docs/stable', None),
    'matplotlib': ('https://matplotlib.org', None),
    }
