"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Inspector2 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [inspector2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Inspector2 extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [inspector2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector2.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'inspector2';
        this.accessLevelList = {
            Write: [
                'AssociateMember',
                'CancelFindingsReport',
                'CreateFilter',
                'CreateFindingsReport',
                'DeleteFilter',
                'Disable',
                'DisableDelegatedAdminAccount',
                'DisassociateMember',
                'Enable',
                'EnableDelegatedAdminAccount',
                'UpdateConfiguration',
                'UpdateFilter',
                'UpdateOrganizationConfiguration'
            ],
            Read: [
                'BatchGetAccountStatus',
                'BatchGetFreeTrialInfo',
                'DescribeOrganizationConfiguration',
                'GetConfiguration',
                'GetDelegatedAdminAccount',
                'GetFindingsReportStatus',
                'GetMember',
                'ListTagsForResource'
            ],
            List: [
                'ListAccountPermissions',
                'ListCoverage',
                'ListCoverageStatistics',
                'ListDelegatedAdminAccounts',
                'ListFilters',
                'ListFindingAggregations',
                'ListFindings',
                'ListMembers',
                'ListUsageTotals'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate an account with an Amazon Inspector administrator account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_AssociateMember.html
     */
    toAssociateMember() {
        return this.to('AssociateMember');
    }
    /**
     * Grants permission to retrieve information about Amazon Inspector accounts for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchGetAccountStatus.html
     */
    toBatchGetAccountStatus() {
        return this.to('BatchGetAccountStatus');
    }
    /**
     * Grants permission to retrieve free trial period eligibility about Amazon Inspector accounts for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_BatchGetFreeTrialInfo.html
     */
    toBatchGetFreeTrialInfo() {
        return this.to('BatchGetFreeTrialInfo');
    }
    /**
     * Grants permission to cancel the generation of a findings report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_CancelFindingsReport.html
     */
    toCancelFindingsReport() {
        return this.to('CancelFindingsReport');
    }
    /**
     * Grants permission to create and define the settings for a findings filter
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_CreateFilter.html
     */
    toCreateFilter() {
        return this.to('CreateFilter');
    }
    /**
     * Grants permission to request the generation of a findings report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_CreateFindingsReport.html
     */
    toCreateFindingsReport() {
        return this.to('CreateFindingsReport');
    }
    /**
     * Grants permission to delete a findings filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DeleteFilter.html
     */
    toDeleteFilter() {
        return this.to('DeleteFilter');
    }
    /**
     * Grants permission to retrieve information about the Amazon Inspector configuration settings for an AWS organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DescribeOrganizationConfiguration.html
     */
    toDescribeOrganizationConfiguration() {
        return this.to('DescribeOrganizationConfiguration');
    }
    /**
     * Grants permission to disable an Amazon Inspector account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_Disable.html
     */
    toDisable() {
        return this.to('Disable');
    }
    /**
     * Grants permission to disable an account as the delegated Amazon Inspector administrator account for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DisableDelegatedAdminAccount.html
     */
    toDisableDelegatedAdminAccount() {
        return this.to('DisableDelegatedAdminAccount');
    }
    /**
     * Grants permission to an Amazon Inspector administrator account to disassociate from an Inspector member account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_DisassociateMember.html
     */
    toDisassociateMember() {
        return this.to('DisassociateMember');
    }
    /**
     * Grants permission to enable and specify the configuration settings for a new Amazon Inspector account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_Enable.html
     */
    toEnable() {
        return this.to('Enable');
    }
    /**
     * Grants permission to enable an account as the delegated Amazon Inspector administrator account for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_EnableDelegatedAdminAccount.html
     */
    toEnableDelegatedAdminAccount() {
        return this.to('EnableDelegatedAdminAccount');
    }
    /**
     * Grants permission to retrieve information about the Amazon Inspector configuration settings for an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetConfiguration.html
     */
    toGetConfiguration() {
        return this.to('GetConfiguration');
    }
    /**
     * Grants permission to retrieve information about the Amazon Inspector administrator account for an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetDelegatedAdminAccount.html
     */
    toGetDelegatedAdminAccount() {
        return this.to('GetDelegatedAdminAccount');
    }
    /**
     * Grants permission to retrieve status for a requested findings report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetFindingsReportStatus.html
     */
    toGetFindingsReportStatus() {
        return this.to('GetFindingsReportStatus');
    }
    /**
     * Grants permission to retrieve information about an account that's associated with an Amazon Inspector administrator account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html
     */
    toGetMember() {
        return this.to('GetMember');
    }
    /**
     * Grants permission to retrieve feature configuration permissions associated with an Amazon Inspector account within an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListAccountPermissions.html
     */
    toListAccountPermissions() {
        return this.to('ListAccountPermissions');
    }
    /**
     * Grants permission to retrieve the types of statistics Amazon Inspector can generate for resources Inspector monitors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListCoverage.html
     */
    toListCoverage() {
        return this.to('ListCoverage');
    }
    /**
     * Grants permission to retrieve statistical data and other information about the resources Amazon Inspector monitors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListCoverageStatistics.html
     */
    toListCoverageStatistics() {
        return this.to('ListCoverageStatistics');
    }
    /**
     * Grants permission to retrieve information about the delegated Amazon Inspector administrator account for an AWS organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListDelegatedAdminAccounts.html
     */
    toListDelegatedAdminAccounts() {
        return this.to('ListDelegatedAdminAccounts');
    }
    /**
     * Grants permission to retrieve information about all findings filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFilters.html
     */
    toListFilters() {
        return this.to('ListFilters');
    }
    /**
     * Grants permission to retrieve statistical data and other information about Amazon Inspector findings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFindingAggregations.html
     */
    toListFindingAggregations() {
        return this.to('ListFindingAggregations');
    }
    /**
     * Grants permission to retrieve a subset of information about one or more findings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListFindings.html
     */
    toListFindings() {
        return this.to('ListFindings');
    }
    /**
     * Grants permission to retrieve information about the Amazon Inspector member accounts that are associated with an Inspector administrator account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html
     */
    toListMembers() {
        return this.to('ListMembers');
    }
    /**
     * Grants permission to retrieve the tags for an Amazon Inspector resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to retrieve aggregated usage data for an account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListUsageTotals.html
     */
    toListUsageTotals() {
        return this.to('ListUsageTotals');
    }
    /**
     * Grants permission to add or update the tags for an Amazon Inspector resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from an Amazon Inspector resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update information about the Amazon Inspector configuration settings for an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_UpdateConfiguration.html
     */
    toUpdateConfiguration() {
        return this.to('UpdateConfiguration');
    }
    /**
     * Grants permission to update the settings for a findings filter
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_UpdateFilter.html
     */
    toUpdateFilter() {
        return this.to('UpdateFilter');
    }
    /**
     * Grants permission to update Amazon Inspector configuration settings for an AWS organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/v2/APIReference/API_UpdateOrganizationConfiguration.html
     */
    toUpdateOrganizationConfiguration() {
        return this.to('UpdateOrganizationConfiguration');
    }
    /**
     * Adds a resource of type Filter to the statement
     *
     * https://docs.aws.amazon.com/inspector/latest/user/what-is-inspector.html
     *
     * @param ownerId - Identifier for the ownerId.
     * @param filterId - Identifier for the filterId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFilter(ownerId, filterId, account, region, partition) {
        return this.on(`arn:${partition || Inspector2.defaultPartition}:inspector2:${region || '*'}:${account || '*'}:owner/${ownerId}/filter/${filterId}`);
    }
    /**
     * Adds a resource of type Finding to the statement
     *
     * https://docs.aws.amazon.com/inspector/latest/user/what-is-inspector.html
     *
     * @param findingId - Identifier for the findingId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onFinding(findingId, account, region, partition) {
        return this.on(`arn:${partition || Inspector2.defaultPartition}:inspector2:${region || '*'}:${account || '*'}:finding/${findingId}`);
    }
}
exports.Inspector2 = Inspector2;
_a = JSII_RTTI_SYMBOL_1;
Inspector2[_a] = { fqn: "iam-floyd.Inspector2", version: "0.468.0" };
//# sourceMappingURL=data:application/json;base64,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