import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [aws-marketplace-seller-reporting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacesellerreporting.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class AwsMarketplaceSellerReporting extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [aws-marketplace-seller-reporting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacesellerreporting.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to view a seller dashboard
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/dashboards.html#reports-accessing
     */
    toGetSellerDashboard(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type SellerDashboard to the statement
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/dashboards.html#reports-accessing
     *
     * @param catalog - Identifier for the catalog.
     * @param dashboardName - Identifier for the dashboardName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSellerDashboard(catalog: string, dashboardName: string, account?: string, partition?: string): this;
}
