import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [securitylake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsecuritylake.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Securitylake extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [securitylake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsecuritylake.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to enable any source type in any region for accounts that are either part of a trusted organization or standalone accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - kms:CreateGrant
     * - kms:DescribeKey
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateAwsLogSource.html
     */
    toCreateAwsLogSource(): this;
    /**
     * Grants permission to add a custom source name
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:CreateCrawler
     * - glue:CreateDatabase
     * - glue:CreateTable
     * - glue:StartCrawlerSchedule
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     * - lakeformation:GrantPermissions
     * - lakeformation:RegisterResource
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateCustomLogSource.html
     */
    toCreateCustomLogSource(): this;
    /**
     * Grants permission to create a new Security Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - lakeformation:GetDataLakeSettings
     * - lakeformation:PutDataLakeSettings
     * - lambda:CreateEventSourceMapping
     * - lambda:CreateFunction
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     * - s3:CreateBucket
     * - s3:ListBucket
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - sqs:CreateQueue
     * - sqs:GetQueueAttributes
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalake.html
     */
    toCreateDatalake(): this;
    /**
     * Grants permission to add to the configuration for automatically enabling Amazon Security Lake access for new organization accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalakeAutoEnable.html
     */
    toCreateDatalakeAutoEnable(): this;
    /**
     * Grants permission to designate the Amazon Security Lake administrator account for the organization
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - organizations:DescribeOrganization
     * - organizations:EnableAWSServiceAccess
     * - organizations:ListDelegatedAdministrators
     * - organizations:ListDelegatedServicesForAccount
     * - organizations:RegisterDelegatedAdministrator
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalakeDelegatedAdmin.html
     */
    toCreateDatalakeDelegatedAdmin(): this;
    /**
     * Grants permission to get instant notifications about exceptions by subscribing to the SNS topics for exception notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDatalakeExceptionsSubscription.html
     */
    toCreateDatalakeExceptionsSubscription(): this;
    /**
     * Grants permission to create a subscription permission for accounts that are already enabled
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     * - lakeformation:GrantPermissions
     * - lakeformation:ListPermissions
     * - lakeformation:RegisterResource
     * - lakeformation:RevokePermissions
     * - ram:GetResourceShareAssociations
     * - ram:GetResourceShares
     * - ram:UpdateResourceShare
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateSubscriber.html
     */
    toCreateSubscriber(): this;
    /**
     * Grants permission to create a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - s3:GetBucketNotification
     * - s3:PutBucketNotification
     * - sqs:CreateQueue
     * - sqs:DeleteQueue
     * - sqs:GetQueueAttributes
     * - sqs:GetQueueUrl
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateSubscriptionNotificationConfiguration.html
     */
    toCreateSubscriptionNotificationConfiguration(): this;
    /**
     * Grants permission to disable any source type in any region for accounts that are either part of a trusted organization or standalone accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteAwsLogSource.html
     */
    toDeleteAwsLogSource(): this;
    /**
     * Grants permission to remove a custom source name
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:StopCrawlerSchedule
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteCustomLogSource.html
     */
    toDeleteCustomLogSource(): this;
    /**
     * Grants permission to delete all Security Data Lakes
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedAdministrators
     * - organizations:ListDelegatedServicesForAccount
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalake.html
     */
    toDeleteDatalake(): this;
    /**
     * Grants permission to remove from the existing configuration the automatic enabling of Amazon Security Lake access for new organization accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalakeAutoEnable.html
     */
    toDeleteDatalakeAutoEnable(): this;
    /**
     * Grants permission to remove the Delegated Administrator account and disable Amazon Security Lake as a service for this organization
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DeregisterDelegatedAdministrator
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalakeDelegatedAdmin.html
     */
    toDeleteDatalakeDelegatedAdmin(): this;
    /**
     * Grants permission to unsubscribe from SNS topics for exception notifications. Also, removes the SNS exception notifications topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDatalakeExceptionsSubscription.html
     */
    toDeleteDatalakeExceptionsSubscription(): this;
    /**
     * Grants permission to delete the specified subscription permissions for accounts that are already enabled
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:DeleteApiDestination
     * - events:DeleteConnection
     * - events:DeleteRule
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     * - iam:DeleteRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:ListRolePolicies
     * - lakeformation:ListPermissions
     * - lakeformation:RevokePermissions
     * - sqs:DeleteQueue
     * - sqs:GetQueueUrl
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteSubscriber.html
     */
    toDeleteSubscriber(): this;
    /**
     * Grants permission to remove a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:DeleteApiDestination
     * - events:DeleteConnection
     * - events:DeleteRule
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     * - iam:DeleteRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:ListRolePolicies
     * - lakeformation:RevokePermissions
     * - sqs:DeleteQueue
     * - sqs:GetQueueUrl
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteSubscriptionNotificationConfiguration.html
     */
    toDeleteSubscriptionNotificationConfiguration(): this;
    /**
     * Grants permission to get information on the Security Data Lake
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalake.html
     */
    toGetDatalake(): this;
    /**
     * Grants permission to get an organization’s configuration setting for the automatic enabling of Amazon Security Lake access for new organization accounts
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeAutoEnable.html
     */
    toGetDatalakeAutoEnable(): this;
    /**
     * Grants permission to allow user to query what was set as the expiration period for the exception message
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeExceptionsExpiry.html
     */
    toGetDatalakeExceptionsExpiry(): this;
    /**
     * Grants permission to query the protocol and endpoint that were supplied when subscribing to the SNS topics for exception notifications
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeExceptionsSubscription.html
     */
    toGetDatalakeExceptionsSubscription(): this;
    /**
     * Grants permission to get a static snapshot of the Security Data Lake in the current region, including enabled accounts and log sources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDatalakeStatus.html
     */
    toGetDatalakeStatus(): this;
    /**
     * Grants permission to get subscription information for a subscription permission for accounts that are already enabled
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetSubscriber.html
     */
    toGetSubscriber(): this;
    /**
     * Grants permission to get information for a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetSubscriptionNotificationConfiguration.html
     */
    toGetSubscriptionNotificationConfiguration(): this;
    /**
     * Grants permission to get the list of all non-retry-able failures
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListDatalakeExceptions.html
     */
    toListDatalakeExceptions(): this;
    /**
     * Grants permission to show the estate view of enabled accounts with the enabled sources in the enabled regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListLogSources.html
     */
    toListLogSources(): this;
    /**
     * Grants permission to list all subscription permissions for accounts that are already enabled
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListSubscribers.html
     */
    toListSubscribers(): this;
    /**
     * Grants permission to update a Security Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - lakeformation:GetDataLakeSettings
     * - lakeformation:PutDataLakeSettings
     * - lambda:CreateEventSourceMapping
     * - lambda:CreateFunction
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     * - s3:CreateBucket
     * - s3:ListBucket
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - sqs:CreateQueue
     * - sqs:GetQueueAttributes
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDatalake.html
     */
    toUpdateDatalake(): this;
    /**
     * Grants permission to control the time-to-live (TTL) for the exception message to remain in service cache
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDatalakeExceptionsExpiry.html
     */
    toUpdateDatalakeExceptionsExpiry(): this;
    /**
     * Grants permission to update subscriptions to the SNS topics for exception notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDatalakeExceptionsSubscription.html
     */
    toUpdateDatalakeExceptionsSubscription(): this;
    /**
     * Grants permission to update subscription information for a subscription permission for accounts that are already enabled
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateSubscriber.html
     */
    toUpdateSubscriber(): this;
    /**
     * Grants permission to update a webhook invocation to notify a client when there is new data in the Data Lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - s3:CreateBucket
     * - s3:GetBucketNotification
     * - s3:ListBucket
     * - s3:PutBucketNotification
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - s3:PutLifecycleConfiguration
     * - sqs:CreateQueue
     * - sqs:DeleteQueue
     * - sqs:GetQueueAttributes
     * - sqs:GetQueueUrl
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateSubscriptionNotificationConfiguration.html
     */
    toUpdateSubscriptionNotificationConfiguration(): this;
    protected accessLevelList: AccessLevelList;
}
