import io

from .excel import update_excel
from .utils import find_static_resource_path


def serve_excel(
    column_names: list[str],
    api_endpoint: str,
    table_name: str = "INPUT_TABLE",
):
    template_path = find_static_resource_path(
        "attachment_server.excel", "template.xlsm"
    )
    return update_excel(
        openXML_file_path=str(template_path),
        column_names=column_names,
        api_endpoint=api_endpoint,
        table_name=table_name,
    )


if __name__ == "__main__":
    print(str(find_static_resource_path("attachment_server.excel", "template.xlsm")))
