import importlib.resources
from importlib.abc import Traversable


def find_static_resource_path(module: str, filename: str = "") -> Traversable:
    try:
        return importlib.resources.files(module).joinpath(filename)
    except Exception:
        raise ValueError(f"Cannot open {filename}")
