# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['abilian',
 'abilian.sbe',
 'abilian.sbe.apps',
 'abilian.sbe.apps.calendar',
 'abilian.sbe.apps.calendar.tests',
 'abilian.sbe.apps.communities',
 'abilian.sbe.apps.communities.tests',
 'abilian.sbe.apps.communities.views',
 'abilian.sbe.apps.documents',
 'abilian.sbe.apps.documents.cmis',
 'abilian.sbe.apps.documents.tests',
 'abilian.sbe.apps.documents.views',
 'abilian.sbe.apps.documents.webdav',
 'abilian.sbe.apps.forum',
 'abilian.sbe.apps.forum.tests',
 'abilian.sbe.apps.main',
 'abilian.sbe.apps.notifications',
 'abilian.sbe.apps.notifications.tasks',
 'abilian.sbe.apps.notifications.views',
 'abilian.sbe.apps.preferences',
 'abilian.sbe.apps.preferences.panels',
 'abilian.sbe.apps.social',
 'abilian.sbe.apps.social.tests',
 'abilian.sbe.apps.social.views',
 'abilian.sbe.apps.wall',
 'abilian.sbe.apps.wiki',
 'abilian.sbe.apps.wiki.tests']

package_data = \
{'': ['*'],
 'abilian.sbe': ['static/csv/*',
                 'static/fileicons/*',
                 'static/icons/*',
                 'static/images/*',
                 'static/img/*',
                 'static/js/*',
                 'static/less/*',
                 'static/less/modules/*',
                 'static/moment/*',
                 'static/pdfjs/*',
                 'static/pdfjs/cmaps/*',
                 'static/pdfjs/images/*',
                 'static/pdfjs/locale/*',
                 'static/pdfjs/locale/en-US/*',
                 'static/pdfjs/locale/fr/*',
                 'static/vendor/*',
                 'templates/*',
                 'translations/*',
                 'translations/es/LC_MESSAGES/messages.po',
                 'translations/fr/LC_MESSAGES/messages.po',
                 'translations/tr/LC_MESSAGES/messages.po',
                 'translations/zh/LC_MESSAGES/messages.po'],
 'abilian.sbe.apps.calendar': ['templates/calendar/*'],
 'abilian.sbe.apps.communities': ['templates/community/*'],
 'abilian.sbe.apps.communities.views': ['data/*'],
 'abilian.sbe.apps.documents': ['templates/cmis/*', 'templates/documents/*'],
 'abilian.sbe.apps.documents.tests': ['data/*', 'data/dummy_files/*'],
 'abilian.sbe.apps.forum': ['templates/forum/*', 'templates/forum/mail/*'],
 'abilian.sbe.apps.forum.tests': ['data/*'],
 'abilian.sbe.apps.notifications': ['templates/notifications/*'],
 'abilian.sbe.apps.preferences': ['templates/preferences/*'],
 'abilian.sbe.apps.social': ['templates/social/*', 'templates/social/mail/*'],
 'abilian.sbe.apps.wall': ['templates/wall/*'],
 'abilian.sbe.apps.wiki': ['data/*', 'templates/wiki/*']}

install_requires = \
['abilian-core>=0.11',
 'chardet',
 'flask-babel<2',
 'html2text>=2020.1.16,<2021.0.0',
 'langid>=1.1',
 'markdown>=3,<4',
 'openpyxl>=2.3.0,<3.0.0',
 'toolz',
 'validate_email',
 'werkzeug<1',
 'wtforms<2.2',
 'xlwt']

setup_kwargs = {
    'name': 'abilian-sbe',
    'version': '0.5.13',
    'description': 'Social Business platform, including: document management, wiki, forum, enterprise social networking, and more',
    'long_description': "About\n=====\n\nAbilian SBE (Social Business Engine) is a platform for social business applications, and more specifically collaborative / enterprise 2.0 business applications, such as enterprise social networks (ESN).\n\nAbilian SBE revolves around the concept of *communities*, which are collaborative spaces with services such as lightweight document management, discussions, wikis, user timelines, etc.\n\nIt is based on the `Abilian Core <http://abilian-core.readthedocs.org/en/latest/>`_ project which provide the basic services, on top of Flask and SQLAlchemy.\n\nAbilian SBE is used by several major customers in production, since mid 2013.\n\n.. image:: https://static.pepy.tech/badge/abilian-core\n   :target: https://pepy.tech/project/abilian-core\n\nScreenshots\n-----------\n\n.. image:: https://raw.githubusercontent.com/abilian/abilian-sbe/master/docs/images/screenshot-3.png\n\n.. image:: https://raw.githubusercontent.com/abilian/abilian-sbe/master/docs/images/screenshot-2.png\n\n.. image:: https://raw.githubusercontent.com/abilian/abilian-sbe/master/docs/images/screenshot-1.png\n\n\nInstall\n=======\n\nPrerequisites (native dependencies)\n-----------------------------------\n\n- Python 2.7, ``virtualenv``, ``pip``\n- `Redis <http://redis.io/>`_\n- Sqlite, or a postgresql database.\n- A few image manipulation libraries (``libpng``, ``libjpeg``...)\n- ``poppler-utils``, ``unoconv``, ``LibreOffice``, ``ImageMagick``.\n- `{Less} <http://lesscss.org/>`__ css pre-processor\n- A Java environment (JRE 1.7 for example). The `closure compiler\n  <https://developers.google.com/closure/compiler/>`_ is used for minifying\n  javascript files. You don't have to install the compiler yourself, but a Java\n  environment is required.\n\nGet a working application\n-------------------------\n\nThe following commands will create a virtualenv for the application,\ninstall a script named ``abilian_sbe``, launch development server and\nopen a setupwizard in your browser:\n\n.. code:: bash\n\n    $ virtualenv sbe\n    $ cd sbe; source bin/activate\n    $ pip install -U setuptools pip\n    $ pip install abilian-sbe\n    $ python -m abilian.sbe.app setup_sbe_app\n\nMAC OS + Homebrew\n-----------------\n\nYou will need to install the following packages using homebrew\n(**before** running ``pip install ...``):\n\n::\n\n    brew install python2.7 jpeg git libmagic poppler imagemagick\n\nRunning with gunicorn\n---------------------\n\n.. code:: bash\n\n    gunicorn 'abilian.sbe.app.create_app()'\n\n\nDeveloping\n==========\n\nBranching policy\n----------------\n\nWe currently have two branches:\n\n- `master` for stable version (0.3.x)\n- `develop` for next version (0.4.devx)\n\nTesting\n-------\n\nShort test\n~~~~~~~~~~\n\nMake sure all the dependencies are installed (cf. above), then run ``make\ntest``.\n\nWith coverage\n~~~~~~~~~~~~~\n\nRun ``make test-with-coverage``.\n\nFull test suite\n~~~~~~~~~~~~~~~\n\nInstall `tox <http://pypi.python.org/pypi/tox>`_. Run ``tox -e ALL``.\n\n2 environments are available:\n\n- ``py27``: uses in-memory sqlite\n- ``py27_postgres``: uses local postgresql server (you need to first create a\n   database, and user/password; tox uses environment variables\n   ``POSTGRES_HOST``, ``POSTGRES_PORT``, ``POSTGRES_DB``, ``POSTGRES_USER``,\n   ``POSTGRES_PASSWORD``)\n\nBuild Status\n------------\n\nThe project is under continuous integration with Travis and CircleCI:\n\n.. image:: https://travis-ci.org/abilian/abilian-sbe.svg?branch=master\n   :target: https://travis-ci.org/abilian/abilian-sbe\n\n.. image:: https://coveralls.io/repos/abilian/abilian-sbe/badge.svg?branch=master\n   :target: https://coveralls.io/r/abilian/abilian-sbe?branch=master\n\nLinks\n=====\n\n- `Discussion list (Google Groups) <https://groups.google.com/forum/#!foru      m/abilian-users>`_\n- `Documentation <http://docs.abilian.com/>`_\n- `GitHub repository <https://github.com/abilian/abilian-sbe>`_\n- `Corporate support <http://www.abilian.com>`_\n",
    'author': 'Abilian SAS',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/abilian/abilian-sbe',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4',
}


setup(**setup_kwargs)
