import pandas as pd
from cag.utils import config

from  cag.graph_framework.components.graph_creators.graph_creator_base import GraphCreatorBase
from datetime import datetime

from nodes.sample_datasource_nodes import ASampleNode


class SampleDatasourceGraphCreator(GraphCreatorBase):

    #### Constant NODE and Edge NAMES ####
    _DATASOURCE_NODE1_NAME = ASampleNode.__name__
    #_DATASOURCE_NODE2_NAME = ASampleNode2.__name__ ...

    _name = "Datasource X Graph Creator"
    _description = "Creates a graph based on a Datasource X"

    #### Define EdgeDefinitions ####
    _edge_definitions = [
        {
            'relation': GraphCreatorBase._BELONGS_TO_RELATION_NAME,
            'from_collections': [GraphCreatorBase._TEXT_NODE_NAME,
                                 _DATASOURCE_NODE1_NAME,
                                 GraphCreatorBase._IMAGE_NODE_NAME],
            'to_collections': [GraphCreatorBase._CORPUS_NODE_NAME]
        },
    ## Add more relations ..
    ]

    def init_graph(self):
        datasource_path = self.corpus_file_or_dir

        # Loop over your data and add them to the graph
        pass

    # Overrides methods from GraphCreatorBase
    def update_graph(self, from_date:datetime=None):

        pass
