# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

unet_ckpt_and_diffusers_mapping = (
    ("model.diffusion_model.time_embed.0.weight", "time_embedding.linear_1.weight"),
    ("model.diffusion_model.time_embed.0.bias", "time_embedding.linear_1.bias"),
    ("model.diffusion_model.time_embed.2.weight", "time_embedding.linear_2.weight"),
    ("model.diffusion_model.time_embed.2.bias", "time_embedding.linear_2.bias"),
    ("model.diffusion_model.input_blocks.0.0.weight", "conv_in.weight"),
    ("model.diffusion_model.input_blocks.0.0.bias", "conv_in.bias"),
    ("model.diffusion_model.out.0.weight", "conv_norm_out.weight"),
    ("model.diffusion_model.out.0.bias", "conv_norm_out.bias"),
    ("model.diffusion_model.out.2.weight", "conv_out.weight"),
    ("model.diffusion_model.out.2.bias", "conv_out.bias"),
    ("model.diffusion_model.input_blocks.1.0.in_layers.0.weight", "down_blocks.0.resnets.0.norm1.weight"),
    ("model.diffusion_model.input_blocks.1.0.in_layers.0.bias", "down_blocks.0.resnets.0.norm1.bias"),
    ("model.diffusion_model.input_blocks.1.0.in_layers.2.weight", "down_blocks.0.resnets.0.conv1.weight"),
    ("model.diffusion_model.input_blocks.1.0.in_layers.2.bias", "down_blocks.0.resnets.0.conv1.bias"),
    ("model.diffusion_model.input_blocks.1.0.emb_layers.1.weight", "down_blocks.0.resnets.0.time_emb_proj.weight"),
    ("model.diffusion_model.input_blocks.1.0.emb_layers.1.bias", "down_blocks.0.resnets.0.time_emb_proj.bias"),
    ("model.diffusion_model.input_blocks.1.0.out_layers.0.weight", "down_blocks.0.resnets.0.norm2.weight"),
    ("model.diffusion_model.input_blocks.1.0.out_layers.0.bias", "down_blocks.0.resnets.0.norm2.bias"),
    ("model.diffusion_model.input_blocks.1.0.out_layers.3.weight", "down_blocks.0.resnets.0.conv2.weight"),
    ("model.diffusion_model.input_blocks.1.0.out_layers.3.bias", "down_blocks.0.resnets.0.conv2.bias"),
    ("model.diffusion_model.input_blocks.1.1.norm.weight", "down_blocks.0.attentions.0.norm.weight"),
    ("model.diffusion_model.input_blocks.1.1.norm.bias", "down_blocks.0.attentions.0.norm.bias"),
    ("model.diffusion_model.input_blocks.1.1.proj_in.weight", "down_blocks.0.attentions.0.proj_in.weight"),
    ("model.diffusion_model.input_blocks.1.1.proj_in.bias", "down_blocks.0.attentions.0.proj_in.bias"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.attn1.to_q.weight", "down_blocks.0.attentions.0.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.attn1.to_k.weight", "down_blocks.0.attentions.0.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.attn1.to_v.weight", "down_blocks.0.attentions.0.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.attn1.to_out.0.weight", "down_blocks.0.attentions.0.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.attn1.to_out.0.bias", "down_blocks.0.attentions.0.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.ff.net.0.proj.weight", "down_blocks.0.attentions.0.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.ff.net.0.proj.bias", "down_blocks.0.attentions.0.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.ff.net.2.weight", "down_blocks.0.attentions.0.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.ff.net.2.bias", "down_blocks.0.attentions.0.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.attn2.to_q.weight", "down_blocks.0.attentions.0.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.attn2.to_k.weight", "down_blocks.0.attentions.0.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.attn2.to_v.weight", "down_blocks.0.attentions.0.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.attn2.to_out.0.weight", "down_blocks.0.attentions.0.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.attn2.to_out.0.bias", "down_blocks.0.attentions.0.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.norm1.weight", "down_blocks.0.attentions.0.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.norm1.bias", "down_blocks.0.attentions.0.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.norm2.weight", "down_blocks.0.attentions.0.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.norm2.bias", "down_blocks.0.attentions.0.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.norm3.weight", "down_blocks.0.attentions.0.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.input_blocks.1.1.transformer_blocks.0.norm3.bias", "down_blocks.0.attentions.0.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.input_blocks.1.1.proj_out.weight", "down_blocks.0.attentions.0.proj_out.weight"),
    ("model.diffusion_model.input_blocks.1.1.proj_out.bias", "down_blocks.0.attentions.0.proj_out.bias"),
    ("model.diffusion_model.input_blocks.2.0.in_layers.0.weight", "down_blocks.0.resnets.1.norm1.weight"),
    ("model.diffusion_model.input_blocks.2.0.in_layers.0.bias", "down_blocks.0.resnets.1.norm1.bias"),
    ("model.diffusion_model.input_blocks.2.0.in_layers.2.weight", "down_blocks.0.resnets.1.conv1.weight"),
    ("model.diffusion_model.input_blocks.2.0.in_layers.2.bias", "down_blocks.0.resnets.1.conv1.bias"),
    ("model.diffusion_model.input_blocks.2.0.emb_layers.1.weight", "down_blocks.0.resnets.1.time_emb_proj.weight"),
    ("model.diffusion_model.input_blocks.2.0.emb_layers.1.bias", "down_blocks.0.resnets.1.time_emb_proj.bias"),
    ("model.diffusion_model.input_blocks.2.0.out_layers.0.weight", "down_blocks.0.resnets.1.norm2.weight"),
    ("model.diffusion_model.input_blocks.2.0.out_layers.0.bias", "down_blocks.0.resnets.1.norm2.bias"),
    ("model.diffusion_model.input_blocks.2.0.out_layers.3.weight", "down_blocks.0.resnets.1.conv2.weight"),
    ("model.diffusion_model.input_blocks.2.0.out_layers.3.bias", "down_blocks.0.resnets.1.conv2.bias"),
    ("model.diffusion_model.input_blocks.2.1.norm.weight", "down_blocks.0.attentions.1.norm.weight"),
    ("model.diffusion_model.input_blocks.2.1.norm.bias", "down_blocks.0.attentions.1.norm.bias"),
    ("model.diffusion_model.input_blocks.2.1.proj_in.weight", "down_blocks.0.attentions.1.proj_in.weight"),
    ("model.diffusion_model.input_blocks.2.1.proj_in.bias", "down_blocks.0.attentions.1.proj_in.bias"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.attn1.to_q.weight", "down_blocks.0.attentions.1.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.attn1.to_k.weight", "down_blocks.0.attentions.1.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.attn1.to_v.weight", "down_blocks.0.attentions.1.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.attn1.to_out.0.weight", "down_blocks.0.attentions.1.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.attn1.to_out.0.bias", "down_blocks.0.attentions.1.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.ff.net.0.proj.weight", "down_blocks.0.attentions.1.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.ff.net.0.proj.bias", "down_blocks.0.attentions.1.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.ff.net.2.weight", "down_blocks.0.attentions.1.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.ff.net.2.bias", "down_blocks.0.attentions.1.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.attn2.to_q.weight", "down_blocks.0.attentions.1.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.attn2.to_k.weight", "down_blocks.0.attentions.1.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.attn2.to_v.weight", "down_blocks.0.attentions.1.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.attn2.to_out.0.weight", "down_blocks.0.attentions.1.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.attn2.to_out.0.bias", "down_blocks.0.attentions.1.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.norm1.weight", "down_blocks.0.attentions.1.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.norm1.bias", "down_blocks.0.attentions.1.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.norm2.weight", "down_blocks.0.attentions.1.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.norm2.bias", "down_blocks.0.attentions.1.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.norm3.weight", "down_blocks.0.attentions.1.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.input_blocks.2.1.transformer_blocks.0.norm3.bias", "down_blocks.0.attentions.1.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.input_blocks.2.1.proj_out.weight", "down_blocks.0.attentions.1.proj_out.weight"),
    ("model.diffusion_model.input_blocks.2.1.proj_out.bias", "down_blocks.0.attentions.1.proj_out.bias"),
    ("model.diffusion_model.input_blocks.3.0.op.weight", "down_blocks.0.downsamplers.0.conv.weight"),
    ("model.diffusion_model.input_blocks.3.0.op.bias", "down_blocks.0.downsamplers.0.conv.bias"),
    ("model.diffusion_model.input_blocks.4.0.in_layers.0.weight", "down_blocks.1.resnets.0.norm1.weight"),
    ("model.diffusion_model.input_blocks.4.0.in_layers.0.bias", "down_blocks.1.resnets.0.norm1.bias"),
    ("model.diffusion_model.input_blocks.4.0.in_layers.2.weight", "down_blocks.1.resnets.0.conv1.weight"),
    ("model.diffusion_model.input_blocks.4.0.in_layers.2.bias", "down_blocks.1.resnets.0.conv1.bias"),
    ("model.diffusion_model.input_blocks.4.0.emb_layers.1.weight", "down_blocks.1.resnets.0.time_emb_proj.weight"),
    ("model.diffusion_model.input_blocks.4.0.emb_layers.1.bias", "down_blocks.1.resnets.0.time_emb_proj.bias"),
    ("model.diffusion_model.input_blocks.4.0.out_layers.0.weight", "down_blocks.1.resnets.0.norm2.weight"),
    ("model.diffusion_model.input_blocks.4.0.out_layers.0.bias", "down_blocks.1.resnets.0.norm2.bias"),
    ("model.diffusion_model.input_blocks.4.0.out_layers.3.weight", "down_blocks.1.resnets.0.conv2.weight"),
    ("model.diffusion_model.input_blocks.4.0.out_layers.3.bias", "down_blocks.1.resnets.0.conv2.bias"),
    ("model.diffusion_model.input_blocks.4.0.skip_connection.weight", "down_blocks.1.resnets.0.conv_shortcut.weight"),
    ("model.diffusion_model.input_blocks.4.0.skip_connection.bias", "down_blocks.1.resnets.0.conv_shortcut.bias"),
    ("model.diffusion_model.input_blocks.4.1.norm.weight", "down_blocks.1.attentions.0.norm.weight"),
    ("model.diffusion_model.input_blocks.4.1.norm.bias", "down_blocks.1.attentions.0.norm.bias"),
    ("model.diffusion_model.input_blocks.4.1.proj_in.weight", "down_blocks.1.attentions.0.proj_in.weight"),
    ("model.diffusion_model.input_blocks.4.1.proj_in.bias", "down_blocks.1.attentions.0.proj_in.bias"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.attn1.to_q.weight", "down_blocks.1.attentions.0.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.attn1.to_k.weight", "down_blocks.1.attentions.0.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.attn1.to_v.weight", "down_blocks.1.attentions.0.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.attn1.to_out.0.weight", "down_blocks.1.attentions.0.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.attn1.to_out.0.bias", "down_blocks.1.attentions.0.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.ff.net.0.proj.weight", "down_blocks.1.attentions.0.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.ff.net.0.proj.bias", "down_blocks.1.attentions.0.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.ff.net.2.weight", "down_blocks.1.attentions.0.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.ff.net.2.bias", "down_blocks.1.attentions.0.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.attn2.to_q.weight", "down_blocks.1.attentions.0.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.attn2.to_k.weight", "down_blocks.1.attentions.0.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.attn2.to_v.weight", "down_blocks.1.attentions.0.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.attn2.to_out.0.weight", "down_blocks.1.attentions.0.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.attn2.to_out.0.bias", "down_blocks.1.attentions.0.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.norm1.weight", "down_blocks.1.attentions.0.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.norm1.bias", "down_blocks.1.attentions.0.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.norm2.weight", "down_blocks.1.attentions.0.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.norm2.bias", "down_blocks.1.attentions.0.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.norm3.weight", "down_blocks.1.attentions.0.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.input_blocks.4.1.transformer_blocks.0.norm3.bias", "down_blocks.1.attentions.0.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.input_blocks.4.1.proj_out.weight", "down_blocks.1.attentions.0.proj_out.weight"),
    ("model.diffusion_model.input_blocks.4.1.proj_out.bias", "down_blocks.1.attentions.0.proj_out.bias"),
    ("model.diffusion_model.input_blocks.5.0.in_layers.0.weight", "down_blocks.1.resnets.1.norm1.weight"),
    ("model.diffusion_model.input_blocks.5.0.in_layers.0.bias", "down_blocks.1.resnets.1.norm1.bias"),
    ("model.diffusion_model.input_blocks.5.0.in_layers.2.weight", "down_blocks.1.resnets.1.conv1.weight"),
    ("model.diffusion_model.input_blocks.5.0.in_layers.2.bias", "down_blocks.1.resnets.1.conv1.bias"),
    ("model.diffusion_model.input_blocks.5.0.emb_layers.1.weight", "down_blocks.1.resnets.1.time_emb_proj.weight"),
    ("model.diffusion_model.input_blocks.5.0.emb_layers.1.bias", "down_blocks.1.resnets.1.time_emb_proj.bias"),
    ("model.diffusion_model.input_blocks.5.0.out_layers.0.weight", "down_blocks.1.resnets.1.norm2.weight"),
    ("model.diffusion_model.input_blocks.5.0.out_layers.0.bias", "down_blocks.1.resnets.1.norm2.bias"),
    ("model.diffusion_model.input_blocks.5.0.out_layers.3.weight", "down_blocks.1.resnets.1.conv2.weight"),
    ("model.diffusion_model.input_blocks.5.0.out_layers.3.bias", "down_blocks.1.resnets.1.conv2.bias"),
    ("model.diffusion_model.input_blocks.5.1.norm.weight", "down_blocks.1.attentions.1.norm.weight"),
    ("model.diffusion_model.input_blocks.5.1.norm.bias", "down_blocks.1.attentions.1.norm.bias"),
    ("model.diffusion_model.input_blocks.5.1.proj_in.weight", "down_blocks.1.attentions.1.proj_in.weight"),
    ("model.diffusion_model.input_blocks.5.1.proj_in.bias", "down_blocks.1.attentions.1.proj_in.bias"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.attn1.to_q.weight", "down_blocks.1.attentions.1.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.attn1.to_k.weight", "down_blocks.1.attentions.1.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.attn1.to_v.weight", "down_blocks.1.attentions.1.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.attn1.to_out.0.weight", "down_blocks.1.attentions.1.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.attn1.to_out.0.bias", "down_blocks.1.attentions.1.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.ff.net.0.proj.weight", "down_blocks.1.attentions.1.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.ff.net.0.proj.bias", "down_blocks.1.attentions.1.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.ff.net.2.weight", "down_blocks.1.attentions.1.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.ff.net.2.bias", "down_blocks.1.attentions.1.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.attn2.to_q.weight", "down_blocks.1.attentions.1.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.attn2.to_k.weight", "down_blocks.1.attentions.1.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.attn2.to_v.weight", "down_blocks.1.attentions.1.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.attn2.to_out.0.weight", "down_blocks.1.attentions.1.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.attn2.to_out.0.bias", "down_blocks.1.attentions.1.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.norm1.weight", "down_blocks.1.attentions.1.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.norm1.bias", "down_blocks.1.attentions.1.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.norm2.weight", "down_blocks.1.attentions.1.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.norm2.bias", "down_blocks.1.attentions.1.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.norm3.weight", "down_blocks.1.attentions.1.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.input_blocks.5.1.transformer_blocks.0.norm3.bias", "down_blocks.1.attentions.1.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.input_blocks.5.1.proj_out.weight", "down_blocks.1.attentions.1.proj_out.weight"),
    ("model.diffusion_model.input_blocks.5.1.proj_out.bias", "down_blocks.1.attentions.1.proj_out.bias"),
    ("model.diffusion_model.input_blocks.6.0.op.weight", "down_blocks.1.downsamplers.0.conv.weight"),
    ("model.diffusion_model.input_blocks.6.0.op.bias", "down_blocks.1.downsamplers.0.conv.bias"),
    ("model.diffusion_model.input_blocks.7.0.in_layers.0.weight", "down_blocks.2.resnets.0.norm1.weight"),
    ("model.diffusion_model.input_blocks.7.0.in_layers.0.bias", "down_blocks.2.resnets.0.norm1.bias"),
    ("model.diffusion_model.input_blocks.7.0.in_layers.2.weight", "down_blocks.2.resnets.0.conv1.weight"),
    ("model.diffusion_model.input_blocks.7.0.in_layers.2.bias", "down_blocks.2.resnets.0.conv1.bias"),
    ("model.diffusion_model.input_blocks.7.0.emb_layers.1.weight", "down_blocks.2.resnets.0.time_emb_proj.weight"),
    ("model.diffusion_model.input_blocks.7.0.emb_layers.1.bias", "down_blocks.2.resnets.0.time_emb_proj.bias"),
    ("model.diffusion_model.input_blocks.7.0.out_layers.0.weight", "down_blocks.2.resnets.0.norm2.weight"),
    ("model.diffusion_model.input_blocks.7.0.out_layers.0.bias", "down_blocks.2.resnets.0.norm2.bias"),
    ("model.diffusion_model.input_blocks.7.0.out_layers.3.weight", "down_blocks.2.resnets.0.conv2.weight"),
    ("model.diffusion_model.input_blocks.7.0.out_layers.3.bias", "down_blocks.2.resnets.0.conv2.bias"),
    ("model.diffusion_model.input_blocks.7.0.skip_connection.weight", "down_blocks.2.resnets.0.conv_shortcut.weight"),
    ("model.diffusion_model.input_blocks.7.0.skip_connection.bias", "down_blocks.2.resnets.0.conv_shortcut.bias"),
    ("model.diffusion_model.input_blocks.7.1.norm.weight", "down_blocks.2.attentions.0.norm.weight"),
    ("model.diffusion_model.input_blocks.7.1.norm.bias", "down_blocks.2.attentions.0.norm.bias"),
    ("model.diffusion_model.input_blocks.7.1.proj_in.weight", "down_blocks.2.attentions.0.proj_in.weight"),
    ("model.diffusion_model.input_blocks.7.1.proj_in.bias", "down_blocks.2.attentions.0.proj_in.bias"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.attn1.to_q.weight", "down_blocks.2.attentions.0.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.attn1.to_k.weight", "down_blocks.2.attentions.0.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.attn1.to_v.weight", "down_blocks.2.attentions.0.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.attn1.to_out.0.weight", "down_blocks.2.attentions.0.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.attn1.to_out.0.bias", "down_blocks.2.attentions.0.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.ff.net.0.proj.weight", "down_blocks.2.attentions.0.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.ff.net.0.proj.bias", "down_blocks.2.attentions.0.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.ff.net.2.weight", "down_blocks.2.attentions.0.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.ff.net.2.bias", "down_blocks.2.attentions.0.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.attn2.to_q.weight", "down_blocks.2.attentions.0.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.attn2.to_k.weight", "down_blocks.2.attentions.0.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.attn2.to_v.weight", "down_blocks.2.attentions.0.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.attn2.to_out.0.weight", "down_blocks.2.attentions.0.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.attn2.to_out.0.bias", "down_blocks.2.attentions.0.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.norm1.weight", "down_blocks.2.attentions.0.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.norm1.bias", "down_blocks.2.attentions.0.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.norm2.weight", "down_blocks.2.attentions.0.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.norm2.bias", "down_blocks.2.attentions.0.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.norm3.weight", "down_blocks.2.attentions.0.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.input_blocks.7.1.transformer_blocks.0.norm3.bias", "down_blocks.2.attentions.0.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.input_blocks.7.1.proj_out.weight", "down_blocks.2.attentions.0.proj_out.weight"),
    ("model.diffusion_model.input_blocks.7.1.proj_out.bias", "down_blocks.2.attentions.0.proj_out.bias"),
    ("model.diffusion_model.input_blocks.8.0.in_layers.0.weight", "down_blocks.2.resnets.1.norm1.weight"),
    ("model.diffusion_model.input_blocks.8.0.in_layers.0.bias", "down_blocks.2.resnets.1.norm1.bias"),
    ("model.diffusion_model.input_blocks.8.0.in_layers.2.weight", "down_blocks.2.resnets.1.conv1.weight"),
    ("model.diffusion_model.input_blocks.8.0.in_layers.2.bias", "down_blocks.2.resnets.1.conv1.bias"),
    ("model.diffusion_model.input_blocks.8.0.emb_layers.1.weight", "down_blocks.2.resnets.1.time_emb_proj.weight"),
    ("model.diffusion_model.input_blocks.8.0.emb_layers.1.bias", "down_blocks.2.resnets.1.time_emb_proj.bias"),
    ("model.diffusion_model.input_blocks.8.0.out_layers.0.weight", "down_blocks.2.resnets.1.norm2.weight"),
    ("model.diffusion_model.input_blocks.8.0.out_layers.0.bias", "down_blocks.2.resnets.1.norm2.bias"),
    ("model.diffusion_model.input_blocks.8.0.out_layers.3.weight", "down_blocks.2.resnets.1.conv2.weight"),
    ("model.diffusion_model.input_blocks.8.0.out_layers.3.bias", "down_blocks.2.resnets.1.conv2.bias"),
    ("model.diffusion_model.input_blocks.8.1.norm.weight", "down_blocks.2.attentions.1.norm.weight"),
    ("model.diffusion_model.input_blocks.8.1.norm.bias", "down_blocks.2.attentions.1.norm.bias"),
    ("model.diffusion_model.input_blocks.8.1.proj_in.weight", "down_blocks.2.attentions.1.proj_in.weight"),
    ("model.diffusion_model.input_blocks.8.1.proj_in.bias", "down_blocks.2.attentions.1.proj_in.bias"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.attn1.to_q.weight", "down_blocks.2.attentions.1.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.attn1.to_k.weight", "down_blocks.2.attentions.1.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.attn1.to_v.weight", "down_blocks.2.attentions.1.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.attn1.to_out.0.weight", "down_blocks.2.attentions.1.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.attn1.to_out.0.bias", "down_blocks.2.attentions.1.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.ff.net.0.proj.weight", "down_blocks.2.attentions.1.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.ff.net.0.proj.bias", "down_blocks.2.attentions.1.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.ff.net.2.weight", "down_blocks.2.attentions.1.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.ff.net.2.bias", "down_blocks.2.attentions.1.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.attn2.to_q.weight", "down_blocks.2.attentions.1.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.attn2.to_k.weight", "down_blocks.2.attentions.1.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.attn2.to_v.weight", "down_blocks.2.attentions.1.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.attn2.to_out.0.weight", "down_blocks.2.attentions.1.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.attn2.to_out.0.bias", "down_blocks.2.attentions.1.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.norm1.weight", "down_blocks.2.attentions.1.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.norm1.bias", "down_blocks.2.attentions.1.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.norm2.weight", "down_blocks.2.attentions.1.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.norm2.bias", "down_blocks.2.attentions.1.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.norm3.weight", "down_blocks.2.attentions.1.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.input_blocks.8.1.transformer_blocks.0.norm3.bias", "down_blocks.2.attentions.1.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.input_blocks.8.1.proj_out.weight", "down_blocks.2.attentions.1.proj_out.weight"),
    ("model.diffusion_model.input_blocks.8.1.proj_out.bias", "down_blocks.2.attentions.1.proj_out.bias"),
    ("model.diffusion_model.input_blocks.9.0.op.weight", "down_blocks.2.downsamplers.0.conv.weight"),
    ("model.diffusion_model.input_blocks.9.0.op.bias", "down_blocks.2.downsamplers.0.conv.bias"),
    ("model.diffusion_model.input_blocks.10.0.in_layers.0.weight", "down_blocks.3.resnets.0.norm1.weight"),
    ("model.diffusion_model.input_blocks.10.0.in_layers.0.bias", "down_blocks.3.resnets.0.norm1.bias"),
    ("model.diffusion_model.input_blocks.10.0.in_layers.2.weight", "down_blocks.3.resnets.0.conv1.weight"),
    ("model.diffusion_model.input_blocks.10.0.in_layers.2.bias", "down_blocks.3.resnets.0.conv1.bias"),
    ("model.diffusion_model.input_blocks.10.0.emb_layers.1.weight", "down_blocks.3.resnets.0.time_emb_proj.weight"),
    ("model.diffusion_model.input_blocks.10.0.emb_layers.1.bias", "down_blocks.3.resnets.0.time_emb_proj.bias"),
    ("model.diffusion_model.input_blocks.10.0.out_layers.0.weight", "down_blocks.3.resnets.0.norm2.weight"),
    ("model.diffusion_model.input_blocks.10.0.out_layers.0.bias", "down_blocks.3.resnets.0.norm2.bias"),
    ("model.diffusion_model.input_blocks.10.0.out_layers.3.weight", "down_blocks.3.resnets.0.conv2.weight"),
    ("model.diffusion_model.input_blocks.10.0.out_layers.3.bias", "down_blocks.3.resnets.0.conv2.bias"),
    ("model.diffusion_model.input_blocks.11.0.in_layers.0.weight", "down_blocks.3.resnets.1.norm1.weight"),
    ("model.diffusion_model.input_blocks.11.0.in_layers.0.bias", "down_blocks.3.resnets.1.norm1.bias"),
    ("model.diffusion_model.input_blocks.11.0.in_layers.2.weight", "down_blocks.3.resnets.1.conv1.weight"),
    ("model.diffusion_model.input_blocks.11.0.in_layers.2.bias", "down_blocks.3.resnets.1.conv1.bias"),
    ("model.diffusion_model.input_blocks.11.0.emb_layers.1.weight", "down_blocks.3.resnets.1.time_emb_proj.weight"),
    ("model.diffusion_model.input_blocks.11.0.emb_layers.1.bias", "down_blocks.3.resnets.1.time_emb_proj.bias"),
    ("model.diffusion_model.input_blocks.11.0.out_layers.0.weight", "down_blocks.3.resnets.1.norm2.weight"),
    ("model.diffusion_model.input_blocks.11.0.out_layers.0.bias", "down_blocks.3.resnets.1.norm2.bias"),
    ("model.diffusion_model.input_blocks.11.0.out_layers.3.weight", "down_blocks.3.resnets.1.conv2.weight"),
    ("model.diffusion_model.input_blocks.11.0.out_layers.3.bias", "down_blocks.3.resnets.1.conv2.bias"),
    ("model.diffusion_model.middle_block.0.in_layers.0.weight", "mid_block.resnets.0.norm1.weight"),
    ("model.diffusion_model.middle_block.0.in_layers.0.bias", "mid_block.resnets.0.norm1.bias"),
    ("model.diffusion_model.middle_block.0.in_layers.2.weight", "mid_block.resnets.0.conv1.weight"),
    ("model.diffusion_model.middle_block.0.in_layers.2.bias", "mid_block.resnets.0.conv1.bias"),
    ("model.diffusion_model.middle_block.0.emb_layers.1.weight", "mid_block.resnets.0.time_emb_proj.weight"),
    ("model.diffusion_model.middle_block.0.emb_layers.1.bias", "mid_block.resnets.0.time_emb_proj.bias"),
    ("model.diffusion_model.middle_block.0.out_layers.0.weight", "mid_block.resnets.0.norm2.weight"),
    ("model.diffusion_model.middle_block.0.out_layers.0.bias", "mid_block.resnets.0.norm2.bias"),
    ("model.diffusion_model.middle_block.0.out_layers.3.weight", "mid_block.resnets.0.conv2.weight"),
    ("model.diffusion_model.middle_block.0.out_layers.3.bias", "mid_block.resnets.0.conv2.bias"),
    ("model.diffusion_model.middle_block.2.in_layers.0.weight", "mid_block.resnets.1.norm1.weight"),
    ("model.diffusion_model.middle_block.2.in_layers.0.bias", "mid_block.resnets.1.norm1.bias"),
    ("model.diffusion_model.middle_block.2.in_layers.2.weight", "mid_block.resnets.1.conv1.weight"),
    ("model.diffusion_model.middle_block.2.in_layers.2.bias", "mid_block.resnets.1.conv1.bias"),
    ("model.diffusion_model.middle_block.2.emb_layers.1.weight", "mid_block.resnets.1.time_emb_proj.weight"),
    ("model.diffusion_model.middle_block.2.emb_layers.1.bias", "mid_block.resnets.1.time_emb_proj.bias"),
    ("model.diffusion_model.middle_block.2.out_layers.0.weight", "mid_block.resnets.1.norm2.weight"),
    ("model.diffusion_model.middle_block.2.out_layers.0.bias", "mid_block.resnets.1.norm2.bias"),
    ("model.diffusion_model.middle_block.2.out_layers.3.weight", "mid_block.resnets.1.conv2.weight"),
    ("model.diffusion_model.middle_block.2.out_layers.3.bias", "mid_block.resnets.1.conv2.bias"),
    ("model.diffusion_model.middle_block.1.norm.weight", "mid_block.attentions.0.norm.weight"),
    ("model.diffusion_model.middle_block.1.norm.bias", "mid_block.attentions.0.norm.bias"),
    ("model.diffusion_model.middle_block.1.proj_in.weight", "mid_block.attentions.0.proj_in.weight"),
    ("model.diffusion_model.middle_block.1.proj_in.bias", "mid_block.attentions.0.proj_in.bias"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.attn1.to_q.weight", "mid_block.attentions.0.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.attn1.to_k.weight", "mid_block.attentions.0.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.attn1.to_v.weight", "mid_block.attentions.0.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.attn1.to_out.0.weight", "mid_block.attentions.0.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.attn1.to_out.0.bias", "mid_block.attentions.0.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.ff.net.0.proj.weight", "mid_block.attentions.0.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.ff.net.0.proj.bias", "mid_block.attentions.0.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.ff.net.2.weight", "mid_block.attentions.0.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.ff.net.2.bias", "mid_block.attentions.0.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.attn2.to_q.weight", "mid_block.attentions.0.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.attn2.to_k.weight", "mid_block.attentions.0.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.attn2.to_v.weight", "mid_block.attentions.0.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.attn2.to_out.0.weight", "mid_block.attentions.0.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.attn2.to_out.0.bias", "mid_block.attentions.0.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.norm1.weight", "mid_block.attentions.0.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.norm1.bias", "mid_block.attentions.0.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.norm2.weight", "mid_block.attentions.0.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.norm2.bias", "mid_block.attentions.0.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.norm3.weight", "mid_block.attentions.0.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.middle_block.1.transformer_blocks.0.norm3.bias", "mid_block.attentions.0.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.middle_block.1.proj_out.weight", "mid_block.attentions.0.proj_out.weight"),
    ("model.diffusion_model.middle_block.1.proj_out.bias", "mid_block.attentions.0.proj_out.bias"),
    ("model.diffusion_model.output_blocks.0.0.in_layers.0.weight", "up_blocks.0.resnets.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.0.0.in_layers.0.bias", "up_blocks.0.resnets.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.0.0.in_layers.2.weight", "up_blocks.0.resnets.0.conv1.weight"),
    ("model.diffusion_model.output_blocks.0.0.in_layers.2.bias", "up_blocks.0.resnets.0.conv1.bias"),
    ("model.diffusion_model.output_blocks.0.0.emb_layers.1.weight", "up_blocks.0.resnets.0.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.0.0.emb_layers.1.bias", "up_blocks.0.resnets.0.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.0.0.out_layers.0.weight", "up_blocks.0.resnets.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.0.0.out_layers.0.bias", "up_blocks.0.resnets.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.0.0.out_layers.3.weight", "up_blocks.0.resnets.0.conv2.weight"),
    ("model.diffusion_model.output_blocks.0.0.out_layers.3.bias", "up_blocks.0.resnets.0.conv2.bias"),
    ("model.diffusion_model.output_blocks.0.0.skip_connection.weight", "up_blocks.0.resnets.0.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.0.0.skip_connection.bias", "up_blocks.0.resnets.0.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.1.0.in_layers.0.weight", "up_blocks.0.resnets.1.norm1.weight"),
    ("model.diffusion_model.output_blocks.1.0.in_layers.0.bias", "up_blocks.0.resnets.1.norm1.bias"),
    ("model.diffusion_model.output_blocks.1.0.in_layers.2.weight", "up_blocks.0.resnets.1.conv1.weight"),
    ("model.diffusion_model.output_blocks.1.0.in_layers.2.bias", "up_blocks.0.resnets.1.conv1.bias"),
    ("model.diffusion_model.output_blocks.1.0.emb_layers.1.weight", "up_blocks.0.resnets.1.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.1.0.emb_layers.1.bias", "up_blocks.0.resnets.1.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.1.0.out_layers.0.weight", "up_blocks.0.resnets.1.norm2.weight"),
    ("model.diffusion_model.output_blocks.1.0.out_layers.0.bias", "up_blocks.0.resnets.1.norm2.bias"),
    ("model.diffusion_model.output_blocks.1.0.out_layers.3.weight", "up_blocks.0.resnets.1.conv2.weight"),
    ("model.diffusion_model.output_blocks.1.0.out_layers.3.bias", "up_blocks.0.resnets.1.conv2.bias"),
    ("model.diffusion_model.output_blocks.1.0.skip_connection.weight", "up_blocks.0.resnets.1.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.1.0.skip_connection.bias", "up_blocks.0.resnets.1.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.2.0.in_layers.0.weight", "up_blocks.0.resnets.2.norm1.weight"),
    ("model.diffusion_model.output_blocks.2.0.in_layers.0.bias", "up_blocks.0.resnets.2.norm1.bias"),
    ("model.diffusion_model.output_blocks.2.0.in_layers.2.weight", "up_blocks.0.resnets.2.conv1.weight"),
    ("model.diffusion_model.output_blocks.2.0.in_layers.2.bias", "up_blocks.0.resnets.2.conv1.bias"),
    ("model.diffusion_model.output_blocks.2.0.emb_layers.1.weight", "up_blocks.0.resnets.2.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.2.0.emb_layers.1.bias", "up_blocks.0.resnets.2.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.2.0.out_layers.0.weight", "up_blocks.0.resnets.2.norm2.weight"),
    ("model.diffusion_model.output_blocks.2.0.out_layers.0.bias", "up_blocks.0.resnets.2.norm2.bias"),
    ("model.diffusion_model.output_blocks.2.0.out_layers.3.weight", "up_blocks.0.resnets.2.conv2.weight"),
    ("model.diffusion_model.output_blocks.2.0.out_layers.3.bias", "up_blocks.0.resnets.2.conv2.bias"),
    ("model.diffusion_model.output_blocks.2.0.skip_connection.weight", "up_blocks.0.resnets.2.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.2.0.skip_connection.bias", "up_blocks.0.resnets.2.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.2.1.conv.weight", "up_blocks.0.upsamplers.0.conv.weight"),
    ("model.diffusion_model.output_blocks.2.1.conv.bias", "up_blocks.0.upsamplers.0.conv.bias"),
    ("model.diffusion_model.output_blocks.3.0.in_layers.0.weight", "up_blocks.1.resnets.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.3.0.in_layers.0.bias", "up_blocks.1.resnets.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.3.0.in_layers.2.weight", "up_blocks.1.resnets.0.conv1.weight"),
    ("model.diffusion_model.output_blocks.3.0.in_layers.2.bias", "up_blocks.1.resnets.0.conv1.bias"),
    ("model.diffusion_model.output_blocks.3.0.emb_layers.1.weight", "up_blocks.1.resnets.0.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.3.0.emb_layers.1.bias", "up_blocks.1.resnets.0.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.3.0.out_layers.0.weight", "up_blocks.1.resnets.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.3.0.out_layers.0.bias", "up_blocks.1.resnets.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.3.0.out_layers.3.weight", "up_blocks.1.resnets.0.conv2.weight"),
    ("model.diffusion_model.output_blocks.3.0.out_layers.3.bias", "up_blocks.1.resnets.0.conv2.bias"),
    ("model.diffusion_model.output_blocks.3.0.skip_connection.weight", "up_blocks.1.resnets.0.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.3.0.skip_connection.bias", "up_blocks.1.resnets.0.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.3.1.norm.weight", "up_blocks.1.attentions.0.norm.weight"),
    ("model.diffusion_model.output_blocks.3.1.norm.bias", "up_blocks.1.attentions.0.norm.bias"),
    ("model.diffusion_model.output_blocks.3.1.proj_in.weight", "up_blocks.1.attentions.0.proj_in.weight"),
    ("model.diffusion_model.output_blocks.3.1.proj_in.bias", "up_blocks.1.attentions.0.proj_in.bias"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.attn1.to_q.weight", "up_blocks.1.attentions.0.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.attn1.to_k.weight", "up_blocks.1.attentions.0.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.attn1.to_v.weight", "up_blocks.1.attentions.0.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.attn1.to_out.0.weight", "up_blocks.1.attentions.0.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.attn1.to_out.0.bias", "up_blocks.1.attentions.0.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.ff.net.0.proj.weight", "up_blocks.1.attentions.0.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.ff.net.0.proj.bias", "up_blocks.1.attentions.0.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.ff.net.2.weight", "up_blocks.1.attentions.0.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.ff.net.2.bias", "up_blocks.1.attentions.0.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.attn2.to_q.weight", "up_blocks.1.attentions.0.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.attn2.to_k.weight", "up_blocks.1.attentions.0.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.attn2.to_v.weight", "up_blocks.1.attentions.0.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.attn2.to_out.0.weight", "up_blocks.1.attentions.0.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.attn2.to_out.0.bias", "up_blocks.1.attentions.0.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.norm1.weight", "up_blocks.1.attentions.0.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.norm1.bias", "up_blocks.1.attentions.0.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.norm2.weight", "up_blocks.1.attentions.0.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.norm2.bias", "up_blocks.1.attentions.0.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.norm3.weight", "up_blocks.1.attentions.0.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.output_blocks.3.1.transformer_blocks.0.norm3.bias", "up_blocks.1.attentions.0.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.output_blocks.3.1.proj_out.weight", "up_blocks.1.attentions.0.proj_out.weight"),
    ("model.diffusion_model.output_blocks.3.1.proj_out.bias", "up_blocks.1.attentions.0.proj_out.bias"),
    ("model.diffusion_model.output_blocks.4.0.in_layers.0.weight", "up_blocks.1.resnets.1.norm1.weight"),
    ("model.diffusion_model.output_blocks.4.0.in_layers.0.bias", "up_blocks.1.resnets.1.norm1.bias"),
    ("model.diffusion_model.output_blocks.4.0.in_layers.2.weight", "up_blocks.1.resnets.1.conv1.weight"),
    ("model.diffusion_model.output_blocks.4.0.in_layers.2.bias", "up_blocks.1.resnets.1.conv1.bias"),
    ("model.diffusion_model.output_blocks.4.0.emb_layers.1.weight", "up_blocks.1.resnets.1.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.4.0.emb_layers.1.bias", "up_blocks.1.resnets.1.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.4.0.out_layers.0.weight", "up_blocks.1.resnets.1.norm2.weight"),
    ("model.diffusion_model.output_blocks.4.0.out_layers.0.bias", "up_blocks.1.resnets.1.norm2.bias"),
    ("model.diffusion_model.output_blocks.4.0.out_layers.3.weight", "up_blocks.1.resnets.1.conv2.weight"),
    ("model.diffusion_model.output_blocks.4.0.out_layers.3.bias", "up_blocks.1.resnets.1.conv2.bias"),
    ("model.diffusion_model.output_blocks.4.0.skip_connection.weight", "up_blocks.1.resnets.1.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.4.0.skip_connection.bias", "up_blocks.1.resnets.1.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.4.1.norm.weight", "up_blocks.1.attentions.1.norm.weight"),
    ("model.diffusion_model.output_blocks.4.1.norm.bias", "up_blocks.1.attentions.1.norm.bias"),
    ("model.diffusion_model.output_blocks.4.1.proj_in.weight", "up_blocks.1.attentions.1.proj_in.weight"),
    ("model.diffusion_model.output_blocks.4.1.proj_in.bias", "up_blocks.1.attentions.1.proj_in.bias"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.attn1.to_q.weight", "up_blocks.1.attentions.1.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.attn1.to_k.weight", "up_blocks.1.attentions.1.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.attn1.to_v.weight", "up_blocks.1.attentions.1.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.attn1.to_out.0.weight", "up_blocks.1.attentions.1.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.attn1.to_out.0.bias", "up_blocks.1.attentions.1.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.ff.net.0.proj.weight", "up_blocks.1.attentions.1.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.ff.net.0.proj.bias", "up_blocks.1.attentions.1.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.ff.net.2.weight", "up_blocks.1.attentions.1.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.ff.net.2.bias", "up_blocks.1.attentions.1.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.attn2.to_q.weight", "up_blocks.1.attentions.1.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.attn2.to_k.weight", "up_blocks.1.attentions.1.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.attn2.to_v.weight", "up_blocks.1.attentions.1.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.attn2.to_out.0.weight", "up_blocks.1.attentions.1.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.attn2.to_out.0.bias", "up_blocks.1.attentions.1.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.norm1.weight", "up_blocks.1.attentions.1.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.norm1.bias", "up_blocks.1.attentions.1.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.norm2.weight", "up_blocks.1.attentions.1.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.norm2.bias", "up_blocks.1.attentions.1.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.norm3.weight", "up_blocks.1.attentions.1.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.output_blocks.4.1.transformer_blocks.0.norm3.bias", "up_blocks.1.attentions.1.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.output_blocks.4.1.proj_out.weight", "up_blocks.1.attentions.1.proj_out.weight"),
    ("model.diffusion_model.output_blocks.4.1.proj_out.bias", "up_blocks.1.attentions.1.proj_out.bias"),
    ("model.diffusion_model.output_blocks.5.0.in_layers.0.weight", "up_blocks.1.resnets.2.norm1.weight"),
    ("model.diffusion_model.output_blocks.5.0.in_layers.0.bias", "up_blocks.1.resnets.2.norm1.bias"),
    ("model.diffusion_model.output_blocks.5.0.in_layers.2.weight", "up_blocks.1.resnets.2.conv1.weight"),
    ("model.diffusion_model.output_blocks.5.0.in_layers.2.bias", "up_blocks.1.resnets.2.conv1.bias"),
    ("model.diffusion_model.output_blocks.5.0.emb_layers.1.weight", "up_blocks.1.resnets.2.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.5.0.emb_layers.1.bias", "up_blocks.1.resnets.2.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.5.0.out_layers.0.weight", "up_blocks.1.resnets.2.norm2.weight"),
    ("model.diffusion_model.output_blocks.5.0.out_layers.0.bias", "up_blocks.1.resnets.2.norm2.bias"),
    ("model.diffusion_model.output_blocks.5.0.out_layers.3.weight", "up_blocks.1.resnets.2.conv2.weight"),
    ("model.diffusion_model.output_blocks.5.0.out_layers.3.bias", "up_blocks.1.resnets.2.conv2.bias"),
    ("model.diffusion_model.output_blocks.5.0.skip_connection.weight", "up_blocks.1.resnets.2.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.5.0.skip_connection.bias", "up_blocks.1.resnets.2.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.5.2.conv.weight", "up_blocks.1.upsamplers.0.conv.weight"),
    ("model.diffusion_model.output_blocks.5.2.conv.bias", "up_blocks.1.upsamplers.0.conv.bias"),
    ("model.diffusion_model.output_blocks.5.1.norm.weight", "up_blocks.1.attentions.2.norm.weight"),
    ("model.diffusion_model.output_blocks.5.1.norm.bias", "up_blocks.1.attentions.2.norm.bias"),
    ("model.diffusion_model.output_blocks.5.1.proj_in.weight", "up_blocks.1.attentions.2.proj_in.weight"),
    ("model.diffusion_model.output_blocks.5.1.proj_in.bias", "up_blocks.1.attentions.2.proj_in.bias"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.attn1.to_q.weight", "up_blocks.1.attentions.2.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.attn1.to_k.weight", "up_blocks.1.attentions.2.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.attn1.to_v.weight", "up_blocks.1.attentions.2.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.attn1.to_out.0.weight", "up_blocks.1.attentions.2.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.attn1.to_out.0.bias", "up_blocks.1.attentions.2.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.ff.net.0.proj.weight", "up_blocks.1.attentions.2.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.ff.net.0.proj.bias", "up_blocks.1.attentions.2.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.ff.net.2.weight", "up_blocks.1.attentions.2.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.ff.net.2.bias", "up_blocks.1.attentions.2.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.attn2.to_q.weight", "up_blocks.1.attentions.2.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.attn2.to_k.weight", "up_blocks.1.attentions.2.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.attn2.to_v.weight", "up_blocks.1.attentions.2.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.attn2.to_out.0.weight", "up_blocks.1.attentions.2.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.attn2.to_out.0.bias", "up_blocks.1.attentions.2.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.norm1.weight", "up_blocks.1.attentions.2.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.norm1.bias", "up_blocks.1.attentions.2.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.norm2.weight", "up_blocks.1.attentions.2.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.norm2.bias", "up_blocks.1.attentions.2.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.norm3.weight", "up_blocks.1.attentions.2.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.output_blocks.5.1.transformer_blocks.0.norm3.bias", "up_blocks.1.attentions.2.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.output_blocks.5.1.proj_out.weight", "up_blocks.1.attentions.2.proj_out.weight"),
    ("model.diffusion_model.output_blocks.5.1.proj_out.bias", "up_blocks.1.attentions.2.proj_out.bias"),
    ("model.diffusion_model.output_blocks.6.0.in_layers.0.weight", "up_blocks.2.resnets.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.6.0.in_layers.0.bias", "up_blocks.2.resnets.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.6.0.in_layers.2.weight", "up_blocks.2.resnets.0.conv1.weight"),
    ("model.diffusion_model.output_blocks.6.0.in_layers.2.bias", "up_blocks.2.resnets.0.conv1.bias"),
    ("model.diffusion_model.output_blocks.6.0.emb_layers.1.weight", "up_blocks.2.resnets.0.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.6.0.emb_layers.1.bias", "up_blocks.2.resnets.0.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.6.0.out_layers.0.weight", "up_blocks.2.resnets.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.6.0.out_layers.0.bias", "up_blocks.2.resnets.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.6.0.out_layers.3.weight", "up_blocks.2.resnets.0.conv2.weight"),
    ("model.diffusion_model.output_blocks.6.0.out_layers.3.bias", "up_blocks.2.resnets.0.conv2.bias"),
    ("model.diffusion_model.output_blocks.6.0.skip_connection.weight", "up_blocks.2.resnets.0.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.6.0.skip_connection.bias", "up_blocks.2.resnets.0.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.6.1.norm.weight", "up_blocks.2.attentions.0.norm.weight"),
    ("model.diffusion_model.output_blocks.6.1.norm.bias", "up_blocks.2.attentions.0.norm.bias"),
    ("model.diffusion_model.output_blocks.6.1.proj_in.weight", "up_blocks.2.attentions.0.proj_in.weight"),
    ("model.diffusion_model.output_blocks.6.1.proj_in.bias", "up_blocks.2.attentions.0.proj_in.bias"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.attn1.to_q.weight", "up_blocks.2.attentions.0.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.attn1.to_k.weight", "up_blocks.2.attentions.0.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.attn1.to_v.weight", "up_blocks.2.attentions.0.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.attn1.to_out.0.weight", "up_blocks.2.attentions.0.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.attn1.to_out.0.bias", "up_blocks.2.attentions.0.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.ff.net.0.proj.weight", "up_blocks.2.attentions.0.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.ff.net.0.proj.bias", "up_blocks.2.attentions.0.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.ff.net.2.weight", "up_blocks.2.attentions.0.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.ff.net.2.bias", "up_blocks.2.attentions.0.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.attn2.to_q.weight", "up_blocks.2.attentions.0.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.attn2.to_k.weight", "up_blocks.2.attentions.0.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.attn2.to_v.weight", "up_blocks.2.attentions.0.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.attn2.to_out.0.weight", "up_blocks.2.attentions.0.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.attn2.to_out.0.bias", "up_blocks.2.attentions.0.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.norm1.weight", "up_blocks.2.attentions.0.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.norm1.bias", "up_blocks.2.attentions.0.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.norm2.weight", "up_blocks.2.attentions.0.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.norm2.bias", "up_blocks.2.attentions.0.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.norm3.weight", "up_blocks.2.attentions.0.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.output_blocks.6.1.transformer_blocks.0.norm3.bias", "up_blocks.2.attentions.0.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.output_blocks.6.1.proj_out.weight", "up_blocks.2.attentions.0.proj_out.weight"),
    ("model.diffusion_model.output_blocks.6.1.proj_out.bias", "up_blocks.2.attentions.0.proj_out.bias"),
    ("model.diffusion_model.output_blocks.7.0.in_layers.0.weight", "up_blocks.2.resnets.1.norm1.weight"),
    ("model.diffusion_model.output_blocks.7.0.in_layers.0.bias", "up_blocks.2.resnets.1.norm1.bias"),
    ("model.diffusion_model.output_blocks.7.0.in_layers.2.weight", "up_blocks.2.resnets.1.conv1.weight"),
    ("model.diffusion_model.output_blocks.7.0.in_layers.2.bias", "up_blocks.2.resnets.1.conv1.bias"),
    ("model.diffusion_model.output_blocks.7.0.emb_layers.1.weight", "up_blocks.2.resnets.1.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.7.0.emb_layers.1.bias", "up_blocks.2.resnets.1.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.7.0.out_layers.0.weight", "up_blocks.2.resnets.1.norm2.weight"),
    ("model.diffusion_model.output_blocks.7.0.out_layers.0.bias", "up_blocks.2.resnets.1.norm2.bias"),
    ("model.diffusion_model.output_blocks.7.0.out_layers.3.weight", "up_blocks.2.resnets.1.conv2.weight"),
    ("model.diffusion_model.output_blocks.7.0.out_layers.3.bias", "up_blocks.2.resnets.1.conv2.bias"),
    ("model.diffusion_model.output_blocks.7.0.skip_connection.weight", "up_blocks.2.resnets.1.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.7.0.skip_connection.bias", "up_blocks.2.resnets.1.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.7.1.norm.weight", "up_blocks.2.attentions.1.norm.weight"),
    ("model.diffusion_model.output_blocks.7.1.norm.bias", "up_blocks.2.attentions.1.norm.bias"),
    ("model.diffusion_model.output_blocks.7.1.proj_in.weight", "up_blocks.2.attentions.1.proj_in.weight"),
    ("model.diffusion_model.output_blocks.7.1.proj_in.bias", "up_blocks.2.attentions.1.proj_in.bias"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.attn1.to_q.weight", "up_blocks.2.attentions.1.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.attn1.to_k.weight", "up_blocks.2.attentions.1.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.attn1.to_v.weight", "up_blocks.2.attentions.1.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.attn1.to_out.0.weight", "up_blocks.2.attentions.1.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.attn1.to_out.0.bias", "up_blocks.2.attentions.1.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.ff.net.0.proj.weight", "up_blocks.2.attentions.1.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.ff.net.0.proj.bias", "up_blocks.2.attentions.1.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.ff.net.2.weight", "up_blocks.2.attentions.1.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.ff.net.2.bias", "up_blocks.2.attentions.1.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.attn2.to_q.weight", "up_blocks.2.attentions.1.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.attn2.to_k.weight", "up_blocks.2.attentions.1.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.attn2.to_v.weight", "up_blocks.2.attentions.1.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.attn2.to_out.0.weight", "up_blocks.2.attentions.1.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.attn2.to_out.0.bias", "up_blocks.2.attentions.1.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.norm1.weight", "up_blocks.2.attentions.1.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.norm1.bias", "up_blocks.2.attentions.1.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.norm2.weight", "up_blocks.2.attentions.1.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.norm2.bias", "up_blocks.2.attentions.1.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.norm3.weight", "up_blocks.2.attentions.1.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.output_blocks.7.1.transformer_blocks.0.norm3.bias", "up_blocks.2.attentions.1.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.output_blocks.7.1.proj_out.weight", "up_blocks.2.attentions.1.proj_out.weight"),
    ("model.diffusion_model.output_blocks.7.1.proj_out.bias", "up_blocks.2.attentions.1.proj_out.bias"),
    ("model.diffusion_model.output_blocks.8.0.in_layers.0.weight", "up_blocks.2.resnets.2.norm1.weight"),
    ("model.diffusion_model.output_blocks.8.0.in_layers.0.bias", "up_blocks.2.resnets.2.norm1.bias"),
    ("model.diffusion_model.output_blocks.8.0.in_layers.2.weight", "up_blocks.2.resnets.2.conv1.weight"),
    ("model.diffusion_model.output_blocks.8.0.in_layers.2.bias", "up_blocks.2.resnets.2.conv1.bias"),
    ("model.diffusion_model.output_blocks.8.0.emb_layers.1.weight", "up_blocks.2.resnets.2.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.8.0.emb_layers.1.bias", "up_blocks.2.resnets.2.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.8.0.out_layers.0.weight", "up_blocks.2.resnets.2.norm2.weight"),
    ("model.diffusion_model.output_blocks.8.0.out_layers.0.bias", "up_blocks.2.resnets.2.norm2.bias"),
    ("model.diffusion_model.output_blocks.8.0.out_layers.3.weight", "up_blocks.2.resnets.2.conv2.weight"),
    ("model.diffusion_model.output_blocks.8.0.out_layers.3.bias", "up_blocks.2.resnets.2.conv2.bias"),
    ("model.diffusion_model.output_blocks.8.0.skip_connection.weight", "up_blocks.2.resnets.2.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.8.0.skip_connection.bias", "up_blocks.2.resnets.2.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.8.2.conv.weight", "up_blocks.2.upsamplers.0.conv.weight"),
    ("model.diffusion_model.output_blocks.8.2.conv.bias", "up_blocks.2.upsamplers.0.conv.bias"),
    ("model.diffusion_model.output_blocks.8.1.norm.weight", "up_blocks.2.attentions.2.norm.weight"),
    ("model.diffusion_model.output_blocks.8.1.norm.bias", "up_blocks.2.attentions.2.norm.bias"),
    ("model.diffusion_model.output_blocks.8.1.proj_in.weight", "up_blocks.2.attentions.2.proj_in.weight"),
    ("model.diffusion_model.output_blocks.8.1.proj_in.bias", "up_blocks.2.attentions.2.proj_in.bias"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.attn1.to_q.weight", "up_blocks.2.attentions.2.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.attn1.to_k.weight", "up_blocks.2.attentions.2.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.attn1.to_v.weight", "up_blocks.2.attentions.2.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.attn1.to_out.0.weight", "up_blocks.2.attentions.2.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.attn1.to_out.0.bias", "up_blocks.2.attentions.2.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.ff.net.0.proj.weight", "up_blocks.2.attentions.2.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.ff.net.0.proj.bias", "up_blocks.2.attentions.2.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.ff.net.2.weight", "up_blocks.2.attentions.2.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.ff.net.2.bias", "up_blocks.2.attentions.2.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.attn2.to_q.weight", "up_blocks.2.attentions.2.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.attn2.to_k.weight", "up_blocks.2.attentions.2.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.attn2.to_v.weight", "up_blocks.2.attentions.2.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.attn2.to_out.0.weight", "up_blocks.2.attentions.2.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.attn2.to_out.0.bias", "up_blocks.2.attentions.2.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.norm1.weight", "up_blocks.2.attentions.2.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.norm1.bias", "up_blocks.2.attentions.2.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.norm2.weight", "up_blocks.2.attentions.2.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.norm2.bias", "up_blocks.2.attentions.2.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.norm3.weight", "up_blocks.2.attentions.2.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.output_blocks.8.1.transformer_blocks.0.norm3.bias", "up_blocks.2.attentions.2.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.output_blocks.8.1.proj_out.weight", "up_blocks.2.attentions.2.proj_out.weight"),
    ("model.diffusion_model.output_blocks.8.1.proj_out.bias", "up_blocks.2.attentions.2.proj_out.bias"),
    ("model.diffusion_model.output_blocks.9.0.in_layers.0.weight", "up_blocks.3.resnets.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.9.0.in_layers.0.bias", "up_blocks.3.resnets.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.9.0.in_layers.2.weight", "up_blocks.3.resnets.0.conv1.weight"),
    ("model.diffusion_model.output_blocks.9.0.in_layers.2.bias", "up_blocks.3.resnets.0.conv1.bias"),
    ("model.diffusion_model.output_blocks.9.0.emb_layers.1.weight", "up_blocks.3.resnets.0.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.9.0.emb_layers.1.bias", "up_blocks.3.resnets.0.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.9.0.out_layers.0.weight", "up_blocks.3.resnets.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.9.0.out_layers.0.bias", "up_blocks.3.resnets.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.9.0.out_layers.3.weight", "up_blocks.3.resnets.0.conv2.weight"),
    ("model.diffusion_model.output_blocks.9.0.out_layers.3.bias", "up_blocks.3.resnets.0.conv2.bias"),
    ("model.diffusion_model.output_blocks.9.0.skip_connection.weight", "up_blocks.3.resnets.0.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.9.0.skip_connection.bias", "up_blocks.3.resnets.0.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.9.1.norm.weight", "up_blocks.3.attentions.0.norm.weight"),
    ("model.diffusion_model.output_blocks.9.1.norm.bias", "up_blocks.3.attentions.0.norm.bias"),
    ("model.diffusion_model.output_blocks.9.1.proj_in.weight", "up_blocks.3.attentions.0.proj_in.weight"),
    ("model.diffusion_model.output_blocks.9.1.proj_in.bias", "up_blocks.3.attentions.0.proj_in.bias"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.attn1.to_q.weight", "up_blocks.3.attentions.0.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.attn1.to_k.weight", "up_blocks.3.attentions.0.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.attn1.to_v.weight", "up_blocks.3.attentions.0.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.attn1.to_out.0.weight", "up_blocks.3.attentions.0.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.attn1.to_out.0.bias", "up_blocks.3.attentions.0.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.ff.net.0.proj.weight", "up_blocks.3.attentions.0.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.ff.net.0.proj.bias", "up_blocks.3.attentions.0.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.ff.net.2.weight", "up_blocks.3.attentions.0.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.ff.net.2.bias", "up_blocks.3.attentions.0.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.attn2.to_q.weight", "up_blocks.3.attentions.0.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.attn2.to_k.weight", "up_blocks.3.attentions.0.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.attn2.to_v.weight", "up_blocks.3.attentions.0.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.attn2.to_out.0.weight", "up_blocks.3.attentions.0.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.attn2.to_out.0.bias", "up_blocks.3.attentions.0.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.norm1.weight", "up_blocks.3.attentions.0.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.norm1.bias", "up_blocks.3.attentions.0.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.norm2.weight", "up_blocks.3.attentions.0.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.norm2.bias", "up_blocks.3.attentions.0.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.norm3.weight", "up_blocks.3.attentions.0.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.output_blocks.9.1.transformer_blocks.0.norm3.bias", "up_blocks.3.attentions.0.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.output_blocks.9.1.proj_out.weight", "up_blocks.3.attentions.0.proj_out.weight"),
    ("model.diffusion_model.output_blocks.9.1.proj_out.bias", "up_blocks.3.attentions.0.proj_out.bias"),
    ("model.diffusion_model.output_blocks.10.0.in_layers.0.weight", "up_blocks.3.resnets.1.norm1.weight"),
    ("model.diffusion_model.output_blocks.10.0.in_layers.0.bias", "up_blocks.3.resnets.1.norm1.bias"),
    ("model.diffusion_model.output_blocks.10.0.in_layers.2.weight", "up_blocks.3.resnets.1.conv1.weight"),
    ("model.diffusion_model.output_blocks.10.0.in_layers.2.bias", "up_blocks.3.resnets.1.conv1.bias"),
    ("model.diffusion_model.output_blocks.10.0.emb_layers.1.weight", "up_blocks.3.resnets.1.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.10.0.emb_layers.1.bias", "up_blocks.3.resnets.1.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.10.0.out_layers.0.weight", "up_blocks.3.resnets.1.norm2.weight"),
    ("model.diffusion_model.output_blocks.10.0.out_layers.0.bias", "up_blocks.3.resnets.1.norm2.bias"),
    ("model.diffusion_model.output_blocks.10.0.out_layers.3.weight", "up_blocks.3.resnets.1.conv2.weight"),
    ("model.diffusion_model.output_blocks.10.0.out_layers.3.bias", "up_blocks.3.resnets.1.conv2.bias"),
    ("model.diffusion_model.output_blocks.10.0.skip_connection.weight", "up_blocks.3.resnets.1.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.10.0.skip_connection.bias", "up_blocks.3.resnets.1.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.10.1.norm.weight", "up_blocks.3.attentions.1.norm.weight"),
    ("model.diffusion_model.output_blocks.10.1.norm.bias", "up_blocks.3.attentions.1.norm.bias"),
    ("model.diffusion_model.output_blocks.10.1.proj_in.weight", "up_blocks.3.attentions.1.proj_in.weight"),
    ("model.diffusion_model.output_blocks.10.1.proj_in.bias", "up_blocks.3.attentions.1.proj_in.bias"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.attn1.to_q.weight", "up_blocks.3.attentions.1.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.attn1.to_k.weight", "up_blocks.3.attentions.1.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.attn1.to_v.weight", "up_blocks.3.attentions.1.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.attn1.to_out.0.weight", "up_blocks.3.attentions.1.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.attn1.to_out.0.bias", "up_blocks.3.attentions.1.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.ff.net.0.proj.weight", "up_blocks.3.attentions.1.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.ff.net.0.proj.bias", "up_blocks.3.attentions.1.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.ff.net.2.weight", "up_blocks.3.attentions.1.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.ff.net.2.bias", "up_blocks.3.attentions.1.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.attn2.to_q.weight", "up_blocks.3.attentions.1.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.attn2.to_k.weight", "up_blocks.3.attentions.1.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.attn2.to_v.weight", "up_blocks.3.attentions.1.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.attn2.to_out.0.weight", "up_blocks.3.attentions.1.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.attn2.to_out.0.bias", "up_blocks.3.attentions.1.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.norm1.weight", "up_blocks.3.attentions.1.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.norm1.bias", "up_blocks.3.attentions.1.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.norm2.weight", "up_blocks.3.attentions.1.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.norm2.bias", "up_blocks.3.attentions.1.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.norm3.weight", "up_blocks.3.attentions.1.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.output_blocks.10.1.transformer_blocks.0.norm3.bias", "up_blocks.3.attentions.1.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.output_blocks.10.1.proj_out.weight", "up_blocks.3.attentions.1.proj_out.weight"),
    ("model.diffusion_model.output_blocks.10.1.proj_out.bias", "up_blocks.3.attentions.1.proj_out.bias"),
    ("model.diffusion_model.output_blocks.11.0.in_layers.0.weight", "up_blocks.3.resnets.2.norm1.weight"),
    ("model.diffusion_model.output_blocks.11.0.in_layers.0.bias", "up_blocks.3.resnets.2.norm1.bias"),
    ("model.diffusion_model.output_blocks.11.0.in_layers.2.weight", "up_blocks.3.resnets.2.conv1.weight"),
    ("model.diffusion_model.output_blocks.11.0.in_layers.2.bias", "up_blocks.3.resnets.2.conv1.bias"),
    ("model.diffusion_model.output_blocks.11.0.emb_layers.1.weight", "up_blocks.3.resnets.2.time_emb_proj.weight"),
    ("model.diffusion_model.output_blocks.11.0.emb_layers.1.bias", "up_blocks.3.resnets.2.time_emb_proj.bias"),
    ("model.diffusion_model.output_blocks.11.0.out_layers.0.weight", "up_blocks.3.resnets.2.norm2.weight"),
    ("model.diffusion_model.output_blocks.11.0.out_layers.0.bias", "up_blocks.3.resnets.2.norm2.bias"),
    ("model.diffusion_model.output_blocks.11.0.out_layers.3.weight", "up_blocks.3.resnets.2.conv2.weight"),
    ("model.diffusion_model.output_blocks.11.0.out_layers.3.bias", "up_blocks.3.resnets.2.conv2.bias"),
    ("model.diffusion_model.output_blocks.11.0.skip_connection.weight", "up_blocks.3.resnets.2.conv_shortcut.weight"),
    ("model.diffusion_model.output_blocks.11.0.skip_connection.bias", "up_blocks.3.resnets.2.conv_shortcut.bias"),
    ("model.diffusion_model.output_blocks.11.1.norm.weight", "up_blocks.3.attentions.2.norm.weight"),
    ("model.diffusion_model.output_blocks.11.1.norm.bias", "up_blocks.3.attentions.2.norm.bias"),
    ("model.diffusion_model.output_blocks.11.1.proj_in.weight", "up_blocks.3.attentions.2.proj_in.weight"),
    ("model.diffusion_model.output_blocks.11.1.proj_in.bias", "up_blocks.3.attentions.2.proj_in.bias"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.attn1.to_q.weight", "up_blocks.3.attentions.2.transformer_blocks.0.attn1.to_q.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.attn1.to_k.weight", "up_blocks.3.attentions.2.transformer_blocks.0.attn1.to_k.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.attn1.to_v.weight", "up_blocks.3.attentions.2.transformer_blocks.0.attn1.to_v.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.attn1.to_out.0.weight", "up_blocks.3.attentions.2.transformer_blocks.0.attn1.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.attn1.to_out.0.bias", "up_blocks.3.attentions.2.transformer_blocks.0.attn1.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.ff.net.0.proj.weight", "up_blocks.3.attentions.2.transformer_blocks.0.ff.net.0.proj.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.ff.net.0.proj.bias", "up_blocks.3.attentions.2.transformer_blocks.0.ff.net.0.proj.bias"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.ff.net.2.weight", "up_blocks.3.attentions.2.transformer_blocks.0.ff.net.2.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.ff.net.2.bias", "up_blocks.3.attentions.2.transformer_blocks.0.ff.net.2.bias"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.attn2.to_q.weight", "up_blocks.3.attentions.2.transformer_blocks.0.attn2.to_q.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.attn2.to_k.weight", "up_blocks.3.attentions.2.transformer_blocks.0.attn2.to_k.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.attn2.to_v.weight", "up_blocks.3.attentions.2.transformer_blocks.0.attn2.to_v.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.attn2.to_out.0.weight", "up_blocks.3.attentions.2.transformer_blocks.0.attn2.to_out.0.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.attn2.to_out.0.bias", "up_blocks.3.attentions.2.transformer_blocks.0.attn2.to_out.0.bias"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.norm1.weight", "up_blocks.3.attentions.2.transformer_blocks.0.norm1.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.norm1.bias", "up_blocks.3.attentions.2.transformer_blocks.0.norm1.bias"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.norm2.weight", "up_blocks.3.attentions.2.transformer_blocks.0.norm2.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.norm2.bias", "up_blocks.3.attentions.2.transformer_blocks.0.norm2.bias"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.norm3.weight", "up_blocks.3.attentions.2.transformer_blocks.0.norm3.weight"),
    ("model.diffusion_model.output_blocks.11.1.transformer_blocks.0.norm3.bias", "up_blocks.3.attentions.2.transformer_blocks.0.norm3.bias"),
    ("model.diffusion_model.output_blocks.11.1.proj_out.weight", "up_blocks.3.attentions.2.proj_out.weight"),
    ("model.diffusion_model.output_blocks.11.1.proj_out.bias", "up_blocks.3.attentions.2.proj_out.bias"),
)

vae_ckpt_and_diffusers_mapping_noconv = (
    ("first_stage_model.encoder.conv_in.weight", "encoder.conv_in.weight"),
    ("first_stage_model.encoder.conv_in.bias", "encoder.conv_in.bias"),
    ("first_stage_model.encoder.conv_out.weight", "encoder.conv_out.weight"),
    ("first_stage_model.encoder.conv_out.bias", "encoder.conv_out.bias"),
    ("first_stage_model.encoder.norm_out.weight", "encoder.conv_norm_out.weight"),
    ("first_stage_model.encoder.norm_out.bias", "encoder.conv_norm_out.bias"),
    ("first_stage_model.decoder.conv_in.weight", "decoder.conv_in.weight"),
    ("first_stage_model.decoder.conv_in.bias", "decoder.conv_in.bias"),
    ("first_stage_model.decoder.conv_out.weight", "decoder.conv_out.weight"),
    ("first_stage_model.decoder.conv_out.bias", "decoder.conv_out.bias"),
    ("first_stage_model.decoder.norm_out.weight", "decoder.conv_norm_out.weight"),
    ("first_stage_model.decoder.norm_out.bias", "decoder.conv_norm_out.bias"),

    ("first_stage_model.quant_conv.weight", "quant_conv.weight"),
    ("first_stage_model.quant_conv.bias", "quant_conv.bias"),
    ("first_stage_model.post_quant_conv.weight", "post_quant_conv.weight"),
    ("first_stage_model.post_quant_conv.bias", "post_quant_conv.bias"),

    ("first_stage_model.encoder.down.0.downsample.conv.weight", "encoder.down_blocks.0.downsamplers.0.conv.weight"),
    ("first_stage_model.encoder.down.0.downsample.conv.bias", "encoder.down_blocks.0.downsamplers.0.conv.bias"),
    ("first_stage_model.encoder.down.0.block.0.norm1.weight", "encoder.down_blocks.0.resnets.0.norm1.weight"),
    ("first_stage_model.encoder.down.0.block.0.norm1.bias", "encoder.down_blocks.0.resnets.0.norm1.bias"),
    ("first_stage_model.encoder.down.0.block.0.conv1.weight", "encoder.down_blocks.0.resnets.0.conv1.weight"),
    ("first_stage_model.encoder.down.0.block.0.conv1.bias", "encoder.down_blocks.0.resnets.0.conv1.bias"),
    ("first_stage_model.encoder.down.0.block.0.norm2.weight", "encoder.down_blocks.0.resnets.0.norm2.weight"),
    ("first_stage_model.encoder.down.0.block.0.norm2.bias", "encoder.down_blocks.0.resnets.0.norm2.bias"),
    ("first_stage_model.encoder.down.0.block.0.conv2.weight", "encoder.down_blocks.0.resnets.0.conv2.weight"),
    ("first_stage_model.encoder.down.0.block.0.conv2.bias", "encoder.down_blocks.0.resnets.0.conv2.bias"),
    ("first_stage_model.encoder.down.0.block.1.norm1.weight", "encoder.down_blocks.0.resnets.1.norm1.weight"),
    ("first_stage_model.encoder.down.0.block.1.norm1.bias", "encoder.down_blocks.0.resnets.1.norm1.bias"),
    ("first_stage_model.encoder.down.0.block.1.conv1.weight", "encoder.down_blocks.0.resnets.1.conv1.weight"),
    ("first_stage_model.encoder.down.0.block.1.conv1.bias", "encoder.down_blocks.0.resnets.1.conv1.bias"),
    ("first_stage_model.encoder.down.0.block.1.norm2.weight", "encoder.down_blocks.0.resnets.1.norm2.weight"),
    ("first_stage_model.encoder.down.0.block.1.norm2.bias", "encoder.down_blocks.0.resnets.1.norm2.bias"),
    ("first_stage_model.encoder.down.0.block.1.conv2.weight", "encoder.down_blocks.0.resnets.1.conv2.weight"),
    ("first_stage_model.encoder.down.0.block.1.conv2.bias", "encoder.down_blocks.0.resnets.1.conv2.bias"),
    ("first_stage_model.encoder.down.1.downsample.conv.weight", "encoder.down_blocks.1.downsamplers.0.conv.weight"),
    ("first_stage_model.encoder.down.1.downsample.conv.bias", "encoder.down_blocks.1.downsamplers.0.conv.bias"),
    ("first_stage_model.encoder.down.1.block.0.norm1.weight", "encoder.down_blocks.1.resnets.0.norm1.weight"),
    ("first_stage_model.encoder.down.1.block.0.norm1.bias", "encoder.down_blocks.1.resnets.0.norm1.bias"),
    ("first_stage_model.encoder.down.1.block.0.conv1.weight", "encoder.down_blocks.1.resnets.0.conv1.weight"),
    ("first_stage_model.encoder.down.1.block.0.conv1.bias", "encoder.down_blocks.1.resnets.0.conv1.bias"),
    ("first_stage_model.encoder.down.1.block.0.norm2.weight", "encoder.down_blocks.1.resnets.0.norm2.weight"),
    ("first_stage_model.encoder.down.1.block.0.norm2.bias", "encoder.down_blocks.1.resnets.0.norm2.bias"),
    ("first_stage_model.encoder.down.1.block.0.conv2.weight", "encoder.down_blocks.1.resnets.0.conv2.weight"),
    ("first_stage_model.encoder.down.1.block.0.conv2.bias", "encoder.down_blocks.1.resnets.0.conv2.bias"),
    ("first_stage_model.encoder.down.1.block.0.nin_shortcut.weight", "encoder.down_blocks.1.resnets.0.conv_shortcut.weight"),
    ("first_stage_model.encoder.down.1.block.0.nin_shortcut.bias", "encoder.down_blocks.1.resnets.0.conv_shortcut.bias"),
    ("first_stage_model.encoder.down.1.block.1.norm1.weight", "encoder.down_blocks.1.resnets.1.norm1.weight"),
    ("first_stage_model.encoder.down.1.block.1.norm1.bias", "encoder.down_blocks.1.resnets.1.norm1.bias"),
    ("first_stage_model.encoder.down.1.block.1.conv1.weight", "encoder.down_blocks.1.resnets.1.conv1.weight"),
    ("first_stage_model.encoder.down.1.block.1.conv1.bias", "encoder.down_blocks.1.resnets.1.conv1.bias"),
    ("first_stage_model.encoder.down.1.block.1.norm2.weight", "encoder.down_blocks.1.resnets.1.norm2.weight"),
    ("first_stage_model.encoder.down.1.block.1.norm2.bias", "encoder.down_blocks.1.resnets.1.norm2.bias"),
    ("first_stage_model.encoder.down.1.block.1.conv2.weight", "encoder.down_blocks.1.resnets.1.conv2.weight"),
    ("first_stage_model.encoder.down.1.block.1.conv2.bias", "encoder.down_blocks.1.resnets.1.conv2.bias"),
    ("first_stage_model.encoder.down.2.downsample.conv.weight", "encoder.down_blocks.2.downsamplers.0.conv.weight"),
    ("first_stage_model.encoder.down.2.downsample.conv.bias", "encoder.down_blocks.2.downsamplers.0.conv.bias"),
    ("first_stage_model.encoder.down.2.block.0.norm1.weight", "encoder.down_blocks.2.resnets.0.norm1.weight"),
    ("first_stage_model.encoder.down.2.block.0.norm1.bias", "encoder.down_blocks.2.resnets.0.norm1.bias"),
    ("first_stage_model.encoder.down.2.block.0.conv1.weight", "encoder.down_blocks.2.resnets.0.conv1.weight"),
    ("first_stage_model.encoder.down.2.block.0.conv1.bias", "encoder.down_blocks.2.resnets.0.conv1.bias"),
    ("first_stage_model.encoder.down.2.block.0.norm2.weight", "encoder.down_blocks.2.resnets.0.norm2.weight"),
    ("first_stage_model.encoder.down.2.block.0.norm2.bias", "encoder.down_blocks.2.resnets.0.norm2.bias"),
    ("first_stage_model.encoder.down.2.block.0.conv2.weight", "encoder.down_blocks.2.resnets.0.conv2.weight"),
    ("first_stage_model.encoder.down.2.block.0.conv2.bias", "encoder.down_blocks.2.resnets.0.conv2.bias"),
    ("first_stage_model.encoder.down.2.block.0.nin_shortcut.weight", "encoder.down_blocks.2.resnets.0.conv_shortcut.weight"),
    ("first_stage_model.encoder.down.2.block.0.nin_shortcut.bias", "encoder.down_blocks.2.resnets.0.conv_shortcut.bias"),
    ("first_stage_model.encoder.down.2.block.1.norm1.weight", "encoder.down_blocks.2.resnets.1.norm1.weight"),
    ("first_stage_model.encoder.down.2.block.1.norm1.bias", "encoder.down_blocks.2.resnets.1.norm1.bias"),
    ("first_stage_model.encoder.down.2.block.1.conv1.weight", "encoder.down_blocks.2.resnets.1.conv1.weight"),
    ("first_stage_model.encoder.down.2.block.1.conv1.bias", "encoder.down_blocks.2.resnets.1.conv1.bias"),
    ("first_stage_model.encoder.down.2.block.1.norm2.weight", "encoder.down_blocks.2.resnets.1.norm2.weight"),
    ("first_stage_model.encoder.down.2.block.1.norm2.bias", "encoder.down_blocks.2.resnets.1.norm2.bias"),
    ("first_stage_model.encoder.down.2.block.1.conv2.weight", "encoder.down_blocks.2.resnets.1.conv2.weight"),
    ("first_stage_model.encoder.down.2.block.1.conv2.bias", "encoder.down_blocks.2.resnets.1.conv2.bias"),
    ("first_stage_model.encoder.down.3.block.0.norm1.weight", "encoder.down_blocks.3.resnets.0.norm1.weight"),
    ("first_stage_model.encoder.down.3.block.0.norm1.bias", "encoder.down_blocks.3.resnets.0.norm1.bias"),
    ("first_stage_model.encoder.down.3.block.0.conv1.weight", "encoder.down_blocks.3.resnets.0.conv1.weight"),
    ("first_stage_model.encoder.down.3.block.0.conv1.bias", "encoder.down_blocks.3.resnets.0.conv1.bias"),
    ("first_stage_model.encoder.down.3.block.0.norm2.weight", "encoder.down_blocks.3.resnets.0.norm2.weight"),
    ("first_stage_model.encoder.down.3.block.0.norm2.bias", "encoder.down_blocks.3.resnets.0.norm2.bias"),
    ("first_stage_model.encoder.down.3.block.0.conv2.weight", "encoder.down_blocks.3.resnets.0.conv2.weight"),
    ("first_stage_model.encoder.down.3.block.0.conv2.bias", "encoder.down_blocks.3.resnets.0.conv2.bias"),
    ("first_stage_model.encoder.down.3.block.1.norm1.weight", "encoder.down_blocks.3.resnets.1.norm1.weight"),
    ("first_stage_model.encoder.down.3.block.1.norm1.bias", "encoder.down_blocks.3.resnets.1.norm1.bias"),
    ("first_stage_model.encoder.down.3.block.1.conv1.weight", "encoder.down_blocks.3.resnets.1.conv1.weight"),
    ("first_stage_model.encoder.down.3.block.1.conv1.bias", "encoder.down_blocks.3.resnets.1.conv1.bias"),
    ("first_stage_model.encoder.down.3.block.1.norm2.weight", "encoder.down_blocks.3.resnets.1.norm2.weight"),
    ("first_stage_model.encoder.down.3.block.1.norm2.bias", "encoder.down_blocks.3.resnets.1.norm2.bias"),
    ("first_stage_model.encoder.down.3.block.1.conv2.weight", "encoder.down_blocks.3.resnets.1.conv2.weight"),
    ("first_stage_model.encoder.down.3.block.1.conv2.bias", "encoder.down_blocks.3.resnets.1.conv2.bias"),
    ("first_stage_model.encoder.mid.block_1.norm1.weight", "encoder.mid_block.resnets.0.norm1.weight"),
    ("first_stage_model.encoder.mid.block_1.norm1.bias", "encoder.mid_block.resnets.0.norm1.bias"),
    ("first_stage_model.encoder.mid.block_1.conv1.weight", "encoder.mid_block.resnets.0.conv1.weight"),
    ("first_stage_model.encoder.mid.block_1.conv1.bias", "encoder.mid_block.resnets.0.conv1.bias"),
    ("first_stage_model.encoder.mid.block_1.norm2.weight", "encoder.mid_block.resnets.0.norm2.weight"),
    ("first_stage_model.encoder.mid.block_1.norm2.bias", "encoder.mid_block.resnets.0.norm2.bias"),
    ("first_stage_model.encoder.mid.block_1.conv2.weight", "encoder.mid_block.resnets.0.conv2.weight"),
    ("first_stage_model.encoder.mid.block_1.conv2.bias", "encoder.mid_block.resnets.0.conv2.bias"),
    ("first_stage_model.encoder.mid.block_2.norm1.weight", "encoder.mid_block.resnets.1.norm1.weight"),
    ("first_stage_model.encoder.mid.block_2.norm1.bias", "encoder.mid_block.resnets.1.norm1.bias"),
    ("first_stage_model.encoder.mid.block_2.conv1.weight", "encoder.mid_block.resnets.1.conv1.weight"),
    ("first_stage_model.encoder.mid.block_2.conv1.bias", "encoder.mid_block.resnets.1.conv1.bias"),
    ("first_stage_model.encoder.mid.block_2.norm2.weight", "encoder.mid_block.resnets.1.norm2.weight"),
    ("first_stage_model.encoder.mid.block_2.norm2.bias", "encoder.mid_block.resnets.1.norm2.bias"),
    ("first_stage_model.encoder.mid.block_2.conv2.weight", "encoder.mid_block.resnets.1.conv2.weight"),
    ("first_stage_model.encoder.mid.block_2.conv2.bias", "encoder.mid_block.resnets.1.conv2.bias"),
    ("first_stage_model.encoder.mid.attn_1.norm.weight", "encoder.mid_block.attentions.0.group_norm.weight"),
    ("first_stage_model.encoder.mid.attn_1.norm.bias", "encoder.mid_block.attentions.0.group_norm.bias"),
    ("first_stage_model.encoder.mid.attn_1.q.bias", "encoder.mid_block.attentions.0.query.bias"),
    ("first_stage_model.encoder.mid.attn_1.k.bias", "encoder.mid_block.attentions.0.key.bias"),
    ("first_stage_model.encoder.mid.attn_1.v.bias", "encoder.mid_block.attentions.0.value.bias"),
    ("first_stage_model.encoder.mid.attn_1.proj_out.bias", "encoder.mid_block.attentions.0.proj_attn.bias"),
    ("first_stage_model.decoder.up.3.upsample.conv.weight", "decoder.up_blocks.0.upsamplers.0.conv.weight"),
    ("first_stage_model.decoder.up.3.upsample.conv.bias", "decoder.up_blocks.0.upsamplers.0.conv.bias"),
    ("first_stage_model.decoder.up.3.block.0.norm1.weight", "decoder.up_blocks.0.resnets.0.norm1.weight"),
    ("first_stage_model.decoder.up.3.block.0.norm1.bias", "decoder.up_blocks.0.resnets.0.norm1.bias"),
    ("first_stage_model.decoder.up.3.block.0.conv1.weight", "decoder.up_blocks.0.resnets.0.conv1.weight"),
    ("first_stage_model.decoder.up.3.block.0.conv1.bias", "decoder.up_blocks.0.resnets.0.conv1.bias"),
    ("first_stage_model.decoder.up.3.block.0.norm2.weight", "decoder.up_blocks.0.resnets.0.norm2.weight"),
    ("first_stage_model.decoder.up.3.block.0.norm2.bias", "decoder.up_blocks.0.resnets.0.norm2.bias"),
    ("first_stage_model.decoder.up.3.block.0.conv2.weight", "decoder.up_blocks.0.resnets.0.conv2.weight"),
    ("first_stage_model.decoder.up.3.block.0.conv2.bias", "decoder.up_blocks.0.resnets.0.conv2.bias"),
    ("first_stage_model.decoder.up.3.block.1.norm1.weight", "decoder.up_blocks.0.resnets.1.norm1.weight"),
    ("first_stage_model.decoder.up.3.block.1.norm1.bias", "decoder.up_blocks.0.resnets.1.norm1.bias"),
    ("first_stage_model.decoder.up.3.block.1.conv1.weight", "decoder.up_blocks.0.resnets.1.conv1.weight"),
    ("first_stage_model.decoder.up.3.block.1.conv1.bias", "decoder.up_blocks.0.resnets.1.conv1.bias"),
    ("first_stage_model.decoder.up.3.block.1.norm2.weight", "decoder.up_blocks.0.resnets.1.norm2.weight"),
    ("first_stage_model.decoder.up.3.block.1.norm2.bias", "decoder.up_blocks.0.resnets.1.norm2.bias"),
    ("first_stage_model.decoder.up.3.block.1.conv2.weight", "decoder.up_blocks.0.resnets.1.conv2.weight"),
    ("first_stage_model.decoder.up.3.block.1.conv2.bias", "decoder.up_blocks.0.resnets.1.conv2.bias"),
    ("first_stage_model.decoder.up.3.block.2.norm1.weight", "decoder.up_blocks.0.resnets.2.norm1.weight"),
    ("first_stage_model.decoder.up.3.block.2.norm1.bias", "decoder.up_blocks.0.resnets.2.norm1.bias"),
    ("first_stage_model.decoder.up.3.block.2.conv1.weight", "decoder.up_blocks.0.resnets.2.conv1.weight"),
    ("first_stage_model.decoder.up.3.block.2.conv1.bias", "decoder.up_blocks.0.resnets.2.conv1.bias"),
    ("first_stage_model.decoder.up.3.block.2.norm2.weight", "decoder.up_blocks.0.resnets.2.norm2.weight"),
    ("first_stage_model.decoder.up.3.block.2.norm2.bias", "decoder.up_blocks.0.resnets.2.norm2.bias"),
    ("first_stage_model.decoder.up.3.block.2.conv2.weight", "decoder.up_blocks.0.resnets.2.conv2.weight"),
    ("first_stage_model.decoder.up.3.block.2.conv2.bias", "decoder.up_blocks.0.resnets.2.conv2.bias"),
    ("first_stage_model.decoder.up.2.upsample.conv.weight", "decoder.up_blocks.1.upsamplers.0.conv.weight"),
    ("first_stage_model.decoder.up.2.upsample.conv.bias", "decoder.up_blocks.1.upsamplers.0.conv.bias"),
    ("first_stage_model.decoder.up.2.block.0.norm1.weight", "decoder.up_blocks.1.resnets.0.norm1.weight"),
    ("first_stage_model.decoder.up.2.block.0.norm1.bias", "decoder.up_blocks.1.resnets.0.norm1.bias"),
    ("first_stage_model.decoder.up.2.block.0.conv1.weight", "decoder.up_blocks.1.resnets.0.conv1.weight"),
    ("first_stage_model.decoder.up.2.block.0.conv1.bias", "decoder.up_blocks.1.resnets.0.conv1.bias"),
    ("first_stage_model.decoder.up.2.block.0.norm2.weight", "decoder.up_blocks.1.resnets.0.norm2.weight"),
    ("first_stage_model.decoder.up.2.block.0.norm2.bias", "decoder.up_blocks.1.resnets.0.norm2.bias"),
    ("first_stage_model.decoder.up.2.block.0.conv2.weight", "decoder.up_blocks.1.resnets.0.conv2.weight"),
    ("first_stage_model.decoder.up.2.block.0.conv2.bias", "decoder.up_blocks.1.resnets.0.conv2.bias"),
    ("first_stage_model.decoder.up.2.block.1.norm1.weight", "decoder.up_blocks.1.resnets.1.norm1.weight"),
    ("first_stage_model.decoder.up.2.block.1.norm1.bias", "decoder.up_blocks.1.resnets.1.norm1.bias"),
    ("first_stage_model.decoder.up.2.block.1.conv1.weight", "decoder.up_blocks.1.resnets.1.conv1.weight"),
    ("first_stage_model.decoder.up.2.block.1.conv1.bias", "decoder.up_blocks.1.resnets.1.conv1.bias"),
    ("first_stage_model.decoder.up.2.block.1.norm2.weight", "decoder.up_blocks.1.resnets.1.norm2.weight"),
    ("first_stage_model.decoder.up.2.block.1.norm2.bias", "decoder.up_blocks.1.resnets.1.norm2.bias"),
    ("first_stage_model.decoder.up.2.block.1.conv2.weight", "decoder.up_blocks.1.resnets.1.conv2.weight"),
    ("first_stage_model.decoder.up.2.block.1.conv2.bias", "decoder.up_blocks.1.resnets.1.conv2.bias"),
    ("first_stage_model.decoder.up.2.block.2.norm1.weight", "decoder.up_blocks.1.resnets.2.norm1.weight"),
    ("first_stage_model.decoder.up.2.block.2.norm1.bias", "decoder.up_blocks.1.resnets.2.norm1.bias"),
    ("first_stage_model.decoder.up.2.block.2.conv1.weight", "decoder.up_blocks.1.resnets.2.conv1.weight"),
    ("first_stage_model.decoder.up.2.block.2.conv1.bias", "decoder.up_blocks.1.resnets.2.conv1.bias"),
    ("first_stage_model.decoder.up.2.block.2.norm2.weight", "decoder.up_blocks.1.resnets.2.norm2.weight"),
    ("first_stage_model.decoder.up.2.block.2.norm2.bias", "decoder.up_blocks.1.resnets.2.norm2.bias"),
    ("first_stage_model.decoder.up.2.block.2.conv2.weight", "decoder.up_blocks.1.resnets.2.conv2.weight"),
    ("first_stage_model.decoder.up.2.block.2.conv2.bias", "decoder.up_blocks.1.resnets.2.conv2.bias"),
    ("first_stage_model.decoder.up.1.upsample.conv.weight", "decoder.up_blocks.2.upsamplers.0.conv.weight"),
    ("first_stage_model.decoder.up.1.upsample.conv.bias", "decoder.up_blocks.2.upsamplers.0.conv.bias"),
    ("first_stage_model.decoder.up.1.block.0.norm1.weight", "decoder.up_blocks.2.resnets.0.norm1.weight"),
    ("first_stage_model.decoder.up.1.block.0.norm1.bias", "decoder.up_blocks.2.resnets.0.norm1.bias"),
    ("first_stage_model.decoder.up.1.block.0.conv1.weight", "decoder.up_blocks.2.resnets.0.conv1.weight"),
    ("first_stage_model.decoder.up.1.block.0.conv1.bias", "decoder.up_blocks.2.resnets.0.conv1.bias"),
    ("first_stage_model.decoder.up.1.block.0.norm2.weight", "decoder.up_blocks.2.resnets.0.norm2.weight"),
    ("first_stage_model.decoder.up.1.block.0.norm2.bias", "decoder.up_blocks.2.resnets.0.norm2.bias"),
    ("first_stage_model.decoder.up.1.block.0.conv2.weight", "decoder.up_blocks.2.resnets.0.conv2.weight"),
    ("first_stage_model.decoder.up.1.block.0.conv2.bias", "decoder.up_blocks.2.resnets.0.conv2.bias"),
    ("first_stage_model.decoder.up.1.block.0.nin_shortcut.weight", "decoder.up_blocks.2.resnets.0.conv_shortcut.weight"),
    ("first_stage_model.decoder.up.1.block.0.nin_shortcut.bias", "decoder.up_blocks.2.resnets.0.conv_shortcut.bias"),
    ("first_stage_model.decoder.up.1.block.1.norm1.weight", "decoder.up_blocks.2.resnets.1.norm1.weight"),
    ("first_stage_model.decoder.up.1.block.1.norm1.bias", "decoder.up_blocks.2.resnets.1.norm1.bias"),
    ("first_stage_model.decoder.up.1.block.1.conv1.weight", "decoder.up_blocks.2.resnets.1.conv1.weight"),
    ("first_stage_model.decoder.up.1.block.1.conv1.bias", "decoder.up_blocks.2.resnets.1.conv1.bias"),
    ("first_stage_model.decoder.up.1.block.1.norm2.weight", "decoder.up_blocks.2.resnets.1.norm2.weight"),
    ("first_stage_model.decoder.up.1.block.1.norm2.bias", "decoder.up_blocks.2.resnets.1.norm2.bias"),
    ("first_stage_model.decoder.up.1.block.1.conv2.weight", "decoder.up_blocks.2.resnets.1.conv2.weight"),
    ("first_stage_model.decoder.up.1.block.1.conv2.bias", "decoder.up_blocks.2.resnets.1.conv2.bias"),
    ("first_stage_model.decoder.up.1.block.2.norm1.weight", "decoder.up_blocks.2.resnets.2.norm1.weight"),
    ("first_stage_model.decoder.up.1.block.2.norm1.bias", "decoder.up_blocks.2.resnets.2.norm1.bias"),
    ("first_stage_model.decoder.up.1.block.2.conv1.weight", "decoder.up_blocks.2.resnets.2.conv1.weight"),
    ("first_stage_model.decoder.up.1.block.2.conv1.bias", "decoder.up_blocks.2.resnets.2.conv1.bias"),
    ("first_stage_model.decoder.up.1.block.2.norm2.weight", "decoder.up_blocks.2.resnets.2.norm2.weight"),
    ("first_stage_model.decoder.up.1.block.2.norm2.bias", "decoder.up_blocks.2.resnets.2.norm2.bias"),
    ("first_stage_model.decoder.up.1.block.2.conv2.weight", "decoder.up_blocks.2.resnets.2.conv2.weight"),
    ("first_stage_model.decoder.up.1.block.2.conv2.bias", "decoder.up_blocks.2.resnets.2.conv2.bias"),
    ("first_stage_model.decoder.up.0.block.0.norm1.weight", "decoder.up_blocks.3.resnets.0.norm1.weight"),
    ("first_stage_model.decoder.up.0.block.0.norm1.bias", "decoder.up_blocks.3.resnets.0.norm1.bias"),
    ("first_stage_model.decoder.up.0.block.0.conv1.weight", "decoder.up_blocks.3.resnets.0.conv1.weight"),
    ("first_stage_model.decoder.up.0.block.0.conv1.bias", "decoder.up_blocks.3.resnets.0.conv1.bias"),
    ("first_stage_model.decoder.up.0.block.0.norm2.weight", "decoder.up_blocks.3.resnets.0.norm2.weight"),
    ("first_stage_model.decoder.up.0.block.0.norm2.bias", "decoder.up_blocks.3.resnets.0.norm2.bias"),
    ("first_stage_model.decoder.up.0.block.0.conv2.weight", "decoder.up_blocks.3.resnets.0.conv2.weight"),
    ("first_stage_model.decoder.up.0.block.0.conv2.bias", "decoder.up_blocks.3.resnets.0.conv2.bias"),
    ("first_stage_model.decoder.up.0.block.0.nin_shortcut.weight", "decoder.up_blocks.3.resnets.0.conv_shortcut.weight"),
    ("first_stage_model.decoder.up.0.block.0.nin_shortcut.bias", "decoder.up_blocks.3.resnets.0.conv_shortcut.bias"),
    ("first_stage_model.decoder.up.0.block.1.norm1.weight", "decoder.up_blocks.3.resnets.1.norm1.weight"),
    ("first_stage_model.decoder.up.0.block.1.norm1.bias", "decoder.up_blocks.3.resnets.1.norm1.bias"),
    ("first_stage_model.decoder.up.0.block.1.conv1.weight", "decoder.up_blocks.3.resnets.1.conv1.weight"),
    ("first_stage_model.decoder.up.0.block.1.conv1.bias", "decoder.up_blocks.3.resnets.1.conv1.bias"),
    ("first_stage_model.decoder.up.0.block.1.norm2.weight", "decoder.up_blocks.3.resnets.1.norm2.weight"),
    ("first_stage_model.decoder.up.0.block.1.norm2.bias", "decoder.up_blocks.3.resnets.1.norm2.bias"),
    ("first_stage_model.decoder.up.0.block.1.conv2.weight", "decoder.up_blocks.3.resnets.1.conv2.weight"),
    ("first_stage_model.decoder.up.0.block.1.conv2.bias", "decoder.up_blocks.3.resnets.1.conv2.bias"),
    ("first_stage_model.decoder.up.0.block.2.norm1.weight", "decoder.up_blocks.3.resnets.2.norm1.weight"),
    ("first_stage_model.decoder.up.0.block.2.norm1.bias", "decoder.up_blocks.3.resnets.2.norm1.bias"),
    ("first_stage_model.decoder.up.0.block.2.conv1.weight", "decoder.up_blocks.3.resnets.2.conv1.weight"),
    ("first_stage_model.decoder.up.0.block.2.conv1.bias", "decoder.up_blocks.3.resnets.2.conv1.bias"),
    ("first_stage_model.decoder.up.0.block.2.norm2.weight", "decoder.up_blocks.3.resnets.2.norm2.weight"),
    ("first_stage_model.decoder.up.0.block.2.norm2.bias", "decoder.up_blocks.3.resnets.2.norm2.bias"),
    ("first_stage_model.decoder.up.0.block.2.conv2.weight", "decoder.up_blocks.3.resnets.2.conv2.weight"),
    ("first_stage_model.decoder.up.0.block.2.conv2.bias", "decoder.up_blocks.3.resnets.2.conv2.bias"),
    ("first_stage_model.decoder.mid.block_1.norm1.weight", "decoder.mid_block.resnets.0.norm1.weight"),
    ("first_stage_model.decoder.mid.block_1.norm1.bias", "decoder.mid_block.resnets.0.norm1.bias"),
    ("first_stage_model.decoder.mid.block_1.conv1.weight", "decoder.mid_block.resnets.0.conv1.weight"),
    ("first_stage_model.decoder.mid.block_1.conv1.bias", "decoder.mid_block.resnets.0.conv1.bias"),
    ("first_stage_model.decoder.mid.block_1.norm2.weight", "decoder.mid_block.resnets.0.norm2.weight"),
    ("first_stage_model.decoder.mid.block_1.norm2.bias", "decoder.mid_block.resnets.0.norm2.bias"),
    ("first_stage_model.decoder.mid.block_1.conv2.weight", "decoder.mid_block.resnets.0.conv2.weight"),
    ("first_stage_model.decoder.mid.block_1.conv2.bias", "decoder.mid_block.resnets.0.conv2.bias"),
    ("first_stage_model.decoder.mid.block_2.norm1.weight", "decoder.mid_block.resnets.1.norm1.weight"),
    ("first_stage_model.decoder.mid.block_2.norm1.bias", "decoder.mid_block.resnets.1.norm1.bias"),
    ("first_stage_model.decoder.mid.block_2.conv1.weight", "decoder.mid_block.resnets.1.conv1.weight"),
    ("first_stage_model.decoder.mid.block_2.conv1.bias", "decoder.mid_block.resnets.1.conv1.bias"),
    ("first_stage_model.decoder.mid.block_2.norm2.weight", "decoder.mid_block.resnets.1.norm2.weight"),
    ("first_stage_model.decoder.mid.block_2.norm2.bias", "decoder.mid_block.resnets.1.norm2.bias"),
    ("first_stage_model.decoder.mid.block_2.conv2.weight", "decoder.mid_block.resnets.1.conv2.weight"),
    ("first_stage_model.decoder.mid.block_2.conv2.bias", "decoder.mid_block.resnets.1.conv2.bias"),
    ("first_stage_model.decoder.mid.attn_1.norm.weight", "decoder.mid_block.attentions.0.group_norm.weight"),
    ("first_stage_model.decoder.mid.attn_1.norm.bias", "decoder.mid_block.attentions.0.group_norm.bias"),
    ("first_stage_model.decoder.mid.attn_1.q.bias", "decoder.mid_block.attentions.0.query.bias"),
    ("first_stage_model.decoder.mid.attn_1.k.bias", "decoder.mid_block.attentions.0.key.bias"),
    ("first_stage_model.decoder.mid.attn_1.v.bias", "decoder.mid_block.attentions.0.value.bias"),
    ("first_stage_model.decoder.mid.attn_1.proj_out.bias", "decoder.mid_block.attentions.0.proj_attn.bias"),

)

vae_ckpt_and_diffusers_mapping_conv = (
    ("first_stage_model.encoder.mid.attn_1.q.weight", "encoder.mid_block.attentions.0.query.weight"),
    ("first_stage_model.encoder.mid.attn_1.k.weight", "encoder.mid_block.attentions.0.key.weight"),
    ("first_stage_model.encoder.mid.attn_1.v.weight", "encoder.mid_block.attentions.0.value.weight"),
    ("first_stage_model.encoder.mid.attn_1.proj_out.weight", "encoder.mid_block.attentions.0.proj_attn.weight"),
    ("first_stage_model.decoder.mid.attn_1.q.weight", "decoder.mid_block.attentions.0.query.weight"),
    ("first_stage_model.decoder.mid.attn_1.k.weight", "decoder.mid_block.attentions.0.key.weight"),
    ("first_stage_model.decoder.mid.attn_1.v.weight", "decoder.mid_block.attentions.0.value.weight"),
    ("first_stage_model.decoder.mid.attn_1.proj_out.weight", "decoder.mid_block.attentions.0.proj_attn.weight"),
)

text_model_ckpt_and_diffusers_mapping_noconv = (
    ('cond_stage_model.transformer.text_model.embeddings.token_embedding.weight', 'text_model.embeddings.token_embedding.weight'),
    ('cond_stage_model.transformer.text_model.embeddings.position_embedding.weight', 'text_model.embeddings.position_embedding.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.self_attn.k_proj.weight', 'text_model.encoder.layers.0.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.self_attn.k_proj.bias', 'text_model.encoder.layers.0.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.self_attn.v_proj.weight', 'text_model.encoder.layers.0.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.self_attn.v_proj.bias', 'text_model.encoder.layers.0.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.self_attn.q_proj.weight', 'text_model.encoder.layers.0.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.self_attn.q_proj.bias', 'text_model.encoder.layers.0.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.self_attn.out_proj.weight', 'text_model.encoder.layers.0.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.self_attn.out_proj.bias', 'text_model.encoder.layers.0.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.layer_norm1.weight', 'text_model.encoder.layers.0.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.layer_norm1.bias', 'text_model.encoder.layers.0.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.mlp.fc1.weight', 'text_model.encoder.layers.0.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.mlp.fc1.bias', 'text_model.encoder.layers.0.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.mlp.fc2.weight', 'text_model.encoder.layers.0.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.mlp.fc2.bias', 'text_model.encoder.layers.0.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.layer_norm2.weight', 'text_model.encoder.layers.0.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.0.layer_norm2.bias', 'text_model.encoder.layers.0.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.self_attn.k_proj.weight', 'text_model.encoder.layers.1.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.self_attn.k_proj.bias', 'text_model.encoder.layers.1.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.self_attn.v_proj.weight', 'text_model.encoder.layers.1.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.self_attn.v_proj.bias', 'text_model.encoder.layers.1.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.self_attn.q_proj.weight', 'text_model.encoder.layers.1.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.self_attn.q_proj.bias', 'text_model.encoder.layers.1.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.self_attn.out_proj.weight', 'text_model.encoder.layers.1.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.self_attn.out_proj.bias', 'text_model.encoder.layers.1.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.layer_norm1.weight', 'text_model.encoder.layers.1.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.layer_norm1.bias', 'text_model.encoder.layers.1.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.mlp.fc1.weight', 'text_model.encoder.layers.1.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.mlp.fc1.bias', 'text_model.encoder.layers.1.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.mlp.fc2.weight', 'text_model.encoder.layers.1.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.mlp.fc2.bias', 'text_model.encoder.layers.1.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.layer_norm2.weight', 'text_model.encoder.layers.1.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.1.layer_norm2.bias', 'text_model.encoder.layers.1.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.self_attn.k_proj.weight', 'text_model.encoder.layers.2.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.self_attn.k_proj.bias', 'text_model.encoder.layers.2.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.self_attn.v_proj.weight', 'text_model.encoder.layers.2.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.self_attn.v_proj.bias', 'text_model.encoder.layers.2.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.self_attn.q_proj.weight', 'text_model.encoder.layers.2.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.self_attn.q_proj.bias', 'text_model.encoder.layers.2.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.self_attn.out_proj.weight', 'text_model.encoder.layers.2.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.self_attn.out_proj.bias', 'text_model.encoder.layers.2.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.layer_norm1.weight', 'text_model.encoder.layers.2.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.layer_norm1.bias', 'text_model.encoder.layers.2.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.mlp.fc1.weight', 'text_model.encoder.layers.2.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.mlp.fc1.bias', 'text_model.encoder.layers.2.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.mlp.fc2.weight', 'text_model.encoder.layers.2.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.mlp.fc2.bias', 'text_model.encoder.layers.2.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.layer_norm2.weight', 'text_model.encoder.layers.2.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.2.layer_norm2.bias', 'text_model.encoder.layers.2.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.self_attn.k_proj.weight', 'text_model.encoder.layers.3.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.self_attn.k_proj.bias', 'text_model.encoder.layers.3.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.self_attn.v_proj.weight', 'text_model.encoder.layers.3.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.self_attn.v_proj.bias', 'text_model.encoder.layers.3.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.self_attn.q_proj.weight', 'text_model.encoder.layers.3.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.self_attn.q_proj.bias', 'text_model.encoder.layers.3.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.self_attn.out_proj.weight', 'text_model.encoder.layers.3.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.self_attn.out_proj.bias', 'text_model.encoder.layers.3.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.layer_norm1.weight', 'text_model.encoder.layers.3.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.layer_norm1.bias', 'text_model.encoder.layers.3.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.mlp.fc1.weight', 'text_model.encoder.layers.3.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.mlp.fc1.bias', 'text_model.encoder.layers.3.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.mlp.fc2.weight', 'text_model.encoder.layers.3.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.mlp.fc2.bias', 'text_model.encoder.layers.3.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.layer_norm2.weight', 'text_model.encoder.layers.3.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.3.layer_norm2.bias', 'text_model.encoder.layers.3.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.self_attn.k_proj.weight', 'text_model.encoder.layers.4.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.self_attn.k_proj.bias', 'text_model.encoder.layers.4.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.self_attn.v_proj.weight', 'text_model.encoder.layers.4.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.self_attn.v_proj.bias', 'text_model.encoder.layers.4.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.self_attn.q_proj.weight', 'text_model.encoder.layers.4.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.self_attn.q_proj.bias', 'text_model.encoder.layers.4.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.self_attn.out_proj.weight', 'text_model.encoder.layers.4.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.self_attn.out_proj.bias', 'text_model.encoder.layers.4.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.layer_norm1.weight', 'text_model.encoder.layers.4.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.layer_norm1.bias', 'text_model.encoder.layers.4.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.mlp.fc1.weight', 'text_model.encoder.layers.4.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.mlp.fc1.bias', 'text_model.encoder.layers.4.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.mlp.fc2.weight', 'text_model.encoder.layers.4.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.mlp.fc2.bias', 'text_model.encoder.layers.4.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.layer_norm2.weight', 'text_model.encoder.layers.4.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.4.layer_norm2.bias', 'text_model.encoder.layers.4.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.self_attn.k_proj.weight', 'text_model.encoder.layers.5.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.self_attn.k_proj.bias', 'text_model.encoder.layers.5.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.self_attn.v_proj.weight', 'text_model.encoder.layers.5.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.self_attn.v_proj.bias', 'text_model.encoder.layers.5.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.self_attn.q_proj.weight', 'text_model.encoder.layers.5.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.self_attn.q_proj.bias', 'text_model.encoder.layers.5.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.self_attn.out_proj.weight', 'text_model.encoder.layers.5.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.self_attn.out_proj.bias', 'text_model.encoder.layers.5.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.layer_norm1.weight', 'text_model.encoder.layers.5.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.layer_norm1.bias', 'text_model.encoder.layers.5.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.mlp.fc1.weight', 'text_model.encoder.layers.5.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.mlp.fc1.bias', 'text_model.encoder.layers.5.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.mlp.fc2.weight', 'text_model.encoder.layers.5.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.mlp.fc2.bias', 'text_model.encoder.layers.5.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.layer_norm2.weight', 'text_model.encoder.layers.5.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.5.layer_norm2.bias', 'text_model.encoder.layers.5.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.self_attn.k_proj.weight', 'text_model.encoder.layers.6.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.self_attn.k_proj.bias', 'text_model.encoder.layers.6.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.self_attn.v_proj.weight', 'text_model.encoder.layers.6.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.self_attn.v_proj.bias', 'text_model.encoder.layers.6.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.self_attn.q_proj.weight', 'text_model.encoder.layers.6.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.self_attn.q_proj.bias', 'text_model.encoder.layers.6.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.self_attn.out_proj.weight', 'text_model.encoder.layers.6.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.self_attn.out_proj.bias', 'text_model.encoder.layers.6.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.layer_norm1.weight', 'text_model.encoder.layers.6.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.layer_norm1.bias', 'text_model.encoder.layers.6.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.mlp.fc1.weight', 'text_model.encoder.layers.6.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.mlp.fc1.bias', 'text_model.encoder.layers.6.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.mlp.fc2.weight', 'text_model.encoder.layers.6.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.mlp.fc2.bias', 'text_model.encoder.layers.6.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.layer_norm2.weight', 'text_model.encoder.layers.6.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.6.layer_norm2.bias', 'text_model.encoder.layers.6.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.self_attn.k_proj.weight', 'text_model.encoder.layers.7.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.self_attn.k_proj.bias', 'text_model.encoder.layers.7.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.self_attn.v_proj.weight', 'text_model.encoder.layers.7.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.self_attn.v_proj.bias', 'text_model.encoder.layers.7.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.self_attn.q_proj.weight', 'text_model.encoder.layers.7.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.self_attn.q_proj.bias', 'text_model.encoder.layers.7.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.self_attn.out_proj.weight', 'text_model.encoder.layers.7.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.self_attn.out_proj.bias', 'text_model.encoder.layers.7.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.layer_norm1.weight', 'text_model.encoder.layers.7.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.layer_norm1.bias', 'text_model.encoder.layers.7.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.mlp.fc1.weight', 'text_model.encoder.layers.7.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.mlp.fc1.bias', 'text_model.encoder.layers.7.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.mlp.fc2.weight', 'text_model.encoder.layers.7.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.mlp.fc2.bias', 'text_model.encoder.layers.7.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.layer_norm2.weight', 'text_model.encoder.layers.7.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.7.layer_norm2.bias', 'text_model.encoder.layers.7.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.self_attn.k_proj.weight', 'text_model.encoder.layers.8.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.self_attn.k_proj.bias', 'text_model.encoder.layers.8.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.self_attn.v_proj.weight', 'text_model.encoder.layers.8.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.self_attn.v_proj.bias', 'text_model.encoder.layers.8.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.self_attn.q_proj.weight', 'text_model.encoder.layers.8.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.self_attn.q_proj.bias', 'text_model.encoder.layers.8.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.self_attn.out_proj.weight', 'text_model.encoder.layers.8.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.self_attn.out_proj.bias', 'text_model.encoder.layers.8.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.layer_norm1.weight', 'text_model.encoder.layers.8.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.layer_norm1.bias', 'text_model.encoder.layers.8.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.mlp.fc1.weight', 'text_model.encoder.layers.8.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.mlp.fc1.bias', 'text_model.encoder.layers.8.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.mlp.fc2.weight', 'text_model.encoder.layers.8.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.mlp.fc2.bias', 'text_model.encoder.layers.8.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.layer_norm2.weight', 'text_model.encoder.layers.8.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.8.layer_norm2.bias', 'text_model.encoder.layers.8.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.self_attn.k_proj.weight', 'text_model.encoder.layers.9.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.self_attn.k_proj.bias', 'text_model.encoder.layers.9.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.self_attn.v_proj.weight', 'text_model.encoder.layers.9.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.self_attn.v_proj.bias', 'text_model.encoder.layers.9.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.self_attn.q_proj.weight', 'text_model.encoder.layers.9.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.self_attn.q_proj.bias', 'text_model.encoder.layers.9.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.self_attn.out_proj.weight', 'text_model.encoder.layers.9.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.self_attn.out_proj.bias', 'text_model.encoder.layers.9.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.layer_norm1.weight', 'text_model.encoder.layers.9.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.layer_norm1.bias', 'text_model.encoder.layers.9.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.mlp.fc1.weight', 'text_model.encoder.layers.9.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.mlp.fc1.bias', 'text_model.encoder.layers.9.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.mlp.fc2.weight', 'text_model.encoder.layers.9.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.mlp.fc2.bias', 'text_model.encoder.layers.9.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.layer_norm2.weight', 'text_model.encoder.layers.9.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.9.layer_norm2.bias', 'text_model.encoder.layers.9.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.self_attn.k_proj.weight', 'text_model.encoder.layers.10.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.self_attn.k_proj.bias', 'text_model.encoder.layers.10.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.self_attn.v_proj.weight', 'text_model.encoder.layers.10.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.self_attn.v_proj.bias', 'text_model.encoder.layers.10.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.self_attn.q_proj.weight', 'text_model.encoder.layers.10.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.self_attn.q_proj.bias', 'text_model.encoder.layers.10.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.self_attn.out_proj.weight', 'text_model.encoder.layers.10.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.self_attn.out_proj.bias', 'text_model.encoder.layers.10.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.layer_norm1.weight', 'text_model.encoder.layers.10.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.layer_norm1.bias', 'text_model.encoder.layers.10.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.mlp.fc1.weight', 'text_model.encoder.layers.10.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.mlp.fc1.bias', 'text_model.encoder.layers.10.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.mlp.fc2.weight', 'text_model.encoder.layers.10.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.mlp.fc2.bias', 'text_model.encoder.layers.10.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.layer_norm2.weight', 'text_model.encoder.layers.10.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.10.layer_norm2.bias', 'text_model.encoder.layers.10.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.self_attn.k_proj.weight', 'text_model.encoder.layers.11.self_attn.k_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.self_attn.k_proj.bias', 'text_model.encoder.layers.11.self_attn.k_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.self_attn.v_proj.weight', 'text_model.encoder.layers.11.self_attn.v_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.self_attn.v_proj.bias', 'text_model.encoder.layers.11.self_attn.v_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.self_attn.q_proj.weight', 'text_model.encoder.layers.11.self_attn.q_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.self_attn.q_proj.bias', 'text_model.encoder.layers.11.self_attn.q_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.self_attn.out_proj.weight', 'text_model.encoder.layers.11.self_attn.out_proj.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.self_attn.out_proj.bias', 'text_model.encoder.layers.11.self_attn.out_proj.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.layer_norm1.weight', 'text_model.encoder.layers.11.layer_norm1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.layer_norm1.bias', 'text_model.encoder.layers.11.layer_norm1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.mlp.fc1.weight', 'text_model.encoder.layers.11.mlp.fc1.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.mlp.fc1.bias', 'text_model.encoder.layers.11.mlp.fc1.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.mlp.fc2.weight', 'text_model.encoder.layers.11.mlp.fc2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.mlp.fc2.bias', 'text_model.encoder.layers.11.mlp.fc2.bias'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.layer_norm2.weight', 'text_model.encoder.layers.11.layer_norm2.weight'),
    ('cond_stage_model.transformer.text_model.encoder.layers.11.layer_norm2.bias', 'text_model.encoder.layers.11.layer_norm2.bias'),
    ('cond_stage_model.transformer.text_model.final_layer_norm.weight', 'text_model.final_layer_norm.weight'),
    ('cond_stage_model.transformer.text_model.final_layer_norm.bias', 'text_model.final_layer_norm.bias'),
)

text_model_ckpt_and_diffusers_mapping_conv = (
    ('cond_stage_model.transformer.text_model.embeddings.position_ids', 'text_model.embeddings.position_ids'),
)
