# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 machine_type: pulumi.Input[str],
                 accelerator_config: Optional[pulumi.Input['InstanceAcceleratorConfigArgs']] = None,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 container_image: Optional[pulumi.Input['InstanceContainerImageArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 custom_gpu_driver_path: Optional[pulumi.Input[str]] = None,
                 data_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 data_disk_type: Optional[pulumi.Input[str]] = None,
                 disk_encryption: Optional[pulumi.Input[str]] = None,
                 install_gpu_driver: Optional[pulumi.Input[bool]] = None,
                 instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 no_proxy_access: Optional[pulumi.Input[bool]] = None,
                 no_public_ip: Optional[pulumi.Input[bool]] = None,
                 no_remove_data_disk: Optional[pulumi.Input[bool]] = None,
                 post_startup_script: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 service_account_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shielded_instance_config: Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vm_image: Optional[pulumi.Input['InstanceVmImageArgs']] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] location: A reference to the zone where the machine resides.
        :param pulumi.Input[str] machine_type: A reference to a machine type which defines VM kind.
        :param pulumi.Input['InstanceAcceleratorConfigArgs'] accelerator_config: The hardware accelerator used on this instance. If you use accelerators,
               make sure that your configuration has enough vCPUs and memory to support the
               machineType you have selected.
               Structure is documented below.
        :param pulumi.Input[int] boot_disk_size_gb: The size of the boot disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] boot_disk_type: Possible disk types for notebook instances.
               Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        :param pulumi.Input['InstanceContainerImageArgs'] container_image: Use a container image to start the notebook instance.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Instance creation time
        :param pulumi.Input[str] custom_gpu_driver_path: Specify a custom Cloud Storage path where the GPU driver is stored.
               If not specified, we'll automatically choose from official GPU drivers.
        :param pulumi.Input[int] data_disk_size_gb: The size of the data disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB).
               You can choose the size of the data disk based on how big your notebooks and data are.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] data_disk_type: Possible disk types for notebook instances.
               Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        :param pulumi.Input[str] disk_encryption: Disk encryption method used on the boot and data disks, defaults to GMEK.
               Possible values are `DISK_ENCRYPTION_UNSPECIFIED`, `GMEK`, and `CMEK`.
        :param pulumi.Input[bool] install_gpu_driver: Whether the end user authorizes Google Cloud to install GPU driver
               on this instance. If this field is empty or set to false, the GPU driver
               won't be installed. Only applicable to instances with GPUs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_owners: The list of owners of this instance after creation.
               Format: alias@example.com.
               Currently supports one owner only.
               If not specified, all of the service account users of
               your VM instance's service account can use the instance.
        :param pulumi.Input[str] kms_key: The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
               Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this instance. These can be later modified by the setLabels method.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Custom metadata to apply to this instance.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] name: The name specified for the Notebook instance.
        :param pulumi.Input[str] network: The name of the VPC that this instance is in.
               Format: projects/{project_id}/global/networks/{network_id}
        :param pulumi.Input[bool] no_proxy_access: The notebook instance will not register with the proxy..
        :param pulumi.Input[bool] no_public_ip: No public IP will be assigned to this instance.
        :param pulumi.Input[bool] no_remove_data_disk: If true, the data disk will not be auto deleted when deleting the instance.
        :param pulumi.Input[str] post_startup_script: Path to a Bash script that automatically runs after a
               notebook instance fully boots up. The path must be a URL
               or Cloud Storage path (gs://path-to-file/file-name).
        :param pulumi.Input[str] project: The name of the Google Cloud project that this VM image belongs to.
               Format: projects/{project_id}
        :param pulumi.Input[str] service_account: The service account on this instance, giving access to other
               Google Cloud services. You can use any service account within
               the same project, but you must have the service account user
               permission to use the instance. If not specified,
               the Compute Engine default service account is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_scopes: Optional. The URIs of service account scopes to be included in Compute Engine instances.
               If not specified, the following scopes are defined:
               - https://www.googleapis.com/auth/cloud-platform
               - https://www.googleapis.com/auth/userinfo.email
        :param pulumi.Input['InstanceShieldedInstanceConfigArgs'] shielded_instance_config: A set of Shielded Instance options. Check [Images using supported Shielded VM features]
               Not all combinations are valid
               Structure is documented below.
        :param pulumi.Input[str] subnet: The name of the subnet that this instance is in.
               Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The Compute Engine tags to add to runtime.
        :param pulumi.Input[str] update_time: Instance update time.
        :param pulumi.Input['InstanceVmImageArgs'] vm_image: Use a Compute Engine VM image to start the notebook instance.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "machine_type", machine_type)
        if accelerator_config is not None:
            pulumi.set(__self__, "accelerator_config", accelerator_config)
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_gpu_driver_path is not None:
            pulumi.set(__self__, "custom_gpu_driver_path", custom_gpu_driver_path)
        if data_disk_size_gb is not None:
            pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        if data_disk_type is not None:
            pulumi.set(__self__, "data_disk_type", data_disk_type)
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if install_gpu_driver is not None:
            pulumi.set(__self__, "install_gpu_driver", install_gpu_driver)
        if instance_owners is not None:
            pulumi.set(__self__, "instance_owners", instance_owners)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if no_proxy_access is not None:
            pulumi.set(__self__, "no_proxy_access", no_proxy_access)
        if no_public_ip is not None:
            pulumi.set(__self__, "no_public_ip", no_public_ip)
        if no_remove_data_disk is not None:
            pulumi.set(__self__, "no_remove_data_disk", no_remove_data_disk)
        if post_startup_script is not None:
            pulumi.set(__self__, "post_startup_script", post_startup_script)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes is not None:
            pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vm_image is not None:
            pulumi.set(__self__, "vm_image", vm_image)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        A reference to the zone where the machine resides.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Input[str]:
        """
        A reference to a machine type which defines VM kind.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> Optional[pulumi.Input['InstanceAcceleratorConfigArgs']]:
        """
        The hardware accelerator used on this instance. If you use accelerators,
        make sure that your configuration has enough vCPUs and memory to support the
        machineType you have selected.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerator_config")

    @accelerator_config.setter
    def accelerator_config(self, value: Optional[pulumi.Input['InstanceAcceleratorConfigArgs']]):
        pulumi.set(self, "accelerator_config", value)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the boot disk in GB attached to this instance,
        up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
        If not specified, this defaults to 100.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Possible disk types for notebook instances.
        Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[pulumi.Input['InstanceContainerImageArgs']]:
        """
        Use a container image to start the notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "container_image")

    @container_image.setter
    def container_image(self, value: Optional[pulumi.Input['InstanceContainerImageArgs']]):
        pulumi.set(self, "container_image", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Instance creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="customGpuDriverPath")
    def custom_gpu_driver_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a custom Cloud Storage path where the GPU driver is stored.
        If not specified, we'll automatically choose from official GPU drivers.
        """
        return pulumi.get(self, "custom_gpu_driver_path")

    @custom_gpu_driver_path.setter
    def custom_gpu_driver_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_gpu_driver_path", value)

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the data disk in GB attached to this instance,
        up to a maximum of 64000 GB (64 TB).
        You can choose the size of the data disk based on how big your notebooks and data are.
        If not specified, this defaults to 100.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @data_disk_size_gb.setter
    def data_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_disk_size_gb", value)

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Possible disk types for notebook instances.
        Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        """
        return pulumi.get(self, "data_disk_type")

    @data_disk_type.setter
    def data_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_disk_type", value)

    @property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Disk encryption method used on the boot and data disks, defaults to GMEK.
        Possible values are `DISK_ENCRYPTION_UNSPECIFIED`, `GMEK`, and `CMEK`.
        """
        return pulumi.get(self, "disk_encryption")

    @disk_encryption.setter
    def disk_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption", value)

    @property
    @pulumi.getter(name="installGpuDriver")
    def install_gpu_driver(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the end user authorizes Google Cloud to install GPU driver
        on this instance. If this field is empty or set to false, the GPU driver
        won't be installed. Only applicable to instances with GPUs.
        """
        return pulumi.get(self, "install_gpu_driver")

    @install_gpu_driver.setter
    def install_gpu_driver(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_gpu_driver", value)

    @property
    @pulumi.getter(name="instanceOwners")
    def instance_owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of owners of this instance after creation.
        Format: alias@example.com.
        Currently supports one owner only.
        If not specified, all of the service account users of
        your VM instance's service account can use the instance.
        """
        return pulumi.get(self, "instance_owners")

    @instance_owners.setter
    def instance_owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_owners", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
        Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this instance. These can be later modified by the setLabels method.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Custom metadata to apply to this instance.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name specified for the Notebook instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC that this instance is in.
        Format: projects/{project_id}/global/networks/{network_id}
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="noProxyAccess")
    def no_proxy_access(self) -> Optional[pulumi.Input[bool]]:
        """
        The notebook instance will not register with the proxy..
        """
        return pulumi.get(self, "no_proxy_access")

    @no_proxy_access.setter
    def no_proxy_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_proxy_access", value)

    @property
    @pulumi.getter(name="noPublicIp")
    def no_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        No public IP will be assigned to this instance.
        """
        return pulumi.get(self, "no_public_ip")

    @no_public_ip.setter
    def no_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_public_ip", value)

    @property
    @pulumi.getter(name="noRemoveDataDisk")
    def no_remove_data_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the data disk will not be auto deleted when deleting the instance.
        """
        return pulumi.get(self, "no_remove_data_disk")

    @no_remove_data_disk.setter
    def no_remove_data_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_remove_data_disk", value)

    @property
    @pulumi.getter(name="postStartupScript")
    def post_startup_script(self) -> Optional[pulumi.Input[str]]:
        """
        Path to a Bash script that automatically runs after a
        notebook instance fully boots up. The path must be a URL
        or Cloud Storage path (gs://path-to-file/file-name).
        """
        return pulumi.get(self, "post_startup_script")

    @post_startup_script.setter
    def post_startup_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post_startup_script", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Google Cloud project that this VM image belongs to.
        Format: projects/{project_id}
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The service account on this instance, giving access to other
        Google Cloud services. You can use any service account within
        the same project, but you must have the service account user
        permission to use the instance. If not specified,
        the Compute Engine default service account is used.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The URIs of service account scopes to be included in Compute Engine instances.
        If not specified, the following scopes are defined:
        - https://www.googleapis.com/auth/cloud-platform
        - https://www.googleapis.com/auth/userinfo.email
        """
        return pulumi.get(self, "service_account_scopes")

    @service_account_scopes.setter
    def service_account_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_account_scopes", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']]:
        """
        A set of Shielded Instance options. Check [Images using supported Shielded VM features]
        Not all combinations are valid
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnet that this instance is in.
        Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Compute Engine tags to add to runtime.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Instance update time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> Optional[pulumi.Input['InstanceVmImageArgs']]:
        """
        Use a Compute Engine VM image to start the notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "vm_image")

    @vm_image.setter
    def vm_image(self, value: Optional[pulumi.Input['InstanceVmImageArgs']]):
        pulumi.set(self, "vm_image", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 accelerator_config: Optional[pulumi.Input['InstanceAcceleratorConfigArgs']] = None,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 container_image: Optional[pulumi.Input['InstanceContainerImageArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 custom_gpu_driver_path: Optional[pulumi.Input[str]] = None,
                 data_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 data_disk_type: Optional[pulumi.Input[str]] = None,
                 disk_encryption: Optional[pulumi.Input[str]] = None,
                 install_gpu_driver: Optional[pulumi.Input[bool]] = None,
                 instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 no_proxy_access: Optional[pulumi.Input[bool]] = None,
                 no_public_ip: Optional[pulumi.Input[bool]] = None,
                 no_remove_data_disk: Optional[pulumi.Input[bool]] = None,
                 post_startup_script: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 proxy_uri: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 service_account_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shielded_instance_config: Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vm_image: Optional[pulumi.Input['InstanceVmImageArgs']] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input['InstanceAcceleratorConfigArgs'] accelerator_config: The hardware accelerator used on this instance. If you use accelerators,
               make sure that your configuration has enough vCPUs and memory to support the
               machineType you have selected.
               Structure is documented below.
        :param pulumi.Input[int] boot_disk_size_gb: The size of the boot disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] boot_disk_type: Possible disk types for notebook instances.
               Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        :param pulumi.Input['InstanceContainerImageArgs'] container_image: Use a container image to start the notebook instance.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Instance creation time
        :param pulumi.Input[str] custom_gpu_driver_path: Specify a custom Cloud Storage path where the GPU driver is stored.
               If not specified, we'll automatically choose from official GPU drivers.
        :param pulumi.Input[int] data_disk_size_gb: The size of the data disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB).
               You can choose the size of the data disk based on how big your notebooks and data are.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] data_disk_type: Possible disk types for notebook instances.
               Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        :param pulumi.Input[str] disk_encryption: Disk encryption method used on the boot and data disks, defaults to GMEK.
               Possible values are `DISK_ENCRYPTION_UNSPECIFIED`, `GMEK`, and `CMEK`.
        :param pulumi.Input[bool] install_gpu_driver: Whether the end user authorizes Google Cloud to install GPU driver
               on this instance. If this field is empty or set to false, the GPU driver
               won't be installed. Only applicable to instances with GPUs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_owners: The list of owners of this instance after creation.
               Format: alias@example.com.
               Currently supports one owner only.
               If not specified, all of the service account users of
               your VM instance's service account can use the instance.
        :param pulumi.Input[str] kms_key: The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
               Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this instance. These can be later modified by the setLabels method.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] location: A reference to the zone where the machine resides.
        :param pulumi.Input[str] machine_type: A reference to a machine type which defines VM kind.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Custom metadata to apply to this instance.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] name: The name specified for the Notebook instance.
        :param pulumi.Input[str] network: The name of the VPC that this instance is in.
               Format: projects/{project_id}/global/networks/{network_id}
        :param pulumi.Input[bool] no_proxy_access: The notebook instance will not register with the proxy..
        :param pulumi.Input[bool] no_public_ip: No public IP will be assigned to this instance.
        :param pulumi.Input[bool] no_remove_data_disk: If true, the data disk will not be auto deleted when deleting the instance.
        :param pulumi.Input[str] post_startup_script: Path to a Bash script that automatically runs after a
               notebook instance fully boots up. The path must be a URL
               or Cloud Storage path (gs://path-to-file/file-name).
        :param pulumi.Input[str] project: The name of the Google Cloud project that this VM image belongs to.
               Format: projects/{project_id}
        :param pulumi.Input[str] proxy_uri: The proxy endpoint that is used to access the Jupyter notebook.
        :param pulumi.Input[str] service_account: The service account on this instance, giving access to other
               Google Cloud services. You can use any service account within
               the same project, but you must have the service account user
               permission to use the instance. If not specified,
               the Compute Engine default service account is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_scopes: Optional. The URIs of service account scopes to be included in Compute Engine instances.
               If not specified, the following scopes are defined:
               - https://www.googleapis.com/auth/cloud-platform
               - https://www.googleapis.com/auth/userinfo.email
        :param pulumi.Input['InstanceShieldedInstanceConfigArgs'] shielded_instance_config: A set of Shielded Instance options. Check [Images using supported Shielded VM features]
               Not all combinations are valid
               Structure is documented below.
        :param pulumi.Input[str] state: The state of this instance.
        :param pulumi.Input[str] subnet: The name of the subnet that this instance is in.
               Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The Compute Engine tags to add to runtime.
        :param pulumi.Input[str] update_time: Instance update time.
        :param pulumi.Input['InstanceVmImageArgs'] vm_image: Use a Compute Engine VM image to start the notebook instance.
               Structure is documented below.
        """
        if accelerator_config is not None:
            pulumi.set(__self__, "accelerator_config", accelerator_config)
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_gpu_driver_path is not None:
            pulumi.set(__self__, "custom_gpu_driver_path", custom_gpu_driver_path)
        if data_disk_size_gb is not None:
            pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        if data_disk_type is not None:
            pulumi.set(__self__, "data_disk_type", data_disk_type)
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if install_gpu_driver is not None:
            pulumi.set(__self__, "install_gpu_driver", install_gpu_driver)
        if instance_owners is not None:
            pulumi.set(__self__, "instance_owners", instance_owners)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if no_proxy_access is not None:
            pulumi.set(__self__, "no_proxy_access", no_proxy_access)
        if no_public_ip is not None:
            pulumi.set(__self__, "no_public_ip", no_public_ip)
        if no_remove_data_disk is not None:
            pulumi.set(__self__, "no_remove_data_disk", no_remove_data_disk)
        if post_startup_script is not None:
            pulumi.set(__self__, "post_startup_script", post_startup_script)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy_uri is not None:
            pulumi.set(__self__, "proxy_uri", proxy_uri)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes is not None:
            pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vm_image is not None:
            pulumi.set(__self__, "vm_image", vm_image)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> Optional[pulumi.Input['InstanceAcceleratorConfigArgs']]:
        """
        The hardware accelerator used on this instance. If you use accelerators,
        make sure that your configuration has enough vCPUs and memory to support the
        machineType you have selected.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerator_config")

    @accelerator_config.setter
    def accelerator_config(self, value: Optional[pulumi.Input['InstanceAcceleratorConfigArgs']]):
        pulumi.set(self, "accelerator_config", value)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the boot disk in GB attached to this instance,
        up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
        If not specified, this defaults to 100.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Possible disk types for notebook instances.
        Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[pulumi.Input['InstanceContainerImageArgs']]:
        """
        Use a container image to start the notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "container_image")

    @container_image.setter
    def container_image(self, value: Optional[pulumi.Input['InstanceContainerImageArgs']]):
        pulumi.set(self, "container_image", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Instance creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="customGpuDriverPath")
    def custom_gpu_driver_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a custom Cloud Storage path where the GPU driver is stored.
        If not specified, we'll automatically choose from official GPU drivers.
        """
        return pulumi.get(self, "custom_gpu_driver_path")

    @custom_gpu_driver_path.setter
    def custom_gpu_driver_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_gpu_driver_path", value)

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the data disk in GB attached to this instance,
        up to a maximum of 64000 GB (64 TB).
        You can choose the size of the data disk based on how big your notebooks and data are.
        If not specified, this defaults to 100.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @data_disk_size_gb.setter
    def data_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_disk_size_gb", value)

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Possible disk types for notebook instances.
        Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        """
        return pulumi.get(self, "data_disk_type")

    @data_disk_type.setter
    def data_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_disk_type", value)

    @property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Disk encryption method used on the boot and data disks, defaults to GMEK.
        Possible values are `DISK_ENCRYPTION_UNSPECIFIED`, `GMEK`, and `CMEK`.
        """
        return pulumi.get(self, "disk_encryption")

    @disk_encryption.setter
    def disk_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption", value)

    @property
    @pulumi.getter(name="installGpuDriver")
    def install_gpu_driver(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the end user authorizes Google Cloud to install GPU driver
        on this instance. If this field is empty or set to false, the GPU driver
        won't be installed. Only applicable to instances with GPUs.
        """
        return pulumi.get(self, "install_gpu_driver")

    @install_gpu_driver.setter
    def install_gpu_driver(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_gpu_driver", value)

    @property
    @pulumi.getter(name="instanceOwners")
    def instance_owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of owners of this instance after creation.
        Format: alias@example.com.
        Currently supports one owner only.
        If not specified, all of the service account users of
        your VM instance's service account can use the instance.
        """
        return pulumi.get(self, "instance_owners")

    @instance_owners.setter
    def instance_owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_owners", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
        Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this instance. These can be later modified by the setLabels method.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to the zone where the machine resides.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to a machine type which defines VM kind.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Custom metadata to apply to this instance.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name specified for the Notebook instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC that this instance is in.
        Format: projects/{project_id}/global/networks/{network_id}
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="noProxyAccess")
    def no_proxy_access(self) -> Optional[pulumi.Input[bool]]:
        """
        The notebook instance will not register with the proxy..
        """
        return pulumi.get(self, "no_proxy_access")

    @no_proxy_access.setter
    def no_proxy_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_proxy_access", value)

    @property
    @pulumi.getter(name="noPublicIp")
    def no_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        No public IP will be assigned to this instance.
        """
        return pulumi.get(self, "no_public_ip")

    @no_public_ip.setter
    def no_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_public_ip", value)

    @property
    @pulumi.getter(name="noRemoveDataDisk")
    def no_remove_data_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the data disk will not be auto deleted when deleting the instance.
        """
        return pulumi.get(self, "no_remove_data_disk")

    @no_remove_data_disk.setter
    def no_remove_data_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_remove_data_disk", value)

    @property
    @pulumi.getter(name="postStartupScript")
    def post_startup_script(self) -> Optional[pulumi.Input[str]]:
        """
        Path to a Bash script that automatically runs after a
        notebook instance fully boots up. The path must be a URL
        or Cloud Storage path (gs://path-to-file/file-name).
        """
        return pulumi.get(self, "post_startup_script")

    @post_startup_script.setter
    def post_startup_script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post_startup_script", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Google Cloud project that this VM image belongs to.
        Format: projects/{project_id}
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="proxyUri")
    def proxy_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The proxy endpoint that is used to access the Jupyter notebook.
        """
        return pulumi.get(self, "proxy_uri")

    @proxy_uri.setter
    def proxy_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_uri", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The service account on this instance, giving access to other
        Google Cloud services. You can use any service account within
        the same project, but you must have the service account user
        permission to use the instance. If not specified,
        the Compute Engine default service account is used.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The URIs of service account scopes to be included in Compute Engine instances.
        If not specified, the following scopes are defined:
        - https://www.googleapis.com/auth/cloud-platform
        - https://www.googleapis.com/auth/userinfo.email
        """
        return pulumi.get(self, "service_account_scopes")

    @service_account_scopes.setter
    def service_account_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_account_scopes", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']]:
        """
        A set of Shielded Instance options. Check [Images using supported Shielded VM features]
        Not all combinations are valid
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of this instance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnet that this instance is in.
        Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Compute Engine tags to add to runtime.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Instance update time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> Optional[pulumi.Input['InstanceVmImageArgs']]:
        """
        Use a Compute Engine VM image to start the notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "vm_image")

    @vm_image.setter
    def vm_image(self, value: Optional[pulumi.Input['InstanceVmImageArgs']]):
        pulumi.set(self, "vm_image", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_config: Optional[pulumi.Input[pulumi.InputType['InstanceAcceleratorConfigArgs']]] = None,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 container_image: Optional[pulumi.Input[pulumi.InputType['InstanceContainerImageArgs']]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 custom_gpu_driver_path: Optional[pulumi.Input[str]] = None,
                 data_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 data_disk_type: Optional[pulumi.Input[str]] = None,
                 disk_encryption: Optional[pulumi.Input[str]] = None,
                 install_gpu_driver: Optional[pulumi.Input[bool]] = None,
                 instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 no_proxy_access: Optional[pulumi.Input[bool]] = None,
                 no_public_ip: Optional[pulumi.Input[bool]] = None,
                 no_remove_data_disk: Optional[pulumi.Input[bool]] = None,
                 post_startup_script: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 service_account_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceShieldedInstanceConfigArgs']]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vm_image: Optional[pulumi.Input[pulumi.InputType['InstanceVmImageArgs']]] = None,
                 __props__=None):
        """
        A Cloud AI Platform Notebook instance.

        > **Note:** Due to limitations of the Notebooks Instance API, many fields
        in this resource do not properly detect drift. These fields will also not
        appear in state once imported.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/ai-platform/notebooks/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/ai-platform-notebooks)

        ## Example Usage
        ### Notebook Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.notebooks.Instance("instance",
            location="us-west1-a",
            machine_type="e2-medium",
            vm_image=gcp.notebooks.InstanceVmImageArgs(
                image_family="tf-latest-cpu",
                project="deeplearning-platform-release",
            ))
        ```
        ### Notebook Instance Basic Container

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.notebooks.Instance("instance",
            container_image=gcp.notebooks.InstanceContainerImageArgs(
                repository="gcr.io/deeplearning-platform-release/base-cpu",
                tag="latest",
            ),
            location="us-west1-a",
            machine_type="e2-medium",
            metadata={
                "proxy-mode": "service_account",
            })
        ```
        ### Notebook Instance Basic Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.notebooks.Instance("instance",
            accelerator_config=gcp.notebooks.InstanceAcceleratorConfigArgs(
                core_count=1,
                type="NVIDIA_TESLA_T4",
            ),
            install_gpu_driver=True,
            location="us-west1-a",
            machine_type="n1-standard-1",
            vm_image=gcp.notebooks.InstanceVmImageArgs(
                image_family="tf-latest-gpu",
                project="deeplearning-platform-release",
            ))
        ```
        ### Notebook Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.get_network(name="default")
        my_subnetwork = gcp.compute.get_subnetwork(name="default",
            region="us-central1")
        instance = gcp.notebooks.Instance("instance",
            location="us-central1-a",
            machine_type="e2-medium",
            vm_image=gcp.notebooks.InstanceVmImageArgs(
                project="deeplearning-platform-release",
                image_family="tf-latest-cpu",
            ),
            instance_owners=["admin@hashicorptest.com"],
            service_account="emailAddress:my@service-account.com",
            install_gpu_driver=True,
            boot_disk_type="PD_SSD",
            boot_disk_size_gb=110,
            no_public_ip=True,
            no_proxy_access=True,
            network=my_network.id,
            subnet=my_subnetwork.id,
            labels={
                "k": "val",
            })
        ```

        ## Import

        Instance can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:notebooks/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{name}}
        ```

        ```sh
         $ pulumi import gcp:notebooks/instance:Instance default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:notebooks/instance:Instance default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InstanceAcceleratorConfigArgs']] accelerator_config: The hardware accelerator used on this instance. If you use accelerators,
               make sure that your configuration has enough vCPUs and memory to support the
               machineType you have selected.
               Structure is documented below.
        :param pulumi.Input[int] boot_disk_size_gb: The size of the boot disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] boot_disk_type: Possible disk types for notebook instances.
               Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        :param pulumi.Input[pulumi.InputType['InstanceContainerImageArgs']] container_image: Use a container image to start the notebook instance.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Instance creation time
        :param pulumi.Input[str] custom_gpu_driver_path: Specify a custom Cloud Storage path where the GPU driver is stored.
               If not specified, we'll automatically choose from official GPU drivers.
        :param pulumi.Input[int] data_disk_size_gb: The size of the data disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB).
               You can choose the size of the data disk based on how big your notebooks and data are.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] data_disk_type: Possible disk types for notebook instances.
               Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        :param pulumi.Input[str] disk_encryption: Disk encryption method used on the boot and data disks, defaults to GMEK.
               Possible values are `DISK_ENCRYPTION_UNSPECIFIED`, `GMEK`, and `CMEK`.
        :param pulumi.Input[bool] install_gpu_driver: Whether the end user authorizes Google Cloud to install GPU driver
               on this instance. If this field is empty or set to false, the GPU driver
               won't be installed. Only applicable to instances with GPUs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_owners: The list of owners of this instance after creation.
               Format: alias@example.com.
               Currently supports one owner only.
               If not specified, all of the service account users of
               your VM instance's service account can use the instance.
        :param pulumi.Input[str] kms_key: The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
               Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this instance. These can be later modified by the setLabels method.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] location: A reference to the zone where the machine resides.
        :param pulumi.Input[str] machine_type: A reference to a machine type which defines VM kind.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Custom metadata to apply to this instance.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] name: The name specified for the Notebook instance.
        :param pulumi.Input[str] network: The name of the VPC that this instance is in.
               Format: projects/{project_id}/global/networks/{network_id}
        :param pulumi.Input[bool] no_proxy_access: The notebook instance will not register with the proxy..
        :param pulumi.Input[bool] no_public_ip: No public IP will be assigned to this instance.
        :param pulumi.Input[bool] no_remove_data_disk: If true, the data disk will not be auto deleted when deleting the instance.
        :param pulumi.Input[str] post_startup_script: Path to a Bash script that automatically runs after a
               notebook instance fully boots up. The path must be a URL
               or Cloud Storage path (gs://path-to-file/file-name).
        :param pulumi.Input[str] project: The name of the Google Cloud project that this VM image belongs to.
               Format: projects/{project_id}
        :param pulumi.Input[str] service_account: The service account on this instance, giving access to other
               Google Cloud services. You can use any service account within
               the same project, but you must have the service account user
               permission to use the instance. If not specified,
               the Compute Engine default service account is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_scopes: Optional. The URIs of service account scopes to be included in Compute Engine instances.
               If not specified, the following scopes are defined:
               - https://www.googleapis.com/auth/cloud-platform
               - https://www.googleapis.com/auth/userinfo.email
        :param pulumi.Input[pulumi.InputType['InstanceShieldedInstanceConfigArgs']] shielded_instance_config: A set of Shielded Instance options. Check [Images using supported Shielded VM features]
               Not all combinations are valid
               Structure is documented below.
        :param pulumi.Input[str] subnet: The name of the subnet that this instance is in.
               Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The Compute Engine tags to add to runtime.
        :param pulumi.Input[str] update_time: Instance update time.
        :param pulumi.Input[pulumi.InputType['InstanceVmImageArgs']] vm_image: Use a Compute Engine VM image to start the notebook instance.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud AI Platform Notebook instance.

        > **Note:** Due to limitations of the Notebooks Instance API, many fields
        in this resource do not properly detect drift. These fields will also not
        appear in state once imported.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/ai-platform/notebooks/docs/reference/rest)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/ai-platform-notebooks)

        ## Example Usage
        ### Notebook Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.notebooks.Instance("instance",
            location="us-west1-a",
            machine_type="e2-medium",
            vm_image=gcp.notebooks.InstanceVmImageArgs(
                image_family="tf-latest-cpu",
                project="deeplearning-platform-release",
            ))
        ```
        ### Notebook Instance Basic Container

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.notebooks.Instance("instance",
            container_image=gcp.notebooks.InstanceContainerImageArgs(
                repository="gcr.io/deeplearning-platform-release/base-cpu",
                tag="latest",
            ),
            location="us-west1-a",
            machine_type="e2-medium",
            metadata={
                "proxy-mode": "service_account",
            })
        ```
        ### Notebook Instance Basic Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.notebooks.Instance("instance",
            accelerator_config=gcp.notebooks.InstanceAcceleratorConfigArgs(
                core_count=1,
                type="NVIDIA_TESLA_T4",
            ),
            install_gpu_driver=True,
            location="us-west1-a",
            machine_type="n1-standard-1",
            vm_image=gcp.notebooks.InstanceVmImageArgs(
                image_family="tf-latest-gpu",
                project="deeplearning-platform-release",
            ))
        ```
        ### Notebook Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.get_network(name="default")
        my_subnetwork = gcp.compute.get_subnetwork(name="default",
            region="us-central1")
        instance = gcp.notebooks.Instance("instance",
            location="us-central1-a",
            machine_type="e2-medium",
            vm_image=gcp.notebooks.InstanceVmImageArgs(
                project="deeplearning-platform-release",
                image_family="tf-latest-cpu",
            ),
            instance_owners=["admin@hashicorptest.com"],
            service_account="emailAddress:my@service-account.com",
            install_gpu_driver=True,
            boot_disk_type="PD_SSD",
            boot_disk_size_gb=110,
            no_public_ip=True,
            no_proxy_access=True,
            network=my_network.id,
            subnet=my_subnetwork.id,
            labels={
                "k": "val",
            })
        ```

        ## Import

        Instance can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:notebooks/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{name}}
        ```

        ```sh
         $ pulumi import gcp:notebooks/instance:Instance default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:notebooks/instance:Instance default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_config: Optional[pulumi.Input[pulumi.InputType['InstanceAcceleratorConfigArgs']]] = None,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 container_image: Optional[pulumi.Input[pulumi.InputType['InstanceContainerImageArgs']]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 custom_gpu_driver_path: Optional[pulumi.Input[str]] = None,
                 data_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 data_disk_type: Optional[pulumi.Input[str]] = None,
                 disk_encryption: Optional[pulumi.Input[str]] = None,
                 install_gpu_driver: Optional[pulumi.Input[bool]] = None,
                 instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 no_proxy_access: Optional[pulumi.Input[bool]] = None,
                 no_public_ip: Optional[pulumi.Input[bool]] = None,
                 no_remove_data_disk: Optional[pulumi.Input[bool]] = None,
                 post_startup_script: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 service_account_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceShieldedInstanceConfigArgs']]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vm_image: Optional[pulumi.Input[pulumi.InputType['InstanceVmImageArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["accelerator_config"] = accelerator_config
            __props__.__dict__["boot_disk_size_gb"] = boot_disk_size_gb
            __props__.__dict__["boot_disk_type"] = boot_disk_type
            __props__.__dict__["container_image"] = container_image
            __props__.__dict__["create_time"] = create_time
            __props__.__dict__["custom_gpu_driver_path"] = custom_gpu_driver_path
            __props__.__dict__["data_disk_size_gb"] = data_disk_size_gb
            __props__.__dict__["data_disk_type"] = data_disk_type
            __props__.__dict__["disk_encryption"] = disk_encryption
            __props__.__dict__["install_gpu_driver"] = install_gpu_driver
            __props__.__dict__["instance_owners"] = instance_owners
            __props__.__dict__["kms_key"] = kms_key
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if machine_type is None and not opts.urn:
                raise TypeError("Missing required property 'machine_type'")
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["no_proxy_access"] = no_proxy_access
            __props__.__dict__["no_public_ip"] = no_public_ip
            __props__.__dict__["no_remove_data_disk"] = no_remove_data_disk
            __props__.__dict__["post_startup_script"] = post_startup_script
            __props__.__dict__["project"] = project
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["service_account_scopes"] = service_account_scopes
            __props__.__dict__["shielded_instance_config"] = shielded_instance_config
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["tags"] = tags
            __props__.__dict__["update_time"] = update_time
            __props__.__dict__["vm_image"] = vm_image
            __props__.__dict__["proxy_uri"] = None
            __props__.__dict__["state"] = None
        super(Instance, __self__).__init__(
            'gcp:notebooks/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_config: Optional[pulumi.Input[pulumi.InputType['InstanceAcceleratorConfigArgs']]] = None,
            boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
            boot_disk_type: Optional[pulumi.Input[str]] = None,
            container_image: Optional[pulumi.Input[pulumi.InputType['InstanceContainerImageArgs']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            custom_gpu_driver_path: Optional[pulumi.Input[str]] = None,
            data_disk_size_gb: Optional[pulumi.Input[int]] = None,
            data_disk_type: Optional[pulumi.Input[str]] = None,
            disk_encryption: Optional[pulumi.Input[str]] = None,
            install_gpu_driver: Optional[pulumi.Input[bool]] = None,
            instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            kms_key: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            machine_type: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            no_proxy_access: Optional[pulumi.Input[bool]] = None,
            no_public_ip: Optional[pulumi.Input[bool]] = None,
            no_remove_data_disk: Optional[pulumi.Input[bool]] = None,
            post_startup_script: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            proxy_uri: Optional[pulumi.Input[str]] = None,
            service_account: Optional[pulumi.Input[str]] = None,
            service_account_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceShieldedInstanceConfigArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            vm_image: Optional[pulumi.Input[pulumi.InputType['InstanceVmImageArgs']]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InstanceAcceleratorConfigArgs']] accelerator_config: The hardware accelerator used on this instance. If you use accelerators,
               make sure that your configuration has enough vCPUs and memory to support the
               machineType you have selected.
               Structure is documented below.
        :param pulumi.Input[int] boot_disk_size_gb: The size of the boot disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] boot_disk_type: Possible disk types for notebook instances.
               Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        :param pulumi.Input[pulumi.InputType['InstanceContainerImageArgs']] container_image: Use a container image to start the notebook instance.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Instance creation time
        :param pulumi.Input[str] custom_gpu_driver_path: Specify a custom Cloud Storage path where the GPU driver is stored.
               If not specified, we'll automatically choose from official GPU drivers.
        :param pulumi.Input[int] data_disk_size_gb: The size of the data disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB).
               You can choose the size of the data disk based on how big your notebooks and data are.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] data_disk_type: Possible disk types for notebook instances.
               Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        :param pulumi.Input[str] disk_encryption: Disk encryption method used on the boot and data disks, defaults to GMEK.
               Possible values are `DISK_ENCRYPTION_UNSPECIFIED`, `GMEK`, and `CMEK`.
        :param pulumi.Input[bool] install_gpu_driver: Whether the end user authorizes Google Cloud to install GPU driver
               on this instance. If this field is empty or set to false, the GPU driver
               won't be installed. Only applicable to instances with GPUs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_owners: The list of owners of this instance after creation.
               Format: alias@example.com.
               Currently supports one owner only.
               If not specified, all of the service account users of
               your VM instance's service account can use the instance.
        :param pulumi.Input[str] kms_key: The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
               Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this instance. These can be later modified by the setLabels method.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] location: A reference to the zone where the machine resides.
        :param pulumi.Input[str] machine_type: A reference to a machine type which defines VM kind.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Custom metadata to apply to this instance.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] name: The name specified for the Notebook instance.
        :param pulumi.Input[str] network: The name of the VPC that this instance is in.
               Format: projects/{project_id}/global/networks/{network_id}
        :param pulumi.Input[bool] no_proxy_access: The notebook instance will not register with the proxy..
        :param pulumi.Input[bool] no_public_ip: No public IP will be assigned to this instance.
        :param pulumi.Input[bool] no_remove_data_disk: If true, the data disk will not be auto deleted when deleting the instance.
        :param pulumi.Input[str] post_startup_script: Path to a Bash script that automatically runs after a
               notebook instance fully boots up. The path must be a URL
               or Cloud Storage path (gs://path-to-file/file-name).
        :param pulumi.Input[str] project: The name of the Google Cloud project that this VM image belongs to.
               Format: projects/{project_id}
        :param pulumi.Input[str] proxy_uri: The proxy endpoint that is used to access the Jupyter notebook.
        :param pulumi.Input[str] service_account: The service account on this instance, giving access to other
               Google Cloud services. You can use any service account within
               the same project, but you must have the service account user
               permission to use the instance. If not specified,
               the Compute Engine default service account is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_scopes: Optional. The URIs of service account scopes to be included in Compute Engine instances.
               If not specified, the following scopes are defined:
               - https://www.googleapis.com/auth/cloud-platform
               - https://www.googleapis.com/auth/userinfo.email
        :param pulumi.Input[pulumi.InputType['InstanceShieldedInstanceConfigArgs']] shielded_instance_config: A set of Shielded Instance options. Check [Images using supported Shielded VM features]
               Not all combinations are valid
               Structure is documented below.
        :param pulumi.Input[str] state: The state of this instance.
        :param pulumi.Input[str] subnet: The name of the subnet that this instance is in.
               Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The Compute Engine tags to add to runtime.
        :param pulumi.Input[str] update_time: Instance update time.
        :param pulumi.Input[pulumi.InputType['InstanceVmImageArgs']] vm_image: Use a Compute Engine VM image to start the notebook instance.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["accelerator_config"] = accelerator_config
        __props__.__dict__["boot_disk_size_gb"] = boot_disk_size_gb
        __props__.__dict__["boot_disk_type"] = boot_disk_type
        __props__.__dict__["container_image"] = container_image
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_gpu_driver_path"] = custom_gpu_driver_path
        __props__.__dict__["data_disk_size_gb"] = data_disk_size_gb
        __props__.__dict__["data_disk_type"] = data_disk_type
        __props__.__dict__["disk_encryption"] = disk_encryption
        __props__.__dict__["install_gpu_driver"] = install_gpu_driver
        __props__.__dict__["instance_owners"] = instance_owners
        __props__.__dict__["kms_key"] = kms_key
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["no_proxy_access"] = no_proxy_access
        __props__.__dict__["no_public_ip"] = no_public_ip
        __props__.__dict__["no_remove_data_disk"] = no_remove_data_disk
        __props__.__dict__["post_startup_script"] = post_startup_script
        __props__.__dict__["project"] = project
        __props__.__dict__["proxy_uri"] = proxy_uri
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["service_account_scopes"] = service_account_scopes
        __props__.__dict__["shielded_instance_config"] = shielded_instance_config
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vm_image"] = vm_image
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> pulumi.Output[Optional['outputs.InstanceAcceleratorConfig']]:
        """
        The hardware accelerator used on this instance. If you use accelerators,
        make sure that your configuration has enough vCPUs and memory to support the
        machineType you have selected.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerator_config")

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> pulumi.Output[Optional[int]]:
        """
        The size of the boot disk in GB attached to this instance,
        up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
        If not specified, this defaults to 100.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> pulumi.Output[Optional[str]]:
        """
        Possible disk types for notebook instances.
        Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        """
        return pulumi.get(self, "boot_disk_type")

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> pulumi.Output[Optional['outputs.InstanceContainerImage']]:
        """
        Use a container image to start the notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "container_image")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Instance creation time
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customGpuDriverPath")
    def custom_gpu_driver_path(self) -> pulumi.Output[Optional[str]]:
        """
        Specify a custom Cloud Storage path where the GPU driver is stored.
        If not specified, we'll automatically choose from official GPU drivers.
        """
        return pulumi.get(self, "custom_gpu_driver_path")

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> pulumi.Output[Optional[int]]:
        """
        The size of the data disk in GB attached to this instance,
        up to a maximum of 64000 GB (64 TB).
        You can choose the size of the data disk based on how big your notebooks and data are.
        If not specified, this defaults to 100.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> pulumi.Output[Optional[str]]:
        """
        Possible disk types for notebook instances.
        Possible values are `DISK_TYPE_UNSPECIFIED`, `PD_STANDARD`, `PD_SSD`, and `PD_BALANCED`.
        """
        return pulumi.get(self, "data_disk_type")

    @property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> pulumi.Output[Optional[str]]:
        """
        Disk encryption method used on the boot and data disks, defaults to GMEK.
        Possible values are `DISK_ENCRYPTION_UNSPECIFIED`, `GMEK`, and `CMEK`.
        """
        return pulumi.get(self, "disk_encryption")

    @property
    @pulumi.getter(name="installGpuDriver")
    def install_gpu_driver(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the end user authorizes Google Cloud to install GPU driver
        on this instance. If this field is empty or set to false, the GPU driver
        won't be installed. Only applicable to instances with GPUs.
        """
        return pulumi.get(self, "install_gpu_driver")

    @property
    @pulumi.getter(name="instanceOwners")
    def instance_owners(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of owners of this instance after creation.
        Format: alias@example.com.
        Currently supports one owner only.
        If not specified, all of the service account users of
        your VM instance's service account can use the instance.
        """
        return pulumi.get(self, "instance_owners")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[Optional[str]]:
        """
        The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
        Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels to apply to this instance. These can be later modified by the setLabels method.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        A reference to the zone where the machine resides.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[str]:
        """
        A reference to a machine type which defines VM kind.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Custom metadata to apply to this instance.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name specified for the Notebook instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The name of the VPC that this instance is in.
        Format: projects/{project_id}/global/networks/{network_id}
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="noProxyAccess")
    def no_proxy_access(self) -> pulumi.Output[Optional[bool]]:
        """
        The notebook instance will not register with the proxy..
        """
        return pulumi.get(self, "no_proxy_access")

    @property
    @pulumi.getter(name="noPublicIp")
    def no_public_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        No public IP will be assigned to this instance.
        """
        return pulumi.get(self, "no_public_ip")

    @property
    @pulumi.getter(name="noRemoveDataDisk")
    def no_remove_data_disk(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the data disk will not be auto deleted when deleting the instance.
        """
        return pulumi.get(self, "no_remove_data_disk")

    @property
    @pulumi.getter(name="postStartupScript")
    def post_startup_script(self) -> pulumi.Output[Optional[str]]:
        """
        Path to a Bash script that automatically runs after a
        notebook instance fully boots up. The path must be a URL
        or Cloud Storage path (gs://path-to-file/file-name).
        """
        return pulumi.get(self, "post_startup_script")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name of the Google Cloud project that this VM image belongs to.
        Format: projects/{project_id}
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="proxyUri")
    def proxy_uri(self) -> pulumi.Output[str]:
        """
        The proxy endpoint that is used to access the Jupyter notebook.
        """
        return pulumi.get(self, "proxy_uri")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[str]:
        """
        The service account on this instance, giving access to other
        Google Cloud services. You can use any service account within
        the same project, but you must have the service account user
        permission to use the instance. If not specified,
        the Compute Engine default service account is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Optional. The URIs of service account scopes to be included in Compute Engine instances.
        If not specified, the following scopes are defined:
        - https://www.googleapis.com/auth/cloud-platform
        - https://www.googleapis.com/auth/userinfo.email
        """
        return pulumi.get(self, "service_account_scopes")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output['outputs.InstanceShieldedInstanceConfig']:
        """
        A set of Shielded Instance options. Check [Images using supported Shielded VM features]
        Not all combinations are valid
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of this instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[str]:
        """
        The name of the subnet that this instance is in.
        Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The Compute Engine tags to add to runtime.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Instance update time.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> pulumi.Output[Optional['outputs.InstanceVmImage']]:
        """
        Use a Compute Engine VM image to start the notebook instance.
        Structure is documented below.
        """
        return pulumi.get(self, "vm_image")

