# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'SecretIamBindingCondition',
    'SecretIamMemberCondition',
    'SecretReplication',
    'SecretReplicationUserManaged',
    'SecretReplicationUserManagedReplica',
]

@pulumi.output_type
class SecretIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SecretIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SecretReplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userManaged":
            suggest = "user_managed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic: Optional[bool] = None,
                 user_managed: Optional['outputs.SecretReplicationUserManaged'] = None):
        """
        :param bool automatic: The Secret will automatically be replicated without any restrictions.
        :param 'SecretReplicationUserManagedArgs' user_managed: The Secret will automatically be replicated without any restrictions.
               Structure is documented below.
        """
        if automatic is not None:
            pulumi.set(__self__, "automatic", automatic)
        if user_managed is not None:
            pulumi.set(__self__, "user_managed", user_managed)

    @property
    @pulumi.getter
    def automatic(self) -> Optional[bool]:
        """
        The Secret will automatically be replicated without any restrictions.
        """
        return pulumi.get(self, "automatic")

    @property
    @pulumi.getter(name="userManaged")
    def user_managed(self) -> Optional['outputs.SecretReplicationUserManaged']:
        """
        The Secret will automatically be replicated without any restrictions.
        Structure is documented below.
        """
        return pulumi.get(self, "user_managed")


@pulumi.output_type
class SecretReplicationUserManaged(dict):
    def __init__(__self__, *,
                 replicas: Sequence['outputs.SecretReplicationUserManagedReplica']):
        """
        :param Sequence['SecretReplicationUserManagedReplicaArgs'] replicas: The list of Replicas for this Secret. Cannot be empty.
               Structure is documented below.
        """
        pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter
    def replicas(self) -> Sequence['outputs.SecretReplicationUserManagedReplica']:
        """
        The list of Replicas for this Secret. Cannot be empty.
        Structure is documented below.
        """
        return pulumi.get(self, "replicas")


@pulumi.output_type
class SecretReplicationUserManagedReplica(dict):
    def __init__(__self__, *,
                 location: str):
        """
        :param str location: The canonical IDs of the location to replicate data. For example: "us-east1".
        """
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The canonical IDs of the location to replicate data. For example: "us-east1".
        """
        return pulumi.get(self, "location")


