"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = exports.TopicProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const datahub_generated_1 = require("./datahub.generated");
Object.defineProperty(exports, "TopicProperty", { enumerable: true, get: function () { return datahub_generated_1.RosTopic; } });
/**
 * A ROS resource type:  `ALIYUN::DATAHUB::Topic`
 */
class Topic extends ros.Resource {
    /**
     * Create a new `ALIYUN::DATAHUB::Topic`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTopic = new datahub_generated_1.RosTopic(this, id, {
            comment: props.comment,
            recordType: props.recordType,
            projectName: props.projectName,
            lifecycle: props.lifecycle ? props.lifecycle : 3,
            recordSchema: props.recordSchema,
            shardCount: props.shardCount ? props.shardCount : 1,
            topicName: props.topicName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTopic;
        this.attrProjectName = rosTopic.attrProjectName;
        this.attrTopicName = rosTopic.attrTopicName;
    }
}
exports.Topic = Topic;
//# sourceMappingURL=data:application/json;base64,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