import * as codecommit from 'aws-cdk-lib/aws-codecommit';
import { SecretValue } from 'aws-cdk-lib';
import { App, ISourceCodeProvider, SourceCodeProviderConfig } from './app';
/**
 * Properties for a GitHub source code provider
 */
export interface GitHubSourceCodeProviderProps {
    /**
     * The user or organization owning the repository
     */
    readonly owner: string;
    /**
     * The name of the repository
     */
    readonly repository: string;
    /**
     * A personal access token with the `repo` scope
     */
    readonly oauthToken: SecretValue;
}
/**
 * GitHub source code provider
 */
export declare class GitHubSourceCodeProvider implements ISourceCodeProvider {
    private readonly props;
    constructor(props: GitHubSourceCodeProviderProps);
    bind(_app: App): SourceCodeProviderConfig;
}
/**
 * Properties for a GitLab source code provider
 */
export interface GitLabSourceCodeProviderProps {
    /**
     * The user or organization owning the repository
     */
    readonly owner: string;
    /**
     * The name of the repository
     */
    readonly repository: string;
    /**
     * A personal access token with the `repo` scope
     */
    readonly oauthToken: SecretValue;
}
/**
 * GitLab source code provider
 */
export declare class GitLabSourceCodeProvider implements ISourceCodeProvider {
    private readonly props;
    constructor(props: GitLabSourceCodeProviderProps);
    bind(_app: App): SourceCodeProviderConfig;
}
/**
 * Properties for a CodeCommit source code provider
 */
export interface CodeCommitSourceCodeProviderProps {
    /**
     * The CodeCommit repository
     */
    readonly repository: codecommit.IRepository;
}
/**
 * CodeCommit source code provider
 */
export declare class CodeCommitSourceCodeProvider implements ISourceCodeProvider {
    private readonly props;
    constructor(props: CodeCommitSourceCodeProviderProps);
    bind(app: App): SourceCodeProviderConfig;
}
