"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Operator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Use condition operators in the `Condition` element to match the condition key and value in the policy against values in the request context.
 *
 * For more information about the `Condition` element, see [IAM JSON Policy Elements: Condition](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
 *
 * The condition operator that you can use in a policy depends on the condition key you choose. You can choose a global condition key or a service-specific condition key. To learn which condition operator you can use for a global condition key, see [AWS Global Condition Context Keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html). To learn which condition operator you can use for a service-specific condition key, see [Actions, Resources, and Condition Keys for AWS Services](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html) and choose the service that you want to view.
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html
 *
 * @experimental
 */
class Operator {
    constructor() {
        this.base = '';
        this.hasIfExists = false;
        this.hasForAllValues = false;
        this.hasForAnyValue = false;
    }
    setBase(base) {
        if (this.base.length) {
            throw new Error(`Operator already set: ${this.base}`);
        }
        this.base = base;
        return this;
    }
    /**
     * @experimental
     */
    toString() {
        let value = this.base;
        if (this.base.length == 0) {
            throw new Error('No operator set');
        }
        if (this.hasIfExists) {
            value += 'IfExists';
        }
        if (this.hasForAllValues) {
            value = `ForAllValues:${value}`;
        }
        if (this.hasForAnyValue) {
            value = `ForAnyValue:${value}`;
        }
        if (this.base == 'Null' && value != this.base) {
            throw new Error(`You cannot add modifiers to the "Null" operator: ${value}`);
        }
        return value;
    }
    /**
     * (experimental) You can add `IfExists` to the end of any condition operator name except the `Null` condition.
     *
     * For example, `StringLikeIfExists`. You do this to say "If the policy key is present in the context of the request, process the key as specified in the policy. If the key is not present, evaluate the condition element as true." Other condition elements in the statement can still result in a nonmatch, but not a missing key when checked with `...IfExists`.
     *
     * @experimental
     */
    ifExists() {
        this.hasIfExists = true;
        return this;
    }
    /**
     * (experimental) Tests whether the value of every member of the request set is a subset of the condition key set.
     *
     * The condition returns true if every key value in the request matches at least one value in the policy. It also returns true if there are no keys in the request, or if the key values resolve to a null data set, such as an empty string.
     *
     * @experimental
     */
    forAllValues() {
        this.hasForAllValues = true;
        return this;
    }
    /**
     * (experimental) Tests whether at least one member of the set of request values matches at least one member of the set of condition key values.
     *
     * The condition returns true if any one of the key values in the request matches any one of the condition values in the policy. For no matching key or a null dataset, the condition returns false.
     *
     * @experimental
     */
    forAnyValue() {
        this.hasForAnyValue = true;
        return this;
    }
    /**
     * (experimental) Exact match, case sensitive.
     *
     * @experimental
     */
    stringEquals() {
        return this.setBase('StringEquals');
    }
    /**
     * (experimental) Negated exact match, case sensitive.
     *
     * @experimental
     */
    stringNotEquals() {
        return this.setBase('StringNotEquals');
    }
    /**
     * (experimental) Exact match, ignore case.
     *
     * @experimental
     */
    stringEqualsIgnoreCase() {
        return this.setBase('StringEqualsIgnoreCase');
    }
    /**
     * (experimental) Exact exact match, ignore case.
     *
     * @experimental
     */
    stringNotEqualsIgnoreCase() {
        return this.setBase('StringNotEqualsIgnoreCase');
    }
    /**
     * (experimental) Case-sensitive match.
     *
     * The values can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`) anywhere in the string.
     *
     * @experimental
     */
    stringLike() {
        return this.setBase('StringLike');
    }
    /**
     * (experimental) Negated case-sensitive matching.
     *
     * The values can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`) anywhere in the string.
     *
     * @experimental
     */
    stringNotLike() {
        return this.setBase('StringNotLike');
    }
    /**
     * (experimental) Exact match.
     *
     * @experimental
     */
    numericEquals() {
        return this.setBase('NumericEquals');
    }
    /**
     * (experimental) Negated exact match.
     *
     * @experimental
     */
    numericNotEquals() {
        return this.setBase('NumericNotEquals');
    }
    /**
     * (experimental) Match numbers lower than value: `<`.
     *
     * @experimental
     */
    numericLessThan() {
        return this.setBase('NumericLessThan');
    }
    /**
     * (experimental) Match numbers lower or equal to value: `<=`.
     *
     * @experimental
     */
    numericLessThanEquals() {
        return this.setBase('NumericLessThanEquals');
    }
    /**
     * (experimental) Match numbers higher than value: `>`.
     *
     * @experimental
     */
    numericGreaterThan() {
        return this.setBase('NumericGreaterThan');
    }
    /**
     * (experimental) Match numbers higher or equal value: `>=`.
     *
     * @experimental
     */
    numericGreaterThanEquals() {
        return this.setBase('NumericGreaterThanEquals');
    }
    /**
     * (experimental) Match a specific date: `=`.
     *
     * @experimental
     */
    dateEquals() {
        return this.setBase('DateEquals');
    }
    /**
     * (experimental) Negated match for a specific date: `!=`.
     *
     * @experimental
     */
    dateNotEquals() {
        return this.setBase('DateNotEquals');
    }
    /**
     * (experimental) Match before a specific date and time: `<`.
     *
     * @experimental
     */
    dateLessThan() {
        return this.setBase('DateLessThan');
    }
    /**
     * (experimental) Match at or before a specific date and time: `<=`.
     *
     * @experimental
     */
    dateLessThanEquals() {
        return this.setBase('DateLessThanEquals');
    }
    /**
     * (experimental) Match after a specific a date and time: `>`.
     *
     * @experimental
     */
    dateGreaterThan() {
        return this.setBase('DateGreaterThan');
    }
    /**
     * (experimental) Match at or after a specific date and time: `>=`.
     *
     * @experimental
     */
    dateGreaterThanEquals() {
        return this.setBase('DateGreaterThanEquals');
    }
    /**
     * (experimental) Boolean match.
     *
     * @experimental
     */
    bool() {
        return this.setBase('Bool');
    }
    /**
     * (experimental) The BinaryEquals condition operator lets you construct Condition elements that test key values that are in binary format.
     *
     * It compares the value of the specified key byte for byte against a [base-64](https://en.wikipedia.org/wiki/Base64) encoded representation of the binary value in the policy.
     *
     * @experimental
     */
    binaryEquals() {
        return this.setBase('BinaryEquals');
    }
    /**
     * (experimental) Match an IP address or range: `=`.
     *
     * @experimental
     */
    ipAddress() {
        return this.setBase('IpAddress');
    }
    /**
     * (experimental) All IP addresses except the specified IP address or range `!=`.
     *
     * @experimental
     */
    notIpAddress() {
        return this.setBase('NotIpAddress');
    }
    /**
     * (experimental) Match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * `ArnEquals` and `ArnLike` behave identical.
     *
     * @experimental
     */
    arnEquals() {
        return this.setBase('ArnEquals');
    }
    /**
     * (experimental) Negated match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * `ArnNotEquals` and `ArnNotLike` behave identical.
     *
     * @experimental
     */
    arnNotEquals() {
        return this.setBase('ArnNotEquals');
    }
    /**
     * (experimental) Match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * @experimental
     */
    arnLike() {
        return this.setBase('ArnLike');
    }
    /**
     * (experimental) Negated match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * `ArnNotEquals` and `ArnNotLike` behave identical.
     *
     * @experimental
     */
    arnNotLike() {
        return this.setBase('ArnNotLike');
    }
    /**
     * (experimental) Check if a key is present at the time of authorization.
     *
     * In the policy statement, use either true (the key doesn't exist — it is null) or false (the key exists and its value is not null).
     *
     * @experimental
     */
    null() {
        return this.setBase('Null');
    }
}
exports.Operator = Operator;
_a = JSII_RTTI_SYMBOL_1;
Operator[_a] = { fqn: "iam-floyd.Operator", version: "0.195.0" };
//# sourceMappingURL=data:application/json;base64,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