import * as iam from 'aws-cdk-lib/aws-iam';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as s3assets from 'aws-cdk-lib/aws-s3-assets';
import * as constructs from 'constructs';
/**
 * (experimental) Represents a Glue Job's Code assets (an asset can be a scripts, a jar, a python file or any other file).
 *
 * @experimental
 */
export declare abstract class Code {
    /**
     * (experimental) Job code as an S3 object.
     *
     * @param bucket The S3 bucket.
     * @param key The object key.
     * @experimental
     */
    static fromBucket(bucket: s3.IBucket, key: string): S3Code;
    /**
     * (experimental) Job code from a local disk path.
     *
     * @param path code file (not a directory).
     * @experimental
     */
    static fromAsset(path: string, options?: s3assets.AssetOptions): AssetCode;
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    abstract bind(scope: constructs.Construct, grantable: iam.IGrantable): CodeConfig;
}
/**
 * (experimental) Glue job Code from an S3 bucket.
 *
 * @experimental
 */
export declare class S3Code extends Code {
    private readonly bucket;
    private readonly key;
    /**
     * @experimental
     */
    constructor(bucket: s3.IBucket, key: string);
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    bind(_scope: constructs.Construct, grantable: iam.IGrantable): CodeConfig;
}
/**
 * (experimental) Job Code from a local file.
 *
 * @experimental
 */
export declare class AssetCode extends Code {
    private readonly path;
    private readonly options;
    private asset?;
    /**
     * @param path The path to the Code file.
     * @experimental
     */
    constructor(path: string, options?: s3assets.AssetOptions);
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    bind(scope: constructs.Construct, grantable: iam.IGrantable): CodeConfig;
    /**
     * Hash a string
     */
    private hashcode;
}
/**
 * (experimental) Result of binding `Code` into a `Job`.
 *
 * @experimental
 */
export interface CodeConfig {
    /**
     * (experimental) The location of the code in S3.
     *
     * @experimental
     */
    readonly s3Location: s3.Location;
}
