import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @experimental
 */
export interface IDatabase extends IResource {
    /**
     * (experimental) The ARN of the catalog.
     *
     * @experimental
     */
    readonly catalogArn: string;
    /**
     * (experimental) The catalog id of the database (usually, the AWS account id).
     *
     * @experimental
     */
    readonly catalogId: string;
    /**
     * (experimental) The ARN of the database.
     *
     * @experimental
     * @attribute true
     */
    readonly databaseArn: string;
    /**
     * (experimental) The name of the database.
     *
     * @experimental
     * @attribute true
     */
    readonly databaseName: string;
}
/**
 * @experimental
 */
export interface DatabaseProps {
    /**
     * (experimental) The name of the database.
     *
     * @experimental
     */
    readonly databaseName: string;
    /**
     * (experimental) The location of the database (for example, an HDFS path).
     *
     * @default undefined. This field is optional in AWS::Glue::Database DatabaseInput
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html
     * @experimental
     */
    readonly locationUri?: string;
}
/**
 * (experimental) A Glue database.
 *
 * @experimental
 */
export declare class Database extends Resource implements IDatabase {
    /**
     * @experimental
     */
    static fromDatabaseArn(scope: Construct, id: string, databaseArn: string): IDatabase;
    /**
     * (experimental) ARN of the Glue catalog in which this database is stored.
     *
     * @experimental
     */
    readonly catalogArn: string;
    /**
     * (experimental) The catalog id of the database (usually, the AWS account id).
     *
     * @experimental
     */
    readonly catalogId: string;
    /**
     * (experimental) ARN of this database.
     *
     * @experimental
     */
    readonly databaseArn: string;
    /**
     * (experimental) Name of this database.
     *
     * @experimental
     */
    readonly databaseName: string;
    /**
     * (experimental) Location URI of this database.
     *
     * @experimental
     */
    readonly locationUri?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DatabaseProps);
}
