# epiccore
REST API for interacting with EPIC (https://epic.zenotech.com) services. <br />
Please note this API is in BETA and does not yet contain all EPIC functionality.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v2
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.4+

## Installation & Usage

You can install using:

```sh
pip install epicore
```

Then import the package:
```python
import epiccore
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import epiccore
from epiccore.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://epic.zenotech.com/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = epiccore.Configuration(
    host = "https://epic.zenotech.com/api/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer
configuration = epiccore.Configuration(
    host = "https://epic.zenotech.com/api/v2",
    api_key = {
        'Bearer': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer'] = 'Bearer'


# Enter a context with an instance of the API client
with epiccore.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = epiccore.BillingApi(api_client)

    try:
        api_response = api_instance.billing_limits_list()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling BillingApi->billing_limits_list: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://epic.zenotech.com/api/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BillingApi* | [**billing_limits_list**](docs/BillingApi.md#billing_limits_list) | **GET** /billing/limits/ | 
*BillingApi* | [**billing_limits_partial_update**](docs/BillingApi.md#billing_limits_partial_update) | **PATCH** /billing/limits/ | 
*CatalogApi* | [**catalog_applications_list**](docs/CatalogApi.md#catalog_applications_list) | **GET** /catalog/applications/ | 
*CatalogApi* | [**catalog_applications_read**](docs/CatalogApi.md#catalog_applications_read) | **GET** /catalog/applications/{id}/ | 
*CatalogApi* | [**catalog_clusters_list**](docs/CatalogApi.md#catalog_clusters_list) | **GET** /catalog/clusters/ | 
*CatalogApi* | [**catalog_clusters_read**](docs/CatalogApi.md#catalog_clusters_read) | **GET** /catalog/clusters/{id}/ | 
*CatalogApi* | [**catalog_desktop_list**](docs/CatalogApi.md#catalog_desktop_list) | **GET** /catalog/desktop/ | 
*CatalogApi* | [**catalog_desktop_read**](docs/CatalogApi.md#catalog_desktop_read) | **GET** /catalog/desktop/{id}/ | 
*DataApi* | [**data_file_list**](docs/DataApi.md#data_file_list) | **GET** /data/file/ | 
*DataApi* | [**data_file_read**](docs/DataApi.md#data_file_read) | **GET** /data/file/{id}/ | 
*DataApi* | [**data_folder_list**](docs/DataApi.md#data_folder_list) | **GET** /data/folder/ | 
*DataApi* | [**data_folder_read**](docs/DataApi.md#data_folder_read) | **GET** /data/folder/{id}/ | 
*DataApi* | [**data_session_list**](docs/DataApi.md#data_session_list) | **GET** /data/session/ | 
*DesktopApi* | [**desktop_create**](docs/DesktopApi.md#desktop_create) | **POST** /desktop/ | 
*DesktopApi* | [**desktop_list**](docs/DesktopApi.md#desktop_list) | **GET** /desktop/ | 
*DesktopApi* | [**desktop_quote**](docs/DesktopApi.md#desktop_quote) | **POST** /desktop/quote/ | 
*DesktopApi* | [**desktop_read**](docs/DesktopApi.md#desktop_read) | **GET** /desktop/{id}/ | 
*DesktopApi* | [**desktop_terminate**](docs/DesktopApi.md#desktop_terminate) | **POST** /desktop/{id}/terminate/ | 
*JobApi* | [**job_auth_read**](docs/JobApi.md#job_auth_read) | **GET** /job/{id}/auth/ | 
*JobApi* | [**job_auth_update**](docs/JobApi.md#job_auth_update) | **PUT** /job/{id}/auth/ | 
*JobApi* | [**job_cancel**](docs/JobApi.md#job_cancel) | **POST** /job/{id}/cancel/ | 
*JobApi* | [**job_create**](docs/JobApi.md#job_create) | **POST** /job/ | 
*JobApi* | [**job_list**](docs/JobApi.md#job_list) | **GET** /job/ | 
*JobApi* | [**job_partial_update**](docs/JobApi.md#job_partial_update) | **PATCH** /job/{id}/ | 
*JobApi* | [**job_quote**](docs/JobApi.md#job_quote) | **POST** /job/quote/ | 
*JobApi* | [**job_read**](docs/JobApi.md#job_read) | **GET** /job/{id}/ | 
*JobApi* | [**job_residuals_read**](docs/JobApi.md#job_residuals_read) | **GET** /job/{id}/residuals/ | 
*JobauthApi* | [**jobauth_list**](docs/JobauthApi.md#jobauth_list) | **GET** /jobauth/ | 
*JobauthApi* | [**jobauth_read**](docs/JobauthApi.md#jobauth_read) | **GET** /jobauth/{job}/ | 
*JobauthApi* | [**jobauth_update**](docs/JobauthApi.md#jobauth_update) | **PUT** /jobauth/{job}/ | 
*JobrefreshApi* | [**jobrefresh_create**](docs/JobrefreshApi.md#jobrefresh_create) | **POST** /jobrefresh/ | 
*JobrefreshApi* | [**jobrefresh_read**](docs/JobrefreshApi.md#jobrefresh_read) | **GET** /jobrefresh/{id}/ | 
*JobstepApi* | [**jobstep_cancel**](docs/JobstepApi.md#jobstep_cancel) | **POST** /jobstep/{id}/cancel/ | 
*JobstepApi* | [**jobstep_list**](docs/JobstepApi.md#jobstep_list) | **GET** /jobstep/ | 
*JobstepApi* | [**jobstep_logs_read**](docs/JobstepApi.md#jobstep_logs_read) | **GET** /jobstep/{id}/logs/ | 
*JobstepApi* | [**jobstep_read**](docs/JobstepApi.md#jobstep_read) | **GET** /jobstep/{id}/ | 
*LicensesApi* | [**licenses_ansys**](docs/LicensesApi.md#licenses_ansys) | **POST** /licenses/ansys/ | 
*LicensesApi* | [**licenses_create**](docs/LicensesApi.md#licenses_create) | **POST** /licenses/ | 
*LicensesApi* | [**licenses_list**](docs/LicensesApi.md#licenses_list) | **GET** /licenses/ | 
*LicensesApi* | [**licenses_read**](docs/LicensesApi.md#licenses_read) | **GET** /licenses/{id}/ | 
*LicensesApi* | [**licenses_update**](docs/LicensesApi.md#licenses_update) | **PUT** /licenses/{id}/ | 
*LicensesApi* | [**licenses_zcad**](docs/LicensesApi.md#licenses_zcad) | **POST** /licenses/zcad/ | 
*LicensesApi* | [**licenses_zcfd**](docs/LicensesApi.md#licenses_zcfd) | **POST** /licenses/zcfd/ | 
*ProfileApi* | [**profile_settings_list**](docs/ProfileApi.md#profile_settings_list) | **GET** /profile/settings/ | 
*ProjectsApi* | [**projects_list**](docs/ProjectsApi.md#projects_list) | **GET** /projects/ | 
*ProjectsApi* | [**projects_partial_update**](docs/ProjectsApi.md#projects_partial_update) | **PATCH** /projects/{id}/ | 
*ProjectsApi* | [**projects_read**](docs/ProjectsApi.md#projects_read) | **GET** /projects/{id}/ | 
*TeamsApi* | [**teams_list**](docs/TeamsApi.md#teams_list) | **GET** /teams/ | 
*TeamsApi* | [**teams_read**](docs/TeamsApi.md#teams_read) | **GET** /teams/{id}/ | 


## Documentation For Models

 - [AcceleratorConfig](docs/AcceleratorConfig.md)
 - [AnsysLicense](docs/AnsysLicense.md)
 - [BatchApplicationDetails](docs/BatchApplicationDetails.md)
 - [BatchApplicationList](docs/BatchApplicationList.md)
 - [BatchApplicationVersionDetails](docs/BatchApplicationVersionDetails.md)
 - [BatchQueueDetails](docs/BatchQueueDetails.md)
 - [Budget](docs/Budget.md)
 - [ClusterNodeConfig](docs/ClusterNodeConfig.md)
 - [Cost](docs/Cost.md)
 - [CostThreshold](docs/CostThreshold.md)
 - [CurrentSpend](docs/CurrentSpend.md)
 - [DataLocation](docs/DataLocation.md)
 - [DataSpec](docs/DataSpec.md)
 - [DesktopInstance](docs/DesktopInstance.md)
 - [DesktopNodeApp](docs/DesktopNodeApp.md)
 - [DesktopNodeAppSummary](docs/DesktopNodeAppSummary.md)
 - [DesktopNodeApplicationVersion](docs/DesktopNodeApplicationVersion.md)
 - [DesktopNodeApplicationVersionSummary](docs/DesktopNodeApplicationVersionSummary.md)
 - [DesktopNodeConnectionType](docs/DesktopNodeConnectionType.md)
 - [DesktopNodeLaunchSpec](docs/DesktopNodeLaunchSpec.md)
 - [DesktopNodeQuote](docs/DesktopNodeQuote.md)
 - [DesktopNodeType](docs/DesktopNodeType.md)
 - [Discount](docs/Discount.md)
 - [File](docs/File.md)
 - [Folder](docs/Folder.md)
 - [FolderDetails](docs/FolderDetails.md)
 - [IaasCost](docs/IaasCost.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse20011](docs/InlineResponse20011.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [Job](docs/Job.md)
 - [JobAppOptions](docs/JobAppOptions.md)
 - [JobArraySpec](docs/JobArraySpec.md)
 - [JobAuth](docs/JobAuth.md)
 - [JobAuthStatus](docs/JobAuthStatus.md)
 - [JobClusterSpec](docs/JobClusterSpec.md)
 - [JobConfiguration](docs/JobConfiguration.md)
 - [JobDataBinding](docs/JobDataBinding.md)
 - [JobLog](docs/JobLog.md)
 - [JobQuote](docs/JobQuote.md)
 - [JobResidual](docs/JobResidual.md)
 - [JobResidualData](docs/JobResidualData.md)
 - [JobSpec](docs/JobSpec.md)
 - [JobStep](docs/JobStep.md)
 - [JobStepDetails](docs/JobStepDetails.md)
 - [JobSummary](docs/JobSummary.md)
 - [JobTaskSpec](docs/JobTaskSpec.md)
 - [JobstepResponseRequest](docs/JobstepResponseRequest.md)
 - [License](docs/License.md)
 - [Limit](docs/Limit.md)
 - [Limits](docs/Limits.md)
 - [MaxLimit](docs/MaxLimit.md)
 - [MonthlyLimit](docs/MonthlyLimit.md)
 - [PriceQuote](docs/PriceQuote.md)
 - [ProductName](docs/ProductName.md)
 - [ProfileSummary](docs/ProfileSummary.md)
 - [Project](docs/Project.md)
 - [ProjectDetails](docs/ProjectDetails.md)
 - [SLA](docs/SLA.md)
 - [ServiceCharge](docs/ServiceCharge.md)
 - [SessionToken](docs/SessionToken.md)
 - [SoftwareCost](docs/SoftwareCost.md)
 - [SpendLimit](docs/SpendLimit.md)
 - [TaskQuote](docs/TaskQuote.md)
 - [Tax](docs/Tax.md)
 - [Team](docs/Team.md)
 - [TeamDetails](docs/TeamDetails.md)
 - [TeamSelect](docs/TeamSelect.md)
 - [Total](docs/Total.md)
 - [Total1](docs/Total1.md)
 - [UserName](docs/UserName.md)
 - [ZenotechLicense](docs/ZenotechLicense.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@zenotech.com

