Smalldoc is a small lib which allow to extract your Python documentation in an easy way.

The following documentation of Smalldoc had been generate executing script [doc.py](doc.py)

---
#  smalldoc

Small module which allow you to extract your docstring documentation in the format of your choice.

##  parse

```python
def parse(working_path: str, module_name: str, show_private=False) -> dict
```

Parse your code and  docstring then generate a dict with it.





###  Arguments

|Name|Type|Description|
|----|----|-----------|
| `module_name` | str| The name of the module you want to generate dict of your documentation |
| `show_private` | | If True, parser will navigate through your private methode. At False by default. |
| `working_path` | str| The working directory to fetch your module |
###  Return

`dict` : Dictionnary which contain metadata and doc.


##  write

```python
def write(module: dict) -> str
```

Now, allow to generate a single page documentation in markdown using the only on Jinja template available.
The dictionary should be generated by parser.



###  Arguments

|Name|Type|Description|
|----|----|-----------|
| `module` | dict| The dict of your module generated by parser. |
###  Return

`str` : A single page markdown representation of your documentation



