
"""
Contains the best fit values as in Salcido et al. (2022).
"""


best_fit_vals = {}
best_fit_vals['200'] = {'alpha': [15.24311120000861,-1.2436699435560352,0.14837558774401766],
                        'beta': [14.969187892657688,-1.0993025612653198,0.12905587245129102],
                        'gamma': [0.8000441576980428,-0.01715621131893159,0.06131887249968379],
                        'lambda_a': [0.02178116280689233,-0.0077564325654746955,0.0007915576054589781],
                        'lambda_b': [3.0878286643613437,0.4529677646796634,0.001552571083240605],
                        'mu_a': [0.6930259177449359,-0.16913553700233935,0.04263185199898842],
                        'mu_b': [3.161914061444856,0.8616834297321924,0.011346427353554053],
                        'mu_c': [5.532188503256583,-3.0864672185252537,0.5083422518560442],
                        'nu_a': [413.00988701513904,311.63957063032285,37.89105940901369],
                        'nu_b': [-11.243859405779181,-0.34421412616421965,0.3343548325485801],
                        'nu_c': [3.476463891168505,-0.018333059687988575,-0.08276237963970698]}

best_fit_vals['500'] = {'alpha': [14.783423122120318,-0.999062404857228,0.12062854541689262],
                        'beta': [14.620528368613265,-0.9136466201011957,0.10835389086945699],
                        'gamma': [0.9671320682693298,-0.03185388045484575,0.02650236152450093],
                        'lambda_a': [0.019349810078190303,-0.007410668383424459,0.0008334762393555539],
                        'lambda_b': [2.9566773924238143,0.6205340408676114,-0.001928273640110775],
                        'mu_a': [0.715853343781141,-0.19276613600825665,0.04948240117059147],
                        'mu_b': [3.385355123440431,0.9658906605139421,-0.06825861100375574],
                        'mu_c': [4.457257708010122,-2.191853871334233,0.45457701107254733],
                        'nu_a': [478.86477329610375,429.88795783439946,249.25655627821902],
                        'nu_b': [-11.227459319819815,-0.5581080204509223,0.4489962047114509],
                        'nu_c': [3.499449440557995,-0.08488559389068073,-0.0923847866118189]}


limits = {}
limits['200'] = {'z': [0.0, 0.125, 0.5, 1.0, 2.0, 3.0],
                 'min_x0': [63.59373179416563, 59.88726319810792, 56.365373020207954, 39.64033211739476, 91.48777680660496, 45.013496639467114],
                 'min_x1': [-9.731727022847117, -9.176876134517682, -8.677101127391419, -6.141984569473165, -14.545324008239655, -7.155837194116757],
                 'min_x2': [0.36717360571115487, 0.34646698848026913, 0.32901138538950075, 0.23315608004243354, 0.5737424941339003, 0.280547072910215],
                 'max_x0': [18.37309024305502, 19.39185050748328, 23.581135709114342, 9.921243320018773, 5.886510333331434, 3.2505595228962156],
                 'max_x1': [-2.759876785639794, -2.9057029039529163, -3.5325526537664476, -1.4680671748329108, -0.8608020248618151, -0.4637637299766807],
                 'max_x2': [0.10310665850449997, 0.10833932967483784, 0.13187267761804813, 0.05397858264481507, 0.031183646792386614, 0.016278390350696954]}

limits['500'] = {'z': [0.0, 0.125, 0.5, 1.0, 2.0, 3.0], 
                 'min_x0': [75.5677443552107, 79.78651701865594, 12.453646158973672, 119.15086918977593, -44.84238282598863, -7.6276638395020955], 
                 'min_x1': [-11.520848743752344, -12.198643828164334, -2.0331966873703737, -18.404036176901812, 7.0469849096252615, 1.391204616961], 
                 'min_x2': [0.4340110697019119, 0.4611079754178873, 0.07774265268071975, 0.705717707613519, -0.2811444520707123, -0.06643766025515274], 
                 'max_x0': [29.7098168708338, 34.60582857431024, 43.06158434616325, 20.02440685404008, 10.119926258411336, 7.046905277066627], 
                 'max_x1': [-4.468289444788325, -5.194226654546699, -6.461887652137118, -2.9536733023513286, -1.4994660666136326, -1.020435592470318], 
                 'max_x2': [0.16735646291136727, 0.1942560839764333, 0.2418483292735806, 0.10842596379693702, 0.055362809275934344, 0.0367046507001731]}
