import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataExternalConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/external/d/external#id DataExternal#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A list of strings, whose first element is the program to run and whose subsequent elements are optional command line arguments to the program. Terraform does not execute the program through a shell, so it is not necessary to escape shell metacharacters nor add quotes around arguments containing spaces.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/external/d/external#program DataExternal#program}
    */
    readonly program: string[];
    /**
    * A map of string values to pass to the external program as the query arguments. If not supplied, the program will receive an empty object as its input.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/external/d/external#query DataExternal#query}
    */
    readonly query?: {
        [key: string]: string;
    };
    /**
    * Working directory of the program. If not supplied, the program will run in the current directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/external/d/external#working_dir DataExternal#working_dir}
    */
    readonly workingDir?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/external/d/external external}
*/
export declare class DataExternal extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "external";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/external/d/external external} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataExternalConfig
    */
    constructor(scope: Construct, id: string, config: DataExternalConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _program?;
    get program(): string[];
    set program(value: string[]);
    get programInput(): string[] | undefined;
    private _query?;
    get query(): {
        [key: string]: string;
    };
    set query(value: {
        [key: string]: string;
    });
    resetQuery(): void;
    get queryInput(): {
        [key: string]: string;
    } | undefined;
    private _result;
    get result(): cdktf.StringMap;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-external.d.ts.map