from insights.parsers.resolv_conf import ResolvConf
from insights.tests import context_wrap


RESOLVCONF = '''
# This file is being maintained by Puppet.
# DO NOT EDIT
search a.b.com b.c.com
options timeout:2 attempts:2
nameserver 10.160.224.51
nameserver 10.160.225.51
nameserver 10.61.193.11
'''

RESOLVCONF_M = '''
; Generated by NetworkManager
search ttt.com
domain ttt.com
nameserver 192.168.30.1
'''

RESOLV_CONF_NO_ACTIVE = '''
nameserver 192.168.30.1
'''


def test_resolv_conf():
    resolv_info = ResolvConf(context_wrap(RESOLVCONF))

    assert resolv_info.get('search') == ['a.b.com', 'b.c.com']
    assert resolv_info.get('options') == ['timeout:2', 'attempts:2']
    assert resolv_info.get('nameserver') == ['10.160.224.51', '10.160.225.51', '10.61.193.11']
    assert resolv_info.get('active') == 'search'


# Testing when 'search' and 'domain' keywords both exist.
def test_resolv_conf_m():
    resolv_info = ResolvConf(context_wrap(RESOLVCONF_M))

    assert resolv_info.get('domain') == ['ttt.com']
    assert resolv_info.get('search') == ['ttt.com']
    assert resolv_info.get('nameserver') == ['192.168.30.1']
    assert resolv_info.get('active') == 'domain'


# And testing when neither 'search' nor 'domain' keywords are found.
def test_resolv_conf_neither():
    resolv = ResolvConf(context_wrap(RESOLV_CONF_NO_ACTIVE))

    assert resolv['nameserver'] == ['192.168.30.1']
    assert resolv['active'] == ''
